package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.ServiceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ServiceStatusFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.model.ConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>();
    private io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder loadBalancer;

    public ServiceStatusFluentImpl() {
    }

    public ServiceStatusFluentImpl(io.fabric8.kubernetes.api.model.ServiceStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withLoadBalancer(instance.getLoadBalancer()); 
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>();}
        io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>();}
        io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.Condition item : items) {io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.Condition> items) {
        for (io.fabric8.kubernetes.api.model.Condition item : items) {io.fabric8.kubernetes.api.model.ConditionBuilder builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Condition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.kubernetes.api.model.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ConditionBuilder>(); for (io.fabric8.kubernetes.api.model.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.Condition item) {
        return new io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.kubernetes.api.model.Condition item) {
        return new io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLoadBalancer instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LoadBalancerStatus getLoadBalancer() {
        return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerStatus buildLoadBalancer() {
        return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(io.fabric8.kubernetes.api.model.LoadBalancerStatus loadBalancer) {
        _visitables.get("loadBalancer").remove(this.loadBalancer);
        if (loadBalancer!=null){ this.loadBalancer= new io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} return (A) this;
    }

    public java.lang.Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl.LoadBalancerNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(io.fabric8.kubernetes.api.model.LoadBalancerStatus item) {
        return new io.fabric8.kubernetes.api.model.ServiceStatusFluentImpl.LoadBalancerNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer() {
        return withNewLoadBalancerLike(getLoadBalancer());
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
        return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(io.fabric8.kubernetes.api.model.LoadBalancerStatus item) {
        return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceStatusFluentImpl that = (ServiceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  loadBalancer,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ConditionFluentImpl<io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.ServiceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.kubernetes.api.model.Condition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class LoadBalancerNestedImpl<N> extends io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl<io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<N>> implements io.fabric8.kubernetes.api.model.ServiceStatusFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder builder;

            LoadBalancerNestedImpl(io.fabric8.kubernetes.api.model.LoadBalancerStatus item) {
                this.builder = new io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder(this, item);
                        
            }

            LoadBalancerNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) ServiceStatusFluentImpl.this.withLoadBalancer(builder.build());
            }

            public N endLoadBalancer() {
                return and();
            }
    }


}
