package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeAddressBuilder extends NodeAddressFluent<NodeAddressBuilder> implements VisitableBuilder<NodeAddress,NodeAddressBuilder>{
  public NodeAddressBuilder() {
    this(new NodeAddress());
  }
  
  public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
    this(fluent, new NodeAddress());
  }
  
  public NodeAddressBuilder(NodeAddressFluent<?> fluent,NodeAddress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeAddressBuilder(NodeAddress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeAddressFluent<?> fluent;
  
  public NodeAddress build() {
    NodeAddress buildable = new NodeAddress(fluent.getAddress(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}