package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceQuotaStatusBuilder extends ResourceQuotaStatusFluent<ResourceQuotaStatusBuilder> implements VisitableBuilder<ResourceQuotaStatus,ResourceQuotaStatusBuilder>{
  public ResourceQuotaStatusBuilder() {
    this(new ResourceQuotaStatus());
  }
  
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent) {
    this(fluent, new ResourceQuotaStatus());
  }
  
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,ResourceQuotaStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceQuotaStatusFluent<?> fluent;
  
  public ResourceQuotaStatus build() {
    ResourceQuotaStatus buildable = new ResourceQuotaStatus(fluent.getHard(),fluent.getUsed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}