package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VolumeMountStatusBuilder extends VolumeMountStatusFluent<VolumeMountStatusBuilder> implements VisitableBuilder<VolumeMountStatus,VolumeMountStatusBuilder>{
  public VolumeMountStatusBuilder() {
    this(new VolumeMountStatus());
  }
  
  public VolumeMountStatusBuilder(VolumeMountStatusFluent<?> fluent) {
    this(fluent, new VolumeMountStatus());
  }
  
  public VolumeMountStatusBuilder(VolumeMountStatusFluent<?> fluent,VolumeMountStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VolumeMountStatusBuilder(VolumeMountStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VolumeMountStatusFluent<?> fluent;
  
  public VolumeMountStatus build() {
    VolumeMountStatus buildable = new VolumeMountStatus(fluent.getMountPath(),fluent.getName(),fluent.getReadOnly(),fluent.getRecursiveReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}