package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FlowSchemaSpecFluentImpl<A extends FlowSchemaSpecFluent<A>> extends BaseFluent<A> implements FlowSchemaSpecFluent<A>{
  public FlowSchemaSpecFluentImpl() {
  }
  public FlowSchemaSpecFluentImpl(FlowSchemaSpec instance) {
    this.withDistinguisherMethod(instance.getDistinguisherMethod()); 
    this.withMatchingPrecedence(instance.getMatchingPrecedence()); 
    this.withPriorityLevelConfiguration(instance.getPriorityLevelConfiguration()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private FlowDistinguisherMethodBuilder distinguisherMethod;
  private Integer matchingPrecedence;
  private PriorityLevelConfigurationReferenceBuilder priorityLevelConfiguration;
  private ArrayList<PolicyRulesWithSubjectsBuilder> rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDistinguisherMethod instead.
   * @return The buildable object.
   */
  @Deprecated
  public FlowDistinguisherMethod getDistinguisherMethod() {
    return this.distinguisherMethod!=null ?this.distinguisherMethod.build():null;
  }
  public FlowDistinguisherMethod buildDistinguisherMethod() {
    return this.distinguisherMethod!=null ?this.distinguisherMethod.build():null;
  }
  public A withDistinguisherMethod(FlowDistinguisherMethod distinguisherMethod) {
    _visitables.get("distinguisherMethod").remove(this.distinguisherMethod);
    if (distinguisherMethod!=null){ this.distinguisherMethod= new FlowDistinguisherMethodBuilder(distinguisherMethod); _visitables.get("distinguisherMethod").add(this.distinguisherMethod);} else { this.distinguisherMethod = null; _visitables.get("distinguisherMethod").remove(this.distinguisherMethod); } return (A) this;
  }
  public Boolean hasDistinguisherMethod() {
    return this.distinguisherMethod != null;
  }
  public A withNewDistinguisherMethod(String type) {
    return (A)withDistinguisherMethod(new FlowDistinguisherMethod(type));
  }
  public FlowSchemaSpecFluent.DistinguisherMethodNested<A> withNewDistinguisherMethod() {
    return new FlowSchemaSpecFluentImpl.DistinguisherMethodNestedImpl();
  }
  public FlowSchemaSpecFluent.DistinguisherMethodNested<A> withNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
    return new FlowSchemaSpecFluentImpl.DistinguisherMethodNestedImpl(item);
  }
  public FlowSchemaSpecFluent.DistinguisherMethodNested<A> editDistinguisherMethod() {
    return withNewDistinguisherMethodLike(getDistinguisherMethod());
  }
  public FlowSchemaSpecFluent.DistinguisherMethodNested<A> editOrNewDistinguisherMethod() {
    return withNewDistinguisherMethodLike(getDistinguisherMethod() != null ? getDistinguisherMethod(): new FlowDistinguisherMethodBuilder().build());
  }
  public FlowSchemaSpecFluent.DistinguisherMethodNested<A> editOrNewDistinguisherMethodLike(FlowDistinguisherMethod item) {
    return withNewDistinguisherMethodLike(getDistinguisherMethod() != null ? getDistinguisherMethod(): item);
  }
  public Integer getMatchingPrecedence() {
    return this.matchingPrecedence;
  }
  public A withMatchingPrecedence(Integer matchingPrecedence) {
    this.matchingPrecedence=matchingPrecedence; return (A) this;
  }
  public Boolean hasMatchingPrecedence() {
    return this.matchingPrecedence != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPriorityLevelConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public PriorityLevelConfigurationReference getPriorityLevelConfiguration() {
    return this.priorityLevelConfiguration!=null ?this.priorityLevelConfiguration.build():null;
  }
  public PriorityLevelConfigurationReference buildPriorityLevelConfiguration() {
    return this.priorityLevelConfiguration!=null ?this.priorityLevelConfiguration.build():null;
  }
  public A withPriorityLevelConfiguration(PriorityLevelConfigurationReference priorityLevelConfiguration) {
    _visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration);
    if (priorityLevelConfiguration!=null){ this.priorityLevelConfiguration= new PriorityLevelConfigurationReferenceBuilder(priorityLevelConfiguration); _visitables.get("priorityLevelConfiguration").add(this.priorityLevelConfiguration);} else { this.priorityLevelConfiguration = null; _visitables.get("priorityLevelConfiguration").remove(this.priorityLevelConfiguration); } return (A) this;
  }
  public Boolean hasPriorityLevelConfiguration() {
    return this.priorityLevelConfiguration != null;
  }
  public A withNewPriorityLevelConfiguration(String name) {
    return (A)withPriorityLevelConfiguration(new PriorityLevelConfigurationReference(name));
  }
  public FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> withNewPriorityLevelConfiguration() {
    return new FlowSchemaSpecFluentImpl.PriorityLevelConfigurationNestedImpl();
  }
  public FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> withNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
    return new FlowSchemaSpecFluentImpl.PriorityLevelConfigurationNestedImpl(item);
  }
  public FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editPriorityLevelConfiguration() {
    return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration());
  }
  public FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfiguration() {
    return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration() != null ? getPriorityLevelConfiguration(): new PriorityLevelConfigurationReferenceBuilder().build());
  }
  public FlowSchemaSpecFluent.PriorityLevelConfigurationNested<A> editOrNewPriorityLevelConfigurationLike(PriorityLevelConfigurationReference item) {
    return withNewPriorityLevelConfigurationLike(getPriorityLevelConfiguration() != null ? getPriorityLevelConfiguration(): item);
  }
  public A addToRules(Integer index,PolicyRulesWithSubjects item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
  }
  public A setToRules(Integer index,PolicyRulesWithSubjects item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);
    if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
    if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
     return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects... items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<PolicyRulesWithSubjects> items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRulesWithSubjectsBuilder>();}
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects... items) {
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<PolicyRulesWithSubjects> items) {
    for (PolicyRulesWithSubjects item : items) {PolicyRulesWithSubjectsBuilder builder = new PolicyRulesWithSubjectsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<PolicyRulesWithSubjectsBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      PolicyRulesWithSubjectsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PolicyRulesWithSubjects> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<PolicyRulesWithSubjects> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public PolicyRulesWithSubjects buildRule(Integer index) {
    return this.rules.get(index).build();
  }
  public PolicyRulesWithSubjects buildFirstRule() {
    return this.rules.get(0).build();
  }
  public PolicyRulesWithSubjects buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public PolicyRulesWithSubjects buildMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    for (PolicyRulesWithSubjectsBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    for (PolicyRulesWithSubjectsBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<PolicyRulesWithSubjects> rules) {
    if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
    if (rules != null) {this.rules = new ArrayList(); for (PolicyRulesWithSubjects item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects... rules) {
    if (this.rules != null) {this.rules.clear();}
    if (rules != null) {for (PolicyRulesWithSubjects item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public FlowSchemaSpecFluent.RulesNested<A> addNewRule() {
    return new FlowSchemaSpecFluentImpl.RulesNestedImpl();
  }
  public FlowSchemaSpecFluent.RulesNested<A> addNewRuleLike(PolicyRulesWithSubjects item) {
    return new FlowSchemaSpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public FlowSchemaSpecFluent.RulesNested<A> setNewRuleLike(Integer index,PolicyRulesWithSubjects item) {
    return new FlowSchemaSpecFluentImpl.RulesNestedImpl(index, item);
  }
  public FlowSchemaSpecFluent.RulesNested<A> editRule(Integer index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public FlowSchemaSpecFluent.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public FlowSchemaSpecFluent.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public FlowSchemaSpecFluent.RulesNested<A> editMatchingRule(Predicate<PolicyRulesWithSubjectsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FlowSchemaSpecFluentImpl that = (FlowSchemaSpecFluentImpl) o;
    if (distinguisherMethod != null ? !distinguisherMethod.equals(that.distinguisherMethod) :that.distinguisherMethod != null) return false;
    if (matchingPrecedence != null ? !matchingPrecedence.equals(that.matchingPrecedence) :that.matchingPrecedence != null) return false;
    if (priorityLevelConfiguration != null ? !priorityLevelConfiguration.equals(that.priorityLevelConfiguration) :that.priorityLevelConfiguration != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(distinguisherMethod,  matchingPrecedence,  priorityLevelConfiguration,  rules,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (distinguisherMethod != null) { sb.append("distinguisherMethod:"); sb.append(distinguisherMethod + ","); }
    if (matchingPrecedence != null) { sb.append("matchingPrecedence:"); sb.append(matchingPrecedence + ","); }
    if (priorityLevelConfiguration != null) { sb.append("priorityLevelConfiguration:"); sb.append(priorityLevelConfiguration + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DistinguisherMethodNestedImpl<N> extends FlowDistinguisherMethodFluentImpl<FlowSchemaSpecFluent.DistinguisherMethodNested<N>> implements FlowSchemaSpecFluent.DistinguisherMethodNested<N>,Nested<N>{
    DistinguisherMethodNestedImpl(FlowDistinguisherMethod item) {
      this.builder = new FlowDistinguisherMethodBuilder(this, item);
    }
    DistinguisherMethodNestedImpl() {
      this.builder = new FlowDistinguisherMethodBuilder(this);
    }
    FlowDistinguisherMethodBuilder builder;
    public N and() {
      return (N) FlowSchemaSpecFluentImpl.this.withDistinguisherMethod(builder.build());
    }
    public N endDistinguisherMethod() {
      return and();
    }
    
  }
  class PriorityLevelConfigurationNestedImpl<N> extends PriorityLevelConfigurationReferenceFluentImpl<FlowSchemaSpecFluent.PriorityLevelConfigurationNested<N>> implements FlowSchemaSpecFluent.PriorityLevelConfigurationNested<N>,Nested<N>{
    PriorityLevelConfigurationNestedImpl(PriorityLevelConfigurationReference item) {
      this.builder = new PriorityLevelConfigurationReferenceBuilder(this, item);
    }
    PriorityLevelConfigurationNestedImpl() {
      this.builder = new PriorityLevelConfigurationReferenceBuilder(this);
    }
    PriorityLevelConfigurationReferenceBuilder builder;
    public N and() {
      return (N) FlowSchemaSpecFluentImpl.this.withPriorityLevelConfiguration(builder.build());
    }
    public N endPriorityLevelConfiguration() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends PolicyRulesWithSubjectsFluentImpl<FlowSchemaSpecFluent.RulesNested<N>> implements FlowSchemaSpecFluent.RulesNested<N>,Nested<N>{
    RulesNestedImpl(Integer index,PolicyRulesWithSubjects item) {
      this.index = index;
      this.builder = new PolicyRulesWithSubjectsBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new PolicyRulesWithSubjectsBuilder(this);
    }
    PolicyRulesWithSubjectsBuilder builder;
    Integer index;
    public N and() {
      return (N) FlowSchemaSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}