package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupSubjectBuilder extends GroupSubjectFluentImpl<GroupSubjectBuilder> implements VisitableBuilder<GroupSubject,GroupSubjectBuilder>{
  public GroupSubjectBuilder() {
    this(false);
  }
  public GroupSubjectBuilder(Boolean validationEnabled) {
    this(new GroupSubject(), validationEnabled);
  }
  public GroupSubjectBuilder(GroupSubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupSubjectBuilder(GroupSubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupSubject(), validationEnabled);
  }
  public GroupSubjectBuilder(GroupSubjectFluent<?> fluent,GroupSubject instance) {
    this(fluent, instance, false);
  }
  public GroupSubjectBuilder(GroupSubjectFluent<?> fluent,GroupSubject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupSubjectBuilder(GroupSubject instance) {
    this(instance,false);
  }
  public GroupSubjectBuilder(GroupSubject instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GroupSubjectFluent<?> fluent;
  Boolean validationEnabled;
  public GroupSubject build() {
    GroupSubject buildable = new GroupSubject(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}