package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QueuingConfigurationBuilder extends QueuingConfigurationFluent<QueuingConfigurationBuilder> implements VisitableBuilder<QueuingConfiguration,QueuingConfigurationBuilder>{
  public QueuingConfigurationBuilder() {
    this(new QueuingConfiguration());
  }
  
  public QueuingConfigurationBuilder(QueuingConfigurationFluent<?> fluent) {
    this(fluent, new QueuingConfiguration());
  }
  
  public QueuingConfigurationBuilder(QueuingConfigurationFluent<?> fluent,QueuingConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QueuingConfigurationBuilder(QueuingConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QueuingConfigurationFluent<?> fluent;
  
  public QueuingConfiguration build() {
    QueuingConfiguration buildable = new QueuingConfiguration(fluent.getHandSize(),fluent.getQueueLengthLimit(),fluent.getQueues());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}