package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyBuilder extends PodSecurityPolicyFluentImpl<PodSecurityPolicyBuilder> implements VisitableBuilder<PodSecurityPolicy,PodSecurityPolicyBuilder>{
  public PodSecurityPolicyBuilder() {
    this(false);
  }
  public PodSecurityPolicyBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicy(), validationEnabled);
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicy(), validationEnabled);
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent,PodSecurityPolicy instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicyFluent<?> fluent,PodSecurityPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicy instance) {
    this(instance,false);
  }
  public PodSecurityPolicyBuilder(PodSecurityPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicy build() {
    PodSecurityPolicy buildable = new PodSecurityPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}