package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicySpecBuilder extends PodSecurityPolicySpecFluentImpl<PodSecurityPolicySpecBuilder> implements VisitableBuilder<PodSecurityPolicySpec,PodSecurityPolicySpecBuilder>{
  public PodSecurityPolicySpecBuilder() {
    this(false);
  }
  public PodSecurityPolicySpecBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicySpec(), validationEnabled);
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicySpec(), validationEnabled);
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent,PodSecurityPolicySpec instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent,PodSecurityPolicySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    fluent.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
    fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    fluent.withAllowedHostPaths(instance.getAllowedHostPaths()); 
    fluent.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
    fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    fluent.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    fluent.withFsGroup(instance.getFsGroup()); 
    fluent.withHostIPC(instance.getHostIPC()); 
    fluent.withHostNetwork(instance.getHostNetwork()); 
    fluent.withHostPID(instance.getHostPID()); 
    fluent.withHostPorts(instance.getHostPorts()); 
    fluent.withPrivileged(instance.getPrivileged()); 
    fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    fluent.withRunAsGroup(instance.getRunAsGroup()); 
    fluent.withRunAsUser(instance.getRunAsUser()); 
    fluent.withRuntimeClass(instance.getRuntimeClass()); 
    fluent.withSeLinux(instance.getSeLinux()); 
    fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance) {
    this(instance,false);
  }
  public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
    this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    this.withAllowedHostPaths(instance.getAllowedHostPaths()); 
    this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
    this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    this.withFsGroup(instance.getFsGroup()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostPorts(instance.getHostPorts()); 
    this.withPrivileged(instance.getPrivileged()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withRuntimeClass(instance.getRuntimeClass()); 
    this.withSeLinux(instance.getSeLinux()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicySpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicySpec build() {
    PodSecurityPolicySpec buildable = new PodSecurityPolicySpec(fluent.getAllowPrivilegeEscalation(),fluent.getAllowedCSIDrivers(),fluent.getAllowedCapabilities(),fluent.getAllowedFlexVolumes(),fluent.getAllowedHostPaths(),fluent.getAllowedProcMountTypes(),fluent.getAllowedUnsafeSysctls(),fluent.getDefaultAddCapabilities(),fluent.getDefaultAllowPrivilegeEscalation(),fluent.getForbiddenSysctls(),fluent.getFsGroup(),fluent.getHostIPC(),fluent.getHostNetwork(),fluent.getHostPID(),fluent.getHostPorts(),fluent.getPrivileged(),fluent.getReadOnlyRootFilesystem(),fluent.getRequiredDropCapabilities(),fluent.getRunAsGroup(),fluent.getRunAsUser(),fluent.getRuntimeClass(),fluent.getSeLinux(),fluent.getSupplementalGroups(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}