package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityPolicySpecFluentImpl<A extends PodSecurityPolicySpecFluent<A>> extends BaseFluent<A> implements PodSecurityPolicySpecFluent<A>{
  public PodSecurityPolicySpecFluentImpl() {
  }
  public PodSecurityPolicySpecFluentImpl(PodSecurityPolicySpec instance) {
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
    this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
    this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
    this.withAllowedHostPaths(instance.getAllowedHostPaths()); 
    this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
    this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
    this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
    this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
    this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
    this.withFsGroup(instance.getFsGroup()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostPorts(instance.getHostPorts()); 
    this.withPrivileged(instance.getPrivileged()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withRuntimeClass(instance.getRuntimeClass()); 
    this.withSeLinux(instance.getSeLinux()); 
    this.withSupplementalGroups(instance.getSupplementalGroups()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean allowPrivilegeEscalation;
  private ArrayList<AllowedCSIDriverBuilder> allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();
  private List<String> allowedCapabilities = new ArrayList<String>();
  private ArrayList<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();
  private ArrayList<AllowedHostPathBuilder> allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();
  private List<String> allowedProcMountTypes = new ArrayList<String>();
  private List<String> allowedUnsafeSysctls = new ArrayList<String>();
  private List<String> defaultAddCapabilities = new ArrayList<String>();
  private Boolean defaultAllowPrivilegeEscalation;
  private List<String> forbiddenSysctls = new ArrayList<String>();
  private FSGroupStrategyOptionsBuilder fsGroup;
  private Boolean hostIPC;
  private Boolean hostNetwork;
  private Boolean hostPID;
  private ArrayList<HostPortRangeBuilder> hostPorts = new ArrayList<HostPortRangeBuilder>();
  private Boolean privileged;
  private Boolean readOnlyRootFilesystem;
  private List<String> requiredDropCapabilities = new ArrayList<String>();
  private RunAsGroupStrategyOptionsBuilder runAsGroup;
  private RunAsUserStrategyOptionsBuilder runAsUser;
  private RuntimeClassStrategyOptionsBuilder runtimeClass;
  private SELinuxStrategyOptionsBuilder seLinux;
  private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
  private List<String> volumes = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public Boolean getAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation;
  }
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
    this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
  }
  public Boolean hasAllowPrivilegeEscalation() {
    return this.allowPrivilegeEscalation != null;
  }
  public A addToAllowedCSIDrivers(Integer index,AllowedCSIDriver item) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();}
    AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(index >= 0 ? index : _visitables.get("allowedCSIDrivers").size(), builder);this.allowedCSIDrivers.add(index >= 0 ? index : allowedCSIDrivers.size(), builder); return (A)this;
  }
  public A setToAllowedCSIDrivers(Integer index,AllowedCSIDriver item) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();}
    AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedCSIDrivers").size()) { _visitables.get("allowedCSIDrivers").add(builder); } else { _visitables.get("allowedCSIDrivers").set(index, builder);}
    if (index < 0 || index >= allowedCSIDrivers.size()) { allowedCSIDrivers.add(builder); } else { allowedCSIDrivers.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();}
    for (AllowedCSIDriver item : items) {AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
  }
  public A addAllToAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
    if (this.allowedCSIDrivers == null) {this.allowedCSIDrivers = new ArrayList<AllowedCSIDriverBuilder>();}
    for (AllowedCSIDriver item : items) {AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").add(builder);this.allowedCSIDrivers.add(builder);} return (A)this;
  }
  public A removeFromAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items) {
    for (AllowedCSIDriver item : items) {AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
    for (AllowedCSIDriver item : items) {AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);_visitables.get("allowedCSIDrivers").remove(builder);if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedCSIDrivers(Predicate<AllowedCSIDriverBuilder> predicate) {
    if (allowedCSIDrivers == null) return (A) this;
    final Iterator<AllowedCSIDriverBuilder> each = allowedCSIDrivers.iterator();
    final List visitables = _visitables.get("allowedCSIDrivers");
    while (each.hasNext()) {
      AllowedCSIDriverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedCSIDrivers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedCSIDriver> getAllowedCSIDrivers() {
    return allowedCSIDrivers != null ? build(allowedCSIDrivers) : null;
  }
  public List<AllowedCSIDriver> buildAllowedCSIDrivers() {
    return allowedCSIDrivers != null ? build(allowedCSIDrivers) : null;
  }
  public AllowedCSIDriver buildAllowedCSIDriver(Integer index) {
    return this.allowedCSIDrivers.get(index).build();
  }
  public AllowedCSIDriver buildFirstAllowedCSIDriver() {
    return this.allowedCSIDrivers.get(0).build();
  }
  public AllowedCSIDriver buildLastAllowedCSIDriver() {
    return this.allowedCSIDrivers.get(allowedCSIDrivers.size() - 1).build();
  }
  public AllowedCSIDriver buildMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
    for (AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
    for (AllowedCSIDriverBuilder item: allowedCSIDrivers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedCSIDrivers(List<AllowedCSIDriver> allowedCSIDrivers) {
    if (this.allowedCSIDrivers != null) { _visitables.get("allowedCSIDrivers").removeAll(this.allowedCSIDrivers);}
    if (allowedCSIDrivers != null) {this.allowedCSIDrivers = new ArrayList(); for (AllowedCSIDriver item : allowedCSIDrivers){this.addToAllowedCSIDrivers(item);}} else { this.allowedCSIDrivers = null;} return (A) this;
  }
  public A withAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... allowedCSIDrivers) {
    if (this.allowedCSIDrivers != null) {this.allowedCSIDrivers.clear();}
    if (allowedCSIDrivers != null) {for (AllowedCSIDriver item :allowedCSIDrivers){ this.addToAllowedCSIDrivers(item);}} return (A) this;
  }
  public Boolean hasAllowedCSIDrivers() {
    return allowedCSIDrivers != null && !allowedCSIDrivers.isEmpty();
  }
  public A addNewAllowedCSIDriver(String name) {
    return (A)addToAllowedCSIDrivers(new AllowedCSIDriver(name));
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriver() {
    return new PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl();
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(AllowedCSIDriver item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl(-1, item);
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(Integer index,AllowedCSIDriver item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedCSIDriversNestedImpl(index, item);
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editAllowedCSIDriver(Integer index) {
    if (allowedCSIDrivers.size() <= index) throw new RuntimeException("Can't edit allowedCSIDrivers. Index exceeds size.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editFirstAllowedCSIDriver() {
    if (allowedCSIDrivers.size() == 0) throw new RuntimeException("Can't edit first allowedCSIDrivers. The list is empty.");
    return setNewAllowedCSIDriverLike(0, buildAllowedCSIDriver(0));
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editLastAllowedCSIDriver() {
    int index = allowedCSIDrivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedCSIDrivers. The list is empty.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedCSIDrivers.size();i++) { 
    if (predicate.test(allowedCSIDrivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedCSIDrivers. No match found.");
    return setNewAllowedCSIDriverLike(index, buildAllowedCSIDriver(index));
  }
  public A addToAllowedCapabilities(Integer index,String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    this.allowedCapabilities.add(index, item);
    return (A)this;
  }
  public A setToAllowedCapabilities(Integer index,String item) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    this.allowedCapabilities.set(index, item); return (A)this;
  }
  public A addToAllowedCapabilities(java.lang.String... items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A addAllToAllowedCapabilities(Collection<String> items) {
    if (this.allowedCapabilities == null) {this.allowedCapabilities = new ArrayList<String>();}
    for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
  }
  public A removeFromAllowedCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedCapabilities(Collection<String> items) {
    for (String item : items) {if (this.allowedCapabilities!= null){ this.allowedCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getAllowedCapabilities() {
    return this.allowedCapabilities;
  }
  public String getAllowedCapability(Integer index) {
    return this.allowedCapabilities.get(index);
  }
  public String getFirstAllowedCapability() {
    return this.allowedCapabilities.get(0);
  }
  public String getLastAllowedCapability() {
    return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
  }
  public String getMatchingAllowedCapability(Predicate<String> predicate) {
    for (String item: allowedCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
    for (String item: allowedCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedCapabilities(List<String> allowedCapabilities) {
    if (allowedCapabilities != null) {this.allowedCapabilities = new ArrayList(); for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} else { this.allowedCapabilities = null;} return (A) this;
  }
  public A withAllowedCapabilities(java.lang.String... allowedCapabilities) {
    if (this.allowedCapabilities != null) {this.allowedCapabilities.clear();}
    if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
  }
  public Boolean hasAllowedCapabilities() {
    return allowedCapabilities != null && !allowedCapabilities.isEmpty();
  }
  public A addToAllowedFlexVolumes(Integer index,AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(index >= 0 ? index : _visitables.get("allowedFlexVolumes").size(), builder);this.allowedFlexVolumes.add(index >= 0 ? index : allowedFlexVolumes.size(), builder); return (A)this;
  }
  public A setToAllowedFlexVolumes(Integer index,AllowedFlexVolume item) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedFlexVolumes").size()) { _visitables.get("allowedFlexVolumes").add(builder); } else { _visitables.get("allowedFlexVolumes").set(index, builder);}
    if (index < 0 || index >= allowedFlexVolumes.size()) { allowedFlexVolumes.add(builder); } else { allowedFlexVolumes.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
    if (this.allowedFlexVolumes == null) {this.allowedFlexVolumes = new ArrayList<AllowedFlexVolumeBuilder>();}
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").add(builder);this.allowedFlexVolumes.add(builder);} return (A)this;
  }
  public A removeFromAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items) {
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
    for (AllowedFlexVolume item : items) {AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);_visitables.get("allowedFlexVolumes").remove(builder);if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
    if (allowedFlexVolumes == null) return (A) this;
    final Iterator<AllowedFlexVolumeBuilder> each = allowedFlexVolumes.iterator();
    final List visitables = _visitables.get("allowedFlexVolumes");
    while (each.hasNext()) {
      AllowedFlexVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedFlexVolume> getAllowedFlexVolumes() {
    return allowedFlexVolumes != null ? build(allowedFlexVolumes) : null;
  }
  public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
    return allowedFlexVolumes != null ? build(allowedFlexVolumes) : null;
  }
  public AllowedFlexVolume buildAllowedFlexVolume(Integer index) {
    return this.allowedFlexVolumes.get(index).build();
  }
  public AllowedFlexVolume buildFirstAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(0).build();
  }
  public AllowedFlexVolume buildLastAllowedFlexVolume() {
    return this.allowedFlexVolumes.get(allowedFlexVolumes.size() - 1).build();
  }
  public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    for (AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    for (AllowedFlexVolumeBuilder item: allowedFlexVolumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) { _visitables.get("allowedFlexVolumes").removeAll(this.allowedFlexVolumes);}
    if (allowedFlexVolumes != null) {this.allowedFlexVolumes = new ArrayList(); for (AllowedFlexVolume item : allowedFlexVolumes){this.addToAllowedFlexVolumes(item);}} else { this.allowedFlexVolumes = null;} return (A) this;
  }
  public A withAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... allowedFlexVolumes) {
    if (this.allowedFlexVolumes != null) {this.allowedFlexVolumes.clear();}
    if (allowedFlexVolumes != null) {for (AllowedFlexVolume item :allowedFlexVolumes){ this.addToAllowedFlexVolumes(item);}} return (A) this;
  }
  public Boolean hasAllowedFlexVolumes() {
    return allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty();
  }
  public A addNewAllowedFlexVolume(String driver) {
    return (A)addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
    return new PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl();
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl(-1, item);
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(Integer index,AllowedFlexVolume item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedFlexVolumesNestedImpl(index, item);
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(Integer index) {
    if (allowedFlexVolumes.size() <= index) throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
    if (allowedFlexVolumes.size() == 0) throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(0, buildAllowedFlexVolume(0));
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
    int index = allowedFlexVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedFlexVolumes.size();i++) { 
    if (predicate.test(allowedFlexVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
    return setNewAllowedFlexVolumeLike(index, buildAllowedFlexVolume(index));
  }
  public A addToAllowedHostPaths(Integer index,AllowedHostPath item) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();}
    AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(index >= 0 ? index : _visitables.get("allowedHostPaths").size(), builder);this.allowedHostPaths.add(index >= 0 ? index : allowedHostPaths.size(), builder); return (A)this;
  }
  public A setToAllowedHostPaths(Integer index,AllowedHostPath item) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();}
    AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedHostPaths").size()) { _visitables.get("allowedHostPaths").add(builder); } else { _visitables.get("allowedHostPaths").set(index, builder);}
    if (index < 0 || index >= allowedHostPaths.size()) { allowedHostPaths.add(builder); } else { allowedHostPaths.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();}
    for (AllowedHostPath item : items) {AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
  }
  public A addAllToAllowedHostPaths(Collection<AllowedHostPath> items) {
    if (this.allowedHostPaths == null) {this.allowedHostPaths = new ArrayList<AllowedHostPathBuilder>();}
    for (AllowedHostPath item : items) {AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").add(builder);this.allowedHostPaths.add(builder);} return (A)this;
  }
  public A removeFromAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items) {
    for (AllowedHostPath item : items) {AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedHostPaths(Collection<AllowedHostPath> items) {
    for (AllowedHostPath item : items) {AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);_visitables.get("allowedHostPaths").remove(builder);if (this.allowedHostPaths != null) {this.allowedHostPaths.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedHostPaths(Predicate<AllowedHostPathBuilder> predicate) {
    if (allowedHostPaths == null) return (A) this;
    final Iterator<AllowedHostPathBuilder> each = allowedHostPaths.iterator();
    final List visitables = _visitables.get("allowedHostPaths");
    while (each.hasNext()) {
      AllowedHostPathBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedHostPaths instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedHostPath> getAllowedHostPaths() {
    return allowedHostPaths != null ? build(allowedHostPaths) : null;
  }
  public List<AllowedHostPath> buildAllowedHostPaths() {
    return allowedHostPaths != null ? build(allowedHostPaths) : null;
  }
  public AllowedHostPath buildAllowedHostPath(Integer index) {
    return this.allowedHostPaths.get(index).build();
  }
  public AllowedHostPath buildFirstAllowedHostPath() {
    return this.allowedHostPaths.get(0).build();
  }
  public AllowedHostPath buildLastAllowedHostPath() {
    return this.allowedHostPaths.get(allowedHostPaths.size() - 1).build();
  }
  public AllowedHostPath buildMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
    for (AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
    for (AllowedHostPathBuilder item: allowedHostPaths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedHostPaths(List<AllowedHostPath> allowedHostPaths) {
    if (this.allowedHostPaths != null) { _visitables.get("allowedHostPaths").removeAll(this.allowedHostPaths);}
    if (allowedHostPaths != null) {this.allowedHostPaths = new ArrayList(); for (AllowedHostPath item : allowedHostPaths){this.addToAllowedHostPaths(item);}} else { this.allowedHostPaths = null;} return (A) this;
  }
  public A withAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... allowedHostPaths) {
    if (this.allowedHostPaths != null) {this.allowedHostPaths.clear();}
    if (allowedHostPaths != null) {for (AllowedHostPath item :allowedHostPaths){ this.addToAllowedHostPaths(item);}} return (A) this;
  }
  public Boolean hasAllowedHostPaths() {
    return allowedHostPaths != null && !allowedHostPaths.isEmpty();
  }
  public A addNewAllowedHostPath(String pathPrefix,Boolean readOnly) {
    return (A)addToAllowedHostPaths(new AllowedHostPath(pathPrefix, readOnly));
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath() {
    return new PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl();
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(AllowedHostPath item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl(-1, item);
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(Integer index,AllowedHostPath item) {
    return new PodSecurityPolicySpecFluentImpl.AllowedHostPathsNestedImpl(index, item);
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(Integer index) {
    if (allowedHostPaths.size() <= index) throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath() {
    if (allowedHostPaths.size() == 0) throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
    return setNewAllowedHostPathLike(0, buildAllowedHostPath(0));
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath() {
    int index = allowedHostPaths.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedHostPaths.size();i++) { 
    if (predicate.test(allowedHostPaths.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
    return setNewAllowedHostPathLike(index, buildAllowedHostPath(index));
  }
  public A addToAllowedProcMountTypes(Integer index,String item) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
    this.allowedProcMountTypes.add(index, item);
    return (A)this;
  }
  public A setToAllowedProcMountTypes(Integer index,String item) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
    this.allowedProcMountTypes.set(index, item); return (A)this;
  }
  public A addToAllowedProcMountTypes(java.lang.String... items) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
    for (String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
  }
  public A addAllToAllowedProcMountTypes(Collection<String> items) {
    if (this.allowedProcMountTypes == null) {this.allowedProcMountTypes = new ArrayList<String>();}
    for (String item : items) {this.allowedProcMountTypes.add(item);} return (A)this;
  }
  public A removeFromAllowedProcMountTypes(java.lang.String... items) {
    for (String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedProcMountTypes(Collection<String> items) {
    for (String item : items) {if (this.allowedProcMountTypes!= null){ this.allowedProcMountTypes.remove(item);}} return (A)this;
  }
  public List<String> getAllowedProcMountTypes() {
    return this.allowedProcMountTypes;
  }
  public String getAllowedProcMountType(Integer index) {
    return this.allowedProcMountTypes.get(index);
  }
  public String getFirstAllowedProcMountType() {
    return this.allowedProcMountTypes.get(0);
  }
  public String getLastAllowedProcMountType() {
    return this.allowedProcMountTypes.get(allowedProcMountTypes.size() - 1);
  }
  public String getMatchingAllowedProcMountType(Predicate<String> predicate) {
    for (String item: allowedProcMountTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedProcMountType(Predicate<String> predicate) {
    for (String item: allowedProcMountTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedProcMountTypes(List<String> allowedProcMountTypes) {
    if (allowedProcMountTypes != null) {this.allowedProcMountTypes = new ArrayList(); for (String item : allowedProcMountTypes){this.addToAllowedProcMountTypes(item);}} else { this.allowedProcMountTypes = null;} return (A) this;
  }
  public A withAllowedProcMountTypes(java.lang.String... allowedProcMountTypes) {
    if (this.allowedProcMountTypes != null) {this.allowedProcMountTypes.clear();}
    if (allowedProcMountTypes != null) {for (String item :allowedProcMountTypes){ this.addToAllowedProcMountTypes(item);}} return (A) this;
  }
  public Boolean hasAllowedProcMountTypes() {
    return allowedProcMountTypes != null && !allowedProcMountTypes.isEmpty();
  }
  public A addToAllowedUnsafeSysctls(Integer index,String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    this.allowedUnsafeSysctls.add(index, item);
    return (A)this;
  }
  public A setToAllowedUnsafeSysctls(Integer index,String item) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    this.allowedUnsafeSysctls.set(index, item); return (A)this;
  }
  public A addToAllowedUnsafeSysctls(java.lang.String... items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
    if (this.allowedUnsafeSysctls == null) {this.allowedUnsafeSysctls = new ArrayList<String>();}
    for (String item : items) {this.allowedUnsafeSysctls.add(item);} return (A)this;
  }
  public A removeFromAllowedUnsafeSysctls(java.lang.String... items) {
    for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
    for (String item : items) {if (this.allowedUnsafeSysctls!= null){ this.allowedUnsafeSysctls.remove(item);}} return (A)this;
  }
  public List<String> getAllowedUnsafeSysctls() {
    return this.allowedUnsafeSysctls;
  }
  public String getAllowedUnsafeSysctl(Integer index) {
    return this.allowedUnsafeSysctls.get(index);
  }
  public String getFirstAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(0);
  }
  public String getLastAllowedUnsafeSysctl() {
    return this.allowedUnsafeSysctls.get(allowedUnsafeSysctls.size() - 1);
  }
  public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
    for (String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
    for (String item: allowedUnsafeSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
    if (allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls = new ArrayList(); for (String item : allowedUnsafeSysctls){this.addToAllowedUnsafeSysctls(item);}} else { this.allowedUnsafeSysctls = null;} return (A) this;
  }
  public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls) {
    if (this.allowedUnsafeSysctls != null) {this.allowedUnsafeSysctls.clear();}
    if (allowedUnsafeSysctls != null) {for (String item :allowedUnsafeSysctls){ this.addToAllowedUnsafeSysctls(item);}} return (A) this;
  }
  public Boolean hasAllowedUnsafeSysctls() {
    return allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty();
  }
  public A addToDefaultAddCapabilities(Integer index,String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    this.defaultAddCapabilities.add(index, item);
    return (A)this;
  }
  public A setToDefaultAddCapabilities(Integer index,String item) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    this.defaultAddCapabilities.set(index, item); return (A)this;
  }
  public A addToDefaultAddCapabilities(java.lang.String... items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A addAllToDefaultAddCapabilities(Collection<String> items) {
    if (this.defaultAddCapabilities == null) {this.defaultAddCapabilities = new ArrayList<String>();}
    for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
  }
  public A removeFromDefaultAddCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
    for (String item : items) {if (this.defaultAddCapabilities!= null){ this.defaultAddCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getDefaultAddCapabilities() {
    return this.defaultAddCapabilities;
  }
  public String getDefaultAddCapability(Integer index) {
    return this.defaultAddCapabilities.get(index);
  }
  public String getFirstDefaultAddCapability() {
    return this.defaultAddCapabilities.get(0);
  }
  public String getLastDefaultAddCapability() {
    return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
  }
  public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
    for (String item: defaultAddCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
    for (String item: defaultAddCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
    if (defaultAddCapabilities != null) {this.defaultAddCapabilities = new ArrayList(); for (String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} else { this.defaultAddCapabilities = null;} return (A) this;
  }
  public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities) {
    if (this.defaultAddCapabilities != null) {this.defaultAddCapabilities.clear();}
    if (defaultAddCapabilities != null) {for (String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
  }
  public Boolean hasDefaultAddCapabilities() {
    return defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty();
  }
  public Boolean getDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation;
  }
  public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
    this.defaultAllowPrivilegeEscalation=defaultAllowPrivilegeEscalation; return (A) this;
  }
  public Boolean hasDefaultAllowPrivilegeEscalation() {
    return this.defaultAllowPrivilegeEscalation != null;
  }
  public A addToForbiddenSysctls(Integer index,String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    this.forbiddenSysctls.add(index, item);
    return (A)this;
  }
  public A setToForbiddenSysctls(Integer index,String item) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    this.forbiddenSysctls.set(index, item); return (A)this;
  }
  public A addToForbiddenSysctls(java.lang.String... items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A addAllToForbiddenSysctls(Collection<String> items) {
    if (this.forbiddenSysctls == null) {this.forbiddenSysctls = new ArrayList<String>();}
    for (String item : items) {this.forbiddenSysctls.add(item);} return (A)this;
  }
  public A removeFromForbiddenSysctls(java.lang.String... items) {
    for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public A removeAllFromForbiddenSysctls(Collection<String> items) {
    for (String item : items) {if (this.forbiddenSysctls!= null){ this.forbiddenSysctls.remove(item);}} return (A)this;
  }
  public List<String> getForbiddenSysctls() {
    return this.forbiddenSysctls;
  }
  public String getForbiddenSysctl(Integer index) {
    return this.forbiddenSysctls.get(index);
  }
  public String getFirstForbiddenSysctl() {
    return this.forbiddenSysctls.get(0);
  }
  public String getLastForbiddenSysctl() {
    return this.forbiddenSysctls.get(forbiddenSysctls.size() - 1);
  }
  public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
    for (String item: forbiddenSysctls) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
    for (String item: forbiddenSysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withForbiddenSysctls(List<String> forbiddenSysctls) {
    if (forbiddenSysctls != null) {this.forbiddenSysctls = new ArrayList(); for (String item : forbiddenSysctls){this.addToForbiddenSysctls(item);}} else { this.forbiddenSysctls = null;} return (A) this;
  }
  public A withForbiddenSysctls(java.lang.String... forbiddenSysctls) {
    if (this.forbiddenSysctls != null) {this.forbiddenSysctls.clear();}
    if (forbiddenSysctls != null) {for (String item :forbiddenSysctls){ this.addToForbiddenSysctls(item);}} return (A) this;
  }
  public Boolean hasForbiddenSysctls() {
    return forbiddenSysctls != null && !forbiddenSysctls.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildFsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public FSGroupStrategyOptions getFsGroup() {
    return this.fsGroup!=null ?this.fsGroup.build():null;
  }
  public FSGroupStrategyOptions buildFsGroup() {
    return this.fsGroup!=null ?this.fsGroup.build():null;
  }
  public A withFsGroup(FSGroupStrategyOptions fsGroup) {
    _visitables.get("fsGroup").remove(this.fsGroup);
    if (fsGroup!=null){ this.fsGroup= new FSGroupStrategyOptionsBuilder(fsGroup); _visitables.get("fsGroup").add(this.fsGroup);} else { this.fsGroup = null; _visitables.get("fsGroup").remove(this.fsGroup); } return (A) this;
  }
  public Boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup() {
    return new PodSecurityPolicySpecFluentImpl.FsGroupNestedImpl();
  }
  public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.FsGroupNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup() {
    return withNewFsGroupLike(getFsGroup());
  }
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup() {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new FSGroupStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
    return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
  }
  public Boolean getHostIPC() {
    return this.hostIPC;
  }
  public A withHostIPC(Boolean hostIPC) {
    this.hostIPC=hostIPC; return (A) this;
  }
  public Boolean hasHostIPC() {
    return this.hostIPC != null;
  }
  public Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public Boolean getHostPID() {
    return this.hostPID;
  }
  public A withHostPID(Boolean hostPID) {
    this.hostPID=hostPID; return (A) this;
  }
  public Boolean hasHostPID() {
    return this.hostPID != null;
  }
  public A addToHostPorts(Integer index,HostPortRange item) {
    if (this.hostPorts == null) {this.hostPorts = new ArrayList<HostPortRangeBuilder>();}
    HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.get("hostPorts").add(index >= 0 ? index : _visitables.get("hostPorts").size(), builder);this.hostPorts.add(index >= 0 ? index : hostPorts.size(), builder); return (A)this;
  }
  public A setToHostPorts(Integer index,HostPortRange item) {
    if (this.hostPorts == null) {this.hostPorts = new ArrayList<HostPortRangeBuilder>();}
    HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
    if (index < 0 || index >= _visitables.get("hostPorts").size()) { _visitables.get("hostPorts").add(builder); } else { _visitables.get("hostPorts").set(index, builder);}
    if (index < 0 || index >= hostPorts.size()) { hostPorts.add(builder); } else { hostPorts.set(index, builder);}
     return (A)this;
  }
  public A addToHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items) {
    if (this.hostPorts == null) {this.hostPorts = new ArrayList<HostPortRangeBuilder>();}
    for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
  }
  public A addAllToHostPorts(Collection<HostPortRange> items) {
    if (this.hostPorts == null) {this.hostPorts = new ArrayList<HostPortRangeBuilder>();}
    for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.get("hostPorts").add(builder);this.hostPorts.add(builder);} return (A)this;
  }
  public A removeFromHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items) {
    for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
  }
  public A removeAllFromHostPorts(Collection<HostPortRange> items) {
    for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.get("hostPorts").remove(builder);if (this.hostPorts != null) {this.hostPorts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHostPorts(Predicate<HostPortRangeBuilder> predicate) {
    if (hostPorts == null) return (A) this;
    final Iterator<HostPortRangeBuilder> each = hostPorts.iterator();
    final List visitables = _visitables.get("hostPorts");
    while (each.hasNext()) {
      HostPortRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHostPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HostPortRange> getHostPorts() {
    return hostPorts != null ? build(hostPorts) : null;
  }
  public List<HostPortRange> buildHostPorts() {
    return hostPorts != null ? build(hostPorts) : null;
  }
  public HostPortRange buildHostPort(Integer index) {
    return this.hostPorts.get(index).build();
  }
  public HostPortRange buildFirstHostPort() {
    return this.hostPorts.get(0).build();
  }
  public HostPortRange buildLastHostPort() {
    return this.hostPorts.get(hostPorts.size() - 1).build();
  }
  public HostPortRange buildMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
    for (HostPortRangeBuilder item: hostPorts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
    for (HostPortRangeBuilder item: hostPorts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostPorts(List<HostPortRange> hostPorts) {
    if (this.hostPorts != null) { _visitables.get("hostPorts").removeAll(this.hostPorts);}
    if (hostPorts != null) {this.hostPorts = new ArrayList(); for (HostPortRange item : hostPorts){this.addToHostPorts(item);}} else { this.hostPorts = null;} return (A) this;
  }
  public A withHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... hostPorts) {
    if (this.hostPorts != null) {this.hostPorts.clear();}
    if (hostPorts != null) {for (HostPortRange item :hostPorts){ this.addToHostPorts(item);}} return (A) this;
  }
  public Boolean hasHostPorts() {
    return hostPorts != null && !hostPorts.isEmpty();
  }
  public A addNewHostPort(Integer max,Integer min) {
    return (A)addToHostPorts(new HostPortRange(max, min));
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort() {
    return new PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl();
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item) {
    return new PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl(-1, item);
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(Integer index,HostPortRange item) {
    return new PodSecurityPolicySpecFluentImpl.HostPortsNestedImpl(index, item);
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(Integer index) {
    if (hostPorts.size() <= index) throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort() {
    if (hostPorts.size() == 0) throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
    return setNewHostPortLike(0, buildHostPort(0));
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort() {
    int index = hostPorts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hostPorts.size();i++) { 
    if (predicate.test(hostPorts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hostPorts. No match found.");
    return setNewHostPortLike(index, buildHostPort(index));
  }
  public Boolean getPrivileged() {
    return this.privileged;
  }
  public A withPrivileged(Boolean privileged) {
    this.privileged=privileged; return (A) this;
  }
  public Boolean hasPrivileged() {
    return this.privileged != null;
  }
  public Boolean getReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem;
  }
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
    this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
  }
  public Boolean hasReadOnlyRootFilesystem() {
    return this.readOnlyRootFilesystem != null;
  }
  public A addToRequiredDropCapabilities(Integer index,String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    this.requiredDropCapabilities.add(index, item);
    return (A)this;
  }
  public A setToRequiredDropCapabilities(Integer index,String item) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    this.requiredDropCapabilities.set(index, item); return (A)this;
  }
  public A addToRequiredDropCapabilities(java.lang.String... items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A addAllToRequiredDropCapabilities(Collection<String> items) {
    if (this.requiredDropCapabilities == null) {this.requiredDropCapabilities = new ArrayList<String>();}
    for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
  }
  public A removeFromRequiredDropCapabilities(java.lang.String... items) {
    for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
    for (String item : items) {if (this.requiredDropCapabilities!= null){ this.requiredDropCapabilities.remove(item);}} return (A)this;
  }
  public List<String> getRequiredDropCapabilities() {
    return this.requiredDropCapabilities;
  }
  public String getRequiredDropCapability(Integer index) {
    return this.requiredDropCapabilities.get(index);
  }
  public String getFirstRequiredDropCapability() {
    return this.requiredDropCapabilities.get(0);
  }
  public String getLastRequiredDropCapability() {
    return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
  }
  public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
    for (String item: requiredDropCapabilities) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
    for (String item: requiredDropCapabilities) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
    if (requiredDropCapabilities != null) {this.requiredDropCapabilities = new ArrayList(); for (String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} else { this.requiredDropCapabilities = null;} return (A) this;
  }
  public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities) {
    if (this.requiredDropCapabilities != null) {this.requiredDropCapabilities.clear();}
    if (requiredDropCapabilities != null) {for (String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
  }
  public Boolean hasRequiredDropCapabilities() {
    return requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildRunAsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsGroupStrategyOptions getRunAsGroup() {
    return this.runAsGroup!=null ?this.runAsGroup.build():null;
  }
  public RunAsGroupStrategyOptions buildRunAsGroup() {
    return this.runAsGroup!=null ?this.runAsGroup.build():null;
  }
  public A withRunAsGroup(RunAsGroupStrategyOptions runAsGroup) {
    _visitables.get("runAsGroup").remove(this.runAsGroup);
    if (runAsGroup!=null){ this.runAsGroup= new RunAsGroupStrategyOptionsBuilder(runAsGroup); _visitables.get("runAsGroup").add(this.runAsGroup);} else { this.runAsGroup = null; _visitables.get("runAsGroup").remove(this.runAsGroup); } return (A) this;
  }
  public Boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup() {
    return new PodSecurityPolicySpecFluentImpl.RunAsGroupNestedImpl();
  }
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.RunAsGroupNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup() {
    return withNewRunAsGroupLike(getRunAsGroup());
  }
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup() {
    return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): new RunAsGroupStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
    return withNewRunAsGroupLike(getRunAsGroup() != null ? getRunAsGroup(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRunAsUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsUserStrategyOptions getRunAsUser() {
    return this.runAsUser!=null ?this.runAsUser.build():null;
  }
  public RunAsUserStrategyOptions buildRunAsUser() {
    return this.runAsUser!=null ?this.runAsUser.build():null;
  }
  public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
    _visitables.get("runAsUser").remove(this.runAsUser);
    if (runAsUser!=null){ this.runAsUser= new RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.get("runAsUser").add(this.runAsUser);} else { this.runAsUser = null; _visitables.get("runAsUser").remove(this.runAsUser); } return (A) this;
  }
  public Boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser() {
    return new PodSecurityPolicySpecFluentImpl.RunAsUserNestedImpl();
  }
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.RunAsUserNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser());
  }
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser() {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new RunAsUserStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
    return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRuntimeClass instead.
   * @return The buildable object.
   */
  @Deprecated
  public RuntimeClassStrategyOptions getRuntimeClass() {
    return this.runtimeClass!=null ?this.runtimeClass.build():null;
  }
  public RuntimeClassStrategyOptions buildRuntimeClass() {
    return this.runtimeClass!=null ?this.runtimeClass.build():null;
  }
  public A withRuntimeClass(RuntimeClassStrategyOptions runtimeClass) {
    _visitables.get("runtimeClass").remove(this.runtimeClass);
    if (runtimeClass!=null){ this.runtimeClass= new RuntimeClassStrategyOptionsBuilder(runtimeClass); _visitables.get("runtimeClass").add(this.runtimeClass);} else { this.runtimeClass = null; _visitables.get("runtimeClass").remove(this.runtimeClass); } return (A) this;
  }
  public Boolean hasRuntimeClass() {
    return this.runtimeClass != null;
  }
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClass() {
    return new PodSecurityPolicySpecFluentImpl.RuntimeClassNestedImpl();
  }
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.RuntimeClassNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editRuntimeClass() {
    return withNewRuntimeClassLike(getRuntimeClass());
  }
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClass() {
    return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): new RuntimeClassStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
    return withNewRuntimeClassLike(getRuntimeClass() != null ? getRuntimeClass(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSeLinux instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxStrategyOptions getSeLinux() {
    return this.seLinux!=null ?this.seLinux.build():null;
  }
  public SELinuxStrategyOptions buildSeLinux() {
    return this.seLinux!=null ?this.seLinux.build():null;
  }
  public A withSeLinux(SELinuxStrategyOptions seLinux) {
    _visitables.get("seLinux").remove(this.seLinux);
    if (seLinux!=null){ this.seLinux= new SELinuxStrategyOptionsBuilder(seLinux); _visitables.get("seLinux").add(this.seLinux);} else { this.seLinux = null; _visitables.get("seLinux").remove(this.seLinux); } return (A) this;
  }
  public Boolean hasSeLinux() {
    return this.seLinux != null;
  }
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux() {
    return new PodSecurityPolicySpecFluentImpl.SeLinuxNestedImpl();
  }
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.SeLinuxNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux() {
    return withNewSeLinuxLike(getSeLinux());
  }
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux() {
    return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): new SELinuxStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item) {
    return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSupplementalGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public SupplementalGroupsStrategyOptions getSupplementalGroups() {
    return this.supplementalGroups!=null ?this.supplementalGroups.build():null;
  }
  public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
    return this.supplementalGroups!=null ?this.supplementalGroups.build():null;
  }
  public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
    _visitables.get("supplementalGroups").remove(this.supplementalGroups);
    if (supplementalGroups!=null){ this.supplementalGroups= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.get("supplementalGroups").add(this.supplementalGroups);} else { this.supplementalGroups = null; _visitables.get("supplementalGroups").remove(this.supplementalGroups); } return (A) this;
  }
  public Boolean hasSupplementalGroups() {
    return this.supplementalGroups != null;
  }
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
    return new PodSecurityPolicySpecFluentImpl.SupplementalGroupsNestedImpl();
  }
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
    return new PodSecurityPolicySpecFluentImpl.SupplementalGroupsNestedImpl(item);
  }
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups());
  }
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new SupplementalGroupsStrategyOptionsBuilder().build());
  }
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
    return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
  }
  public A addToVolumes(Integer index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  public A setToVolumes(Integer index,String item) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    this.volumes.set(index, item); return (A)this;
  }
  public A addToVolumes(java.lang.String... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A addAllToVolumes(Collection<String> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<String>();}
    for (String item : items) {this.volumes.add(item);} return (A)this;
  }
  public A removeFromVolumes(java.lang.String... items) {
    for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<String> items) {
    for (String item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
  }
  public List<String> getVolumes() {
    return this.volumes;
  }
  public String getVolume(Integer index) {
    return this.volumes.get(index);
  }
  public String getFirstVolume() {
    return this.volumes.get(0);
  }
  public String getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  public String getMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<String> predicate) {
    for (String item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<String> volumes) {
    if (volumes != null) {this.volumes = new ArrayList(); for (String item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(java.lang.String... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSecurityPolicySpecFluentImpl that = (PodSecurityPolicySpecFluentImpl) o;
    if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
    if (allowedCSIDrivers != null ? !allowedCSIDrivers.equals(that.allowedCSIDrivers) :that.allowedCSIDrivers != null) return false;
    if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
    if (allowedFlexVolumes != null ? !allowedFlexVolumes.equals(that.allowedFlexVolumes) :that.allowedFlexVolumes != null) return false;
    if (allowedHostPaths != null ? !allowedHostPaths.equals(that.allowedHostPaths) :that.allowedHostPaths != null) return false;
    if (allowedProcMountTypes != null ? !allowedProcMountTypes.equals(that.allowedProcMountTypes) :that.allowedProcMountTypes != null) return false;
    if (allowedUnsafeSysctls != null ? !allowedUnsafeSysctls.equals(that.allowedUnsafeSysctls) :that.allowedUnsafeSysctls != null) return false;
    if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
    if (defaultAllowPrivilegeEscalation != null ? !defaultAllowPrivilegeEscalation.equals(that.defaultAllowPrivilegeEscalation) :that.defaultAllowPrivilegeEscalation != null) return false;
    if (forbiddenSysctls != null ? !forbiddenSysctls.equals(that.forbiddenSysctls) :that.forbiddenSysctls != null) return false;
    if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
    if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
    if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
    if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
    if (hostPorts != null ? !hostPorts.equals(that.hostPorts) :that.hostPorts != null) return false;
    if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
    if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
    if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
    if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
    if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
    if (runtimeClass != null ? !runtimeClass.equals(that.runtimeClass) :that.runtimeClass != null) return false;
    if (seLinux != null ? !seLinux.equals(that.seLinux) :that.seLinux != null) return false;
    if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowPrivilegeEscalation,  allowedCSIDrivers,  allowedCapabilities,  allowedFlexVolumes,  allowedHostPaths,  allowedProcMountTypes,  allowedUnsafeSysctls,  defaultAddCapabilities,  defaultAllowPrivilegeEscalation,  forbiddenSysctls,  fsGroup,  hostIPC,  hostNetwork,  hostPID,  hostPorts,  privileged,  readOnlyRootFilesystem,  requiredDropCapabilities,  runAsGroup,  runAsUser,  runtimeClass,  seLinux,  supplementalGroups,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowPrivilegeEscalation != null) { sb.append("allowPrivilegeEscalation:"); sb.append(allowPrivilegeEscalation + ","); }
    if (allowedCSIDrivers != null && !allowedCSIDrivers.isEmpty()) { sb.append("allowedCSIDrivers:"); sb.append(allowedCSIDrivers + ","); }
    if (allowedCapabilities != null && !allowedCapabilities.isEmpty()) { sb.append("allowedCapabilities:"); sb.append(allowedCapabilities + ","); }
    if (allowedFlexVolumes != null && !allowedFlexVolumes.isEmpty()) { sb.append("allowedFlexVolumes:"); sb.append(allowedFlexVolumes + ","); }
    if (allowedHostPaths != null && !allowedHostPaths.isEmpty()) { sb.append("allowedHostPaths:"); sb.append(allowedHostPaths + ","); }
    if (allowedProcMountTypes != null && !allowedProcMountTypes.isEmpty()) { sb.append("allowedProcMountTypes:"); sb.append(allowedProcMountTypes + ","); }
    if (allowedUnsafeSysctls != null && !allowedUnsafeSysctls.isEmpty()) { sb.append("allowedUnsafeSysctls:"); sb.append(allowedUnsafeSysctls + ","); }
    if (defaultAddCapabilities != null && !defaultAddCapabilities.isEmpty()) { sb.append("defaultAddCapabilities:"); sb.append(defaultAddCapabilities + ","); }
    if (defaultAllowPrivilegeEscalation != null) { sb.append("defaultAllowPrivilegeEscalation:"); sb.append(defaultAllowPrivilegeEscalation + ","); }
    if (forbiddenSysctls != null && !forbiddenSysctls.isEmpty()) { sb.append("forbiddenSysctls:"); sb.append(forbiddenSysctls + ","); }
    if (fsGroup != null) { sb.append("fsGroup:"); sb.append(fsGroup + ","); }
    if (hostIPC != null) { sb.append("hostIPC:"); sb.append(hostIPC + ","); }
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (hostPID != null) { sb.append("hostPID:"); sb.append(hostPID + ","); }
    if (hostPorts != null && !hostPorts.isEmpty()) { sb.append("hostPorts:"); sb.append(hostPorts + ","); }
    if (privileged != null) { sb.append("privileged:"); sb.append(privileged + ","); }
    if (readOnlyRootFilesystem != null) { sb.append("readOnlyRootFilesystem:"); sb.append(readOnlyRootFilesystem + ","); }
    if (requiredDropCapabilities != null && !requiredDropCapabilities.isEmpty()) { sb.append("requiredDropCapabilities:"); sb.append(requiredDropCapabilities + ","); }
    if (runAsGroup != null) { sb.append("runAsGroup:"); sb.append(runAsGroup + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (runtimeClass != null) { sb.append("runtimeClass:"); sb.append(runtimeClass + ","); }
    if (seLinux != null) { sb.append("seLinux:"); sb.append(seLinux + ","); }
    if (supplementalGroups != null) { sb.append("supplementalGroups:"); sb.append(supplementalGroups + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowPrivilegeEscalation() {
    return withAllowPrivilegeEscalation(true);
  }
  public A withDefaultAllowPrivilegeEscalation() {
    return withDefaultAllowPrivilegeEscalation(true);
  }
  public A withHostIPC() {
    return withHostIPC(true);
  }
  public A withHostNetwork() {
    return withHostNetwork(true);
  }
  public A withHostPID() {
    return withHostPID(true);
  }
  public A withPrivileged() {
    return withPrivileged(true);
  }
  public A withReadOnlyRootFilesystem() {
    return withReadOnlyRootFilesystem(true);
  }
  class AllowedCSIDriversNestedImpl<N> extends AllowedCSIDriverFluentImpl<PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>> implements PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>,Nested<N>{
    AllowedCSIDriversNestedImpl(Integer index,AllowedCSIDriver item) {
      this.index = index;
      this.builder = new AllowedCSIDriverBuilder(this, item);
    }
    AllowedCSIDriversNestedImpl() {
      this.index = -1;
      this.builder = new AllowedCSIDriverBuilder(this);
    }
    AllowedCSIDriverBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedCSIDrivers(index,builder.build());
    }
    public N endAllowedCSIDriver() {
      return and();
    }
    
  }
  class AllowedFlexVolumesNestedImpl<N> extends AllowedFlexVolumeFluentImpl<PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>> implements PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>,Nested<N>{
    AllowedFlexVolumesNestedImpl(Integer index,AllowedFlexVolume item) {
      this.index = index;
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumesNestedImpl() {
      this.index = -1;
      this.builder = new AllowedFlexVolumeBuilder(this);
    }
    AllowedFlexVolumeBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedFlexVolumes(index,builder.build());
    }
    public N endAllowedFlexVolume() {
      return and();
    }
    
  }
  class AllowedHostPathsNestedImpl<N> extends AllowedHostPathFluentImpl<PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>> implements PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>,Nested<N>{
    AllowedHostPathsNestedImpl(Integer index,AllowedHostPath item) {
      this.index = index;
      this.builder = new AllowedHostPathBuilder(this, item);
    }
    AllowedHostPathsNestedImpl() {
      this.index = -1;
      this.builder = new AllowedHostPathBuilder(this);
    }
    AllowedHostPathBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToAllowedHostPaths(index,builder.build());
    }
    public N endAllowedHostPath() {
      return and();
    }
    
  }
  class FsGroupNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.FsGroupNested<N>> implements PodSecurityPolicySpecFluent.FsGroupNested<N>,Nested<N>{
    FsGroupNestedImpl(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FsGroupNestedImpl() {
      this.builder = new FSGroupStrategyOptionsBuilder(this);
    }
    FSGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withFsGroup(builder.build());
    }
    public N endFsGroup() {
      return and();
    }
    
  }
  class HostPortsNestedImpl<N> extends HostPortRangeFluentImpl<PodSecurityPolicySpecFluent.HostPortsNested<N>> implements PodSecurityPolicySpecFluent.HostPortsNested<N>,Nested<N>{
    HostPortsNestedImpl(Integer index,HostPortRange item) {
      this.index = index;
      this.builder = new HostPortRangeBuilder(this, item);
    }
    HostPortsNestedImpl() {
      this.index = -1;
      this.builder = new HostPortRangeBuilder(this);
    }
    HostPortRangeBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.setToHostPorts(index,builder.build());
    }
    public N endHostPort() {
      return and();
    }
    
  }
  class RunAsGroupNestedImpl<N> extends RunAsGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsGroupNested<N>> implements PodSecurityPolicySpecFluent.RunAsGroupNested<N>,Nested<N>{
    RunAsGroupNestedImpl(RunAsGroupStrategyOptions item) {
      this.builder = new RunAsGroupStrategyOptionsBuilder(this, item);
    }
    RunAsGroupNestedImpl() {
      this.builder = new RunAsGroupStrategyOptionsBuilder(this);
    }
    RunAsGroupStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRunAsGroup(builder.build());
    }
    public N endRunAsGroup() {
      return and();
    }
    
  }
  class RunAsUserNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsUserNested<N>> implements PodSecurityPolicySpecFluent.RunAsUserNested<N>,Nested<N>{
    RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserNestedImpl() {
      this.builder = new RunAsUserStrategyOptionsBuilder(this);
    }
    RunAsUserStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRunAsUser(builder.build());
    }
    public N endRunAsUser() {
      return and();
    }
    
  }
  class RuntimeClassNestedImpl<N> extends RuntimeClassStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RuntimeClassNested<N>> implements PodSecurityPolicySpecFluent.RuntimeClassNested<N>,Nested<N>{
    RuntimeClassNestedImpl(RuntimeClassStrategyOptions item) {
      this.builder = new RuntimeClassStrategyOptionsBuilder(this, item);
    }
    RuntimeClassNestedImpl() {
      this.builder = new RuntimeClassStrategyOptionsBuilder(this);
    }
    RuntimeClassStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withRuntimeClass(builder.build());
    }
    public N endRuntimeClass() {
      return and();
    }
    
  }
  class SeLinuxNestedImpl<N> extends SELinuxStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SeLinuxNested<N>> implements PodSecurityPolicySpecFluent.SeLinuxNested<N>,Nested<N>{
    SeLinuxNestedImpl(SELinuxStrategyOptions item) {
      this.builder = new SELinuxStrategyOptionsBuilder(this, item);
    }
    SeLinuxNestedImpl() {
      this.builder = new SELinuxStrategyOptionsBuilder(this);
    }
    SELinuxStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withSeLinux(builder.build());
    }
    public N endSeLinux() {
      return and();
    }
    
  }
  class SupplementalGroupsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>> implements PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,Nested<N>{
    SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsNestedImpl() {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(builder.build());
    }
    public N endSupplementalGroups() {
      return and();
    }
    
  }
  
}