/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentTriggerImageChangeParamsFluentImpl<A extends DeploymentTriggerImageChangeParamsFluent<A>>
extends BaseFluent<A>
implements DeploymentTriggerImageChangeParamsFluent<A> {
    private Boolean automatic;
    private List<String> containerNames = new ArrayList<String>();
    private ObjectReferenceBuilder from;
    private String lastTriggeredImage;
    private Map<String, Object> additionalProperties;

    public DeploymentTriggerImageChangeParamsFluentImpl() {
    }

    public DeploymentTriggerImageChangeParamsFluentImpl(DeploymentTriggerImageChangeParams instance) {
        this.withAutomatic(instance.getAutomatic());
        this.withContainerNames(instance.getContainerNames());
        this.withFrom(instance.getFrom());
        this.withLastTriggeredImage(instance.getLastTriggeredImage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAutomatic() {
        return this.automatic;
    }

    @Override
    public A withAutomatic(Boolean automatic) {
        this.automatic = automatic;
        return (A)this;
    }

    @Override
    public Boolean hasAutomatic() {
        return this.automatic != null;
    }

    @Override
    public A addToContainerNames(Integer index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerNames(Integer index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerNames(String ... items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerNames() {
        return this.containerNames;
    }

    @Override
    public String getContainerName(Integer index) {
        return this.containerNames.get(index);
    }

    @Override
    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    @Override
    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    @Override
    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerNames(List<String> containerNames) {
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    @Override
    public A addNewContainerName(String arg0) {
        return this.addToContainerNames(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getLastTriggeredImage() {
        return this.lastTriggeredImage;
    }

    @Override
    public A withLastTriggeredImage(String lastTriggeredImage) {
        this.lastTriggeredImage = lastTriggeredImage;
        return (A)this;
    }

    @Override
    public Boolean hasLastTriggeredImage() {
        return this.lastTriggeredImage != null;
    }

    @Override
    @Deprecated
    public A withNewLastTriggeredImage(String arg0) {
        return this.withLastTriggeredImage(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentTriggerImageChangeParamsFluentImpl that = (DeploymentTriggerImageChangeParamsFluentImpl)o;
        if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) {
            return false;
        }
        if (this.containerNames != null ? !this.containerNames.equals(that.containerNames) : that.containerNames != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.lastTriggeredImage != null ? !this.lastTriggeredImage.equals(that.lastTriggeredImage) : that.lastTriggeredImage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.automatic, this.containerNames, this.from, this.lastTriggeredImage, this.additionalProperties, super.hashCode());
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DeploymentTriggerImageChangeParamsFluent.FromNested<N>>
    implements DeploymentTriggerImageChangeParamsFluent.FromNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentTriggerImageChangeParamsFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

