/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfig;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.RAIDConfigFluentImpl;
import java.util.Objects;

public class RAIDConfigBuilder
extends RAIDConfigFluentImpl<RAIDConfigBuilder>
implements VisitableBuilder<RAIDConfig, RAIDConfigBuilder> {
    RAIDConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RAIDConfigBuilder() {
        this(false);
    }

    public RAIDConfigBuilder(Boolean validationEnabled) {
        this(new RAIDConfig(), validationEnabled);
    }

    public RAIDConfigBuilder(RAIDConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RAIDConfigBuilder(RAIDConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RAIDConfig(), validationEnabled);
    }

    public RAIDConfigBuilder(RAIDConfigFluent<?> fluent, RAIDConfig instance) {
        this(fluent, instance, false);
    }

    public RAIDConfigBuilder(RAIDConfigFluent<?> fluent, RAIDConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes());
        fluent.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RAIDConfigBuilder(RAIDConfig instance) {
        this(instance, (Boolean)false);
    }

    public RAIDConfigBuilder(RAIDConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHardwareRAIDVolumes(instance.getHardwareRAIDVolumes());
        this.withSoftwareRAIDVolumes(instance.getSoftwareRAIDVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RAIDConfig build() {
        RAIDConfig buildable = new RAIDConfig(this.fluent.getHardwareRAIDVolumes(), this.fluent.getSoftwareRAIDVolumes());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RAIDConfigBuilder that = (RAIDConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

