/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock;

import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.server.mock.CustomResourceAware;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.Resetable;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.MockResponse;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class KubernetesMixedDispatcher
extends Dispatcher
implements Resetable,
CustomResourceAware {
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final MockDispatcher mockDispatcher;
    private final KubernetesCrudDispatcher kubernetesCrudDispatcher;

    public KubernetesMixedDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses) {
        this(responses, Collections.emptyList());
    }

    public KubernetesMixedDispatcher(Map<ServerRequest, Queue<ServerResponse>> responses, List<CustomResourceDefinitionContext> crdContexts) {
        this.responses = responses;
        this.mockDispatcher = new MockDispatcher(responses);
        this.kubernetesCrudDispatcher = new KubernetesCrudDispatcher(crdContexts);
    }

    public MockResponse dispatch(RecordedRequest request) {
        Queue<ServerResponse> responseQueue = this.responses.get(new SimpleRequest(HttpMethod.valueOf((String)request.getMethod()), request.getPath()));
        if (responseQueue != null && !responseQueue.isEmpty()) {
            return this.mockDispatcher.dispatch(request);
        }
        return this.kubernetesCrudDispatcher.dispatch(request);
    }

    @Override
    public void reset() {
        this.kubernetesCrudDispatcher.reset();
    }

    @Override
    public void expectCustomResource(CustomResourceDefinitionContext rdc) {
        this.kubernetesCrudDispatcher.expectCustomResource(rdc);
    }
}

