/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import java.nio.charset.StandardCharsets;

public class WebSocketMessage {
    private final Long delay;
    private final byte[] body;
    private final boolean toBeRemoved;
    private final boolean binary;

    public WebSocketMessage(String body) {
        this((Long)0L, body, true);
    }

    public WebSocketMessage(byte[] body) {
        this((Long)0L, body, true, true);
    }

    public WebSocketMessage(String body, boolean toBeRemoved) {
        this((Long)0L, body.getBytes(StandardCharsets.UTF_8), toBeRemoved, false);
    }

    public WebSocketMessage(byte[] body, boolean toBeRemoved) {
        this((Long)0L, body, toBeRemoved, true);
    }

    public WebSocketMessage(Long delay, String body, boolean toBeRemoved) {
        this(delay, body.getBytes(StandardCharsets.UTF_8), toBeRemoved, false);
    }

    public WebSocketMessage(Long delay, byte[] body, boolean toBeRemoved) {
        this(delay, body, toBeRemoved, true);
    }

    public WebSocketMessage(Long delay, String body, boolean toBeRemoved, boolean binary) {
        this(delay, body.getBytes(StandardCharsets.UTF_8), toBeRemoved, binary);
    }

    public WebSocketMessage(Long delay, byte[] body, boolean toBeRemoved, boolean binary) {
        this.delay = delay;
        this.body = body;
        this.toBeRemoved = toBeRemoved;
        this.binary = binary;
    }

    public Long getDelay() {
        return this.delay;
    }

    public String getBody() {
        return new String(this.body);
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public boolean isBinary() {
        return this.binary;
    }
}

