/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRange;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRangeBuilder;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.HourRangeFluent;
import io.fabric8.openclustermanagement.api.model.multicloudoperatorssubscription.apps.v1.TimeWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TimeWindowFluent<A extends TimeWindowFluent<A>>
extends BaseFluent<A> {
    private List<String> daysofweek = new ArrayList<String>();
    private ArrayList<HourRangeBuilder> hours = new ArrayList();
    private String location;
    private String windowtype;
    private Map<String, Object> additionalProperties;

    public TimeWindowFluent() {
    }

    public TimeWindowFluent(TimeWindow instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TimeWindow instance) {
        TimeWindow timeWindow = instance = instance != null ? instance : new TimeWindow();
        if (instance != null) {
            this.withDaysofweek(instance.getDaysofweek());
            this.withHours(instance.getHours());
            this.withLocation(instance.getLocation());
            this.withWindowtype(instance.getWindowtype());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDaysofweek(int index, String item) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        this.daysofweek.add(index, item);
        return (A)((Object)this);
    }

    public A setToDaysofweek(int index, String item) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        this.daysofweek.set(index, item);
        return (A)((Object)this);
    }

    public A addToDaysofweek(String ... items) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        for (String item : items) {
            this.daysofweek.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDaysofweek(Collection<String> items) {
        if (this.daysofweek == null) {
            this.daysofweek = new ArrayList<String>();
        }
        for (String item : items) {
            this.daysofweek.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDaysofweek(String ... items) {
        if (this.daysofweek == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.daysofweek.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDaysofweek(Collection<String> items) {
        if (this.daysofweek == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.daysofweek.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDaysofweek() {
        return this.daysofweek;
    }

    public String getDaysofweek(int index) {
        return this.daysofweek.get(index);
    }

    public String getFirstDaysofweek() {
        return this.daysofweek.get(0);
    }

    public String getLastDaysofweek() {
        return this.daysofweek.get(this.daysofweek.size() - 1);
    }

    public String getMatchingDaysofweek(Predicate<String> predicate) {
        for (String item : this.daysofweek) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDaysofweek(Predicate<String> predicate) {
        for (String item : this.daysofweek) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDaysofweek(List<String> daysofweek) {
        if (daysofweek != null) {
            this.daysofweek = new ArrayList<String>();
            for (String item : daysofweek) {
                this.addToDaysofweek(item);
            }
        } else {
            this.daysofweek = null;
        }
        return (A)((Object)this);
    }

    public A withDaysofweek(String ... daysofweek) {
        if (this.daysofweek != null) {
            this.daysofweek.clear();
            this._visitables.remove((Object)"daysofweek");
        }
        if (daysofweek != null) {
            for (String item : daysofweek) {
                this.addToDaysofweek(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDaysofweek() {
        return this.daysofweek != null && !this.daysofweek.isEmpty();
    }

    public A addToHours(int index, HourRange item) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        HourRangeBuilder builder = new HourRangeBuilder(item);
        if (index < 0 || index >= this.hours.size()) {
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        } else {
            this._visitables.get((Object)"hours").add(index, builder);
            this.hours.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHours(int index, HourRange item) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        HourRangeBuilder builder = new HourRangeBuilder(item);
        if (index < 0 || index >= this.hours.size()) {
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        } else {
            this._visitables.get((Object)"hours").set(index, builder);
            this.hours.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHours(HourRange ... items) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHours(Collection<HourRange> items) {
        if (this.hours == null) {
            this.hours = new ArrayList();
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").add(builder);
            this.hours.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHours(HourRange ... items) {
        if (this.hours == null) {
            return (A)((Object)this);
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").remove((Object)builder);
            this.hours.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHours(Collection<HourRange> items) {
        if (this.hours == null) {
            return (A)((Object)this);
        }
        for (HourRange item : items) {
            HourRangeBuilder builder = new HourRangeBuilder(item);
            this._visitables.get((Object)"hours").remove((Object)builder);
            this.hours.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHours(Predicate<HourRangeBuilder> predicate) {
        if (this.hours == null) {
            return (A)((Object)this);
        }
        Iterator<HourRangeBuilder> each = this.hours.iterator();
        List visitables = this._visitables.get((Object)"hours");
        while (each.hasNext()) {
            HourRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HourRange> buildHours() {
        return this.hours != null ? TimeWindowFluent.build(this.hours) : null;
    }

    public HourRange buildHour(int index) {
        return this.hours.get(index).build();
    }

    public HourRange buildFirstHour() {
        return this.hours.get(0).build();
    }

    public HourRange buildLastHour() {
        return this.hours.get(this.hours.size() - 1).build();
    }

    public HourRange buildMatchingHour(Predicate<HourRangeBuilder> predicate) {
        for (HourRangeBuilder item : this.hours) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHour(Predicate<HourRangeBuilder> predicate) {
        for (HourRangeBuilder item : this.hours) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHours(List<HourRange> hours) {
        if (this.hours != null) {
            this._visitables.get((Object)"hours").clear();
        }
        if (hours != null) {
            this.hours = new ArrayList();
            for (HourRange item : hours) {
                this.addToHours(item);
            }
        } else {
            this.hours = null;
        }
        return (A)((Object)this);
    }

    public A withHours(HourRange ... hours) {
        if (this.hours != null) {
            this.hours.clear();
            this._visitables.remove((Object)"hours");
        }
        if (hours != null) {
            for (HourRange item : hours) {
                this.addToHours(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHours() {
        return this.hours != null && !this.hours.isEmpty();
    }

    public A addNewHour(String end, String start) {
        return this.addToHours(new HourRange(end, start));
    }

    public HoursNested<A> addNewHour() {
        return new HoursNested(-1, null);
    }

    public HoursNested<A> addNewHourLike(HourRange item) {
        return new HoursNested(-1, item);
    }

    public HoursNested<A> setNewHourLike(int index, HourRange item) {
        return new HoursNested(index, item);
    }

    public HoursNested<A> editHour(int index) {
        if (this.hours.size() <= index) {
            throw new RuntimeException("Can't edit hours. Index exceeds size.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    public HoursNested<A> editFirstHour() {
        if (this.hours.size() == 0) {
            throw new RuntimeException("Can't edit first hours. The list is empty.");
        }
        return this.setNewHourLike(0, this.buildHour(0));
    }

    public HoursNested<A> editLastHour() {
        int index = this.hours.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hours. The list is empty.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    public HoursNested<A> editMatchingHour(Predicate<HourRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hours.size(); ++i) {
            if (!predicate.test(this.hours.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hours. No match found.");
        }
        return this.setNewHourLike(index, this.buildHour(index));
    }

    public String getLocation() {
        return this.location;
    }

    public A withLocation(String location) {
        this.location = location;
        return (A)((Object)this);
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public String getWindowtype() {
        return this.windowtype;
    }

    public A withWindowtype(String windowtype) {
        this.windowtype = windowtype;
        return (A)((Object)this);
    }

    public boolean hasWindowtype() {
        return this.windowtype != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeWindowFluent that = (TimeWindowFluent)((Object)o);
        if (!Objects.equals(this.daysofweek, that.daysofweek)) {
            return false;
        }
        if (!Objects.equals(this.hours, that.hours)) {
            return false;
        }
        if (!Objects.equals(this.location, that.location)) {
            return false;
        }
        if (!Objects.equals(this.windowtype, that.windowtype)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.daysofweek, this.hours, this.location, this.windowtype, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.daysofweek != null && !this.daysofweek.isEmpty()) {
            sb.append("daysofweek:");
            sb.append(this.daysofweek + ",");
        }
        if (this.hours != null && !this.hours.isEmpty()) {
            sb.append("hours:");
            sb.append(this.hours + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(this.location + ",");
        }
        if (this.windowtype != null) {
            sb.append("windowtype:");
            sb.append(this.windowtype + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HoursNested<N>
    extends HourRangeFluent<HoursNested<N>>
    implements Nested<N> {
        HourRangeBuilder builder;
        int index;

        HoursNested(int index, HourRange item) {
            this.index = index;
            this.builder = new HourRangeBuilder(this, item);
        }

        public N and() {
            return (N)TimeWindowFluent.this.setToHours(this.index, this.builder.build());
        }

        public N endHour() {
            return this.and();
        }
    }
}

