/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionFluent;
import io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecisionFluentImpl;
import java.util.Objects;

public class ClusterDecisionBuilder
extends ClusterDecisionFluentImpl<ClusterDecisionBuilder>
implements VisitableBuilder<ClusterDecision, ClusterDecisionBuilder> {
    ClusterDecisionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterDecisionBuilder() {
        this(false);
    }

    public ClusterDecisionBuilder(Boolean validationEnabled) {
        this(new ClusterDecision(), validationEnabled);
    }

    public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterDecision(), validationEnabled);
    }

    public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent, ClusterDecision instance) {
        this(fluent, instance, false);
    }

    public ClusterDecisionBuilder(ClusterDecisionFluent<?> fluent, ClusterDecision instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterName(instance.getClusterName());
        fluent.withReason(instance.getReason());
        this.validationEnabled = validationEnabled;
    }

    public ClusterDecisionBuilder(ClusterDecision instance) {
        this(instance, (Boolean)false);
    }

    public ClusterDecisionBuilder(ClusterDecision instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterName(instance.getClusterName());
        this.withReason(instance.getReason());
        this.validationEnabled = validationEnabled;
    }

    public ClusterDecision build() {
        ClusterDecision buildable = new ClusterDecision(this.fluent.getClusterName(), this.fluent.getReason());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterDecisionBuilder that = (ClusterDecisionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

