/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfigBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.BackupConfigFluentImpl;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.ExternalDNSConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.ExternalDNSConfigBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.ExternalDNSConfigFluentImpl;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.FailedProvisionConfig;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.FailedProvisionConfigBuilder;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.FailedProvisionConfigFluentImpl;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HiveConfigSpec;
import io.fabric8.openclustermanagement.api.model.multiclusterhub.operator.v1.HiveConfigSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HiveConfigSpecFluentImpl<A extends HiveConfigSpecFluent<A>>
extends BaseFluent<A>
implements HiveConfigSpecFluent<A> {
    private List<LocalObjectReference> additionalCertificateAuthorities;
    private BackupConfigBuilder backup;
    private ExternalDNSConfigBuilder externalDNS;
    private FailedProvisionConfigBuilder failedProvisionConfig;
    private LocalObjectReference globalPullSecret;
    private Boolean maintenanceMode;

    public HiveConfigSpecFluentImpl() {
    }

    public HiveConfigSpecFluentImpl(HiveConfigSpec instance) {
        this.withAdditionalCertificateAuthorities(instance.getAdditionalCertificateAuthorities());
        this.withBackup(instance.getBackup());
        this.withExternalDNS(instance.getExternalDNS());
        this.withFailedProvisionConfig(instance.getFailedProvisionConfig());
        this.withGlobalPullSecret(instance.getGlobalPullSecret());
        this.withMaintenanceMode(instance.getMaintenanceMode());
    }

    @Override
    public A addToAdditionalCertificateAuthorities(Integer index, LocalObjectReference item) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList<LocalObjectReference>();
        }
        this.additionalCertificateAuthorities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalCertificateAuthorities(Integer index, LocalObjectReference item) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList<LocalObjectReference>();
        }
        this.additionalCertificateAuthorities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalCertificateAuthorities(LocalObjectReference ... items) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.additionalCertificateAuthorities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
        if (this.additionalCertificateAuthorities == null) {
            this.additionalCertificateAuthorities = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.additionalCertificateAuthorities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalCertificateAuthorities(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            if (this.additionalCertificateAuthorities == null) continue;
            this.additionalCertificateAuthorities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalCertificateAuthorities(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            if (this.additionalCertificateAuthorities == null) continue;
            this.additionalCertificateAuthorities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getAdditionalCertificateAuthorities() {
        return this.additionalCertificateAuthorities;
    }

    @Override
    public LocalObjectReference getAdditionalCertificateAuthority(Integer index) {
        return this.additionalCertificateAuthorities.get(index);
    }

    @Override
    public LocalObjectReference getFirstAdditionalCertificateAuthority() {
        return this.additionalCertificateAuthorities.get(0);
    }

    @Override
    public LocalObjectReference getLastAdditionalCertificateAuthority() {
        return this.additionalCertificateAuthorities.get(this.additionalCertificateAuthorities.size() - 1);
    }

    @Override
    public LocalObjectReference getMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.additionalCertificateAuthorities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalCertificateAuthority(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.additionalCertificateAuthorities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalCertificateAuthorities(List<LocalObjectReference> additionalCertificateAuthorities) {
        if (additionalCertificateAuthorities != null) {
            this.additionalCertificateAuthorities = new ArrayList<LocalObjectReference>();
            for (LocalObjectReference item : additionalCertificateAuthorities) {
                this.addToAdditionalCertificateAuthorities(item);
            }
        } else {
            this.additionalCertificateAuthorities = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalCertificateAuthorities(LocalObjectReference ... additionalCertificateAuthorities) {
        if (this.additionalCertificateAuthorities != null) {
            this.additionalCertificateAuthorities.clear();
        }
        if (additionalCertificateAuthorities != null) {
            for (LocalObjectReference item : additionalCertificateAuthorities) {
                this.addToAdditionalCertificateAuthorities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalCertificateAuthorities() {
        return this.additionalCertificateAuthorities != null && !this.additionalCertificateAuthorities.isEmpty();
    }

    @Override
    public A addNewAdditionalCertificateAuthority(String name) {
        return this.addToAdditionalCertificateAuthorities(new LocalObjectReference(name));
    }

    @Override
    @Deprecated
    public BackupConfig getBackup() {
        return this.backup != null ? this.backup.build() : null;
    }

    @Override
    public BackupConfig buildBackup() {
        return this.backup != null ? this.backup.build() : null;
    }

    @Override
    public A withBackup(BackupConfig backup) {
        this._visitables.get((Object)"backup").remove(this.backup);
        if (backup != null) {
            this.backup = new BackupConfigBuilder(backup);
            this._visitables.get((Object)"backup").add(this.backup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackup() {
        return this.backup != null;
    }

    @Override
    public HiveConfigSpecFluent.BackupNested<A> withNewBackup() {
        return new BackupNestedImpl();
    }

    @Override
    public HiveConfigSpecFluent.BackupNested<A> withNewBackupLike(BackupConfig item) {
        return new BackupNestedImpl(item);
    }

    @Override
    public HiveConfigSpecFluent.BackupNested<A> editBackup() {
        return this.withNewBackupLike(this.getBackup());
    }

    @Override
    public HiveConfigSpecFluent.BackupNested<A> editOrNewBackup() {
        return this.withNewBackupLike(this.getBackup() != null ? this.getBackup() : new BackupConfigBuilder().build());
    }

    @Override
    public HiveConfigSpecFluent.BackupNested<A> editOrNewBackupLike(BackupConfig item) {
        return this.withNewBackupLike(this.getBackup() != null ? this.getBackup() : item);
    }

    @Override
    @Deprecated
    public ExternalDNSConfig getExternalDNS() {
        return this.externalDNS != null ? this.externalDNS.build() : null;
    }

    @Override
    public ExternalDNSConfig buildExternalDNS() {
        return this.externalDNS != null ? this.externalDNS.build() : null;
    }

    @Override
    public A withExternalDNS(ExternalDNSConfig externalDNS) {
        this._visitables.get((Object)"externalDNS").remove(this.externalDNS);
        if (externalDNS != null) {
            this.externalDNS = new ExternalDNSConfigBuilder(externalDNS);
            this._visitables.get((Object)"externalDNS").add(this.externalDNS);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalDNS() {
        return this.externalDNS != null;
    }

    @Override
    public HiveConfigSpecFluent.ExternalDNSNested<A> withNewExternalDNS() {
        return new ExternalDNSNestedImpl();
    }

    @Override
    public HiveConfigSpecFluent.ExternalDNSNested<A> withNewExternalDNSLike(ExternalDNSConfig item) {
        return new ExternalDNSNestedImpl(item);
    }

    @Override
    public HiveConfigSpecFluent.ExternalDNSNested<A> editExternalDNS() {
        return this.withNewExternalDNSLike(this.getExternalDNS());
    }

    @Override
    public HiveConfigSpecFluent.ExternalDNSNested<A> editOrNewExternalDNS() {
        return this.withNewExternalDNSLike(this.getExternalDNS() != null ? this.getExternalDNS() : new ExternalDNSConfigBuilder().build());
    }

    @Override
    public HiveConfigSpecFluent.ExternalDNSNested<A> editOrNewExternalDNSLike(ExternalDNSConfig item) {
        return this.withNewExternalDNSLike(this.getExternalDNS() != null ? this.getExternalDNS() : item);
    }

    @Override
    @Deprecated
    public FailedProvisionConfig getFailedProvisionConfig() {
        return this.failedProvisionConfig != null ? this.failedProvisionConfig.build() : null;
    }

    @Override
    public FailedProvisionConfig buildFailedProvisionConfig() {
        return this.failedProvisionConfig != null ? this.failedProvisionConfig.build() : null;
    }

    @Override
    public A withFailedProvisionConfig(FailedProvisionConfig failedProvisionConfig) {
        this._visitables.get((Object)"failedProvisionConfig").remove(this.failedProvisionConfig);
        if (failedProvisionConfig != null) {
            this.failedProvisionConfig = new FailedProvisionConfigBuilder(failedProvisionConfig);
            this._visitables.get((Object)"failedProvisionConfig").add(this.failedProvisionConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFailedProvisionConfig() {
        return this.failedProvisionConfig != null;
    }

    @Override
    public A withNewFailedProvisionConfig(Boolean skipGatherLogs) {
        return this.withFailedProvisionConfig(new FailedProvisionConfig(skipGatherLogs));
    }

    @Override
    public HiveConfigSpecFluent.FailedProvisionConfigNested<A> withNewFailedProvisionConfig() {
        return new FailedProvisionConfigNestedImpl();
    }

    @Override
    public HiveConfigSpecFluent.FailedProvisionConfigNested<A> withNewFailedProvisionConfigLike(FailedProvisionConfig item) {
        return new FailedProvisionConfigNestedImpl(item);
    }

    @Override
    public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editFailedProvisionConfig() {
        return this.withNewFailedProvisionConfigLike(this.getFailedProvisionConfig());
    }

    @Override
    public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfig() {
        return this.withNewFailedProvisionConfigLike(this.getFailedProvisionConfig() != null ? this.getFailedProvisionConfig() : new FailedProvisionConfigBuilder().build());
    }

    @Override
    public HiveConfigSpecFluent.FailedProvisionConfigNested<A> editOrNewFailedProvisionConfigLike(FailedProvisionConfig item) {
        return this.withNewFailedProvisionConfigLike(this.getFailedProvisionConfig() != null ? this.getFailedProvisionConfig() : item);
    }

    @Override
    public LocalObjectReference getGlobalPullSecret() {
        return this.globalPullSecret;
    }

    @Override
    public A withGlobalPullSecret(LocalObjectReference globalPullSecret) {
        this.globalPullSecret = globalPullSecret;
        return (A)this;
    }

    @Override
    public Boolean hasGlobalPullSecret() {
        return this.globalPullSecret != null;
    }

    @Override
    public A withNewGlobalPullSecret(String name) {
        return this.withGlobalPullSecret(new LocalObjectReference(name));
    }

    @Override
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    @Override
    public A withMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return (A)this;
    }

    @Override
    public Boolean hasMaintenanceMode() {
        return this.maintenanceMode != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveConfigSpecFluentImpl that = (HiveConfigSpecFluentImpl)o;
        if (this.additionalCertificateAuthorities != null ? !this.additionalCertificateAuthorities.equals(that.additionalCertificateAuthorities) : that.additionalCertificateAuthorities != null) {
            return false;
        }
        if (this.backup != null ? !this.backup.equals(that.backup) : that.backup != null) {
            return false;
        }
        if (this.externalDNS != null ? !this.externalDNS.equals(that.externalDNS) : that.externalDNS != null) {
            return false;
        }
        if (this.failedProvisionConfig != null ? !this.failedProvisionConfig.equals(that.failedProvisionConfig) : that.failedProvisionConfig != null) {
            return false;
        }
        if (this.globalPullSecret != null ? !this.globalPullSecret.equals((Object)that.globalPullSecret) : that.globalPullSecret != null) {
            return false;
        }
        return !(this.maintenanceMode != null ? !this.maintenanceMode.equals(that.maintenanceMode) : that.maintenanceMode != null);
    }

    public int hashCode() {
        return Objects.hash(this.additionalCertificateAuthorities, this.backup, this.externalDNS, this.failedProvisionConfig, this.globalPullSecret, this.maintenanceMode, super.hashCode());
    }

    public class FailedProvisionConfigNestedImpl<N>
    extends FailedProvisionConfigFluentImpl<HiveConfigSpecFluent.FailedProvisionConfigNested<N>>
    implements HiveConfigSpecFluent.FailedProvisionConfigNested<N>,
    Nested<N> {
        FailedProvisionConfigBuilder builder;

        FailedProvisionConfigNestedImpl(FailedProvisionConfig item) {
            this.builder = new FailedProvisionConfigBuilder(this, item);
        }

        FailedProvisionConfigNestedImpl() {
            this.builder = new FailedProvisionConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)HiveConfigSpecFluentImpl.this.withFailedProvisionConfig(this.builder.build());
        }

        @Override
        public N endFailedProvisionConfig() {
            return this.and();
        }
    }

    public class ExternalDNSNestedImpl<N>
    extends ExternalDNSConfigFluentImpl<HiveConfigSpecFluent.ExternalDNSNested<N>>
    implements HiveConfigSpecFluent.ExternalDNSNested<N>,
    Nested<N> {
        ExternalDNSConfigBuilder builder;

        ExternalDNSNestedImpl(ExternalDNSConfig item) {
            this.builder = new ExternalDNSConfigBuilder(this, item);
        }

        ExternalDNSNestedImpl() {
            this.builder = new ExternalDNSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)HiveConfigSpecFluentImpl.this.withExternalDNS(this.builder.build());
        }

        @Override
        public N endExternalDNS() {
            return this.and();
        }
    }

    public class BackupNestedImpl<N>
    extends BackupConfigFluentImpl<HiveConfigSpecFluent.BackupNested<N>>
    implements HiveConfigSpecFluent.BackupNested<N>,
    Nested<N> {
        BackupConfigBuilder builder;

        BackupNestedImpl(BackupConfig item) {
            this.builder = new BackupConfigBuilder(this, item);
        }

        BackupNestedImpl() {
            this.builder = new BackupConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)HiveConfigSpecFluentImpl.this.withBackup(this.builder.build());
        }

        @Override
        public N endBackup() {
            return this.and();
        }
    }
}

