/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Map;

public class OpenShiftConfig
extends Config {
    public static final String KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY = "kubernetes.oapi.version";
    public static final String OPENSHIFT_URL_SYTEM_PROPERTY = "openshift.url";
    private String oapiVersion = "v1";
    private String openShiftUrl;

    OpenShiftConfig() {
    }

    public OpenShiftConfig(Config kubernetesConfig) {
        this(kubernetesConfig, OpenShiftConfig.getDefaultOpenShiftUrl(kubernetesConfig), OpenShiftConfig.getDefaultOapiVersion(kubernetesConfig));
    }

    public OpenShiftConfig(String openShiftUrl, String oapiVersion, String masterUrl, String apiVersion, String namespace, Boolean trustCerts, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String username, String password, String oauthToken, int watchReconnectInterval, int watchReconnectLimit, int connectionTimeout, int requestTimeout, long rollingTimeout, long scaleTimeout, int loggingInterval, String httpProxy, String httpsProxy, String[] noProxy, Map<Integer, String> errorMessages, String userAgent) {
        super(masterUrl, apiVersion, namespace, trustCerts.booleanValue(), caCertFile, caCertData, clientCertFile, clientCertData, clientKeyFile, clientKeyData, clientKeyAlgo, clientKeyPassphrase, username, password, oauthToken, watchReconnectInterval, watchReconnectLimit, connectionTimeout, requestTimeout, rollingTimeout, scaleTimeout, loggingInterval, httpProxy, httpsProxy, noProxy, errorMessages, userAgent);
        this.oapiVersion = oapiVersion;
        this.openShiftUrl = openShiftUrl;
        if (this.openShiftUrl == null || this.openShiftUrl.isEmpty()) {
            this.openShiftUrl = URLUtils.join((String[])new String[]{this.getMasterUrl(), "oapi", this.oapiVersion});
        }
        if (!this.openShiftUrl.endsWith("/")) {
            this.openShiftUrl = this.openShiftUrl + "/";
        }
    }

    public OpenShiftConfig(Config kubernetesConfig, String openShiftUrl, String oapiVersion) {
        this(openShiftUrl, oapiVersion, kubernetesConfig.getMasterUrl(), kubernetesConfig.getApiVersion(), kubernetesConfig.getNamespace(), kubernetesConfig.isTrustCerts(), kubernetesConfig.getCaCertFile(), kubernetesConfig.getCaCertData(), kubernetesConfig.getClientCertFile(), kubernetesConfig.getClientCertData(), kubernetesConfig.getClientKeyFile(), kubernetesConfig.getClientKeyData(), kubernetesConfig.getClientKeyAlgo(), kubernetesConfig.getClientKeyPassphrase(), kubernetesConfig.getUsername(), kubernetesConfig.getPassword(), kubernetesConfig.getOauthToken(), kubernetesConfig.getWatchReconnectInterval(), kubernetesConfig.getWatchReconnectLimit(), kubernetesConfig.getConnectionTimeout(), kubernetesConfig.getRequestTimeout(), kubernetesConfig.getRollingTimeout(), kubernetesConfig.getScaleTimeout(), kubernetesConfig.getLoggingInterval(), kubernetesConfig.getHttpProxy(), kubernetesConfig.getHttpsProxy(), kubernetesConfig.getNoProxy(), kubernetesConfig.getErrorMessages(), kubernetesConfig.getUserAgent());
    }

    public static OpenShiftConfig wrap(Config config) {
        return config instanceof OpenShiftConfig ? (OpenShiftConfig)config : new OpenShiftConfig(config);
    }

    private static String getDefaultOapiVersion(Config config) {
        return Utils.getSystemPropertyOrEnvVar((String)KUBERNETES_OAPI_VERSION_SYSTEM_PROPERTY, (String)config.getApiVersion());
    }

    private static String getDefaultOpenShiftUrl(Config config) {
        return Utils.getSystemPropertyOrEnvVar((String)OPENSHIFT_URL_SYTEM_PROPERTY, (String)URLUtils.join((String[])new String[]{config.getMasterUrl(), "oapi", OpenShiftConfig.getDefaultOapiVersion(config)}));
    }

    public String getOapiVersion() {
        return this.oapiVersion;
    }

    public void setOapiVersion(String oapiVersion) {
        this.oapiVersion = oapiVersion;
    }

    public String getOpenShiftUrl() {
        return this.openShiftUrl;
    }

    public void setOpenShiftUrl(String openShiftUrl) {
        this.openShiftUrl = openShiftUrl;
    }
}

