package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIServerListBuilder extends APIServerListFluent<APIServerListBuilder> implements VisitableBuilder<APIServerList,APIServerListBuilder>{
  public APIServerListBuilder() {
    this(new APIServerList());
  }
  
  public APIServerListBuilder(APIServerListFluent<?> fluent) {
    this(fluent, new APIServerList());
  }
  
  public APIServerListBuilder(APIServerListFluent<?> fluent,APIServerList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIServerListBuilder(APIServerList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIServerListFluent<?> fluent;
  
  public APIServerList build() {
    APIServerList buildable = new APIServerList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}