package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AuthenticationListBuilder extends AuthenticationListFluent<AuthenticationListBuilder> implements VisitableBuilder<AuthenticationList,AuthenticationListBuilder>{
  public AuthenticationListBuilder() {
    this(new AuthenticationList());
  }
  
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent) {
    this(fluent, new AuthenticationList());
  }
  
  public AuthenticationListBuilder(AuthenticationListFluent<?> fluent,AuthenticationList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AuthenticationListBuilder(AuthenticationList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AuthenticationListFluent<?> fluent;
  
  public AuthenticationList build() {
    AuthenticationList buildable = new AuthenticationList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}