package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AuthenticationSpecFluent<A extends AuthenticationSpecFluent<A>> extends BaseFluent<A>{
  public AuthenticationSpecFluent() {
  }
  
  public AuthenticationSpecFluent(AuthenticationSpec instance) {
    this.copyInstance(instance);
  }
  private ConfigMapNameReferenceBuilder oauthMetadata;
  private String serviceAccountIssuer;
  private String type;
  private WebhookTokenAuthenticatorBuilder webhookTokenAuthenticator;
  private ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder> webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AuthenticationSpec instance) {
    instance = (instance != null ? instance : new AuthenticationSpec());
    if (instance != null) {
          this.withOauthMetadata(instance.getOauthMetadata());
          this.withServiceAccountIssuer(instance.getServiceAccountIssuer());
          this.withType(instance.getType());
          this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator());
          this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ConfigMapNameReference buildOauthMetadata() {
    return this.oauthMetadata != null ? this.oauthMetadata.build() : null;
  }
  
  public A withOauthMetadata(ConfigMapNameReference oauthMetadata) {
    this._visitables.remove("oauthMetadata");
    if (oauthMetadata != null) {
        this.oauthMetadata = new ConfigMapNameReferenceBuilder(oauthMetadata);
        this._visitables.get("oauthMetadata").add(this.oauthMetadata);
    } else {
        this.oauthMetadata = null;
        this._visitables.get("oauthMetadata").remove(this.oauthMetadata);
    }
    return (A) this;
  }
  
  public boolean hasOauthMetadata() {
    return this.oauthMetadata != null;
  }
  
  public A withNewOauthMetadata(String name) {
    return (A)withOauthMetadata(new ConfigMapNameReference(name));
  }
  
  public OauthMetadataNested<A> withNewOauthMetadata() {
    return new OauthMetadataNested(null);
  }
  
  public OauthMetadataNested<A> withNewOauthMetadataLike(ConfigMapNameReference item) {
    return new OauthMetadataNested(item);
  }
  
  public OauthMetadataNested<A> editOauthMetadata() {
    return withNewOauthMetadataLike(java.util.Optional.ofNullable(buildOauthMetadata()).orElse(null));
  }
  
  public OauthMetadataNested<A> editOrNewOauthMetadata() {
    return withNewOauthMetadataLike(java.util.Optional.ofNullable(buildOauthMetadata()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public OauthMetadataNested<A> editOrNewOauthMetadataLike(ConfigMapNameReference item) {
    return withNewOauthMetadataLike(java.util.Optional.ofNullable(buildOauthMetadata()).orElse(item));
  }
  
  public String getServiceAccountIssuer() {
    return this.serviceAccountIssuer;
  }
  
  public A withServiceAccountIssuer(String serviceAccountIssuer) {
    this.serviceAccountIssuer = serviceAccountIssuer;
    return (A) this;
  }
  
  public boolean hasServiceAccountIssuer() {
    return this.serviceAccountIssuer != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public WebhookTokenAuthenticator buildWebhookTokenAuthenticator() {
    return this.webhookTokenAuthenticator != null ? this.webhookTokenAuthenticator.build() : null;
  }
  
  public A withWebhookTokenAuthenticator(WebhookTokenAuthenticator webhookTokenAuthenticator) {
    this._visitables.remove("webhookTokenAuthenticator");
    if (webhookTokenAuthenticator != null) {
        this.webhookTokenAuthenticator = new WebhookTokenAuthenticatorBuilder(webhookTokenAuthenticator);
        this._visitables.get("webhookTokenAuthenticator").add(this.webhookTokenAuthenticator);
    } else {
        this.webhookTokenAuthenticator = null;
        this._visitables.get("webhookTokenAuthenticator").remove(this.webhookTokenAuthenticator);
    }
    return (A) this;
  }
  
  public boolean hasWebhookTokenAuthenticator() {
    return this.webhookTokenAuthenticator != null;
  }
  
  public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticator() {
    return new WebhookTokenAuthenticatorNested(null);
  }
  
  public WebhookTokenAuthenticatorNested<A> withNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
    return new WebhookTokenAuthenticatorNested(item);
  }
  
  public WebhookTokenAuthenticatorNested<A> editWebhookTokenAuthenticator() {
    return withNewWebhookTokenAuthenticatorLike(java.util.Optional.ofNullable(buildWebhookTokenAuthenticator()).orElse(null));
  }
  
  public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticator() {
    return withNewWebhookTokenAuthenticatorLike(java.util.Optional.ofNullable(buildWebhookTokenAuthenticator()).orElse(new WebhookTokenAuthenticatorBuilder().build()));
  }
  
  public WebhookTokenAuthenticatorNested<A> editOrNewWebhookTokenAuthenticatorLike(WebhookTokenAuthenticator item) {
    return withNewWebhookTokenAuthenticatorLike(java.util.Optional.ofNullable(buildWebhookTokenAuthenticator()).orElse(item));
  }
  
  public A addToWebhookTokenAuthenticators(int index,DeprecatedWebhookTokenAuthenticator item) {
    if (this.webhookTokenAuthenticators == null) {this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();}
    DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
    if (index < 0 || index >= webhookTokenAuthenticators.size()) { _visitables.get("webhookTokenAuthenticators").add(builder); webhookTokenAuthenticators.add(builder); } else { _visitables.get("webhookTokenAuthenticators").add(index, builder); webhookTokenAuthenticators.add(index, builder);}
    return (A)this;
  }
  
  public A setToWebhookTokenAuthenticators(int index,DeprecatedWebhookTokenAuthenticator item) {
    if (this.webhookTokenAuthenticators == null) {this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();}
    DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);
    if (index < 0 || index >= webhookTokenAuthenticators.size()) { _visitables.get("webhookTokenAuthenticators").add(builder); webhookTokenAuthenticators.add(builder); } else { _visitables.get("webhookTokenAuthenticators").set(index, builder); webhookTokenAuthenticators.set(index, builder);}
    return (A)this;
  }
  
  public A addToWebhookTokenAuthenticators(io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticator... items) {
    if (this.webhookTokenAuthenticators == null) {this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();}
    for (DeprecatedWebhookTokenAuthenticator item : items) {DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);_visitables.get("webhookTokenAuthenticators").add(builder);this.webhookTokenAuthenticators.add(builder);} return (A)this;
  }
  
  public A addAllToWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
    if (this.webhookTokenAuthenticators == null) {this.webhookTokenAuthenticators = new ArrayList<DeprecatedWebhookTokenAuthenticatorBuilder>();}
    for (DeprecatedWebhookTokenAuthenticator item : items) {DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);_visitables.get("webhookTokenAuthenticators").add(builder);this.webhookTokenAuthenticators.add(builder);} return (A)this;
  }
  
  public A removeFromWebhookTokenAuthenticators(io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticator... items) {
    if (this.webhookTokenAuthenticators == null) return (A)this;
    for (DeprecatedWebhookTokenAuthenticator item : items) {DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);_visitables.get("webhookTokenAuthenticators").remove(builder); this.webhookTokenAuthenticators.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWebhookTokenAuthenticators(Collection<DeprecatedWebhookTokenAuthenticator> items) {
    if (this.webhookTokenAuthenticators == null) return (A)this;
    for (DeprecatedWebhookTokenAuthenticator item : items) {DeprecatedWebhookTokenAuthenticatorBuilder builder = new DeprecatedWebhookTokenAuthenticatorBuilder(item);_visitables.get("webhookTokenAuthenticators").remove(builder); this.webhookTokenAuthenticators.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWebhookTokenAuthenticators(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
    if (webhookTokenAuthenticators == null) return (A) this;
    final Iterator<DeprecatedWebhookTokenAuthenticatorBuilder> each = webhookTokenAuthenticators.iterator();
    final List visitables = _visitables.get("webhookTokenAuthenticators");
    while (each.hasNext()) {
      DeprecatedWebhookTokenAuthenticatorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DeprecatedWebhookTokenAuthenticator> buildWebhookTokenAuthenticators() {
    return this.webhookTokenAuthenticators != null ? build(webhookTokenAuthenticators) : null;
  }
  
  public DeprecatedWebhookTokenAuthenticator buildWebhookTokenAuthenticator(int index) {
    return this.webhookTokenAuthenticators.get(index).build();
  }
  
  public DeprecatedWebhookTokenAuthenticator buildFirstWebhookTokenAuthenticator() {
    return this.webhookTokenAuthenticators.get(0).build();
  }
  
  public DeprecatedWebhookTokenAuthenticator buildLastWebhookTokenAuthenticator() {
    return this.webhookTokenAuthenticators.get(webhookTokenAuthenticators.size() - 1).build();
  }
  
  public DeprecatedWebhookTokenAuthenticator buildMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
      for (DeprecatedWebhookTokenAuthenticatorBuilder item : webhookTokenAuthenticators) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
      for (DeprecatedWebhookTokenAuthenticatorBuilder item : webhookTokenAuthenticators) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWebhookTokenAuthenticators(List<DeprecatedWebhookTokenAuthenticator> webhookTokenAuthenticators) {
    if (this.webhookTokenAuthenticators != null) {
      this._visitables.get("webhookTokenAuthenticators").clear();
    }
    if (webhookTokenAuthenticators != null) {
        this.webhookTokenAuthenticators = new ArrayList();
        for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
          this.addToWebhookTokenAuthenticators(item);
        }
    } else {
      this.webhookTokenAuthenticators = null;
    }
    return (A) this;
  }
  
  public A withWebhookTokenAuthenticators(io.fabric8.openshift.api.model.config.v1.DeprecatedWebhookTokenAuthenticator... webhookTokenAuthenticators) {
    if (this.webhookTokenAuthenticators != null) {
        this.webhookTokenAuthenticators.clear();
        _visitables.remove("webhookTokenAuthenticators");
    }
    if (webhookTokenAuthenticators != null) {
      for (DeprecatedWebhookTokenAuthenticator item : webhookTokenAuthenticators) {
        this.addToWebhookTokenAuthenticators(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWebhookTokenAuthenticators() {
    return this.webhookTokenAuthenticators != null && !this.webhookTokenAuthenticators.isEmpty();
  }
  
  public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticator() {
    return new WebhookTokenAuthenticatorsNested(-1, null);
  }
  
  public WebhookTokenAuthenticatorsNested<A> addNewWebhookTokenAuthenticatorLike(DeprecatedWebhookTokenAuthenticator item) {
    return new WebhookTokenAuthenticatorsNested(-1, item);
  }
  
  public WebhookTokenAuthenticatorsNested<A> setNewWebhookTokenAuthenticatorLike(int index,DeprecatedWebhookTokenAuthenticator item) {
    return new WebhookTokenAuthenticatorsNested(index, item);
  }
  
  public WebhookTokenAuthenticatorsNested<A> editWebhookTokenAuthenticator(int index) {
    if (webhookTokenAuthenticators.size() <= index) throw new RuntimeException("Can't edit webhookTokenAuthenticators. Index exceeds size.");
    return setNewWebhookTokenAuthenticatorLike(index, buildWebhookTokenAuthenticator(index));
  }
  
  public WebhookTokenAuthenticatorsNested<A> editFirstWebhookTokenAuthenticator() {
    if (webhookTokenAuthenticators.size() == 0) throw new RuntimeException("Can't edit first webhookTokenAuthenticators. The list is empty.");
    return setNewWebhookTokenAuthenticatorLike(0, buildWebhookTokenAuthenticator(0));
  }
  
  public WebhookTokenAuthenticatorsNested<A> editLastWebhookTokenAuthenticator() {
    int index = webhookTokenAuthenticators.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webhookTokenAuthenticators. The list is empty.");
    return setNewWebhookTokenAuthenticatorLike(index, buildWebhookTokenAuthenticator(index));
  }
  
  public WebhookTokenAuthenticatorsNested<A> editMatchingWebhookTokenAuthenticator(Predicate<DeprecatedWebhookTokenAuthenticatorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webhookTokenAuthenticators.size();i++) { 
    if (predicate.test(webhookTokenAuthenticators.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webhookTokenAuthenticators. No match found.");
    return setNewWebhookTokenAuthenticatorLike(index, buildWebhookTokenAuthenticator(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthenticationSpecFluent that = (AuthenticationSpecFluent) o;
    if (!java.util.Objects.equals(oauthMetadata, that.oauthMetadata)) return false;
    if (!java.util.Objects.equals(serviceAccountIssuer, that.serviceAccountIssuer)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(webhookTokenAuthenticator, that.webhookTokenAuthenticator)) return false;
    if (!java.util.Objects.equals(webhookTokenAuthenticators, that.webhookTokenAuthenticators)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(oauthMetadata,  serviceAccountIssuer,  type,  webhookTokenAuthenticator,  webhookTokenAuthenticators,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (oauthMetadata != null) { sb.append("oauthMetadata:"); sb.append(oauthMetadata + ","); }
    if (serviceAccountIssuer != null) { sb.append("serviceAccountIssuer:"); sb.append(serviceAccountIssuer + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (webhookTokenAuthenticator != null) { sb.append("webhookTokenAuthenticator:"); sb.append(webhookTokenAuthenticator + ","); }
    if (webhookTokenAuthenticators != null && !webhookTokenAuthenticators.isEmpty()) { sb.append("webhookTokenAuthenticators:"); sb.append(webhookTokenAuthenticators + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OauthMetadataNested<N> extends ConfigMapNameReferenceFluent<OauthMetadataNested<N>> implements Nested<N>{
    OauthMetadataNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) AuthenticationSpecFluent.this.withOauthMetadata(builder.build());
    }
    
    public N endOauthMetadata() {
      return and();
    }
    
  
  }
  public class WebhookTokenAuthenticatorNested<N> extends WebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorNested<N>> implements Nested<N>{
    WebhookTokenAuthenticatorNested(WebhookTokenAuthenticator item) {
      this.builder = new WebhookTokenAuthenticatorBuilder(this, item);
    }
    WebhookTokenAuthenticatorBuilder builder;
    
    public N and() {
      return (N) AuthenticationSpecFluent.this.withWebhookTokenAuthenticator(builder.build());
    }
    
    public N endWebhookTokenAuthenticator() {
      return and();
    }
    
  
  }
  public class WebhookTokenAuthenticatorsNested<N> extends DeprecatedWebhookTokenAuthenticatorFluent<WebhookTokenAuthenticatorsNested<N>> implements Nested<N>{
    WebhookTokenAuthenticatorsNested(int index,DeprecatedWebhookTokenAuthenticator item) {
      this.index = index;
      this.builder = new DeprecatedWebhookTokenAuthenticatorBuilder(this, item);
    }
    DeprecatedWebhookTokenAuthenticatorBuilder builder;
    int index;
    
    public N and() {
      return (N) AuthenticationSpecFluent.this.setToWebhookTokenAuthenticators(index,builder.build());
    }
    
    public N endWebhookTokenAuthenticator() {
      return and();
    }
    
  
  }

}