package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BuildOverridesBuilder extends BuildOverridesFluent<BuildOverridesBuilder> implements VisitableBuilder<BuildOverrides,BuildOverridesBuilder>{
  public BuildOverridesBuilder() {
    this(new BuildOverrides());
  }
  
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent) {
    this(fluent, new BuildOverrides());
  }
  
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent,BuildOverrides instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BuildOverridesBuilder(BuildOverrides instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BuildOverridesFluent<?> fluent;
  
  public BuildOverrides build() {
    BuildOverrides buildable = new BuildOverrides(fluent.getForcePull(),fluent.buildImageLabels(),fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}