package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleStatusBuilder extends ConsoleStatusFluent<ConsoleStatusBuilder> implements VisitableBuilder<ConsoleStatus,ConsoleStatusBuilder>{
  public ConsoleStatusBuilder() {
    this(new ConsoleStatus());
  }
  
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent) {
    this(fluent, new ConsoleStatus());
  }
  
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleStatusBuilder(ConsoleStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleStatusFluent<?> fluent;
  
  public ConsoleStatus build() {
    ConsoleStatus buildable = new ConsoleStatus(fluent.getConsoleURL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}