package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LDAPAttributeMappingBuilder extends LDAPAttributeMappingFluent<LDAPAttributeMappingBuilder> implements VisitableBuilder<LDAPAttributeMapping,LDAPAttributeMappingBuilder>{
  public LDAPAttributeMappingBuilder() {
    this(new LDAPAttributeMapping());
  }
  
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent) {
    this(fluent, new LDAPAttributeMapping());
  }
  
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,LDAPAttributeMapping instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LDAPAttributeMappingBuilder(LDAPAttributeMapping instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LDAPAttributeMappingFluent<?> fluent;
  
  public LDAPAttributeMapping build() {
    LDAPAttributeMapping buildable = new LDAPAttributeMapping(fluent.getEmail(),fluent.getId(),fluent.getName(),fluent.getPreferredUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}