/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxy;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxyEndpoint;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxyEndpointBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsolePluginProxyEndpointFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConsolePluginProxyFluent<A extends ConsolePluginProxyFluent<A>>
extends BaseFluent<A> {
    private String alias;
    private String authorization;
    private String caCertificate;
    private ConsolePluginProxyEndpointBuilder endpoint;
    private Map<String, Object> additionalProperties;

    public ConsolePluginProxyFluent() {
    }

    public ConsolePluginProxyFluent(ConsolePluginProxy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsolePluginProxy instance) {
        ConsolePluginProxy consolePluginProxy = instance = instance != null ? instance : new ConsolePluginProxy();
        if (instance != null) {
            this.withAlias(instance.getAlias());
            this.withAuthorization(instance.getAuthorization());
            this.withCaCertificate(instance.getCaCertificate());
            this.withEndpoint(instance.getEndpoint());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public A withAlias(String alias) {
        this.alias = alias;
        return (A)((Object)this);
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public A withAuthorization(String authorization) {
        this.authorization = authorization;
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public A withCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
        return (A)((Object)this);
    }

    public boolean hasCaCertificate() {
        return this.caCertificate != null;
    }

    public ConsolePluginProxyEndpoint buildEndpoint() {
        return this.endpoint != null ? this.endpoint.build() : null;
    }

    public A withEndpoint(ConsolePluginProxyEndpoint endpoint) {
        this._visitables.remove((Object)"endpoint");
        if (endpoint != null) {
            this.endpoint = new ConsolePluginProxyEndpointBuilder(endpoint);
            this._visitables.get((Object)"endpoint").add(this.endpoint);
        } else {
            this.endpoint = null;
            this._visitables.get((Object)"endpoint").remove((Object)this.endpoint);
        }
        return (A)((Object)this);
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public EndpointNested<A> withNewEndpoint() {
        return new EndpointNested(null);
    }

    public EndpointNested<A> withNewEndpointLike(ConsolePluginProxyEndpoint item) {
        return new EndpointNested(item);
    }

    public EndpointNested<A> editEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(null));
    }

    public EndpointNested<A> editOrNewEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(new ConsolePluginProxyEndpointBuilder().build()));
    }

    public EndpointNested<A> editOrNewEndpointLike(ConsolePluginProxyEndpoint item) {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsolePluginProxyFluent that = (ConsolePluginProxyFluent)((Object)o);
        if (!Objects.equals(this.alias, that.alias)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.caCertificate, that.caCertificate)) {
            return false;
        }
        if (!Objects.equals((Object)this.endpoint, (Object)that.endpoint)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.authorization, this.caCertificate, this.endpoint, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alias != null) {
            sb.append("alias:");
            sb.append(this.alias + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.caCertificate != null) {
            sb.append("caCertificate:");
            sb.append(this.caCertificate + ",");
        }
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append(this.endpoint + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointNested<N>
    extends ConsolePluginProxyEndpointFluent<EndpointNested<N>>
    implements Nested<N> {
        ConsolePluginProxyEndpointBuilder builder;

        EndpointNested(ConsolePluginProxyEndpoint item) {
            this.builder = new ConsolePluginProxyEndpointBuilder(this, item);
        }

        public N and() {
            return (N)ConsolePluginProxyFluent.this.withEndpoint(this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

