package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CheckpointBuilder extends CheckpointFluent<CheckpointBuilder> implements VisitableBuilder<Checkpoint,CheckpointBuilder>{
  public CheckpointBuilder() {
    this(new Checkpoint());
  }
  
  public CheckpointBuilder(CheckpointFluent<?> fluent) {
    this(fluent, new Checkpoint());
  }
  
  public CheckpointBuilder(CheckpointFluent<?> fluent,Checkpoint instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CheckpointBuilder(Checkpoint instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CheckpointFluent<?> fluent;
  
  public Checkpoint build() {
    Checkpoint buildable = new Checkpoint(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}