package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachinePoolSpecBuilder extends MachinePoolSpecFluent<MachinePoolSpecBuilder> implements VisitableBuilder<MachinePoolSpec,MachinePoolSpecBuilder>{
  public MachinePoolSpecBuilder() {
    this(new MachinePoolSpec());
  }
  
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent) {
    this(fluent, new MachinePoolSpec());
  }
  
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent,MachinePoolSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachinePoolSpecBuilder(MachinePoolSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachinePoolSpecFluent<?> fluent;
  
  public MachinePoolSpec build() {
    MachinePoolSpec buildable = new MachinePoolSpec(fluent.buildAutoscaling(),fluent.buildClusterDeploymentRef(),fluent.getLabels(),fluent.getName(),fluent.buildPlatform(),fluent.getReplicas(),fluent.getTaints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}