package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AssumeRoleBuilder extends AssumeRoleFluent<AssumeRoleBuilder> implements VisitableBuilder<AssumeRole,AssumeRoleBuilder>{
  public AssumeRoleBuilder() {
    this(new AssumeRole());
  }
  
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent) {
    this(fluent, new AssumeRole());
  }
  
  public AssumeRoleBuilder(AssumeRoleFluent<?> fluent,AssumeRole instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AssumeRoleBuilder(AssumeRole instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AssumeRoleFluent<?> fluent;
  
  public AssumeRole build() {
    AssumeRole buildable = new AssumeRole(fluent.getExternalID(),fluent.getRoleARN());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}