package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureDNSZoneSpecBuilder extends AzureDNSZoneSpecFluent<AzureDNSZoneSpecBuilder> implements VisitableBuilder<AzureDNSZoneSpec,AzureDNSZoneSpecBuilder>{
  public AzureDNSZoneSpecBuilder() {
    this(new AzureDNSZoneSpec());
  }
  
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent) {
    this(fluent, new AzureDNSZoneSpec());
  }
  
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpecFluent<?> fluent,AzureDNSZoneSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureDNSZoneSpecBuilder(AzureDNSZoneSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureDNSZoneSpecFluent<?> fluent;
  
  public AzureDNSZoneSpec build() {
    AzureDNSZoneSpec buildable = new AzureDNSZoneSpec(fluent.getCloudName(),fluent.buildCredentialsSecretRef(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}