package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretMappingBuilder extends SecretMappingFluent<SecretMappingBuilder> implements VisitableBuilder<SecretMapping,SecretMappingBuilder>{
  public SecretMappingBuilder() {
    this(new SecretMapping());
  }
  
  public SecretMappingBuilder(SecretMappingFluent<?> fluent) {
    this(fluent, new SecretMapping());
  }
  
  public SecretMappingBuilder(SecretMappingFluent<?> fluent,SecretMapping instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretMappingBuilder(SecretMapping instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretMappingFluent<?> fluent;
  
  public SecretMapping build() {
    SecretMapping buildable = new SecretMapping(fluent.buildSourceRef(),fluent.buildTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}