package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigPoolSpecBuilder extends MachineConfigPoolSpecFluent<MachineConfigPoolSpecBuilder> implements VisitableBuilder<MachineConfigPoolSpec,MachineConfigPoolSpecBuilder>{
  public MachineConfigPoolSpecBuilder() {
    this(new MachineConfigPoolSpec());
  }
  
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent) {
    this(fluent, new MachineConfigPoolSpec());
  }
  
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpecFluent<?> fluent,MachineConfigPoolSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigPoolSpecBuilder(MachineConfigPoolSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigPoolSpecFluent<?> fluent;
  
  public MachineConfigPoolSpec build() {
    MachineConfigPoolSpec buildable = new MachineConfigPoolSpec(fluent.buildConfiguration(),fluent.buildMachineConfigSelector(),fluent.buildMaxUnavailable(),fluent.buildNodeSelector(),fluent.getPaused());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}