package io.fabric8.openshift.api.model.machineconfig.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerRuntimeConfigurationFluent<A extends ContainerRuntimeConfigurationFluent<A>> extends BaseFluent<A>{
  public ContainerRuntimeConfigurationFluent() {
  }
  
  public ContainerRuntimeConfigurationFluent(ContainerRuntimeConfiguration instance) {
    this.copyInstance(instance);
  }
  private String defaultRuntime;
  private String logLevel;
  private Quantity logSizeMax;
  private Quantity overlaySize;
  private Long pidsLimit;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerRuntimeConfiguration instance) {
    instance = (instance != null ? instance : new ContainerRuntimeConfiguration());
    if (instance != null) {
          this.withDefaultRuntime(instance.getDefaultRuntime());
          this.withLogLevel(instance.getLogLevel());
          this.withLogSizeMax(instance.getLogSizeMax());
          this.withOverlaySize(instance.getOverlaySize());
          this.withPidsLimit(instance.getPidsLimit());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDefaultRuntime() {
    return this.defaultRuntime;
  }
  
  public A withDefaultRuntime(String defaultRuntime) {
    this.defaultRuntime = defaultRuntime;
    return (A) this;
  }
  
  public boolean hasDefaultRuntime() {
    return this.defaultRuntime != null;
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public Quantity getLogSizeMax() {
    return this.logSizeMax;
  }
  
  public A withLogSizeMax(Quantity logSizeMax) {
    this.logSizeMax = logSizeMax;
    return (A) this;
  }
  
  public boolean hasLogSizeMax() {
    return this.logSizeMax != null;
  }
  
  public A withNewLogSizeMax(String amount,String format) {
    return (A)withLogSizeMax(new Quantity(amount, format));
  }
  
  public A withNewLogSizeMax(String amount) {
    return (A)withLogSizeMax(new Quantity(amount));
  }
  
  public Quantity getOverlaySize() {
    return this.overlaySize;
  }
  
  public A withOverlaySize(Quantity overlaySize) {
    this.overlaySize = overlaySize;
    return (A) this;
  }
  
  public boolean hasOverlaySize() {
    return this.overlaySize != null;
  }
  
  public A withNewOverlaySize(String amount,String format) {
    return (A)withOverlaySize(new Quantity(amount, format));
  }
  
  public A withNewOverlaySize(String amount) {
    return (A)withOverlaySize(new Quantity(amount));
  }
  
  public Long getPidsLimit() {
    return this.pidsLimit;
  }
  
  public A withPidsLimit(Long pidsLimit) {
    this.pidsLimit = pidsLimit;
    return (A) this;
  }
  
  public boolean hasPidsLimit() {
    return this.pidsLimit != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerRuntimeConfigurationFluent that = (ContainerRuntimeConfigurationFluent) o;
    if (!java.util.Objects.equals(defaultRuntime, that.defaultRuntime)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(logSizeMax, that.logSizeMax)) return false;
    if (!java.util.Objects.equals(overlaySize, that.overlaySize)) return false;
    if (!java.util.Objects.equals(pidsLimit, that.pidsLimit)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(defaultRuntime,  logLevel,  logSizeMax,  overlaySize,  pidsLimit,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultRuntime != null) { sb.append("defaultRuntime:"); sb.append(defaultRuntime + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (logSizeMax != null) { sb.append("logSizeMax:"); sb.append(logSizeMax + ","); }
    if (overlaySize != null) { sb.append("overlaySize:"); sb.append(overlaySize + ","); }
    if (pidsLimit != null) { sb.append("pidsLimit:"); sb.append(pidsLimit + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}