package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageRegistryConfigRouteBuilder extends ImageRegistryConfigRouteFluent<ImageRegistryConfigRouteBuilder> implements VisitableBuilder<ImageRegistryConfigRoute,ImageRegistryConfigRouteBuilder>{
  public ImageRegistryConfigRouteBuilder() {
    this(new ImageRegistryConfigRoute());
  }
  
  public ImageRegistryConfigRouteBuilder(ImageRegistryConfigRouteFluent<?> fluent) {
    this(fluent, new ImageRegistryConfigRoute());
  }
  
  public ImageRegistryConfigRouteBuilder(ImageRegistryConfigRouteFluent<?> fluent,ImageRegistryConfigRoute instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageRegistryConfigRouteBuilder(ImageRegistryConfigRoute instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageRegistryConfigRouteFluent<?> fluent;
  
  public ImageRegistryConfigRoute build() {
    ImageRegistryConfigRoute buildable = new ImageRegistryConfigRoute(fluent.getHostname(),fluent.getName(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}