package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageRegistryStatusBuilder extends ImageRegistryStatusFluent<ImageRegistryStatusBuilder> implements VisitableBuilder<ImageRegistryStatus,ImageRegistryStatusBuilder>{
  public ImageRegistryStatusBuilder() {
    this(new ImageRegistryStatus());
  }
  
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent) {
    this(fluent, new ImageRegistryStatus());
  }
  
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent,ImageRegistryStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageRegistryStatusBuilder(ImageRegistryStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageRegistryStatusFluent<?> fluent;
  
  public ImageRegistryStatus build() {
    ImageRegistryStatus buildable = new ImageRegistryStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.buildStorage(),fluent.getStorageManaged(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}