package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ArgumentBuilder extends ArgumentFluent<ArgumentBuilder> implements VisitableBuilder<Argument,ArgumentBuilder>{
  public ArgumentBuilder() {
    this(new Argument());
  }
  
  public ArgumentBuilder(ArgumentFluent<?> fluent) {
    this(fluent, new Argument());
  }
  
  public ArgumentBuilder(ArgumentFluent<?> fluent,Argument instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ArgumentBuilder(Argument instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ArgumentFluent<?> fluent;
  
  public Argument build() {
    Argument buildable = new Argument(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}