package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodMonitorListBuilder extends PodMonitorListFluent<PodMonitorListBuilder> implements VisitableBuilder<PodMonitorList,PodMonitorListBuilder>{
  public PodMonitorListBuilder() {
    this(new PodMonitorList());
  }
  
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent) {
    this(fluent, new PodMonitorList());
  }
  
  public PodMonitorListBuilder(PodMonitorListFluent<?> fluent,PodMonitorList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodMonitorListBuilder(PodMonitorList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodMonitorListFluent<?> fluent;
  
  public PodMonitorList build() {
    PodMonitorList buildable = new PodMonitorList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}