package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RuleGroupFluent<A extends RuleGroupFluent<A>> extends BaseFluent<A>{
  public RuleGroupFluent() {
  }
  
  public RuleGroupFluent(RuleGroup instance) {
    this.copyInstance(instance);
  }
  private String interval;
  private Integer limit;
  private String name;
  private String partialResponseStrategy;
  private ArrayList<RuleBuilder> rules = new ArrayList<RuleBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RuleGroup instance) {
    instance = (instance != null ? instance : new RuleGroup());
    if (instance != null) {
          this.withInterval(instance.getInterval());
          this.withLimit(instance.getLimit());
          this.withName(instance.getName());
          this.withPartialResponseStrategy(instance.getPartialResponseStrategy());
          this.withRules(instance.getRules());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getInterval() {
    return this.interval;
  }
  
  public A withInterval(String interval) {
    this.interval = interval;
    return (A) this;
  }
  
  public boolean hasInterval() {
    return this.interval != null;
  }
  
  public Integer getLimit() {
    return this.limit;
  }
  
  public A withLimit(Integer limit) {
    this.limit = limit;
    return (A) this;
  }
  
  public boolean hasLimit() {
    return this.limit != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getPartialResponseStrategy() {
    return this.partialResponseStrategy;
  }
  
  public A withPartialResponseStrategy(String partialResponseStrategy) {
    this.partialResponseStrategy = partialResponseStrategy;
    return (A) this;
  }
  
  public boolean hasPartialResponseStrategy() {
    return this.partialResponseStrategy != null;
  }
  
  public A addToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  
  public A setToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  
  public A addToRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A addAllToRules(Collection<Rule> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... items) {
    if (this.rules == null) return (A)this;
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<Rule> items) {
    if (this.rules == null) return (A)this;
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<RuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      RuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Rule> buildRules() {
    return this.rules != null ? build(rules) : null;
  }
  
  public Rule buildRule(int index) {
    return this.rules.get(index).build();
  }
  
  public Rule buildFirstRule() {
    return this.rules.get(0).build();
  }
  
  public Rule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  
  public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
      for (RuleBuilder item : rules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
      for (RuleBuilder item : rules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRules(List<Rule> rules) {
    if (this.rules != null) {
      this._visitables.get("rules").clear();
    }
    if (rules != null) {
        this.rules = new ArrayList();
        for (Rule item : rules) {
          this.addToRules(item);
        }
    } else {
      this.rules = null;
    }
    return (A) this;
  }
  
  public A withRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... rules) {
    if (this.rules != null) {
        this.rules.clear();
        _visitables.remove("rules");
    }
    if (rules != null) {
      for (Rule item : rules) {
        this.addToRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRules() {
    return this.rules != null && !this.rules.isEmpty();
  }
  
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  
  public RulesNested<A> addNewRuleLike(Rule item) {
    return new RulesNested(-1, item);
  }
  
  public RulesNested<A> setNewRuleLike(int index,Rule item) {
    return new RulesNested(index, item);
  }
  
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuleGroupFluent that = (RuleGroupFluent) o;
    if (!java.util.Objects.equals(interval, that.interval)) return false;
    if (!java.util.Objects.equals(limit, that.limit)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(partialResponseStrategy, that.partialResponseStrategy)) return false;
    if (!java.util.Objects.equals(rules, that.rules)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(interval,  limit,  name,  partialResponseStrategy,  rules,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (limit != null) { sb.append("limit:"); sb.append(limit + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (partialResponseStrategy != null) { sb.append("partialResponseStrategy:"); sb.append(partialResponseStrategy + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RulesNested<N> extends RuleFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,Rule item) {
      this.index = index;
      this.builder = new RuleBuilder(this, item);
    }
    RuleBuilder builder;
    int index;
    
    public N and() {
      return (N) RuleGroupFluent.this.setToRules(index,builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }

}