package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TelegramConfigFluent<A extends TelegramConfigFluent<A>> extends BaseFluent<A>{
  public TelegramConfigFluent() {
  }
  
  public TelegramConfigFluent(TelegramConfig instance) {
    this.copyInstance(instance);
  }
  private String apiURL;
  private SecretKeySelector botToken;
  private String botTokenFile;
  private Long chatID;
  private Boolean disableNotifications;
  private HTTPConfigBuilder httpConfig;
  private String message;
  private String parseMode;
  private Boolean sendResolved;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TelegramConfig instance) {
    instance = (instance != null ? instance : new TelegramConfig());
    if (instance != null) {
          this.withApiURL(instance.getApiURL());
          this.withBotToken(instance.getBotToken());
          this.withBotTokenFile(instance.getBotTokenFile());
          this.withChatID(instance.getChatID());
          this.withDisableNotifications(instance.getDisableNotifications());
          this.withHttpConfig(instance.getHttpConfig());
          this.withMessage(instance.getMessage());
          this.withParseMode(instance.getParseMode());
          this.withSendResolved(instance.getSendResolved());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(String apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public SecretKeySelector getBotToken() {
    return this.botToken;
  }
  
  public A withBotToken(SecretKeySelector botToken) {
    this.botToken = botToken;
    return (A) this;
  }
  
  public boolean hasBotToken() {
    return this.botToken != null;
  }
  
  public A withNewBotToken(String key,String name,Boolean optional) {
    return (A)withBotToken(new SecretKeySelector(key, name, optional));
  }
  
  public String getBotTokenFile() {
    return this.botTokenFile;
  }
  
  public A withBotTokenFile(String botTokenFile) {
    this.botTokenFile = botTokenFile;
    return (A) this;
  }
  
  public boolean hasBotTokenFile() {
    return this.botTokenFile != null;
  }
  
  public Long getChatID() {
    return this.chatID;
  }
  
  public A withChatID(Long chatID) {
    this.chatID = chatID;
    return (A) this;
  }
  
  public boolean hasChatID() {
    return this.chatID != null;
  }
  
  public Boolean getDisableNotifications() {
    return this.disableNotifications;
  }
  
  public A withDisableNotifications(Boolean disableNotifications) {
    this.disableNotifications = disableNotifications;
    return (A) this;
  }
  
  public boolean hasDisableNotifications() {
    return this.disableNotifications != null;
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public String getMessage() {
    return this.message;
  }
  
  public A withMessage(String message) {
    this.message = message;
    return (A) this;
  }
  
  public boolean hasMessage() {
    return this.message != null;
  }
  
  public String getParseMode() {
    return this.parseMode;
  }
  
  public A withParseMode(String parseMode) {
    this.parseMode = parseMode;
    return (A) this;
  }
  
  public boolean hasParseMode() {
    return this.parseMode != null;
  }
  
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved = sendResolved;
    return (A) this;
  }
  
  public boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TelegramConfigFluent that = (TelegramConfigFluent) o;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(botToken, that.botToken)) return false;
    if (!java.util.Objects.equals(botTokenFile, that.botTokenFile)) return false;
    if (!java.util.Objects.equals(chatID, that.chatID)) return false;
    if (!java.util.Objects.equals(disableNotifications, that.disableNotifications)) return false;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(message, that.message)) return false;
    if (!java.util.Objects.equals(parseMode, that.parseMode)) return false;
    if (!java.util.Objects.equals(sendResolved, that.sendResolved)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiURL,  botToken,  botTokenFile,  chatID,  disableNotifications,  httpConfig,  message,  parseMode,  sendResolved,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (botToken != null) { sb.append("botToken:"); sb.append(botToken + ","); }
    if (botTokenFile != null) { sb.append("botTokenFile:"); sb.append(botTokenFile + ","); }
    if (chatID != null) { sb.append("chatID:"); sb.append(chatID + ","); }
    if (disableNotifications != null) { sb.append("disableNotifications:"); sb.append(disableNotifications + ","); }
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (parseMode != null) { sb.append("parseMode:"); sb.append(parseMode + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDisableNotifications() {
    return withDisableNotifications(true);
  }
  
  public A withSendResolved() {
    return withSendResolved(true);
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) TelegramConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }

}