package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DefaultNetworkDefinitionBuilder extends DefaultNetworkDefinitionFluent<DefaultNetworkDefinitionBuilder> implements VisitableBuilder<DefaultNetworkDefinition,DefaultNetworkDefinitionBuilder>{
  public DefaultNetworkDefinitionBuilder() {
    this(new DefaultNetworkDefinition());
  }
  
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent) {
    this(fluent, new DefaultNetworkDefinition());
  }
  
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinitionFluent<?> fluent,DefaultNetworkDefinition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DefaultNetworkDefinitionBuilder(DefaultNetworkDefinition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DefaultNetworkDefinitionFluent<?> fluent;
  
  public DefaultNetworkDefinition build() {
    DefaultNetworkDefinition buildable = new DefaultNetworkDefinition(fluent.buildKuryrConfig(),fluent.buildOpenshiftSDNConfig(),fluent.buildOvnKubernetesConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}