package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IPAMConfigBuilder extends IPAMConfigFluent<IPAMConfigBuilder> implements VisitableBuilder<IPAMConfig,IPAMConfigBuilder>{
  public IPAMConfigBuilder() {
    this(new IPAMConfig());
  }
  
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent) {
    this(fluent, new IPAMConfig());
  }
  
  public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IPAMConfigBuilder(IPAMConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IPAMConfigFluent<?> fluent;
  
  public IPAMConfig build() {
    IPAMConfig buildable = new IPAMConfig(fluent.buildStaticIPAMConfig(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}