package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenShiftControllerManagerStatusBuilder extends OpenShiftControllerManagerStatusFluent<OpenShiftControllerManagerStatusBuilder> implements VisitableBuilder<OpenShiftControllerManagerStatus,OpenShiftControllerManagerStatusBuilder>{
  public OpenShiftControllerManagerStatusBuilder() {
    this(new OpenShiftControllerManagerStatus());
  }
  
  public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent) {
    this(fluent, new OpenShiftControllerManagerStatus());
  }
  
  public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatusFluent<?> fluent,OpenShiftControllerManagerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenShiftControllerManagerStatusBuilder(OpenShiftControllerManagerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenShiftControllerManagerStatusFluent<?> fluent;
  
  public OpenShiftControllerManagerStatus build() {
    OpenShiftControllerManagerStatus buildable = new OpenShiftControllerManagerStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}