package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuickStartsBuilder extends QuickStartsFluent<QuickStartsBuilder> implements VisitableBuilder<QuickStarts,QuickStartsBuilder>{
  public QuickStartsBuilder() {
    this(new QuickStarts());
  }
  
  public QuickStartsBuilder(QuickStartsFluent<?> fluent) {
    this(fluent, new QuickStarts());
  }
  
  public QuickStartsBuilder(QuickStartsFluent<?> fluent,QuickStarts instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuickStartsBuilder(QuickStarts instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuickStartsFluent<?> fluent;
  
  public QuickStarts build() {
    QuickStarts buildable = new QuickStarts(fluent.getDisabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}