package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatus;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckCondition;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntry;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpec;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrors;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StorageSpecFluent<A extends StorageSpecFluent<A>> extends BaseFluent<A>{
  public StorageSpecFluent() {
  }
  
  public StorageSpecFluent(StorageSpec instance) {
    this.copyInstance(instance);
  }
  private String logLevel;
  private String managementState;
  private VisitableBuilder<? extends KubernetesResource,?> observedConfig;
  private String operatorLogLevel;
  private VisitableBuilder<? extends KubernetesResource,?> unsupportedConfigOverrides;
  private String vsphereStorageDriver;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StorageSpec instance) {
    instance = (instance != null ? instance : new StorageSpec());
    if (instance != null) {
          this.withLogLevel(instance.getLogLevel());
          this.withManagementState(instance.getManagementState());
          this.withObservedConfig(instance.getObservedConfig());
          this.withOperatorLogLevel(instance.getOperatorLogLevel());
          this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
          this.withVsphereStorageDriver(instance.getVsphereStorageDriver());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public KubernetesResource buildObservedConfig() {
    return this.observedConfig != null ? this.observedConfig.build() : null;
  }
  
  public A withObservedConfig(KubernetesResource observedConfig) {
    if (observedConfig == null) {
        this.observedConfig = null;
        this._visitables.remove("observedConfig");
        return (A) this;
    } else {
        VisitableBuilder<? extends KubernetesResource,?> builder = builder(observedConfig);;
        this._visitables.clear();
        this._visitables.get("observedConfig").add(builder);
        this.observedConfig = builder;
        return (A) this;
    }
  }
  
  public boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  
  public ServiceCatalogAPIServerListObservedConfigNested<A> withNewServiceCatalogAPIServerListObservedConfig() {
    return new ServiceCatalogAPIServerListObservedConfigNested(null);
  }
  
  public ServiceCatalogAPIServerListObservedConfigNested<A> withNewServiceCatalogAPIServerListObservedConfigLike(ServiceCatalogAPIServerList item) {
    return new ServiceCatalogAPIServerListObservedConfigNested(item);
  }
  
  public PodNetworkConnectivityCheckStatusObservedConfigNested<A> withNewPodNetworkConnectivityCheckStatusObservedConfig() {
    return new PodNetworkConnectivityCheckStatusObservedConfigNested(null);
  }
  
  public PodNetworkConnectivityCheckStatusObservedConfigNested<A> withNewPodNetworkConnectivityCheckStatusObservedConfigLike(PodNetworkConnectivityCheckStatus item) {
    return new PodNetworkConnectivityCheckStatusObservedConfigNested(item);
  }
  
  public ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new ImagePrunerObservedConfigNested(null);
  }
  
  public ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new ImagePrunerObservedConfigNested(item);
  }
  
  public KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new KubeControllerManagerObservedConfigNested(null);
  }
  
  public KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new KubeControllerManagerObservedConfigNested(item);
  }
  
  public PodTemplateSpecObservedConfigNested<A> withNewPodTemplateSpecObservedConfig() {
    return new PodTemplateSpecObservedConfigNested(null);
  }
  
  public PodTemplateSpecObservedConfigNested<A> withNewPodTemplateSpecObservedConfigLike(PodTemplateSpec item) {
    return new PodTemplateSpecObservedConfigNested(item);
  }
  
  public KubeControllerManagerStatusObservedConfigNested<A> withNewKubeControllerManagerStatusObservedConfig() {
    return new KubeControllerManagerStatusObservedConfigNested(null);
  }
  
  public KubeControllerManagerStatusObservedConfigNested<A> withNewKubeControllerManagerStatusObservedConfigLike(KubeControllerManagerStatus item) {
    return new KubeControllerManagerStatusObservedConfigNested(item);
  }
  
  public CSISnapshotControllerStatusObservedConfigNested<A> withNewCSISnapshotControllerStatusObservedConfig() {
    return new CSISnapshotControllerStatusObservedConfigNested(null);
  }
  
  public CSISnapshotControllerStatusObservedConfigNested<A> withNewCSISnapshotControllerStatusObservedConfigLike(CSISnapshotControllerStatus item) {
    return new CSISnapshotControllerStatusObservedConfigNested(item);
  }
  
  public IPsecConfigObservedNested<A> withNewIPsecConfigObserved() {
    return new IPsecConfigObservedNested(null);
  }
  
  public IPsecConfigObservedNested<A> withNewIPsecConfigObservedLike(IPsecConfig item) {
    return new IPsecConfigObservedNested(item);
  }
  
  public ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new ImageContentSourcePolicyObservedConfigNested(null);
  }
  
  public ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyObservedConfigNested(item);
  }
  
  public ResourceRequirementsObservedConfigNested<A> withNewResourceRequirementsObservedConfig() {
    return new ResourceRequirementsObservedConfigNested(null);
  }
  
  public ResourceRequirementsObservedConfigNested<A> withNewResourceRequirementsObservedConfigLike(ResourceRequirements item) {
    return new ResourceRequirementsObservedConfigNested(item);
  }
  
  public KubeStorageVersionMigratorSpecObservedConfigNested<A> withNewKubeStorageVersionMigratorSpecObservedConfig() {
    return new KubeStorageVersionMigratorSpecObservedConfigNested(null);
  }
  
  public KubeStorageVersionMigratorSpecObservedConfigNested<A> withNewKubeStorageVersionMigratorSpecObservedConfigLike(KubeStorageVersionMigratorSpec item) {
    return new KubeStorageVersionMigratorSpecObservedConfigNested(item);
  }
  
  public OpenShiftSDNConfigObservedNested<A> withNewOpenShiftSDNConfigObserved() {
    return new OpenShiftSDNConfigObservedNested(null);
  }
  
  public OpenShiftSDNConfigObservedNested<A> withNewOpenShiftSDNConfigObservedLike(OpenShiftSDNConfig item) {
    return new OpenShiftSDNConfigObservedNested(item);
  }
  
  public A withNewOpenShiftSDNConfigObserved(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withObservedConfig(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  
  public IngressControllerHTTPHeadersObservedConfigNested<A> withNewIngressControllerHTTPHeadersObservedConfig() {
    return new IngressControllerHTTPHeadersObservedConfigNested(null);
  }
  
  public IngressControllerHTTPHeadersObservedConfigNested<A> withNewIngressControllerHTTPHeadersObservedConfigLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerHTTPHeadersObservedConfigNested(item);
  }
  
  public ConsoleListObservedConfigNested<A> withNewConsoleListObservedConfig() {
    return new ConsoleListObservedConfigNested(null);
  }
  
  public ConsoleListObservedConfigNested<A> withNewConsoleListObservedConfigLike(ConsoleList item) {
    return new ConsoleListObservedConfigNested(item);
  }
  
  public ServiceAccountIssuerStatusObservedConfigNested<A> withNewServiceAccountIssuerStatusObservedConfig() {
    return new ServiceAccountIssuerStatusObservedConfigNested(null);
  }
  
  public ServiceAccountIssuerStatusObservedConfigNested<A> withNewServiceAccountIssuerStatusObservedConfigLike(ServiceAccountIssuerStatus item) {
    return new ServiceAccountIssuerStatusObservedConfigNested(item);
  }
  
  public A withNewServiceAccountIssuerStatusObservedConfig(String expirationTime,String name) {
    return (A)withObservedConfig(new ServiceAccountIssuerStatus(expirationTime, name));
  }
  
  public DeveloperConsoleCatalogCategoryObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryObservedConfig() {
    return new DeveloperConsoleCatalogCategoryObservedConfigNested(null);
  }
  
  public DeveloperConsoleCatalogCategoryObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryObservedConfigLike(DeveloperConsoleCatalogCategory item) {
    return new DeveloperConsoleCatalogCategoryObservedConfigNested(item);
  }
  
  public ExportNetworkFlowsObservedConfigNested<A> withNewExportNetworkFlowsObservedConfig() {
    return new ExportNetworkFlowsObservedConfigNested(null);
  }
  
  public ExportNetworkFlowsObservedConfigNested<A> withNewExportNetworkFlowsObservedConfigLike(ExportNetworkFlows item) {
    return new ExportNetworkFlowsObservedConfigNested(item);
  }
  
  public OpenShiftControllerManagerSpecObservedConfigNested<A> withNewOpenShiftControllerManagerSpecObservedConfig() {
    return new OpenShiftControllerManagerSpecObservedConfigNested(null);
  }
  
  public OpenShiftControllerManagerSpecObservedConfigNested<A> withNewOpenShiftControllerManagerSpecObservedConfigLike(OpenShiftControllerManagerSpec item) {
    return new OpenShiftControllerManagerSpecObservedConfigNested(item);
  }
  
  public ClusterCSIDriverSpecObservedConfigNested<A> withNewClusterCSIDriverSpecObservedConfig() {
    return new ClusterCSIDriverSpecObservedConfigNested(null);
  }
  
  public ClusterCSIDriverSpecObservedConfigNested<A> withNewClusterCSIDriverSpecObservedConfigLike(ClusterCSIDriverSpec item) {
    return new ClusterCSIDriverSpecObservedConfigNested(item);
  }
  
  public RepositoryDigestMirrorsObservedConfigNested<A> withNewRepositoryDigestMirrorsObservedConfig() {
    return new RepositoryDigestMirrorsObservedConfigNested(null);
  }
  
  public RepositoryDigestMirrorsObservedConfigNested<A> withNewRepositoryDigestMirrorsObservedConfigLike(RepositoryDigestMirrors item) {
    return new RepositoryDigestMirrorsObservedConfigNested(item);
  }
  
  public ConsoleCustomizationObservedConfigNested<A> withNewConsoleCustomizationObservedConfig() {
    return new ConsoleCustomizationObservedConfigNested(null);
  }
  
  public ConsoleCustomizationObservedConfigNested<A> withNewConsoleCustomizationObservedConfigLike(ConsoleCustomization item) {
    return new ConsoleCustomizationObservedConfigNested(item);
  }
  
  public CSISnapshotControllerSpecObservedConfigNested<A> withNewCSISnapshotControllerSpecObservedConfig() {
    return new CSISnapshotControllerSpecObservedConfigNested(null);
  }
  
  public CSISnapshotControllerSpecObservedConfigNested<A> withNewCSISnapshotControllerSpecObservedConfigLike(CSISnapshotControllerSpec item) {
    return new CSISnapshotControllerSpecObservedConfigNested(item);
  }
  
  public UpstreamResolversObservedConfigNested<A> withNewUpstreamResolversObservedConfig() {
    return new UpstreamResolversObservedConfigNested(null);
  }
  
  public UpstreamResolversObservedConfigNested<A> withNewUpstreamResolversObservedConfigLike(UpstreamResolvers item) {
    return new UpstreamResolversObservedConfigNested(item);
  }
  
  public IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig() {
    return new IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested(null);
  }
  
  public IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfigLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested(item);
  }
  
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig(String format,String name) {
    return (A)withObservedConfig(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  
  public MTUMigrationValuesObservedConfigNested<A> withNewMTUMigrationValuesObservedConfig() {
    return new MTUMigrationValuesObservedConfigNested(null);
  }
  
  public MTUMigrationValuesObservedConfigNested<A> withNewMTUMigrationValuesObservedConfigLike(MTUMigrationValues item) {
    return new MTUMigrationValuesObservedConfigNested(item);
  }
  
  public A withNewMTUMigrationValuesObservedConfig(Integer from,Integer to) {
    return (A)withObservedConfig(new MTUMigrationValues(from, to));
  }
  
  public ConfigStatusObservedConfigNested<A> withNewConfigStatusObservedConfig() {
    return new ConfigStatusObservedConfigNested(null);
  }
  
  public ConfigStatusObservedConfigNested<A> withNewConfigStatusObservedConfigLike(ConfigStatus item) {
    return new ConfigStatusObservedConfigNested(item);
  }
  
  public VSphereCSIDriverConfigSpecObservedNested<A> withNewVSphereCSIDriverConfigSpecObserved() {
    return new VSphereCSIDriverConfigSpecObservedNested(null);
  }
  
  public VSphereCSIDriverConfigSpecObservedNested<A> withNewVSphereCSIDriverConfigSpecObservedLike(VSphereCSIDriverConfigSpec item) {
    return new VSphereCSIDriverConfigSpecObservedNested(item);
  }
  
  public ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new ServiceCAObservedConfigNested(null);
  }
  
  public ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new ServiceCAObservedConfigNested(item);
  }
  
  public ServiceCatalogControllerManagerSpecObservedConfigNested<A> withNewServiceCatalogControllerManagerSpecObservedConfig() {
    return new ServiceCatalogControllerManagerSpecObservedConfigNested(null);
  }
  
  public ServiceCatalogControllerManagerSpecObservedConfigNested<A> withNewServiceCatalogControllerManagerSpecObservedConfigLike(ServiceCatalogControllerManagerSpec item) {
    return new ServiceCatalogControllerManagerSpecObservedConfigNested(item);
  }
  
  public IngressControllerListObservedConfigNested<A> withNewIngressControllerListObservedConfig() {
    return new IngressControllerListObservedConfigNested(null);
  }
  
  public IngressControllerListObservedConfigNested<A> withNewIngressControllerListObservedConfigLike(IngressControllerList item) {
    return new IngressControllerListObservedConfigNested(item);
  }
  
  public DNSListObservedConfigNested<A> withNewDNSListObservedConfig() {
    return new DNSListObservedConfigNested(null);
  }
  
  public DNSListObservedConfigNested<A> withNewDNSListObservedConfigLike(DNSList item) {
    return new DNSListObservedConfigNested(item);
  }
  
  public KubeAPIServerStatusObservedConfigNested<A> withNewKubeAPIServerStatusObservedConfig() {
    return new KubeAPIServerStatusObservedConfigNested(null);
  }
  
  public KubeAPIServerStatusObservedConfigNested<A> withNewKubeAPIServerStatusObservedConfigLike(KubeAPIServerStatus item) {
    return new KubeAPIServerStatusObservedConfigNested(item);
  }
  
  public AWSClassicLoadBalancerParametersObservedConfigNested<A> withNewAWSClassicLoadBalancerParametersObservedConfig() {
    return new AWSClassicLoadBalancerParametersObservedConfigNested(null);
  }
  
  public AWSClassicLoadBalancerParametersObservedConfigNested<A> withNewAWSClassicLoadBalancerParametersObservedConfigLike(AWSClassicLoadBalancerParameters item) {
    return new AWSClassicLoadBalancerParametersObservedConfigNested(item);
  }
  
  public KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new KubeAPIServerObservedConfigNested(null);
  }
  
  public KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new KubeAPIServerObservedConfigNested(item);
  }
  
  public ConsoleConfigRouteObservedNested<A> withNewConsoleConfigRouteObserved() {
    return new ConsoleConfigRouteObservedNested(null);
  }
  
  public ConsoleConfigRouteObservedNested<A> withNewConsoleConfigRouteObservedLike(ConsoleConfigRoute item) {
    return new ConsoleConfigRouteObservedNested(item);
  }
  
  public IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new IngressControllerObservedConfigNested(null);
  }
  
  public IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new IngressControllerObservedConfigNested(item);
  }
  
  public CloudCredentialStatusObservedConfigNested<A> withNewCloudCredentialStatusObservedConfig() {
    return new CloudCredentialStatusObservedConfigNested(null);
  }
  
  public CloudCredentialStatusObservedConfigNested<A> withNewCloudCredentialStatusObservedConfigLike(CloudCredentialStatus item) {
    return new CloudCredentialStatusObservedConfigNested(item);
  }
  
  public KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new KubeStorageVersionMigratorObservedConfigNested(null);
  }
  
  public KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new KubeStorageVersionMigratorObservedConfigNested(item);
  }
  
  public IngressControllerStatusObservedConfigNested<A> withNewIngressControllerStatusObservedConfig() {
    return new IngressControllerStatusObservedConfigNested(null);
  }
  
  public IngressControllerStatusObservedConfigNested<A> withNewIngressControllerStatusObservedConfigLike(IngressControllerStatus item) {
    return new IngressControllerStatusObservedConfigNested(item);
  }
  
  public ServiceCatalogControllerManagerStatusObservedConfigNested<A> withNewServiceCatalogControllerManagerStatusObservedConfig() {
    return new ServiceCatalogControllerManagerStatusObservedConfigNested(null);
  }
  
  public ServiceCatalogControllerManagerStatusObservedConfigNested<A> withNewServiceCatalogControllerManagerStatusObservedConfigLike(ServiceCatalogControllerManagerStatus item) {
    return new ServiceCatalogControllerManagerStatusObservedConfigNested(item);
  }
  
  public ImagePrunerListObservedConfigNested<A> withNewImagePrunerListObservedConfig() {
    return new ImagePrunerListObservedConfigNested(null);
  }
  
  public ImagePrunerListObservedConfigNested<A> withNewImagePrunerListObservedConfigLike(ImagePrunerList item) {
    return new ImagePrunerListObservedConfigNested(item);
  }
  
  public LocalObjectReferenceObservedConfigNested<A> withNewLocalObjectReferenceObservedConfig() {
    return new LocalObjectReferenceObservedConfigNested(null);
  }
  
  public LocalObjectReferenceObservedConfigNested<A> withNewLocalObjectReferenceObservedConfigLike(LocalObjectReference item) {
    return new LocalObjectReferenceObservedConfigNested(item);
  }
  
  public A withNewLocalObjectReferenceObservedConfig(String name) {
    return (A)withObservedConfig(new LocalObjectReference(name));
  }
  
  public ContainerLoggingDestinationParametersObservedConfigNested<A> withNewContainerLoggingDestinationParametersObservedConfig() {
    return new ContainerLoggingDestinationParametersObservedConfigNested(null);
  }
  
  public ContainerLoggingDestinationParametersObservedConfigNested<A> withNewContainerLoggingDestinationParametersObservedConfigLike(ContainerLoggingDestinationParameters item) {
    return new ContainerLoggingDestinationParametersObservedConfigNested(item);
  }
  
  public A withNewContainerLoggingDestinationParametersObservedConfig(Integer maxLength) {
    return (A)withObservedConfig(new ContainerLoggingDestinationParameters(maxLength));
  }
  
  public KubeAPIServerSpecObservedConfigNested<A> withNewKubeAPIServerSpecObservedConfig() {
    return new KubeAPIServerSpecObservedConfigNested(null);
  }
  
  public KubeAPIServerSpecObservedConfigNested<A> withNewKubeAPIServerSpecObservedConfigLike(KubeAPIServerSpec item) {
    return new KubeAPIServerSpecObservedConfigNested(item);
  }
  
  public KubeSchedulerListObservedConfigNested<A> withNewKubeSchedulerListObservedConfig() {
    return new KubeSchedulerListObservedConfigNested(null);
  }
  
  public KubeSchedulerListObservedConfigNested<A> withNewKubeSchedulerListObservedConfigLike(KubeSchedulerList item) {
    return new KubeSchedulerListObservedConfigNested(item);
  }
  
  public StaticIPAMRoutesObservedConfigNested<A> withNewStaticIPAMRoutesObservedConfig() {
    return new StaticIPAMRoutesObservedConfigNested(null);
  }
  
  public StaticIPAMRoutesObservedConfigNested<A> withNewStaticIPAMRoutesObservedConfigLike(StaticIPAMRoutes item) {
    return new StaticIPAMRoutesObservedConfigNested(item);
  }
  
  public A withNewStaticIPAMRoutesObservedConfig(String destination,String gateway) {
    return (A)withObservedConfig(new StaticIPAMRoutes(destination, gateway));
  }
  
  public OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new OpenShiftControllerManagerObservedConfigNested(null);
  }
  
  public OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new OpenShiftControllerManagerObservedConfigNested(item);
  }
  
  public EndpointPublishingStrategyObservedConfigNested<A> withNewEndpointPublishingStrategyObservedConfig() {
    return new EndpointPublishingStrategyObservedConfigNested(null);
  }
  
  public EndpointPublishingStrategyObservedConfigNested<A> withNewEndpointPublishingStrategyObservedConfigLike(EndpointPublishingStrategy item) {
    return new EndpointPublishingStrategyObservedConfigNested(item);
  }
  
  public CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new CloudCredentialObservedConfigNested(null);
  }
  
  public CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new CloudCredentialObservedConfigNested(item);
  }
  
  public KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new KubeSchedulerObservedConfigNested(null);
  }
  
  public KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new KubeSchedulerObservedConfigNested(item);
  }
  
  public ClusterCSIDriverStatusObservedConfigNested<A> withNewClusterCSIDriverStatusObservedConfig() {
    return new ClusterCSIDriverStatusObservedConfigNested(null);
  }
  
  public ClusterCSIDriverStatusObservedConfigNested<A> withNewClusterCSIDriverStatusObservedConfigLike(ClusterCSIDriverStatus item) {
    return new ClusterCSIDriverStatusObservedConfigNested(item);
  }
  
  public SFlowConfigObservedNested<A> withNewSFlowConfigObserved() {
    return new SFlowConfigObservedNested(null);
  }
  
  public SFlowConfigObservedNested<A> withNewSFlowConfigObservedLike(SFlowConfig item) {
    return new SFlowConfigObservedNested(item);
  }
  
  public ForwardPluginObservedConfigNested<A> withNewForwardPluginObservedConfig() {
    return new ForwardPluginObservedConfigNested(null);
  }
  
  public ForwardPluginObservedConfigNested<A> withNewForwardPluginObservedConfigLike(ForwardPlugin item) {
    return new ForwardPluginObservedConfigNested(item);
  }
  
  public LogEntryObservedConfigNested<A> withNewLogEntryObservedConfig() {
    return new LogEntryObservedConfigNested(null);
  }
  
  public LogEntryObservedConfigNested<A> withNewLogEntryObservedConfigLike(LogEntry item) {
    return new LogEntryObservedConfigNested(item);
  }
  
  public AdditionalNetworkDefinitionObservedConfigNested<A> withNewAdditionalNetworkDefinitionObservedConfig() {
    return new AdditionalNetworkDefinitionObservedConfigNested(null);
  }
  
  public AdditionalNetworkDefinitionObservedConfigNested<A> withNewAdditionalNetworkDefinitionObservedConfigLike(AdditionalNetworkDefinition item) {
    return new AdditionalNetworkDefinitionObservedConfigNested(item);
  }
  
  public AuthenticationStatusObservedConfigNested<A> withNewAuthenticationStatusObservedConfig() {
    return new AuthenticationStatusObservedConfigNested(null);
  }
  
  public AuthenticationStatusObservedConfigNested<A> withNewAuthenticationStatusObservedConfigLike(AuthenticationStatus item) {
    return new AuthenticationStatusObservedConfigNested(item);
  }
  
  public NodePortStrategyObservedConfigNested<A> withNewNodePortStrategyObservedConfig() {
    return new NodePortStrategyObservedConfigNested(null);
  }
  
  public NodePortStrategyObservedConfigNested<A> withNewNodePortStrategyObservedConfigLike(NodePortStrategy item) {
    return new NodePortStrategyObservedConfigNested(item);
  }
  
  public A withNewNodePortStrategyObservedConfig(String protocol) {
    return (A)withObservedConfig(new NodePortStrategy(protocol));
  }
  
  public NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new NetworkObservedConfigNested(null);
  }
  
  public NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new NetworkObservedConfigNested(item);
  }
  
  public ClientTLSObservedConfigNested<A> withNewClientTLSObservedConfig() {
    return new ClientTLSObservedConfigNested(null);
  }
  
  public ClientTLSObservedConfigNested<A> withNewClientTLSObservedConfigLike(ClientTLS item) {
    return new ClientTLSObservedConfigNested(item);
  }
  
  public ImagePrunerStatusObservedConfigNested<A> withNewImagePrunerStatusObservedConfig() {
    return new ImagePrunerStatusObservedConfigNested(null);
  }
  
  public ImagePrunerStatusObservedConfigNested<A> withNewImagePrunerStatusObservedConfigLike(ImagePrunerStatus item) {
    return new ImagePrunerStatusObservedConfigNested(item);
  }
  
  public UpstreamObservedConfigNested<A> withNewUpstreamObservedConfig() {
    return new UpstreamObservedConfigNested(null);
  }
  
  public UpstreamObservedConfigNested<A> withNewUpstreamObservedConfigLike(Upstream item) {
    return new UpstreamObservedConfigNested(item);
  }
  
  public A withNewUpstreamObservedConfig(String address,Integer port,String type) {
    return (A)withObservedConfig(new Upstream(address, port, type));
  }
  
  public AzureDiskEncryptionSetObservedConfigNested<A> withNewAzureDiskEncryptionSetObservedConfig() {
    return new AzureDiskEncryptionSetObservedConfigNested(null);
  }
  
  public AzureDiskEncryptionSetObservedConfigNested<A> withNewAzureDiskEncryptionSetObservedConfigLike(AzureDiskEncryptionSet item) {
    return new AzureDiskEncryptionSetObservedConfigNested(item);
  }
  
  public A withNewAzureDiskEncryptionSetObservedConfig(String name,String resourceGroup,String subscriptionID) {
    return (A)withObservedConfig(new AzureDiskEncryptionSet(name, resourceGroup, subscriptionID));
  }
  
  public ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new ServiceCatalogAPIServerObservedConfigNested(null);
  }
  
  public ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new ServiceCatalogAPIServerObservedConfigNested(item);
  }
  
  public CSIDriverConfigSpecObservedNested<A> withNewCSIDriverConfigSpecObserved() {
    return new CSIDriverConfigSpecObservedNested(null);
  }
  
  public CSIDriverConfigSpecObservedNested<A> withNewCSIDriverConfigSpecObservedLike(CSIDriverConfigSpec item) {
    return new CSIDriverConfigSpecObservedNested(item);
  }
  
  public IngressControllerCaptureHTTPHeaderObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeaderObservedConfig() {
    return new IngressControllerCaptureHTTPHeaderObservedConfigNested(null);
  }
  
  public IngressControllerCaptureHTTPHeaderObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeaderObservedConfigLike(IngressControllerCaptureHTTPHeader item) {
    return new IngressControllerCaptureHTTPHeaderObservedConfigNested(item);
  }
  
  public A withNewIngressControllerCaptureHTTPHeaderObservedConfig(Integer maxLength,String name) {
    return (A)withObservedConfig(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  
  public NetworkMigrationObservedConfigNested<A> withNewNetworkMigrationObservedConfig() {
    return new NetworkMigrationObservedConfigNested(null);
  }
  
  public NetworkMigrationObservedConfigNested<A> withNewNetworkMigrationObservedConfigLike(NetworkMigration item) {
    return new NetworkMigrationObservedConfigNested(item);
  }
  
  public DNSRecordListObservedConfigNested<A> withNewDNSRecordListObservedConfig() {
    return new DNSRecordListObservedConfigNested(null);
  }
  
  public DNSRecordListObservedConfigNested<A> withNewDNSRecordListObservedConfigLike(DNSRecordList item) {
    return new DNSRecordListObservedConfigNested(item);
  }
  
  public RawExtensionObservedConfigNested<A> withNewRawExtensionObservedConfig() {
    return new RawExtensionObservedConfigNested(null);
  }
  
  public RawExtensionObservedConfigNested<A> withNewRawExtensionObservedConfigLike(RawExtension item) {
    return new RawExtensionObservedConfigNested(item);
  }
  
  public A withNewRawExtensionObservedConfig(Object value) {
    return (A)withObservedConfig(new RawExtension(value));
  }
  
  public EtcdSpecObservedConfigNested<A> withNewEtcdSpecObservedConfig() {
    return new EtcdSpecObservedConfigNested(null);
  }
  
  public EtcdSpecObservedConfigNested<A> withNewEtcdSpecObservedConfigLike(EtcdSpec item) {
    return new EtcdSpecObservedConfigNested(item);
  }
  
  public PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new PodNetworkConnectivityCheckObservedConfigNested(null);
  }
  
  public PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new PodNetworkConnectivityCheckObservedConfigNested(item);
  }
  
  public LoadBalancerStrategyObservedConfigNested<A> withNewLoadBalancerStrategyObservedConfig() {
    return new LoadBalancerStrategyObservedConfigNested(null);
  }
  
  public LoadBalancerStrategyObservedConfigNested<A> withNewLoadBalancerStrategyObservedConfigLike(LoadBalancerStrategy item) {
    return new LoadBalancerStrategyObservedConfigNested(item);
  }
  
  public OpenShiftAPIServerStatusObservedConfigNested<A> withNewOpenShiftAPIServerStatusObservedConfig() {
    return new OpenShiftAPIServerStatusObservedConfigNested(null);
  }
  
  public OpenShiftAPIServerStatusObservedConfigNested<A> withNewOpenShiftAPIServerStatusObservedConfigLike(OpenShiftAPIServerStatus item) {
    return new OpenShiftAPIServerStatusObservedConfigNested(item);
  }
  
  public DNSOverTLSConfigObservedNested<A> withNewDNSOverTLSConfigObserved() {
    return new DNSOverTLSConfigObservedNested(null);
  }
  
  public DNSOverTLSConfigObservedNested<A> withNewDNSOverTLSConfigObservedLike(DNSOverTLSConfig item) {
    return new DNSOverTLSConfigObservedNested(item);
  }
  
  public CloudCredentialListObservedConfigNested<A> withNewCloudCredentialListObservedConfig() {
    return new CloudCredentialListObservedConfigNested(null);
  }
  
  public CloudCredentialListObservedConfigNested<A> withNewCloudCredentialListObservedConfigLike(CloudCredentialList item) {
    return new CloudCredentialListObservedConfigNested(item);
  }
  
  public DNSCacheObservedConfigNested<A> withNewDNSCacheObservedConfig() {
    return new DNSCacheObservedConfigNested(null);
  }
  
  public DNSCacheObservedConfigNested<A> withNewDNSCacheObservedConfigLike(DNSCache item) {
    return new DNSCacheObservedConfigNested(item);
  }
  
  public ImagePrunerSpecObservedConfigNested<A> withNewImagePrunerSpecObservedConfig() {
    return new ImagePrunerSpecObservedConfigNested(null);
  }
  
  public ImagePrunerSpecObservedConfigNested<A> withNewImagePrunerSpecObservedConfigLike(ImagePrunerSpec item) {
    return new ImagePrunerSpecObservedConfigNested(item);
  }
  
  public ConfigListObservedConfigNested<A> withNewConfigListObservedConfig() {
    return new ConfigListObservedConfigNested(null);
  }
  
  public ConfigListObservedConfigNested<A> withNewConfigListObservedConfigLike(ConfigList item) {
    return new ConfigListObservedConfigNested(item);
  }
  
  public AuthenticationListObservedConfigNested<A> withNewAuthenticationListObservedConfig() {
    return new AuthenticationListObservedConfigNested(null);
  }
  
  public AuthenticationListObservedConfigNested<A> withNewAuthenticationListObservedConfigLike(AuthenticationList item) {
    return new AuthenticationListObservedConfigNested(item);
  }
  
  public PinnedResourceReferenceObservedConfigNested<A> withNewPinnedResourceReferenceObservedConfig() {
    return new PinnedResourceReferenceObservedConfigNested(null);
  }
  
  public PinnedResourceReferenceObservedConfigNested<A> withNewPinnedResourceReferenceObservedConfigLike(PinnedResourceReference item) {
    return new PinnedResourceReferenceObservedConfigNested(item);
  }
  
  public A withNewPinnedResourceReferenceObservedConfig(String group,String resource,String version) {
    return (A)withObservedConfig(new PinnedResourceReference(group, resource, version));
  }
  
  public KubeControllerManagerListObservedConfigNested<A> withNewKubeControllerManagerListObservedConfig() {
    return new KubeControllerManagerListObservedConfigNested(null);
  }
  
  public KubeControllerManagerListObservedConfigNested<A> withNewKubeControllerManagerListObservedConfigLike(KubeControllerManagerList item) {
    return new KubeControllerManagerListObservedConfigNested(item);
  }
  
  public IPAMConfigObservedNested<A> withNewIPAMConfigObserved() {
    return new IPAMConfigObservedNested(null);
  }
  
  public IPAMConfigObservedNested<A> withNewIPAMConfigObservedLike(IPAMConfig item) {
    return new IPAMConfigObservedNested(item);
  }
  
  public ContainerObservedConfigNested<A> withNewContainerObservedConfig() {
    return new ContainerObservedConfigNested(null);
  }
  
  public ContainerObservedConfigNested<A> withNewContainerObservedConfigLike(Container item) {
    return new ContainerObservedConfigNested(item);
  }
  
  public IBMLoadBalancerParametersObservedConfigNested<A> withNewIBMLoadBalancerParametersObservedConfig() {
    return new IBMLoadBalancerParametersObservedConfigNested(null);
  }
  
  public IBMLoadBalancerParametersObservedConfigNested<A> withNewIBMLoadBalancerParametersObservedConfigLike(IBMLoadBalancerParameters item) {
    return new IBMLoadBalancerParametersObservedConfigNested(item);
  }
  
  public A withNewIBMLoadBalancerParametersObservedConfig(String protocol) {
    return (A)withObservedConfig(new IBMLoadBalancerParameters(protocol));
  }
  
  public AccessLoggingObservedConfigNested<A> withNewAccessLoggingObservedConfig() {
    return new AccessLoggingObservedConfigNested(null);
  }
  
  public AccessLoggingObservedConfigNested<A> withNewAccessLoggingObservedConfigLike(AccessLogging item) {
    return new AccessLoggingObservedConfigNested(item);
  }
  
  public HostNetworkStrategyObservedConfigNested<A> withNewHostNetworkStrategyObservedConfig() {
    return new HostNetworkStrategyObservedConfigNested(null);
  }
  
  public HostNetworkStrategyObservedConfigNested<A> withNewHostNetworkStrategyObservedConfigLike(HostNetworkStrategy item) {
    return new HostNetworkStrategyObservedConfigNested(item);
  }
  
  public A withNewHostNetworkStrategyObservedConfig(Integer httpPort,Integer httpsPort,String protocol,Integer statsPort) {
    return (A)withObservedConfig(new HostNetworkStrategy(httpPort, httpsPort, protocol, statsPort));
  }
  
  public KubeSchedulerSpecObservedConfigNested<A> withNewKubeSchedulerSpecObservedConfig() {
    return new KubeSchedulerSpecObservedConfigNested(null);
  }
  
  public KubeSchedulerSpecObservedConfigNested<A> withNewKubeSchedulerSpecObservedConfigLike(KubeSchedulerSpec item) {
    return new KubeSchedulerSpecObservedConfigNested(item);
  }
  
  public ImageContentSourcePolicyListObservedConfigNested<A> withNewImageContentSourcePolicyListObservedConfig() {
    return new ImageContentSourcePolicyListObservedConfigNested(null);
  }
  
  public ImageContentSourcePolicyListObservedConfigNested<A> withNewImageContentSourcePolicyListObservedConfigLike(ImageContentSourcePolicyList item) {
    return new ImageContentSourcePolicyListObservedConfigNested(item);
  }
  
  public OpenShiftControllerManagerStatusObservedConfigNested<A> withNewOpenShiftControllerManagerStatusObservedConfig() {
    return new OpenShiftControllerManagerStatusObservedConfigNested(null);
  }
  
  public OpenShiftControllerManagerStatusObservedConfigNested<A> withNewOpenShiftControllerManagerStatusObservedConfigLike(OpenShiftControllerManagerStatus item) {
    return new OpenShiftControllerManagerStatusObservedConfigNested(item);
  }
  
  public ServiceCatalogAPIServerStatusObservedConfigNested<A> withNewServiceCatalogAPIServerStatusObservedConfig() {
    return new ServiceCatalogAPIServerStatusObservedConfigNested(null);
  }
  
  public ServiceCatalogAPIServerStatusObservedConfigNested<A> withNewServiceCatalogAPIServerStatusObservedConfigLike(ServiceCatalogAPIServerStatus item) {
    return new ServiceCatalogAPIServerStatusObservedConfigNested(item);
  }
  
  public DNSNodePlacementObservedConfigNested<A> withNewDNSNodePlacementObservedConfig() {
    return new DNSNodePlacementObservedConfigNested(null);
  }
  
  public DNSNodePlacementObservedConfigNested<A> withNewDNSNodePlacementObservedConfigLike(DNSNodePlacement item) {
    return new DNSNodePlacementObservedConfigNested(item);
  }
  
  public NetworkListObservedConfigNested<A> withNewNetworkListObservedConfig() {
    return new NetworkListObservedConfigNested(null);
  }
  
  public NetworkListObservedConfigNested<A> withNewNetworkListObservedConfigLike(NetworkList item) {
    return new NetworkListObservedConfigNested(item);
  }
  
  public ProviderLoadBalancerParametersObservedConfigNested<A> withNewProviderLoadBalancerParametersObservedConfig() {
    return new ProviderLoadBalancerParametersObservedConfigNested(null);
  }
  
  public ProviderLoadBalancerParametersObservedConfigNested<A> withNewProviderLoadBalancerParametersObservedConfigLike(ProviderLoadBalancerParameters item) {
    return new ProviderLoadBalancerParametersObservedConfigNested(item);
  }
  
  public ResourceAttributesAccessReviewObservedConfigNested<A> withNewResourceAttributesAccessReviewObservedConfig() {
    return new ResourceAttributesAccessReviewObservedConfigNested(null);
  }
  
  public ResourceAttributesAccessReviewObservedConfigNested<A> withNewResourceAttributesAccessReviewObservedConfigLike(ResourceAttributesAccessReview item) {
    return new ResourceAttributesAccessReviewObservedConfigNested(item);
  }
  
  public ServiceCASpecObservedConfigNested<A> withNewServiceCASpecObservedConfig() {
    return new ServiceCASpecObservedConfigNested(null);
  }
  
  public ServiceCASpecObservedConfigNested<A> withNewServiceCASpecObservedConfigLike(ServiceCASpec item) {
    return new ServiceCASpecObservedConfigNested(item);
  }
  
  public PrivateStrategyObservedConfigNested<A> withNewPrivateStrategyObservedConfig() {
    return new PrivateStrategyObservedConfigNested(null);
  }
  
  public PrivateStrategyObservedConfigNested<A> withNewPrivateStrategyObservedConfigLike(PrivateStrategy item) {
    return new PrivateStrategyObservedConfigNested(item);
  }
  
  public A withNewPrivateStrategyObservedConfig(String protocol) {
    return (A)withObservedConfig(new PrivateStrategy(protocol));
  }
  
  public PodNetworkConnectivityCheckListObservedConfigNested<A> withNewPodNetworkConnectivityCheckListObservedConfig() {
    return new PodNetworkConnectivityCheckListObservedConfigNested(null);
  }
  
  public PodNetworkConnectivityCheckListObservedConfigNested<A> withNewPodNetworkConnectivityCheckListObservedConfigLike(PodNetworkConnectivityCheckList item) {
    return new PodNetworkConnectivityCheckListObservedConfigNested(item);
  }
  
  public OpenShiftAPIServerListObservedConfigNested<A> withNewOpenShiftAPIServerListObservedConfig() {
    return new OpenShiftAPIServerListObservedConfigNested(null);
  }
  
  public OpenShiftAPIServerListObservedConfigNested<A> withNewOpenShiftAPIServerListObservedConfigLike(OpenShiftAPIServerList item) {
    return new OpenShiftAPIServerListObservedConfigNested(item);
  }
  
  public OAuthAPIServerStatusObservedConfigNested<A> withNewOAuthAPIServerStatusObservedConfig() {
    return new OAuthAPIServerStatusObservedConfigNested(null);
  }
  
  public OAuthAPIServerStatusObservedConfigNested<A> withNewOAuthAPIServerStatusObservedConfigLike(OAuthAPIServerStatus item) {
    return new OAuthAPIServerStatusObservedConfigNested(item);
  }
  
  public A withNewOAuthAPIServerStatusObservedConfig(Integer latestAvailableRevision) {
    return (A)withObservedConfig(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  
  public GCPCSIDriverConfigSpecObservedNested<A> withNewGCPCSIDriverConfigSpecObserved() {
    return new GCPCSIDriverConfigSpecObservedNested(null);
  }
  
  public GCPCSIDriverConfigSpecObservedNested<A> withNewGCPCSIDriverConfigSpecObservedLike(GCPCSIDriverConfigSpec item) {
    return new GCPCSIDriverConfigSpecObservedNested(item);
  }
  
  public ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new ServiceCatalogControllerManagerObservedConfigNested(null);
  }
  
  public ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerObservedConfigNested(item);
  }
  
  public IngressControllerCaptureHTTPCookieObservedConfigNested<A> withNewIngressControllerCaptureHTTPCookieObservedConfig() {
    return new IngressControllerCaptureHTTPCookieObservedConfigNested(null);
  }
  
  public IngressControllerCaptureHTTPCookieObservedConfigNested<A> withNewIngressControllerCaptureHTTPCookieObservedConfigLike(IngressControllerCaptureHTTPCookie item) {
    return new IngressControllerCaptureHTTPCookieObservedConfigNested(item);
  }
  
  public A withNewIngressControllerCaptureHTTPCookieObservedConfig(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withObservedConfig(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  
  public DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new DNSObservedConfigNested(null);
  }
  
  public DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new DNSObservedConfigNested(item);
  }
  
  public AddPageObservedConfigNested<A> withNewAddPageObservedConfig() {
    return new AddPageObservedConfigNested(null);
  }
  
  public AddPageObservedConfigNested<A> withNewAddPageObservedConfigLike(AddPage item) {
    return new AddPageObservedConfigNested(item);
  }
  
  public AzureCSIDriverConfigSpecObservedNested<A> withNewAzureCSIDriverConfigSpecObserved() {
    return new AzureCSIDriverConfigSpecObservedNested(null);
  }
  
  public AzureCSIDriverConfigSpecObservedNested<A> withNewAzureCSIDriverConfigSpecObservedLike(AzureCSIDriverConfigSpec item) {
    return new AzureCSIDriverConfigSpecObservedNested(item);
  }
  
  public StorageListObservedConfigNested<A> withNewStorageListObservedConfig() {
    return new StorageListObservedConfigNested(null);
  }
  
  public StorageListObservedConfigNested<A> withNewStorageListObservedConfigLike(StorageList item) {
    return new StorageListObservedConfigNested(item);
  }
  
  public AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new AuthenticationObservedConfigNested(null);
  }
  
  public AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new AuthenticationObservedConfigNested(item);
  }
  
  public ServiceCAStatusObservedConfigNested<A> withNewServiceCAStatusObservedConfig() {
    return new ServiceCAStatusObservedConfigNested(null);
  }
  
  public ServiceCAStatusObservedConfigNested<A> withNewServiceCAStatusObservedConfigLike(ServiceCAStatus item) {
    return new ServiceCAStatusObservedConfigNested(item);
  }
  
  public MTUMigrationObservedConfigNested<A> withNewMTUMigrationObservedConfig() {
    return new MTUMigrationObservedConfigNested(null);
  }
  
  public MTUMigrationObservedConfigNested<A> withNewMTUMigrationObservedConfigLike(MTUMigration item) {
    return new MTUMigrationObservedConfigNested(item);
  }
  
  public PerspectiveObservedConfigNested<A> withNewPerspectiveObservedConfig() {
    return new PerspectiveObservedConfigNested(null);
  }
  
  public PerspectiveObservedConfigNested<A> withNewPerspectiveObservedConfigLike(Perspective item) {
    return new PerspectiveObservedConfigNested(item);
  }
  
  public LabelSelectorObservedConfigNested<A> withNewLabelSelectorObservedConfig() {
    return new LabelSelectorObservedConfigNested(null);
  }
  
  public LabelSelectorObservedConfigNested<A> withNewLabelSelectorObservedConfigLike(LabelSelector item) {
    return new LabelSelectorObservedConfigNested(item);
  }
  
  public KubeStorageVersionMigratorListObservedConfigNested<A> withNewKubeStorageVersionMigratorListObservedConfig() {
    return new KubeStorageVersionMigratorListObservedConfigNested(null);
  }
  
  public KubeStorageVersionMigratorListObservedConfigNested<A> withNewKubeStorageVersionMigratorListObservedConfigLike(KubeStorageVersionMigratorList item) {
    return new KubeStorageVersionMigratorListObservedConfigNested(item);
  }
  
  public StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new StorageObservedConfigNested(null);
  }
  
  public StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new StorageObservedConfigNested(item);
  }
  
  public ServiceCatalogControllerManagerListObservedConfigNested<A> withNewServiceCatalogControllerManagerListObservedConfig() {
    return new ServiceCatalogControllerManagerListObservedConfigNested(null);
  }
  
  public ServiceCatalogControllerManagerListObservedConfigNested<A> withNewServiceCatalogControllerManagerListObservedConfigLike(ServiceCatalogControllerManagerList item) {
    return new ServiceCatalogControllerManagerListObservedConfigNested(item);
  }
  
  public DeveloperConsoleCatalogCategoryMetaObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryMetaObservedConfig() {
    return new DeveloperConsoleCatalogCategoryMetaObservedConfigNested(null);
  }
  
  public DeveloperConsoleCatalogCategoryMetaObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryMetaObservedConfigLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new DeveloperConsoleCatalogCategoryMetaObservedConfigNested(item);
  }
  
  public OVNKubernetesConfigObservedNested<A> withNewOVNKubernetesConfigObserved() {
    return new OVNKubernetesConfigObservedNested(null);
  }
  
  public OVNKubernetesConfigObservedNested<A> withNewOVNKubernetesConfigObservedLike(OVNKubernetesConfig item) {
    return new OVNKubernetesConfigObservedNested(item);
  }
  
  public DNSSpecObservedConfigNested<A> withNewDNSSpecObservedConfig() {
    return new DNSSpecObservedConfigNested(null);
  }
  
  public DNSSpecObservedConfigNested<A> withNewDNSSpecObservedConfigLike(DNSSpec item) {
    return new DNSSpecObservedConfigNested(item);
  }
  
  public IngressControllerSpecObservedConfigNested<A> withNewIngressControllerSpecObservedConfig() {
    return new IngressControllerSpecObservedConfigNested(null);
  }
  
  public IngressControllerSpecObservedConfigNested<A> withNewIngressControllerSpecObservedConfigLike(IngressControllerSpec item) {
    return new IngressControllerSpecObservedConfigNested(item);
  }
  
  public OperatorConditionObservedConfigNested<A> withNewOperatorConditionObservedConfig() {
    return new OperatorConditionObservedConfigNested(null);
  }
  
  public OperatorConditionObservedConfigNested<A> withNewOperatorConditionObservedConfigLike(OperatorCondition item) {
    return new OperatorConditionObservedConfigNested(item);
  }
  
  public A withNewOperatorConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObservedConfig(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ProxyConfigObservedNested<A> withNewProxyConfigObserved() {
    return new ProxyConfigObservedNested(null);
  }
  
  public ProxyConfigObservedNested<A> withNewProxyConfigObservedLike(ProxyConfig item) {
    return new ProxyConfigObservedNested(item);
  }
  
  public KuryrConfigObservedNested<A> withNewKuryrConfigObserved() {
    return new KuryrConfigObservedNested(null);
  }
  
  public KuryrConfigObservedNested<A> withNewKuryrConfigObservedLike(KuryrConfig item) {
    return new KuryrConfigObservedNested(item);
  }
  
  public ServiceCatalogAPIServerSpecObservedConfigNested<A> withNewServiceCatalogAPIServerSpecObservedConfig() {
    return new ServiceCatalogAPIServerSpecObservedConfigNested(null);
  }
  
  public ServiceCatalogAPIServerSpecObservedConfigNested<A> withNewServiceCatalogAPIServerSpecObservedConfigLike(ServiceCatalogAPIServerSpec item) {
    return new ServiceCatalogAPIServerSpecObservedConfigNested(item);
  }
  
  public ImageContentSourcePolicySpecObservedConfigNested<A> withNewImageContentSourcePolicySpecObservedConfig() {
    return new ImageContentSourcePolicySpecObservedConfigNested(null);
  }
  
  public ImageContentSourcePolicySpecObservedConfigNested<A> withNewImageContentSourcePolicySpecObservedConfigLike(ImageContentSourcePolicySpec item) {
    return new ImageContentSourcePolicySpecObservedConfigNested(item);
  }
  
  public DNSStatusObservedConfigNested<A> withNewDNSStatusObservedConfig() {
    return new DNSStatusObservedConfigNested(null);
  }
  
  public DNSStatusObservedConfigNested<A> withNewDNSStatusObservedConfigLike(DNSStatus item) {
    return new DNSStatusObservedConfigNested(item);
  }
  
  public DNSTransportConfigObservedNested<A> withNewDNSTransportConfigObserved() {
    return new DNSTransportConfigObservedNested(null);
  }
  
  public DNSTransportConfigObservedNested<A> withNewDNSTransportConfigObservedLike(DNSTransportConfig item) {
    return new DNSTransportConfigObservedNested(item);
  }
  
  public GCPLoadBalancerParametersObservedConfigNested<A> withNewGCPLoadBalancerParametersObservedConfig() {
    return new GCPLoadBalancerParametersObservedConfigNested(null);
  }
  
  public GCPLoadBalancerParametersObservedConfigNested<A> withNewGCPLoadBalancerParametersObservedConfigLike(GCPLoadBalancerParameters item) {
    return new GCPLoadBalancerParametersObservedConfigNested(item);
  }
  
  public A withNewGCPLoadBalancerParametersObservedConfig(String clientAccess) {
    return (A)withObservedConfig(new GCPLoadBalancerParameters(clientAccess));
  }
  
  public KubeAPIServerListObservedConfigNested<A> withNewKubeAPIServerListObservedConfig() {
    return new KubeAPIServerListObservedConfigNested(null);
  }
  
  public KubeAPIServerListObservedConfigNested<A> withNewKubeAPIServerListObservedConfigLike(KubeAPIServerList item) {
    return new KubeAPIServerListObservedConfigNested(item);
  }
  
  public ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new ConfigObservedConfigNested(null);
  }
  
  public ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new ConfigObservedConfigNested(item);
  }
  
  public ObjectMetaObservedConfigNested<A> withNewObjectMetaObservedConfig() {
    return new ObjectMetaObservedConfigNested(null);
  }
  
  public ObjectMetaObservedConfigNested<A> withNewObjectMetaObservedConfigLike(ObjectMeta item) {
    return new ObjectMetaObservedConfigNested(item);
  }
  
  public ClusterCSIDriverListObservedConfigNested<A> withNewClusterCSIDriverListObservedConfig() {
    return new ClusterCSIDriverListObservedConfigNested(null);
  }
  
  public ClusterCSIDriverListObservedConfigNested<A> withNewClusterCSIDriverListObservedConfigLike(ClusterCSIDriverList item) {
    return new ClusterCSIDriverListObservedConfigNested(item);
  }
  
  public SimpleMacvlanConfigObservedNested<A> withNewSimpleMacvlanConfigObserved() {
    return new SimpleMacvlanConfigObservedNested(null);
  }
  
  public SimpleMacvlanConfigObservedNested<A> withNewSimpleMacvlanConfigObservedLike(SimpleMacvlanConfig item) {
    return new SimpleMacvlanConfigObservedNested(item);
  }
  
  public PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new PersistentVolumeClaimObservedConfigNested(null);
  }
  
  public PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimObservedConfigNested(item);
  }
  
  public GenericKubernetesResourceObservedConfigNested<A> withNewGenericKubernetesResourceObservedConfig() {
    return new GenericKubernetesResourceObservedConfigNested(null);
  }
  
  public GenericKubernetesResourceObservedConfigNested<A> withNewGenericKubernetesResourceObservedConfigLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceObservedConfigNested(item);
  }
  
  public EgressIPConfigObservedNested<A> withNewEgressIPConfigObserved() {
    return new EgressIPConfigObservedNested(null);
  }
  
  public EgressIPConfigObservedNested<A> withNewEgressIPConfigObservedLike(EgressIPConfig item) {
    return new EgressIPConfigObservedNested(item);
  }
  
  public A withNewEgressIPConfigObserved(Integer reachabilityTotalTimeoutSeconds) {
    return (A)withObservedConfig(new EgressIPConfig(reachabilityTotalTimeoutSeconds));
  }
  
  public HybridOverlayConfigObservedNested<A> withNewHybridOverlayConfigObserved() {
    return new HybridOverlayConfigObservedNested(null);
  }
  
  public HybridOverlayConfigObservedNested<A> withNewHybridOverlayConfigObservedLike(HybridOverlayConfig item) {
    return new HybridOverlayConfigObservedNested(item);
  }
  
  public AWSLoadBalancerParametersObservedConfigNested<A> withNewAWSLoadBalancerParametersObservedConfig() {
    return new AWSLoadBalancerParametersObservedConfigNested(null);
  }
  
  public AWSLoadBalancerParametersObservedConfigNested<A> withNewAWSLoadBalancerParametersObservedConfigLike(AWSLoadBalancerParameters item) {
    return new AWSLoadBalancerParametersObservedConfigNested(item);
  }
  
  public CSISnapshotControllerListObservedConfigNested<A> withNewCSISnapshotControllerListObservedConfig() {
    return new CSISnapshotControllerListObservedConfigNested(null);
  }
  
  public CSISnapshotControllerListObservedConfigNested<A> withNewCSISnapshotControllerListObservedConfigLike(CSISnapshotControllerList item) {
    return new CSISnapshotControllerListObservedConfigNested(item);
  }
  
  public ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new ConsoleObservedConfigNested(null);
  }
  
  public ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new ConsoleObservedConfigNested(item);
  }
  
  public DNSZoneConditionObservedConfigNested<A> withNewDNSZoneConditionObservedConfig() {
    return new DNSZoneConditionObservedConfigNested(null);
  }
  
  public DNSZoneConditionObservedConfigNested<A> withNewDNSZoneConditionObservedConfigLike(DNSZoneCondition item) {
    return new DNSZoneConditionObservedConfigNested(item);
  }
  
  public A withNewDNSZoneConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObservedConfig(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new ClusterCSIDriverObservedConfigNested(null);
  }
  
  public ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new ClusterCSIDriverObservedConfigNested(item);
  }
  
  public QuickStartsObservedConfigNested<A> withNewQuickStartsObservedConfig() {
    return new QuickStartsObservedConfigNested(null);
  }
  
  public QuickStartsObservedConfigNested<A> withNewQuickStartsObservedConfigLike(QuickStarts item) {
    return new QuickStartsObservedConfigNested(item);
  }
  
  public DNSZoneStatusObservedConfigNested<A> withNewDNSZoneStatusObservedConfig() {
    return new DNSZoneStatusObservedConfigNested(null);
  }
  
  public DNSZoneStatusObservedConfigNested<A> withNewDNSZoneStatusObservedConfigLike(DNSZoneStatus item) {
    return new DNSZoneStatusObservedConfigNested(item);
  }
  
  public OutageEntryObservedConfigNested<A> withNewOutageEntryObservedConfig() {
    return new OutageEntryObservedConfigNested(null);
  }
  
  public OutageEntryObservedConfigNested<A> withNewOutageEntryObservedConfigLike(OutageEntry item) {
    return new OutageEntryObservedConfigNested(item);
  }
  
  public ConfigSpecObservedConfigNested<A> withNewConfigSpecObservedConfig() {
    return new ConfigSpecObservedConfigNested(null);
  }
  
  public ConfigSpecObservedConfigNested<A> withNewConfigSpecObservedConfigLike(ConfigSpec item) {
    return new ConfigSpecObservedConfigNested(item);
  }
  
  public OpenShiftControllerManagerListObservedConfigNested<A> withNewOpenShiftControllerManagerListObservedConfig() {
    return new OpenShiftControllerManagerListObservedConfigNested(null);
  }
  
  public OpenShiftControllerManagerListObservedConfigNested<A> withNewOpenShiftControllerManagerListObservedConfigLike(OpenShiftControllerManagerList item) {
    return new OpenShiftControllerManagerListObservedConfigNested(item);
  }
  
  public EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new EtcdObservedConfigNested(null);
  }
  
  public EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new EtcdObservedConfigNested(item);
  }
  
  public IPFIXConfigObservedNested<A> withNewIPFIXConfigObserved() {
    return new IPFIXConfigObservedNested(null);
  }
  
  public IPFIXConfigObservedNested<A> withNewIPFIXConfigObservedLike(IPFIXConfig item) {
    return new IPFIXConfigObservedNested(item);
  }
  
  public NetworkStatusObservedConfigNested<A> withNewNetworkStatusObservedConfig() {
    return new NetworkStatusObservedConfigNested(null);
  }
  
  public NetworkStatusObservedConfigNested<A> withNewNetworkStatusObservedConfigLike(NetworkStatus item) {
    return new NetworkStatusObservedConfigNested(item);
  }
  
  public PodNetworkConnectivityCheckConditionObservedConfigNested<A> withNewPodNetworkConnectivityCheckConditionObservedConfig() {
    return new PodNetworkConnectivityCheckConditionObservedConfigNested(null);
  }
  
  public PodNetworkConnectivityCheckConditionObservedConfigNested<A> withNewPodNetworkConnectivityCheckConditionObservedConfigLike(PodNetworkConnectivityCheckCondition item) {
    return new PodNetworkConnectivityCheckConditionObservedConfigNested(item);
  }
  
  public A withNewPodNetworkConnectivityCheckConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withObservedConfig(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public NodeStatusObservedConfigNested<A> withNewNodeStatusObservedConfig() {
    return new NodeStatusObservedConfigNested(null);
  }
  
  public NodeStatusObservedConfigNested<A> withNewNodeStatusObservedConfigLike(NodeStatus item) {
    return new NodeStatusObservedConfigNested(item);
  }
  
  public RouteAdmissionPolicyObservedConfigNested<A> withNewRouteAdmissionPolicyObservedConfig() {
    return new RouteAdmissionPolicyObservedConfigNested(null);
  }
  
  public RouteAdmissionPolicyObservedConfigNested<A> withNewRouteAdmissionPolicyObservedConfigLike(RouteAdmissionPolicy item) {
    return new RouteAdmissionPolicyObservedConfigNested(item);
  }
  
  public A withNewRouteAdmissionPolicyObservedConfig(String namespaceOwnership,String wildcardPolicy) {
    return (A)withObservedConfig(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  
  public GenerationStatusObservedConfigNested<A> withNewGenerationStatusObservedConfig() {
    return new GenerationStatusObservedConfigNested(null);
  }
  
  public GenerationStatusObservedConfigNested<A> withNewGenerationStatusObservedConfigLike(GenerationStatus item) {
    return new GenerationStatusObservedConfigNested(item);
  }
  
  public IngressControllerCaptureHTTPHeadersObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeadersObservedConfig() {
    return new IngressControllerCaptureHTTPHeadersObservedConfigNested(null);
  }
  
  public IngressControllerCaptureHTTPHeadersObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeadersObservedConfigLike(IngressControllerCaptureHTTPHeaders item) {
    return new IngressControllerCaptureHTTPHeadersObservedConfigNested(item);
  }
  
  public EtcdListObservedConfigNested<A> withNewEtcdListObservedConfig() {
    return new EtcdListObservedConfigNested(null);
  }
  
  public EtcdListObservedConfigNested<A> withNewEtcdListObservedConfigLike(EtcdList item) {
    return new EtcdListObservedConfigNested(item);
  }
  
  public FeaturesMigrationObservedConfigNested<A> withNewFeaturesMigrationObservedConfig() {
    return new FeaturesMigrationObservedConfigNested(null);
  }
  
  public FeaturesMigrationObservedConfigNested<A> withNewFeaturesMigrationObservedConfigLike(FeaturesMigration item) {
    return new FeaturesMigrationObservedConfigNested(item);
  }
  
  public A withNewFeaturesMigrationObservedConfig(Boolean egressFirewall,Boolean egressIP,Boolean multicast) {
    return (A)withObservedConfig(new FeaturesMigration(egressFirewall, egressIP, multicast));
  }
  
  public DefaultNetworkDefinitionObservedConfigNested<A> withNewDefaultNetworkDefinitionObservedConfig() {
    return new DefaultNetworkDefinitionObservedConfigNested(null);
  }
  
  public DefaultNetworkDefinitionObservedConfigNested<A> withNewDefaultNetworkDefinitionObservedConfigLike(DefaultNetworkDefinition item) {
    return new DefaultNetworkDefinitionObservedConfigNested(item);
  }
  
  public GCPKMSKeyReferenceObservedConfigNested<A> withNewGCPKMSKeyReferenceObservedConfig() {
    return new GCPKMSKeyReferenceObservedConfigNested(null);
  }
  
  public GCPKMSKeyReferenceObservedConfigNested<A> withNewGCPKMSKeyReferenceObservedConfigLike(GCPKMSKeyReference item) {
    return new GCPKMSKeyReferenceObservedConfigNested(item);
  }
  
  public A withNewGCPKMSKeyReferenceObservedConfig(String keyRing,String location,String name,String projectID) {
    return (A)withObservedConfig(new GCPKMSKeyReference(keyRing, location, name, projectID));
  }
  
  public OpenShiftAPIServerSpecObservedConfigNested<A> withNewOpenShiftAPIServerSpecObservedConfig() {
    return new OpenShiftAPIServerSpecObservedConfigNested(null);
  }
  
  public OpenShiftAPIServerSpecObservedConfigNested<A> withNewOpenShiftAPIServerSpecObservedConfigLike(OpenShiftAPIServerSpec item) {
    return new OpenShiftAPIServerSpecObservedConfigNested(item);
  }
  
  public KubeSchedulerStatusObservedConfigNested<A> withNewKubeSchedulerStatusObservedConfig() {
    return new KubeSchedulerStatusObservedConfigNested(null);
  }
  
  public KubeSchedulerStatusObservedConfigNested<A> withNewKubeSchedulerStatusObservedConfigLike(KubeSchedulerStatus item) {
    return new KubeSchedulerStatusObservedConfigNested(item);
  }
  
  public SyslogLoggingDestinationParametersObservedConfigNested<A> withNewSyslogLoggingDestinationParametersObservedConfig() {
    return new SyslogLoggingDestinationParametersObservedConfigNested(null);
  }
  
  public SyslogLoggingDestinationParametersObservedConfigNested<A> withNewSyslogLoggingDestinationParametersObservedConfigLike(SyslogLoggingDestinationParameters item) {
    return new SyslogLoggingDestinationParametersObservedConfigNested(item);
  }
  
  public A withNewSyslogLoggingDestinationParametersObservedConfig(String address,String facility,Integer maxLength,Integer port) {
    return (A)withObservedConfig(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  
  public AWSNetworkLoadBalancerParametersObservedConfigNested<A> withNewAWSNetworkLoadBalancerParametersObservedConfig() {
    return new AWSNetworkLoadBalancerParametersObservedConfigNested(null);
  }
  
  public AWSNetworkLoadBalancerParametersObservedConfigNested<A> withNewAWSNetworkLoadBalancerParametersObservedConfigLike(AWSNetworkLoadBalancerParameters item) {
    return new AWSNetworkLoadBalancerParametersObservedConfigNested(item);
  }
  
  public ServiceCAListObservedConfigNested<A> withNewServiceCAListObservedConfig() {
    return new ServiceCAListObservedConfigNested(null);
  }
  
  public ServiceCAListObservedConfigNested<A> withNewServiceCAListObservedConfigLike(ServiceCAList item) {
    return new ServiceCAListObservedConfigNested(item);
  }
  
  public EtcdStatusObservedConfigNested<A> withNewEtcdStatusObservedConfig() {
    return new EtcdStatusObservedConfigNested(null);
  }
  
  public EtcdStatusObservedConfigNested<A> withNewEtcdStatusObservedConfigLike(EtcdStatus item) {
    return new EtcdStatusObservedConfigNested(item);
  }
  
  public StatuspageProviderObservedConfigNested<A> withNewStatuspageProviderObservedConfig() {
    return new StatuspageProviderObservedConfigNested(null);
  }
  
  public StatuspageProviderObservedConfigNested<A> withNewStatuspageProviderObservedConfigLike(StatuspageProvider item) {
    return new StatuspageProviderObservedConfigNested(item);
  }
  
  public A withNewStatuspageProviderObservedConfig(String pageID) {
    return (A)withObservedConfig(new StatuspageProvider(pageID));
  }
  
  public KubeStorageVersionMigratorStatusObservedConfigNested<A> withNewKubeStorageVersionMigratorStatusObservedConfig() {
    return new KubeStorageVersionMigratorStatusObservedConfigNested(null);
  }
  
  public KubeStorageVersionMigratorStatusObservedConfigNested<A> withNewKubeStorageVersionMigratorStatusObservedConfigLike(KubeStorageVersionMigratorStatus item) {
    return new KubeStorageVersionMigratorStatusObservedConfigNested(item);
  }
  
  public ConsoleProvidersObservedConfigNested<A> withNewConsoleProvidersObservedConfig() {
    return new ConsoleProvidersObservedConfigNested(null);
  }
  
  public ConsoleProvidersObservedConfigNested<A> withNewConsoleProvidersObservedConfigLike(ConsoleProviders item) {
    return new ConsoleProvidersObservedConfigNested(item);
  }
  
  public IngressControllerLoggingObservedConfigNested<A> withNewIngressControllerLoggingObservedConfig() {
    return new IngressControllerLoggingObservedConfigNested(null);
  }
  
  public IngressControllerLoggingObservedConfigNested<A> withNewIngressControllerLoggingObservedConfigLike(IngressControllerLogging item) {
    return new IngressControllerLoggingObservedConfigNested(item);
  }
  
  public StorageStatusObservedConfigNested<A> withNewStorageStatusObservedConfig() {
    return new StorageStatusObservedConfigNested(null);
  }
  
  public StorageStatusObservedConfigNested<A> withNewStorageStatusObservedConfigLike(StorageStatus item) {
    return new StorageStatusObservedConfigNested(item);
  }
  
  public AuthenticationSpecObservedConfigNested<A> withNewAuthenticationSpecObservedConfig() {
    return new AuthenticationSpecObservedConfigNested(null);
  }
  
  public AuthenticationSpecObservedConfigNested<A> withNewAuthenticationSpecObservedConfigLike(AuthenticationSpec item) {
    return new AuthenticationSpecObservedConfigNested(item);
  }
  
  public PodNetworkConnectivityCheckSpecObservedConfigNested<A> withNewPodNetworkConnectivityCheckSpecObservedConfig() {
    return new PodNetworkConnectivityCheckSpecObservedConfigNested(null);
  }
  
  public PodNetworkConnectivityCheckSpecObservedConfigNested<A> withNewPodNetworkConnectivityCheckSpecObservedConfigLike(PodNetworkConnectivityCheckSpec item) {
    return new PodNetworkConnectivityCheckSpecObservedConfigNested(item);
  }
  
  public CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new CSISnapshotControllerObservedConfigNested(null);
  }
  
  public CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new CSISnapshotControllerObservedConfigNested(item);
  }
  
  public DeveloperConsoleCatalogTypesObservedConfigNested<A> withNewDeveloperConsoleCatalogTypesObservedConfig() {
    return new DeveloperConsoleCatalogTypesObservedConfigNested(null);
  }
  
  public DeveloperConsoleCatalogTypesObservedConfigNested<A> withNewDeveloperConsoleCatalogTypesObservedConfigLike(DeveloperConsoleCatalogTypes item) {
    return new DeveloperConsoleCatalogTypesObservedConfigNested(item);
  }
  
  public DNSRecordSpecObservedConfigNested<A> withNewDNSRecordSpecObservedConfig() {
    return new DNSRecordSpecObservedConfigNested(null);
  }
  
  public DNSRecordSpecObservedConfigNested<A> withNewDNSRecordSpecObservedConfigLike(DNSRecordSpec item) {
    return new DNSRecordSpecObservedConfigNested(item);
  }
  
  public DeveloperConsoleCatalogCustomizationObservedConfigNested<A> withNewDeveloperConsoleCatalogCustomizationObservedConfig() {
    return new DeveloperConsoleCatalogCustomizationObservedConfigNested(null);
  }
  
  public DeveloperConsoleCatalogCustomizationObservedConfigNested<A> withNewDeveloperConsoleCatalogCustomizationObservedConfigLike(DeveloperConsoleCatalogCustomization item) {
    return new DeveloperConsoleCatalogCustomizationObservedConfigNested(item);
  }
  
  public LoggingDestinationObservedConfigNested<A> withNewLoggingDestinationObservedConfig() {
    return new LoggingDestinationObservedConfigNested(null);
  }
  
  public LoggingDestinationObservedConfigNested<A> withNewLoggingDestinationObservedConfigLike(LoggingDestination item) {
    return new LoggingDestinationObservedConfigNested(item);
  }
  
  public IngressControllerTuningOptionsObservedConfigNested<A> withNewIngressControllerTuningOptionsObservedConfig() {
    return new IngressControllerTuningOptionsObservedConfigNested(null);
  }
  
  public IngressControllerTuningOptionsObservedConfigNested<A> withNewIngressControllerTuningOptionsObservedConfigLike(IngressControllerTuningOptions item) {
    return new IngressControllerTuningOptionsObservedConfigNested(item);
  }
  
  public StaticIPAMConfigObservedNested<A> withNewStaticIPAMConfigObserved() {
    return new StaticIPAMConfigObservedNested(null);
  }
  
  public StaticIPAMConfigObservedNested<A> withNewStaticIPAMConfigObservedLike(StaticIPAMConfig item) {
    return new StaticIPAMConfigObservedNested(item);
  }
  
  public AWSCSIDriverConfigSpecObservedNested<A> withNewAWSCSIDriverConfigSpecObserved() {
    return new AWSCSIDriverConfigSpecObservedNested(null);
  }
  
  public AWSCSIDriverConfigSpecObservedNested<A> withNewAWSCSIDriverConfigSpecObservedLike(AWSCSIDriverConfigSpec item) {
    return new AWSCSIDriverConfigSpecObservedNested(item);
  }
  
  public A withNewAWSCSIDriverConfigSpecObserved(String kmsKeyARN) {
    return (A)withObservedConfig(new AWSCSIDriverConfigSpec(kmsKeyARN));
  }
  
  public KubeControllerManagerSpecObservedConfigNested<A> withNewKubeControllerManagerSpecObservedConfig() {
    return new KubeControllerManagerSpecObservedConfigNested(null);
  }
  
  public KubeControllerManagerSpecObservedConfigNested<A> withNewKubeControllerManagerSpecObservedConfigLike(KubeControllerManagerSpec item) {
    return new KubeControllerManagerSpecObservedConfigNested(item);
  }
  
  public StaticIPAMDNSObservedConfigNested<A> withNewStaticIPAMDNSObservedConfig() {
    return new StaticIPAMDNSObservedConfigNested(null);
  }
  
  public StaticIPAMDNSObservedConfigNested<A> withNewStaticIPAMDNSObservedConfigLike(StaticIPAMDNS item) {
    return new StaticIPAMDNSObservedConfigNested(item);
  }
  
  public StorageSpecObservedConfigNested<A> withNewStorageSpecObservedConfig() {
    return new StorageSpecObservedConfigNested(null);
  }
  
  public StorageSpecObservedConfigNested<A> withNewStorageSpecObservedConfigLike(StorageSpec item) {
    return new StorageSpecObservedConfigNested(item);
  }
  
  public NodePlacementObservedConfigNested<A> withNewNodePlacementObservedConfig() {
    return new NodePlacementObservedConfigNested(null);
  }
  
  public NodePlacementObservedConfigNested<A> withNewNodePlacementObservedConfigLike(NodePlacement item) {
    return new NodePlacementObservedConfigNested(item);
  }
  
  public NetworkSpecObservedConfigNested<A> withNewNetworkSpecObservedConfig() {
    return new NetworkSpecObservedConfigNested(null);
  }
  
  public NetworkSpecObservedConfigNested<A> withNewNetworkSpecObservedConfigLike(NetworkSpec item) {
    return new NetworkSpecObservedConfigNested(item);
  }
  
  public ConsoleStatusObservedConfigNested<A> withNewConsoleStatusObservedConfig() {
    return new ConsoleStatusObservedConfigNested(null);
  }
  
  public ConsoleStatusObservedConfigNested<A> withNewConsoleStatusObservedConfigLike(ConsoleStatus item) {
    return new ConsoleStatusObservedConfigNested(item);
  }
  
  public ObjectReferenceObservedConfigNested<A> withNewObjectReferenceObservedConfig() {
    return new ObjectReferenceObservedConfigNested(null);
  }
  
  public ObjectReferenceObservedConfigNested<A> withNewObjectReferenceObservedConfigLike(ObjectReference item) {
    return new ObjectReferenceObservedConfigNested(item);
  }
  
  public ServerObservedConfigNested<A> withNewServerObservedConfig() {
    return new ServerObservedConfigNested(null);
  }
  
  public ServerObservedConfigNested<A> withNewServerObservedConfigLike(Server item) {
    return new ServerObservedConfigNested(item);
  }
  
  public CloudCredentialSpecObservedConfigNested<A> withNewCloudCredentialSpecObservedConfig() {
    return new CloudCredentialSpecObservedConfigNested(null);
  }
  
  public CloudCredentialSpecObservedConfigNested<A> withNewCloudCredentialSpecObservedConfigLike(CloudCredentialSpec item) {
    return new CloudCredentialSpecObservedConfigNested(item);
  }
  
  public DNSRecordStatusObservedConfigNested<A> withNewDNSRecordStatusObservedConfig() {
    return new DNSRecordStatusObservedConfigNested(null);
  }
  
  public DNSRecordStatusObservedConfigNested<A> withNewDNSRecordStatusObservedConfigLike(DNSRecordStatus item) {
    return new DNSRecordStatusObservedConfigNested(item);
  }
  
  public ClusterNetworkEntryObservedConfigNested<A> withNewClusterNetworkEntryObservedConfig() {
    return new ClusterNetworkEntryObservedConfigNested(null);
  }
  
  public ClusterNetworkEntryObservedConfigNested<A> withNewClusterNetworkEntryObservedConfigLike(ClusterNetworkEntry item) {
    return new ClusterNetworkEntryObservedConfigNested(item);
  }
  
  public A withNewClusterNetworkEntryObservedConfig(String cidr,Integer hostPrefix) {
    return (A)withObservedConfig(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  
  public HTTPCompressionPolicyObservedConfigNested<A> withNewHTTPCompressionPolicyObservedConfig() {
    return new HTTPCompressionPolicyObservedConfigNested(null);
  }
  
  public HTTPCompressionPolicyObservedConfigNested<A> withNewHTTPCompressionPolicyObservedConfigLike(HTTPCompressionPolicy item) {
    return new HTTPCompressionPolicyObservedConfigNested(item);
  }
  
  public NetFlowConfigObservedNested<A> withNewNetFlowConfigObserved() {
    return new NetFlowConfigObservedNested(null);
  }
  
  public NetFlowConfigObservedNested<A> withNewNetFlowConfigObservedLike(NetFlowConfig item) {
    return new NetFlowConfigObservedNested(item);
  }
  
  public ProjectAccessObservedConfigNested<A> withNewProjectAccessObservedConfig() {
    return new ProjectAccessObservedConfigNested(null);
  }
  
  public ProjectAccessObservedConfigNested<A> withNewProjectAccessObservedConfigLike(ProjectAccess item) {
    return new ProjectAccessObservedConfigNested(item);
  }
  
  public GatewayConfigObservedNested<A> withNewGatewayConfigObserved() {
    return new GatewayConfigObservedNested(null);
  }
  
  public GatewayConfigObservedNested<A> withNewGatewayConfigObservedLike(GatewayConfig item) {
    return new GatewayConfigObservedNested(item);
  }
  
  public A withNewGatewayConfigObserved(String ipForwarding,Boolean routingViaHost) {
    return (A)withObservedConfig(new GatewayConfig(ipForwarding, routingViaHost));
  }
  
  public PolicyAuditConfigObservedNested<A> withNewPolicyAuditConfigObserved() {
    return new PolicyAuditConfigObservedNested(null);
  }
  
  public PolicyAuditConfigObservedNested<A> withNewPolicyAuditConfigObservedLike(PolicyAuditConfig item) {
    return new PolicyAuditConfigObservedNested(item);
  }
  
  public A withNewPolicyAuditConfigObserved(String destination,Integer maxFileSize,Integer maxLogFiles,Integer rateLimit,String syslogFacility) {
    return (A)withObservedConfig(new PolicyAuditConfig(destination, maxFileSize, maxLogFiles, rateLimit, syslogFacility));
  }
  
  public PerspectiveVisibilityObservedConfigNested<A> withNewPerspectiveVisibilityObservedConfig() {
    return new PerspectiveVisibilityObservedConfigNested(null);
  }
  
  public PerspectiveVisibilityObservedConfigNested<A> withNewPerspectiveVisibilityObservedConfigLike(PerspectiveVisibility item) {
    return new PerspectiveVisibilityObservedConfigNested(item);
  }
  
  public StaticIPAMAddressesObservedConfigNested<A> withNewStaticIPAMAddressesObservedConfig() {
    return new StaticIPAMAddressesObservedConfigNested(null);
  }
  
  public StaticIPAMAddressesObservedConfigNested<A> withNewStaticIPAMAddressesObservedConfigLike(StaticIPAMAddresses item) {
    return new StaticIPAMAddressesObservedConfigNested(item);
  }
  
  public A withNewStaticIPAMAddressesObservedConfig(String address,String gateway) {
    return (A)withObservedConfig(new StaticIPAMAddresses(address, gateway));
  }
  
  public DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new DNSRecordObservedConfigNested(null);
  }
  
  public DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new DNSRecordObservedConfigNested(item);
  }
  
  public OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new OpenShiftAPIServerObservedConfigNested(null);
  }
  
  public OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new OpenShiftAPIServerObservedConfigNested(item);
  }
  
  public ConsoleSpecObservedConfigNested<A> withNewConsoleSpecObservedConfig() {
    return new ConsoleSpecObservedConfigNested(null);
  }
  
  public ConsoleSpecObservedConfigNested<A> withNewConsoleSpecObservedConfigLike(ConsoleSpec item) {
    return new ConsoleSpecObservedConfigNested(item);
  }
  
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel = operatorLogLevel;
    return (A) this;
  }
  
  public boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  public KubernetesResource buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null ? this.unsupportedConfigOverrides.build() : null;
  }
  
  public A withUnsupportedConfigOverrides(KubernetesResource unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides == null) {
        this.unsupportedConfigOverrides = null;
        this._visitables.remove("unsupportedConfigOverrides");
        return (A) this;
    } else {
        VisitableBuilder<? extends KubernetesResource,?> builder = builder(unsupportedConfigOverrides);;
        this._visitables.clear();
        this._visitables.get("unsupportedConfigOverrides").add(builder);
        this.unsupportedConfigOverrides = builder;
        return (A) this;
    }
  }
  
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  
  public ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverridesLike(ServiceCatalogAPIServerList item) {
    return new ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(item);
  }
  
  public PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(null);
  }
  
  public PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckStatus item) {
    return new PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new ImagePrunerUnsupportedConfigOverridesNested(null);
  }
  
  public ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new ImagePrunerUnsupportedConfigOverridesNested(item);
  }
  
  public KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new KubeControllerManagerUnsupportedConfigOverridesNested(null);
  }
  
  public KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new KubeControllerManagerUnsupportedConfigOverridesNested(item);
  }
  
  public PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverrides() {
    return new PodTemplateSpecUnsupportedConfigOverridesNested(null);
  }
  
  public PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverridesLike(PodTemplateSpec item) {
    return new PodTemplateSpecUnsupportedConfigOverridesNested(item);
  }
  
  public KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverrides() {
    return new KubeControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverridesLike(KubeControllerManagerStatus item) {
    return new KubeControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverrides() {
    return new CSISnapshotControllerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverridesLike(CSISnapshotControllerStatus item) {
    return new CSISnapshotControllerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverrides() {
    return new IPsecConfigUnsupportedOverridesNested(null);
  }
  
  public IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverridesLike(IPsecConfig item) {
    return new IPsecConfigUnsupportedOverridesNested(item);
  }
  
  public ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicyUnsupportedConfigOverridesNested(null);
  }
  
  public ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyUnsupportedConfigOverridesNested(item);
  }
  
  public ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverrides() {
    return new ResourceRequirementsUnsupportedConfigOverridesNested(null);
  }
  
  public ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverridesLike(ResourceRequirements item) {
    return new ResourceRequirementsUnsupportedConfigOverridesNested(item);
  }
  
  public KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(null);
  }
  
  public KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverridesLike(KubeStorageVersionMigratorSpec item) {
    return new KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverrides() {
    return new OpenShiftSDNConfigUnsupportedOverridesNested(null);
  }
  
  public OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverridesLike(OpenShiftSDNConfig item) {
    return new OpenShiftSDNConfigUnsupportedOverridesNested(item);
  }
  
  public A withNewOpenShiftSDNConfigUnsupportedOverrides(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withUnsupportedConfigOverrides(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  
  public IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverrides() {
    return new ConsoleListUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverridesLike(ConsoleList item) {
    return new ConsoleListUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<A> withNewServiceAccountIssuerStatusUnsupportedConfigOverrides() {
    return new ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<A> withNewServiceAccountIssuerStatusUnsupportedConfigOverridesLike(ServiceAccountIssuerStatus item) {
    return new ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewServiceAccountIssuerStatusUnsupportedConfigOverrides(String expirationTime,String name) {
    return (A)withUnsupportedConfigOverrides(new ServiceAccountIssuerStatus(expirationTime, name));
  }
  
  public DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(null);
  }
  
  public DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategory item) {
    return new DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(item);
  }
  
  public ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverrides() {
    return new ExportNetworkFlowsUnsupportedConfigOverridesNested(null);
  }
  
  public ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverridesLike(ExportNetworkFlows item) {
    return new ExportNetworkFlowsUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverridesLike(OpenShiftControllerManagerSpec item) {
    return new OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverrides() {
    return new ClusterCSIDriverSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverridesLike(ClusterCSIDriverSpec item) {
    return new ClusterCSIDriverSpecUnsupportedConfigOverridesNested(item);
  }
  
  public RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverrides() {
    return new RepositoryDigestMirrorsUnsupportedConfigOverridesNested(null);
  }
  
  public RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverridesLike(RepositoryDigestMirrors item) {
    return new RepositoryDigestMirrorsUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverrides() {
    return new ConsoleCustomizationUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverridesLike(ConsoleCustomization item) {
    return new ConsoleCustomizationUnsupportedConfigOverridesNested(item);
  }
  
  public CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverrides() {
    return new CSISnapshotControllerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverridesLike(CSISnapshotControllerSpec item) {
    return new CSISnapshotControllerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverrides() {
    return new UpstreamResolversUnsupportedConfigOverridesNested(null);
  }
  
  public UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverridesLike(UpstreamResolvers item) {
    return new UpstreamResolversUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
    return new IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(String format,String name) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  
  public MTUMigrationValuesUnsupportedConfigOverridesNested<A> withNewMTUMigrationValuesUnsupportedConfigOverrides() {
    return new MTUMigrationValuesUnsupportedConfigOverridesNested(null);
  }
  
  public MTUMigrationValuesUnsupportedConfigOverridesNested<A> withNewMTUMigrationValuesUnsupportedConfigOverridesLike(MTUMigrationValues item) {
    return new MTUMigrationValuesUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewMTUMigrationValuesUnsupportedConfigOverrides(Integer from,Integer to) {
    return (A)withUnsupportedConfigOverrides(new MTUMigrationValues(from, to));
  }
  
  public ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverrides() {
    return new ConfigStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverridesLike(ConfigStatus item) {
    return new ConfigStatusUnsupportedConfigOverridesNested(item);
  }
  
  public VSphereCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewVSphereCSIDriverConfigSpecUnsupportedOverrides() {
    return new VSphereCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  
  public VSphereCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewVSphereCSIDriverConfigSpecUnsupportedOverridesLike(VSphereCSIDriverConfigSpec item) {
    return new VSphereCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  
  public ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new ServiceCAUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new ServiceCAUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerSpec item) {
    return new ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverrides() {
    return new IngressControllerListUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverridesLike(IngressControllerList item) {
    return new IngressControllerListUnsupportedConfigOverridesNested(item);
  }
  
  public DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverrides() {
    return new DNSListUnsupportedConfigOverridesNested(null);
  }
  
  public DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverridesLike(DNSList item) {
    return new DNSListUnsupportedConfigOverridesNested(item);
  }
  
  public KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverrides() {
    return new KubeAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverridesLike(KubeAPIServerStatus item) {
    return new KubeAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverridesLike(AWSClassicLoadBalancerParameters item) {
    return new AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new KubeAPIServerUnsupportedConfigOverridesNested(null);
  }
  
  public KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new KubeAPIServerUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverrides() {
    return new ConsoleConfigRouteUnsupportedOverridesNested(null);
  }
  
  public ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverridesLike(ConsoleConfigRoute item) {
    return new ConsoleConfigRouteUnsupportedOverridesNested(item);
  }
  
  public IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new IngressControllerUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new IngressControllerUnsupportedConfigOverridesNested(item);
  }
  
  public CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverrides() {
    return new CloudCredentialStatusUnsupportedConfigOverridesNested(null);
  }
  
  public CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverridesLike(CloudCredentialStatus item) {
    return new CloudCredentialStatusUnsupportedConfigOverridesNested(item);
  }
  
  public KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorUnsupportedConfigOverridesNested(null);
  }
  
  public KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new KubeStorageVersionMigratorUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverrides() {
    return new IngressControllerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverridesLike(IngressControllerStatus item) {
    return new IngressControllerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerStatus item) {
    return new ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverrides() {
    return new ImagePrunerListUnsupportedConfigOverridesNested(null);
  }
  
  public ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverridesLike(ImagePrunerList item) {
    return new ImagePrunerListUnsupportedConfigOverridesNested(item);
  }
  
  public LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverrides() {
    return new LocalObjectReferenceUnsupportedConfigOverridesNested(null);
  }
  
  public LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverridesLike(LocalObjectReference item) {
    return new LocalObjectReferenceUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewLocalObjectReferenceUnsupportedConfigOverrides(String name) {
    return (A)withUnsupportedConfigOverrides(new LocalObjectReference(name));
  }
  
  public ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(null);
  }
  
  public ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverridesLike(ContainerLoggingDestinationParameters item) {
    return new ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides(Integer maxLength) {
    return (A)withUnsupportedConfigOverrides(new ContainerLoggingDestinationParameters(maxLength));
  }
  
  public KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverrides() {
    return new KubeAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverridesLike(KubeAPIServerSpec item) {
    return new KubeAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverrides() {
    return new KubeSchedulerListUnsupportedConfigOverridesNested(null);
  }
  
  public KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverridesLike(KubeSchedulerList item) {
    return new KubeSchedulerListUnsupportedConfigOverridesNested(item);
  }
  
  public StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverrides() {
    return new StaticIPAMRoutesUnsupportedConfigOverridesNested(null);
  }
  
  public StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverridesLike(StaticIPAMRoutes item) {
    return new StaticIPAMRoutesUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewStaticIPAMRoutesUnsupportedConfigOverrides(String destination,String gateway) {
    return (A)withUnsupportedConfigOverrides(new StaticIPAMRoutes(destination, gateway));
  }
  
  public OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new OpenShiftControllerManagerUnsupportedConfigOverridesNested(item);
  }
  
  public EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverrides() {
    return new EndpointPublishingStrategyUnsupportedConfigOverridesNested(null);
  }
  
  public EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverridesLike(EndpointPublishingStrategy item) {
    return new EndpointPublishingStrategyUnsupportedConfigOverridesNested(item);
  }
  
  public CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new CloudCredentialUnsupportedConfigOverridesNested(null);
  }
  
  public CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new CloudCredentialUnsupportedConfigOverridesNested(item);
  }
  
  public KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new KubeSchedulerUnsupportedConfigOverridesNested(null);
  }
  
  public KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new KubeSchedulerUnsupportedConfigOverridesNested(item);
  }
  
  public ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverrides() {
    return new ClusterCSIDriverStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverridesLike(ClusterCSIDriverStatus item) {
    return new ClusterCSIDriverStatusUnsupportedConfigOverridesNested(item);
  }
  
  public SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverrides() {
    return new SFlowConfigUnsupportedOverridesNested(null);
  }
  
  public SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverridesLike(SFlowConfig item) {
    return new SFlowConfigUnsupportedOverridesNested(item);
  }
  
  public ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverrides() {
    return new ForwardPluginUnsupportedConfigOverridesNested(null);
  }
  
  public ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverridesLike(ForwardPlugin item) {
    return new ForwardPluginUnsupportedConfigOverridesNested(item);
  }
  
  public LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverrides() {
    return new LogEntryUnsupportedConfigOverridesNested(null);
  }
  
  public LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverridesLike(LogEntry item) {
    return new LogEntryUnsupportedConfigOverridesNested(item);
  }
  
  public AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
    return new AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(null);
  }
  
  public AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverridesLike(AdditionalNetworkDefinition item) {
    return new AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(item);
  }
  
  public AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverrides() {
    return new AuthenticationStatusUnsupportedConfigOverridesNested(null);
  }
  
  public AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverridesLike(AuthenticationStatus item) {
    return new AuthenticationStatusUnsupportedConfigOverridesNested(item);
  }
  
  public NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverrides() {
    return new NodePortStrategyUnsupportedConfigOverridesNested(null);
  }
  
  public NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverridesLike(NodePortStrategy item) {
    return new NodePortStrategyUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewNodePortStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new NodePortStrategy(protocol));
  }
  
  public NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new NetworkUnsupportedConfigOverridesNested(null);
  }
  
  public NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new NetworkUnsupportedConfigOverridesNested(item);
  }
  
  public ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverrides() {
    return new ClientTLSUnsupportedConfigOverridesNested(null);
  }
  
  public ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverridesLike(ClientTLS item) {
    return new ClientTLSUnsupportedConfigOverridesNested(item);
  }
  
  public ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverrides() {
    return new ImagePrunerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverridesLike(ImagePrunerStatus item) {
    return new ImagePrunerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverrides() {
    return new UpstreamUnsupportedConfigOverridesNested(null);
  }
  
  public UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverridesLike(Upstream item) {
    return new UpstreamUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewUpstreamUnsupportedConfigOverrides(String address,Integer port,String type) {
    return (A)withUnsupportedConfigOverrides(new Upstream(address, port, type));
  }
  
  public AzureDiskEncryptionSetUnsupportedConfigOverridesNested<A> withNewAzureDiskEncryptionSetUnsupportedConfigOverrides() {
    return new AzureDiskEncryptionSetUnsupportedConfigOverridesNested(null);
  }
  
  public AzureDiskEncryptionSetUnsupportedConfigOverridesNested<A> withNewAzureDiskEncryptionSetUnsupportedConfigOverridesLike(AzureDiskEncryptionSet item) {
    return new AzureDiskEncryptionSetUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewAzureDiskEncryptionSetUnsupportedConfigOverrides(String name,String resourceGroup,String subscriptionID) {
    return (A)withUnsupportedConfigOverrides(new AzureDiskEncryptionSet(name, resourceGroup, subscriptionID));
  }
  
  public ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new ServiceCatalogAPIServerUnsupportedConfigOverridesNested(item);
  }
  
  public CSIDriverConfigSpecUnsupportedOverridesNested<A> withNewCSIDriverConfigSpecUnsupportedOverrides() {
    return new CSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  
  public CSIDriverConfigSpecUnsupportedOverridesNested<A> withNewCSIDriverConfigSpecUnsupportedOverridesLike(CSIDriverConfigSpec item) {
    return new CSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  
  public IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeader item) {
    return new IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(Integer maxLength,String name) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  
  public NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverrides() {
    return new NetworkMigrationUnsupportedConfigOverridesNested(null);
  }
  
  public NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverridesLike(NetworkMigration item) {
    return new NetworkMigrationUnsupportedConfigOverridesNested(item);
  }
  
  public DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverrides() {
    return new DNSRecordListUnsupportedConfigOverridesNested(null);
  }
  
  public DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverridesLike(DNSRecordList item) {
    return new DNSRecordListUnsupportedConfigOverridesNested(item);
  }
  
  public RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverrides() {
    return new RawExtensionUnsupportedConfigOverridesNested(null);
  }
  
  public RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverridesLike(RawExtension item) {
    return new RawExtensionUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewRawExtensionUnsupportedConfigOverrides(Object value) {
    return (A)withUnsupportedConfigOverrides(new RawExtension(value));
  }
  
  public EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverrides() {
    return new EtcdSpecUnsupportedConfigOverridesNested(null);
  }
  
  public EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverridesLike(EtcdSpec item) {
    return new EtcdSpecUnsupportedConfigOverridesNested(item);
  }
  
  public PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(null);
  }
  
  public PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(item);
  }
  
  public LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverrides() {
    return new LoadBalancerStrategyUnsupportedConfigOverridesNested(null);
  }
  
  public LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverridesLike(LoadBalancerStrategy item) {
    return new LoadBalancerStrategyUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverridesLike(OpenShiftAPIServerStatus item) {
    return new OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public DNSOverTLSConfigUnsupportedOverridesNested<A> withNewDNSOverTLSConfigUnsupportedOverrides() {
    return new DNSOverTLSConfigUnsupportedOverridesNested(null);
  }
  
  public DNSOverTLSConfigUnsupportedOverridesNested<A> withNewDNSOverTLSConfigUnsupportedOverridesLike(DNSOverTLSConfig item) {
    return new DNSOverTLSConfigUnsupportedOverridesNested(item);
  }
  
  public CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverrides() {
    return new CloudCredentialListUnsupportedConfigOverridesNested(null);
  }
  
  public CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverridesLike(CloudCredentialList item) {
    return new CloudCredentialListUnsupportedConfigOverridesNested(item);
  }
  
  public DNSCacheUnsupportedConfigOverridesNested<A> withNewDNSCacheUnsupportedConfigOverrides() {
    return new DNSCacheUnsupportedConfigOverridesNested(null);
  }
  
  public DNSCacheUnsupportedConfigOverridesNested<A> withNewDNSCacheUnsupportedConfigOverridesLike(DNSCache item) {
    return new DNSCacheUnsupportedConfigOverridesNested(item);
  }
  
  public ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverrides() {
    return new ImagePrunerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverridesLike(ImagePrunerSpec item) {
    return new ImagePrunerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverrides() {
    return new ConfigListUnsupportedConfigOverridesNested(null);
  }
  
  public ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverridesLike(ConfigList item) {
    return new ConfigListUnsupportedConfigOverridesNested(item);
  }
  
  public AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverrides() {
    return new AuthenticationListUnsupportedConfigOverridesNested(null);
  }
  
  public AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverridesLike(AuthenticationList item) {
    return new AuthenticationListUnsupportedConfigOverridesNested(item);
  }
  
  public PinnedResourceReferenceUnsupportedConfigOverridesNested<A> withNewPinnedResourceReferenceUnsupportedConfigOverrides() {
    return new PinnedResourceReferenceUnsupportedConfigOverridesNested(null);
  }
  
  public PinnedResourceReferenceUnsupportedConfigOverridesNested<A> withNewPinnedResourceReferenceUnsupportedConfigOverridesLike(PinnedResourceReference item) {
    return new PinnedResourceReferenceUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewPinnedResourceReferenceUnsupportedConfigOverrides(String group,String resource,String version) {
    return (A)withUnsupportedConfigOverrides(new PinnedResourceReference(group, resource, version));
  }
  
  public KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverrides() {
    return new KubeControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  
  public KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverridesLike(KubeControllerManagerList item) {
    return new KubeControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  
  public IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverrides() {
    return new IPAMConfigUnsupportedOverridesNested(null);
  }
  
  public IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverridesLike(IPAMConfig item) {
    return new IPAMConfigUnsupportedOverridesNested(item);
  }
  
  public ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverrides() {
    return new ContainerUnsupportedConfigOverridesNested(null);
  }
  
  public ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverridesLike(Container item) {
    return new ContainerUnsupportedConfigOverridesNested(item);
  }
  
  public IBMLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewIBMLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IBMLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public IBMLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewIBMLoadBalancerParametersUnsupportedConfigOverridesLike(IBMLoadBalancerParameters item) {
    return new IBMLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewIBMLoadBalancerParametersUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new IBMLoadBalancerParameters(protocol));
  }
  
  public AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverrides() {
    return new AccessLoggingUnsupportedConfigOverridesNested(null);
  }
  
  public AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverridesLike(AccessLogging item) {
    return new AccessLoggingUnsupportedConfigOverridesNested(item);
  }
  
  public HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverrides() {
    return new HostNetworkStrategyUnsupportedConfigOverridesNested(null);
  }
  
  public HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverridesLike(HostNetworkStrategy item) {
    return new HostNetworkStrategyUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewHostNetworkStrategyUnsupportedConfigOverrides(Integer httpPort,Integer httpsPort,String protocol,Integer statsPort) {
    return (A)withUnsupportedConfigOverrides(new HostNetworkStrategy(httpPort, httpsPort, protocol, statsPort));
  }
  
  public KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverrides() {
    return new KubeSchedulerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverridesLike(KubeSchedulerSpec item) {
    return new KubeSchedulerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicyListUnsupportedConfigOverridesNested(null);
  }
  
  public ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverridesLike(ImageContentSourcePolicyList item) {
    return new ImageContentSourcePolicyListUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverridesLike(OpenShiftControllerManagerStatus item) {
    return new OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverridesLike(ServiceCatalogAPIServerStatus item) {
    return new ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverrides() {
    return new DNSNodePlacementUnsupportedConfigOverridesNested(null);
  }
  
  public DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverridesLike(DNSNodePlacement item) {
    return new DNSNodePlacementUnsupportedConfigOverridesNested(item);
  }
  
  public NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverrides() {
    return new NetworkListUnsupportedConfigOverridesNested(null);
  }
  
  public NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverridesLike(NetworkList item) {
    return new NetworkListUnsupportedConfigOverridesNested(item);
  }
  
  public ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverrides() {
    return new ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverridesLike(ProviderLoadBalancerParameters item) {
    return new ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<A> withNewResourceAttributesAccessReviewUnsupportedConfigOverrides() {
    return new ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(null);
  }
  
  public ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<A> withNewResourceAttributesAccessReviewUnsupportedConfigOverridesLike(ResourceAttributesAccessReview item) {
    return new ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverrides() {
    return new ServiceCASpecUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverridesLike(ServiceCASpec item) {
    return new ServiceCASpecUnsupportedConfigOverridesNested(item);
  }
  
  public PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverrides() {
    return new PrivateStrategyUnsupportedConfigOverridesNested(null);
  }
  
  public PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverridesLike(PrivateStrategy item) {
    return new PrivateStrategyUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewPrivateStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new PrivateStrategy(protocol));
  }
  
  public PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(null);
  }
  
  public PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckList item) {
    return new PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerListUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverridesLike(OpenShiftAPIServerList item) {
    return new OpenShiftAPIServerListUnsupportedConfigOverridesNested(item);
  }
  
  public OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverrides() {
    return new OAuthAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverridesLike(OAuthAPIServerStatus item) {
    return new OAuthAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewOAuthAPIServerStatusUnsupportedConfigOverrides(Integer latestAvailableRevision) {
    return (A)withUnsupportedConfigOverrides(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  
  public GCPCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewGCPCSIDriverConfigSpecUnsupportedOverrides() {
    return new GCPCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  
  public GCPCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewGCPCSIDriverConfigSpecUnsupportedOverridesLike(GCPCSIDriverConfigSpec item) {
    return new GCPCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  
  public ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPCookie item) {
    return new IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  
  public DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new DNSUnsupportedConfigOverridesNested(null);
  }
  
  public DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new DNSUnsupportedConfigOverridesNested(item);
  }
  
  public AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverrides() {
    return new AddPageUnsupportedConfigOverridesNested(null);
  }
  
  public AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverridesLike(AddPage item) {
    return new AddPageUnsupportedConfigOverridesNested(item);
  }
  
  public AzureCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAzureCSIDriverConfigSpecUnsupportedOverrides() {
    return new AzureCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  
  public AzureCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAzureCSIDriverConfigSpecUnsupportedOverridesLike(AzureCSIDriverConfigSpec item) {
    return new AzureCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  
  public StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverrides() {
    return new StorageListUnsupportedConfigOverridesNested(null);
  }
  
  public StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverridesLike(StorageList item) {
    return new StorageListUnsupportedConfigOverridesNested(item);
  }
  
  public AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new AuthenticationUnsupportedConfigOverridesNested(null);
  }
  
  public AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new AuthenticationUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverrides() {
    return new ServiceCAStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverridesLike(ServiceCAStatus item) {
    return new ServiceCAStatusUnsupportedConfigOverridesNested(item);
  }
  
  public MTUMigrationUnsupportedConfigOverridesNested<A> withNewMTUMigrationUnsupportedConfigOverrides() {
    return new MTUMigrationUnsupportedConfigOverridesNested(null);
  }
  
  public MTUMigrationUnsupportedConfigOverridesNested<A> withNewMTUMigrationUnsupportedConfigOverridesLike(MTUMigration item) {
    return new MTUMigrationUnsupportedConfigOverridesNested(item);
  }
  
  public PerspectiveUnsupportedConfigOverridesNested<A> withNewPerspectiveUnsupportedConfigOverrides() {
    return new PerspectiveUnsupportedConfigOverridesNested(null);
  }
  
  public PerspectiveUnsupportedConfigOverridesNested<A> withNewPerspectiveUnsupportedConfigOverridesLike(Perspective item) {
    return new PerspectiveUnsupportedConfigOverridesNested(item);
  }
  
  public LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverrides() {
    return new LabelSelectorUnsupportedConfigOverridesNested(null);
  }
  
  public LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverridesLike(LabelSelector item) {
    return new LabelSelectorUnsupportedConfigOverridesNested(item);
  }
  
  public KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(null);
  }
  
  public KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverridesLike(KubeStorageVersionMigratorList item) {
    return new KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(item);
  }
  
  public StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new StorageUnsupportedConfigOverridesNested(null);
  }
  
  public StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new StorageUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerList item) {
    return new ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  
  public DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(null);
  }
  
  public DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(item);
  }
  
  public OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverrides() {
    return new OVNKubernetesConfigUnsupportedOverridesNested(null);
  }
  
  public OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverridesLike(OVNKubernetesConfig item) {
    return new OVNKubernetesConfigUnsupportedOverridesNested(item);
  }
  
  public DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverrides() {
    return new DNSSpecUnsupportedConfigOverridesNested(null);
  }
  
  public DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverridesLike(DNSSpec item) {
    return new DNSSpecUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverridesLike(IngressControllerSpec item) {
    return new IngressControllerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverrides() {
    return new OperatorConditionUnsupportedConfigOverridesNested(null);
  }
  
  public OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverridesLike(OperatorCondition item) {
    return new OperatorConditionUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewOperatorConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverrides() {
    return new ProxyConfigUnsupportedOverridesNested(null);
  }
  
  public ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverridesLike(ProxyConfig item) {
    return new ProxyConfigUnsupportedOverridesNested(item);
  }
  
  public KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverrides() {
    return new KuryrConfigUnsupportedOverridesNested(null);
  }
  
  public KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverridesLike(KuryrConfig item) {
    return new KuryrConfigUnsupportedOverridesNested(item);
  }
  
  public ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverridesLike(ServiceCatalogAPIServerSpec item) {
    return new ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(null);
  }
  
  public ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverridesLike(ImageContentSourcePolicySpec item) {
    return new ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(item);
  }
  
  public DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverrides() {
    return new DNSStatusUnsupportedConfigOverridesNested(null);
  }
  
  public DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverridesLike(DNSStatus item) {
    return new DNSStatusUnsupportedConfigOverridesNested(item);
  }
  
  public DNSTransportConfigUnsupportedOverridesNested<A> withNewDNSTransportConfigUnsupportedOverrides() {
    return new DNSTransportConfigUnsupportedOverridesNested(null);
  }
  
  public DNSTransportConfigUnsupportedOverridesNested<A> withNewDNSTransportConfigUnsupportedOverridesLike(DNSTransportConfig item) {
    return new DNSTransportConfigUnsupportedOverridesNested(item);
  }
  
  public GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverrides() {
    return new GCPLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverridesLike(GCPLoadBalancerParameters item) {
    return new GCPLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewGCPLoadBalancerParametersUnsupportedConfigOverrides(String clientAccess) {
    return (A)withUnsupportedConfigOverrides(new GCPLoadBalancerParameters(clientAccess));
  }
  
  public KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverrides() {
    return new KubeAPIServerListUnsupportedConfigOverridesNested(null);
  }
  
  public KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverridesLike(KubeAPIServerList item) {
    return new KubeAPIServerListUnsupportedConfigOverridesNested(item);
  }
  
  public ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new ConfigUnsupportedConfigOverridesNested(null);
  }
  
  public ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new ConfigUnsupportedConfigOverridesNested(item);
  }
  
  public ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverrides() {
    return new ObjectMetaUnsupportedConfigOverridesNested(null);
  }
  
  public ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverridesLike(ObjectMeta item) {
    return new ObjectMetaUnsupportedConfigOverridesNested(item);
  }
  
  public ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverrides() {
    return new ClusterCSIDriverListUnsupportedConfigOverridesNested(null);
  }
  
  public ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverridesLike(ClusterCSIDriverList item) {
    return new ClusterCSIDriverListUnsupportedConfigOverridesNested(item);
  }
  
  public SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverrides() {
    return new SimpleMacvlanConfigUnsupportedOverridesNested(null);
  }
  
  public SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverridesLike(SimpleMacvlanConfig item) {
    return new SimpleMacvlanConfigUnsupportedOverridesNested(item);
  }
  
  public PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new PersistentVolumeClaimUnsupportedConfigOverridesNested(null);
  }
  
  public PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimUnsupportedConfigOverridesNested(item);
  }
  
  public GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverrides() {
    return new GenericKubernetesResourceUnsupportedConfigOverridesNested(null);
  }
  
  public GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverridesLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceUnsupportedConfigOverridesNested(item);
  }
  
  public EgressIPConfigUnsupportedOverridesNested<A> withNewEgressIPConfigUnsupportedOverrides() {
    return new EgressIPConfigUnsupportedOverridesNested(null);
  }
  
  public EgressIPConfigUnsupportedOverridesNested<A> withNewEgressIPConfigUnsupportedOverridesLike(EgressIPConfig item) {
    return new EgressIPConfigUnsupportedOverridesNested(item);
  }
  
  public A withNewEgressIPConfigUnsupportedOverrides(Integer reachabilityTotalTimeoutSeconds) {
    return (A)withUnsupportedConfigOverrides(new EgressIPConfig(reachabilityTotalTimeoutSeconds));
  }
  
  public HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverrides() {
    return new HybridOverlayConfigUnsupportedOverridesNested(null);
  }
  
  public HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverridesLike(HybridOverlayConfig item) {
    return new HybridOverlayConfigUnsupportedOverridesNested(item);
  }
  
  public AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverridesLike(AWSLoadBalancerParameters item) {
    return new AWSLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverrides() {
    return new CSISnapshotControllerListUnsupportedConfigOverridesNested(null);
  }
  
  public CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverridesLike(CSISnapshotControllerList item) {
    return new CSISnapshotControllerListUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new ConsoleUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new ConsoleUnsupportedConfigOverridesNested(item);
  }
  
  public DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverrides() {
    return new DNSZoneConditionUnsupportedConfigOverridesNested(null);
  }
  
  public DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverridesLike(DNSZoneCondition item) {
    return new DNSZoneConditionUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewDNSZoneConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new ClusterCSIDriverUnsupportedConfigOverridesNested(null);
  }
  
  public ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new ClusterCSIDriverUnsupportedConfigOverridesNested(item);
  }
  
  public QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverrides() {
    return new QuickStartsUnsupportedConfigOverridesNested(null);
  }
  
  public QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverridesLike(QuickStarts item) {
    return new QuickStartsUnsupportedConfigOverridesNested(item);
  }
  
  public DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverrides() {
    return new DNSZoneStatusUnsupportedConfigOverridesNested(null);
  }
  
  public DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverridesLike(DNSZoneStatus item) {
    return new DNSZoneStatusUnsupportedConfigOverridesNested(item);
  }
  
  public OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverrides() {
    return new OutageEntryUnsupportedConfigOverridesNested(null);
  }
  
  public OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverridesLike(OutageEntry item) {
    return new OutageEntryUnsupportedConfigOverridesNested(item);
  }
  
  public ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverrides() {
    return new ConfigSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverridesLike(ConfigSpec item) {
    return new ConfigSpecUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverridesLike(OpenShiftControllerManagerList item) {
    return new OpenShiftControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  
  public EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new EtcdUnsupportedConfigOverridesNested(null);
  }
  
  public EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new EtcdUnsupportedConfigOverridesNested(item);
  }
  
  public IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverrides() {
    return new IPFIXConfigUnsupportedOverridesNested(null);
  }
  
  public IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverridesLike(IPFIXConfig item) {
    return new IPFIXConfigUnsupportedOverridesNested(item);
  }
  
  public NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverrides() {
    return new NetworkStatusUnsupportedConfigOverridesNested(null);
  }
  
  public NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverridesLike(NetworkStatus item) {
    return new NetworkStatusUnsupportedConfigOverridesNested(item);
  }
  
  public PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(null);
  }
  
  public PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckCondition item) {
    return new PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverrides() {
    return new NodeStatusUnsupportedConfigOverridesNested(null);
  }
  
  public NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverridesLike(NodeStatus item) {
    return new NodeStatusUnsupportedConfigOverridesNested(item);
  }
  
  public RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverrides() {
    return new RouteAdmissionPolicyUnsupportedConfigOverridesNested(null);
  }
  
  public RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverridesLike(RouteAdmissionPolicy item) {
    return new RouteAdmissionPolicyUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewRouteAdmissionPolicyUnsupportedConfigOverrides(String namespaceOwnership,String wildcardPolicy) {
    return (A)withUnsupportedConfigOverrides(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  
  public GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverrides() {
    return new GenerationStatusUnsupportedConfigOverridesNested(null);
  }
  
  public GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverridesLike(GenerationStatus item) {
    return new GenerationStatusUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeaders item) {
    return new IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(item);
  }
  
  public EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverrides() {
    return new EtcdListUnsupportedConfigOverridesNested(null);
  }
  
  public EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverridesLike(EtcdList item) {
    return new EtcdListUnsupportedConfigOverridesNested(item);
  }
  
  public FeaturesMigrationUnsupportedConfigOverridesNested<A> withNewFeaturesMigrationUnsupportedConfigOverrides() {
    return new FeaturesMigrationUnsupportedConfigOverridesNested(null);
  }
  
  public FeaturesMigrationUnsupportedConfigOverridesNested<A> withNewFeaturesMigrationUnsupportedConfigOverridesLike(FeaturesMigration item) {
    return new FeaturesMigrationUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewFeaturesMigrationUnsupportedConfigOverrides(Boolean egressFirewall,Boolean egressIP,Boolean multicast) {
    return (A)withUnsupportedConfigOverrides(new FeaturesMigration(egressFirewall, egressIP, multicast));
  }
  
  public DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverrides() {
    return new DefaultNetworkDefinitionUnsupportedConfigOverridesNested(null);
  }
  
  public DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverridesLike(DefaultNetworkDefinition item) {
    return new DefaultNetworkDefinitionUnsupportedConfigOverridesNested(item);
  }
  
  public GCPKMSKeyReferenceUnsupportedConfigOverridesNested<A> withNewGCPKMSKeyReferenceUnsupportedConfigOverrides() {
    return new GCPKMSKeyReferenceUnsupportedConfigOverridesNested(null);
  }
  
  public GCPKMSKeyReferenceUnsupportedConfigOverridesNested<A> withNewGCPKMSKeyReferenceUnsupportedConfigOverridesLike(GCPKMSKeyReference item) {
    return new GCPKMSKeyReferenceUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewGCPKMSKeyReferenceUnsupportedConfigOverrides(String keyRing,String location,String name,String projectID) {
    return (A)withUnsupportedConfigOverrides(new GCPKMSKeyReference(keyRing, location, name, projectID));
  }
  
  public OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverridesLike(OpenShiftAPIServerSpec item) {
    return new OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverrides() {
    return new KubeSchedulerStatusUnsupportedConfigOverridesNested(null);
  }
  
  public KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverridesLike(KubeSchedulerStatus item) {
    return new KubeSchedulerStatusUnsupportedConfigOverridesNested(item);
  }
  
  public SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(null);
  }
  
  public SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverridesLike(SyslogLoggingDestinationParameters item) {
    return new SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides(String address,String facility,Integer maxLength,Integer port) {
    return (A)withUnsupportedConfigOverrides(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  
  public AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  
  public AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverridesLike(AWSNetworkLoadBalancerParameters item) {
    return new AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  
  public ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverrides() {
    return new ServiceCAListUnsupportedConfigOverridesNested(null);
  }
  
  public ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverridesLike(ServiceCAList item) {
    return new ServiceCAListUnsupportedConfigOverridesNested(item);
  }
  
  public EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverrides() {
    return new EtcdStatusUnsupportedConfigOverridesNested(null);
  }
  
  public EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverridesLike(EtcdStatus item) {
    return new EtcdStatusUnsupportedConfigOverridesNested(item);
  }
  
  public StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverrides() {
    return new StatuspageProviderUnsupportedConfigOverridesNested(null);
  }
  
  public StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverridesLike(StatuspageProvider item) {
    return new StatuspageProviderUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewStatuspageProviderUnsupportedConfigOverrides(String pageID) {
    return (A)withUnsupportedConfigOverrides(new StatuspageProvider(pageID));
  }
  
  public KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(null);
  }
  
  public KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverridesLike(KubeStorageVersionMigratorStatus item) {
    return new KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverrides() {
    return new ConsoleProvidersUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverridesLike(ConsoleProviders item) {
    return new ConsoleProvidersUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverrides() {
    return new IngressControllerLoggingUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverridesLike(IngressControllerLogging item) {
    return new IngressControllerLoggingUnsupportedConfigOverridesNested(item);
  }
  
  public StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverrides() {
    return new StorageStatusUnsupportedConfigOverridesNested(null);
  }
  
  public StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverridesLike(StorageStatus item) {
    return new StorageStatusUnsupportedConfigOverridesNested(item);
  }
  
  public AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverrides() {
    return new AuthenticationSpecUnsupportedConfigOverridesNested(null);
  }
  
  public AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverridesLike(AuthenticationSpec item) {
    return new AuthenticationSpecUnsupportedConfigOverridesNested(item);
  }
  
  public PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(null);
  }
  
  public PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckSpec item) {
    return new PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(item);
  }
  
  public CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new CSISnapshotControllerUnsupportedConfigOverridesNested(null);
  }
  
  public CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new CSISnapshotControllerUnsupportedConfigOverridesNested(item);
  }
  
  public DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogTypesUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(null);
  }
  
  public DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogTypesUnsupportedConfigOverridesLike(DeveloperConsoleCatalogTypes item) {
    return new DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(item);
  }
  
  public DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverrides() {
    return new DNSRecordSpecUnsupportedConfigOverridesNested(null);
  }
  
  public DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverridesLike(DNSRecordSpec item) {
    return new DNSRecordSpecUnsupportedConfigOverridesNested(item);
  }
  
  public DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(null);
  }
  
  public DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCustomization item) {
    return new DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(item);
  }
  
  public LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverrides() {
    return new LoggingDestinationUnsupportedConfigOverridesNested(null);
  }
  
  public LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverridesLike(LoggingDestination item) {
    return new LoggingDestinationUnsupportedConfigOverridesNested(item);
  }
  
  public IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverrides() {
    return new IngressControllerTuningOptionsUnsupportedConfigOverridesNested(null);
  }
  
  public IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverridesLike(IngressControllerTuningOptions item) {
    return new IngressControllerTuningOptionsUnsupportedConfigOverridesNested(item);
  }
  
  public StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverrides() {
    return new StaticIPAMConfigUnsupportedOverridesNested(null);
  }
  
  public StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverridesLike(StaticIPAMConfig item) {
    return new StaticIPAMConfigUnsupportedOverridesNested(item);
  }
  
  public AWSCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAWSCSIDriverConfigSpecUnsupportedOverrides() {
    return new AWSCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  
  public AWSCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAWSCSIDriverConfigSpecUnsupportedOverridesLike(AWSCSIDriverConfigSpec item) {
    return new AWSCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  
  public A withNewAWSCSIDriverConfigSpecUnsupportedOverrides(String kmsKeyARN) {
    return (A)withUnsupportedConfigOverrides(new AWSCSIDriverConfigSpec(kmsKeyARN));
  }
  
  public KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverrides() {
    return new KubeControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  
  public KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverridesLike(KubeControllerManagerSpec item) {
    return new KubeControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  
  public StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverrides() {
    return new StaticIPAMDNSUnsupportedConfigOverridesNested(null);
  }
  
  public StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverridesLike(StaticIPAMDNS item) {
    return new StaticIPAMDNSUnsupportedConfigOverridesNested(item);
  }
  
  public StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverrides() {
    return new StorageSpecUnsupportedConfigOverridesNested(null);
  }
  
  public StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverridesLike(StorageSpec item) {
    return new StorageSpecUnsupportedConfigOverridesNested(item);
  }
  
  public NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverrides() {
    return new NodePlacementUnsupportedConfigOverridesNested(null);
  }
  
  public NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverridesLike(NodePlacement item) {
    return new NodePlacementUnsupportedConfigOverridesNested(item);
  }
  
  public NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverrides() {
    return new NetworkSpecUnsupportedConfigOverridesNested(null);
  }
  
  public NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverridesLike(NetworkSpec item) {
    return new NetworkSpecUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverrides() {
    return new ConsoleStatusUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverridesLike(ConsoleStatus item) {
    return new ConsoleStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverrides() {
    return new ObjectReferenceUnsupportedConfigOverridesNested(null);
  }
  
  public ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverridesLike(ObjectReference item) {
    return new ObjectReferenceUnsupportedConfigOverridesNested(item);
  }
  
  public ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverrides() {
    return new ServerUnsupportedConfigOverridesNested(null);
  }
  
  public ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverridesLike(Server item) {
    return new ServerUnsupportedConfigOverridesNested(item);
  }
  
  public CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverrides() {
    return new CloudCredentialSpecUnsupportedConfigOverridesNested(null);
  }
  
  public CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverridesLike(CloudCredentialSpec item) {
    return new CloudCredentialSpecUnsupportedConfigOverridesNested(item);
  }
  
  public DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverrides() {
    return new DNSRecordStatusUnsupportedConfigOverridesNested(null);
  }
  
  public DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverridesLike(DNSRecordStatus item) {
    return new DNSRecordStatusUnsupportedConfigOverridesNested(item);
  }
  
  public ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverrides() {
    return new ClusterNetworkEntryUnsupportedConfigOverridesNested(null);
  }
  
  public ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverridesLike(ClusterNetworkEntry item) {
    return new ClusterNetworkEntryUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewClusterNetworkEntryUnsupportedConfigOverrides(String cidr,Integer hostPrefix) {
    return (A)withUnsupportedConfigOverrides(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  
  public HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverrides() {
    return new HTTPCompressionPolicyUnsupportedConfigOverridesNested(null);
  }
  
  public HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverridesLike(HTTPCompressionPolicy item) {
    return new HTTPCompressionPolicyUnsupportedConfigOverridesNested(item);
  }
  
  public NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverrides() {
    return new NetFlowConfigUnsupportedOverridesNested(null);
  }
  
  public NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverridesLike(NetFlowConfig item) {
    return new NetFlowConfigUnsupportedOverridesNested(item);
  }
  
  public ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverrides() {
    return new ProjectAccessUnsupportedConfigOverridesNested(null);
  }
  
  public ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverridesLike(ProjectAccess item) {
    return new ProjectAccessUnsupportedConfigOverridesNested(item);
  }
  
  public GatewayConfigUnsupportedOverridesNested<A> withNewGatewayConfigUnsupportedOverrides() {
    return new GatewayConfigUnsupportedOverridesNested(null);
  }
  
  public GatewayConfigUnsupportedOverridesNested<A> withNewGatewayConfigUnsupportedOverridesLike(GatewayConfig item) {
    return new GatewayConfigUnsupportedOverridesNested(item);
  }
  
  public A withNewGatewayConfigUnsupportedOverrides(String ipForwarding,Boolean routingViaHost) {
    return (A)withUnsupportedConfigOverrides(new GatewayConfig(ipForwarding, routingViaHost));
  }
  
  public PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverrides() {
    return new PolicyAuditConfigUnsupportedOverridesNested(null);
  }
  
  public PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverridesLike(PolicyAuditConfig item) {
    return new PolicyAuditConfigUnsupportedOverridesNested(item);
  }
  
  public A withNewPolicyAuditConfigUnsupportedOverrides(String destination,Integer maxFileSize,Integer maxLogFiles,Integer rateLimit,String syslogFacility) {
    return (A)withUnsupportedConfigOverrides(new PolicyAuditConfig(destination, maxFileSize, maxLogFiles, rateLimit, syslogFacility));
  }
  
  public PerspectiveVisibilityUnsupportedConfigOverridesNested<A> withNewPerspectiveVisibilityUnsupportedConfigOverrides() {
    return new PerspectiveVisibilityUnsupportedConfigOverridesNested(null);
  }
  
  public PerspectiveVisibilityUnsupportedConfigOverridesNested<A> withNewPerspectiveVisibilityUnsupportedConfigOverridesLike(PerspectiveVisibility item) {
    return new PerspectiveVisibilityUnsupportedConfigOverridesNested(item);
  }
  
  public StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverrides() {
    return new StaticIPAMAddressesUnsupportedConfigOverridesNested(null);
  }
  
  public StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverridesLike(StaticIPAMAddresses item) {
    return new StaticIPAMAddressesUnsupportedConfigOverridesNested(item);
  }
  
  public A withNewStaticIPAMAddressesUnsupportedConfigOverrides(String address,String gateway) {
    return (A)withUnsupportedConfigOverrides(new StaticIPAMAddresses(address, gateway));
  }
  
  public DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new DNSRecordUnsupportedConfigOverridesNested(null);
  }
  
  public DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new DNSRecordUnsupportedConfigOverridesNested(item);
  }
  
  public OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerUnsupportedConfigOverridesNested(null);
  }
  
  public OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new OpenShiftAPIServerUnsupportedConfigOverridesNested(item);
  }
  
  public ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverrides() {
    return new ConsoleSpecUnsupportedConfigOverridesNested(null);
  }
  
  public ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverridesLike(ConsoleSpec item) {
    return new ConsoleSpecUnsupportedConfigOverridesNested(item);
  }
  
  public String getVsphereStorageDriver() {
    return this.vsphereStorageDriver;
  }
  
  public A withVsphereStorageDriver(String vsphereStorageDriver) {
    this.vsphereStorageDriver = vsphereStorageDriver;
    return (A) this;
  }
  
  public boolean hasVsphereStorageDriver() {
    return this.vsphereStorageDriver != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageSpecFluent that = (StorageSpecFluent) o;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(observedConfig, that.observedConfig)) return false;
    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;
    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;
    if (!java.util.Objects.equals(vsphereStorageDriver, that.vsphereStorageDriver)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(logLevel,  managementState,  observedConfig,  operatorLogLevel,  unsupportedConfigOverrides,  vsphereStorageDriver,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (vsphereStorageDriver != null) { sb.append("vsphereStorageDriver:"); sb.append(vsphereStorageDriver + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerList": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerListBuilder((ServiceCatalogAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckStatus": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckStatusBuilder((PodNetworkConnectivityCheckStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePruner": return (VisitableBuilder<T, ?>)new ImagePrunerBuilder((ImagePruner) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManager": return (VisitableBuilder<T, ?>)new KubeControllerManagerBuilder((KubeControllerManager) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerStatus": return (VisitableBuilder<T, ?>)new KubeControllerManagerStatusBuilder((KubeControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerStatus": return (VisitableBuilder<T, ?>)new CSISnapshotControllerStatusBuilder((CSISnapshotControllerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPsecConfig": return (VisitableBuilder<T, ?>)new IPsecConfigBuilder((IPsecConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicy": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorSpec": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorSpecBuilder((KubeStorageVersionMigratorSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftSDNConfig": return (VisitableBuilder<T, ?>)new OpenShiftSDNConfigBuilder((OpenShiftSDNConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerHTTPHeaders": return (VisitableBuilder<T, ?>)new IngressControllerHTTPHeadersBuilder((IngressControllerHTTPHeaders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleList": return (VisitableBuilder<T, ?>)new ConsoleListBuilder((ConsoleList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceAccountIssuerStatus": return (VisitableBuilder<T, ?>)new ServiceAccountIssuerStatusBuilder((ServiceAccountIssuerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCategory": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCategoryBuilder((DeveloperConsoleCatalogCategory) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ExportNetworkFlows": return (VisitableBuilder<T, ?>)new ExportNetworkFlowsBuilder((ExportNetworkFlows) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerSpec": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerSpecBuilder((OpenShiftControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverSpec": return (VisitableBuilder<T, ?>)new ClusterCSIDriverSpecBuilder((ClusterCSIDriverSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"RepositoryDigestMirrors": return (VisitableBuilder<T, ?>)new RepositoryDigestMirrorsBuilder((RepositoryDigestMirrors) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleCustomization": return (VisitableBuilder<T, ?>)new ConsoleCustomizationBuilder((ConsoleCustomization) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerSpec": return (VisitableBuilder<T, ?>)new CSISnapshotControllerSpecBuilder((CSISnapshotControllerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"UpstreamResolvers": return (VisitableBuilder<T, ?>)new UpstreamResolversBuilder((UpstreamResolvers) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerHTTPUniqueIdHeaderPolicy": return (VisitableBuilder<T, ?>)new IngressControllerHTTPUniqueIdHeaderPolicyBuilder((IngressControllerHTTPUniqueIdHeaderPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"MTUMigrationValues": return (VisitableBuilder<T, ?>)new MTUMigrationValuesBuilder((MTUMigrationValues) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigStatus": return (VisitableBuilder<T, ?>)new ConfigStatusBuilder((ConfigStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"VSphereCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new VSphereCSIDriverConfigSpecBuilder((VSphereCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCA": return (VisitableBuilder<T, ?>)new ServiceCABuilder((ServiceCA) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerSpec": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerSpecBuilder((ServiceCatalogControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerList": return (VisitableBuilder<T, ?>)new IngressControllerListBuilder((IngressControllerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSList": return (VisitableBuilder<T, ?>)new DNSListBuilder((DNSList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerStatus": return (VisitableBuilder<T, ?>)new KubeAPIServerStatusBuilder((KubeAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSClassicLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSClassicLoadBalancerParametersBuilder((AWSClassicLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServer": return (VisitableBuilder<T, ?>)new KubeAPIServerBuilder((KubeAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleConfigRoute": return (VisitableBuilder<T, ?>)new ConsoleConfigRouteBuilder((ConsoleConfigRoute) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressController": return (VisitableBuilder<T, ?>)new IngressControllerBuilder((IngressController) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialStatus": return (VisitableBuilder<T, ?>)new CloudCredentialStatusBuilder((CloudCredentialStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigrator": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerStatus": return (VisitableBuilder<T, ?>)new IngressControllerStatusBuilder((IngressControllerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerStatus": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerStatusBuilder((ServiceCatalogControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerList": return (VisitableBuilder<T, ?>)new ImagePrunerListBuilder((ImagePrunerList) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ContainerLoggingDestinationParameters": return (VisitableBuilder<T, ?>)new ContainerLoggingDestinationParametersBuilder((ContainerLoggingDestinationParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerSpec": return (VisitableBuilder<T, ?>)new KubeAPIServerSpecBuilder((KubeAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerList": return (VisitableBuilder<T, ?>)new KubeSchedulerListBuilder((KubeSchedulerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMRoutes": return (VisitableBuilder<T, ?>)new StaticIPAMRoutesBuilder((StaticIPAMRoutes) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManager": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerBuilder((OpenShiftControllerManager) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EndpointPublishingStrategy": return (VisitableBuilder<T, ?>)new EndpointPublishingStrategyBuilder((EndpointPublishingStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredential": return (VisitableBuilder<T, ?>)new CloudCredentialBuilder((CloudCredential) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeScheduler": return (VisitableBuilder<T, ?>)new KubeSchedulerBuilder((KubeScheduler) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverStatus": return (VisitableBuilder<T, ?>)new ClusterCSIDriverStatusBuilder((ClusterCSIDriverStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SFlowConfig": return (VisitableBuilder<T, ?>)new SFlowConfigBuilder((SFlowConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ForwardPlugin": return (VisitableBuilder<T, ?>)new ForwardPluginBuilder((ForwardPlugin) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"LogEntry": return (VisitableBuilder<T, ?>)new LogEntryBuilder((LogEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AdditionalNetworkDefinition": return (VisitableBuilder<T, ?>)new AdditionalNetworkDefinitionBuilder((AdditionalNetworkDefinition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationStatus": return (VisitableBuilder<T, ?>)new AuthenticationStatusBuilder((AuthenticationStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodePortStrategy": return (VisitableBuilder<T, ?>)new NodePortStrategyBuilder((NodePortStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Network": return (VisitableBuilder<T, ?>)new NetworkBuilder((Network) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClientTLS": return (VisitableBuilder<T, ?>)new ClientTLSBuilder((ClientTLS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerStatus": return (VisitableBuilder<T, ?>)new ImagePrunerStatusBuilder((ImagePrunerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Upstream": return (VisitableBuilder<T, ?>)new UpstreamBuilder((Upstream) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AzureDiskEncryptionSet": return (VisitableBuilder<T, ?>)new AzureDiskEncryptionSetBuilder((AzureDiskEncryptionSet) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServer": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new CSIDriverConfigSpecBuilder((CSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPHeader": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPHeaderBuilder((IngressControllerCaptureHTTPHeader) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkMigration": return (VisitableBuilder<T, ?>)new NetworkMigrationBuilder((NetworkMigration) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordList": return (VisitableBuilder<T, ?>)new DNSRecordListBuilder((DNSRecordList) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdSpec": return (VisitableBuilder<T, ?>)new EtcdSpecBuilder((EtcdSpec) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheck": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"LoadBalancerStrategy": return (VisitableBuilder<T, ?>)new LoadBalancerStrategyBuilder((LoadBalancerStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerStatus": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerStatusBuilder((OpenShiftAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSOverTLSConfig": return (VisitableBuilder<T, ?>)new DNSOverTLSConfigBuilder((DNSOverTLSConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialList": return (VisitableBuilder<T, ?>)new CloudCredentialListBuilder((CloudCredentialList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSCache": return (VisitableBuilder<T, ?>)new DNSCacheBuilder((DNSCache) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerSpec": return (VisitableBuilder<T, ?>)new ImagePrunerSpecBuilder((ImagePrunerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigList": return (VisitableBuilder<T, ?>)new ConfigListBuilder((ConfigList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationList": return (VisitableBuilder<T, ?>)new AuthenticationListBuilder((AuthenticationList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PinnedResourceReference": return (VisitableBuilder<T, ?>)new PinnedResourceReferenceBuilder((PinnedResourceReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerList": return (VisitableBuilder<T, ?>)new KubeControllerManagerListBuilder((KubeControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPAMConfig": return (VisitableBuilder<T, ?>)new IPAMConfigBuilder((IPAMConfig) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IBMLoadBalancerParameters": return (VisitableBuilder<T, ?>)new IBMLoadBalancerParametersBuilder((IBMLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AccessLogging": return (VisitableBuilder<T, ?>)new AccessLoggingBuilder((AccessLogging) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HostNetworkStrategy": return (VisitableBuilder<T, ?>)new HostNetworkStrategyBuilder((HostNetworkStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerSpec": return (VisitableBuilder<T, ?>)new KubeSchedulerSpecBuilder((KubeSchedulerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicyList": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicyListBuilder((ImageContentSourcePolicyList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerStatus": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerStatusBuilder((OpenShiftControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerStatus": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerStatusBuilder((ServiceCatalogAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSNodePlacement": return (VisitableBuilder<T, ?>)new DNSNodePlacementBuilder((DNSNodePlacement) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkList": return (VisitableBuilder<T, ?>)new NetworkListBuilder((NetworkList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProviderLoadBalancerParameters": return (VisitableBuilder<T, ?>)new ProviderLoadBalancerParametersBuilder((ProviderLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ResourceAttributesAccessReview": return (VisitableBuilder<T, ?>)new ResourceAttributesAccessReviewBuilder((ResourceAttributesAccessReview) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCASpec": return (VisitableBuilder<T, ?>)new ServiceCASpecBuilder((ServiceCASpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PrivateStrategy": return (VisitableBuilder<T, ?>)new PrivateStrategyBuilder((PrivateStrategy) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckList": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckListBuilder((PodNetworkConnectivityCheckList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerList": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerListBuilder((OpenShiftAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OAuthAPIServerStatus": return (VisitableBuilder<T, ?>)new OAuthAPIServerStatusBuilder((OAuthAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new GCPCSIDriverConfigSpecBuilder((GCPCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManager": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPCookie": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPCookieBuilder((IngressControllerCaptureHTTPCookie) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNS": return (VisitableBuilder<T, ?>)new DNSBuilder((DNS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AddPage": return (VisitableBuilder<T, ?>)new AddPageBuilder((AddPage) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AzureCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new AzureCSIDriverConfigSpecBuilder((AzureCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageList": return (VisitableBuilder<T, ?>)new StorageListBuilder((StorageList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Authentication": return (VisitableBuilder<T, ?>)new AuthenticationBuilder((Authentication) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCAStatus": return (VisitableBuilder<T, ?>)new ServiceCAStatusBuilder((ServiceCAStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"MTUMigration": return (VisitableBuilder<T, ?>)new MTUMigrationBuilder((MTUMigration) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Perspective": return (VisitableBuilder<T, ?>)new PerspectiveBuilder((Perspective) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorList": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorListBuilder((KubeStorageVersionMigratorList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Storage": return (VisitableBuilder<T, ?>)new StorageBuilder((Storage) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerList": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerListBuilder((ServiceCatalogControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCategoryMeta": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCategoryMetaBuilder((DeveloperConsoleCatalogCategoryMeta) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OVNKubernetesConfig": return (VisitableBuilder<T, ?>)new OVNKubernetesConfigBuilder((OVNKubernetesConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSSpec": return (VisitableBuilder<T, ?>)new DNSSpecBuilder((DNSSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerSpec": return (VisitableBuilder<T, ?>)new IngressControllerSpecBuilder((IngressControllerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OperatorCondition": return (VisitableBuilder<T, ?>)new OperatorConditionBuilder((OperatorCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProxyConfig": return (VisitableBuilder<T, ?>)new ProxyConfigBuilder((ProxyConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KuryrConfig": return (VisitableBuilder<T, ?>)new KuryrConfigBuilder((KuryrConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerSpec": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerSpecBuilder((ServiceCatalogAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicySpec": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicySpecBuilder((ImageContentSourcePolicySpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSStatus": return (VisitableBuilder<T, ?>)new DNSStatusBuilder((DNSStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSTransportConfig": return (VisitableBuilder<T, ?>)new DNSTransportConfigBuilder((DNSTransportConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPLoadBalancerParameters": return (VisitableBuilder<T, ?>)new GCPLoadBalancerParametersBuilder((GCPLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerList": return (VisitableBuilder<T, ?>)new KubeAPIServerListBuilder((KubeAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Config": return (VisitableBuilder<T, ?>)new ConfigBuilder((Config) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverList": return (VisitableBuilder<T, ?>)new ClusterCSIDriverListBuilder((ClusterCSIDriverList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SimpleMacvlanConfig": return (VisitableBuilder<T, ?>)new SimpleMacvlanConfigBuilder((SimpleMacvlanConfig) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EgressIPConfig": return (VisitableBuilder<T, ?>)new EgressIPConfigBuilder((EgressIPConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HybridOverlayConfig": return (VisitableBuilder<T, ?>)new HybridOverlayConfigBuilder((HybridOverlayConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSLoadBalancerParametersBuilder((AWSLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerList": return (VisitableBuilder<T, ?>)new CSISnapshotControllerListBuilder((CSISnapshotControllerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Console": return (VisitableBuilder<T, ?>)new ConsoleBuilder((Console) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSZoneCondition": return (VisitableBuilder<T, ?>)new DNSZoneConditionBuilder((DNSZoneCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriver": return (VisitableBuilder<T, ?>)new ClusterCSIDriverBuilder((ClusterCSIDriver) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"QuickStarts": return (VisitableBuilder<T, ?>)new QuickStartsBuilder((QuickStarts) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSZoneStatus": return (VisitableBuilder<T, ?>)new DNSZoneStatusBuilder((DNSZoneStatus) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"OutageEntry": return (VisitableBuilder<T, ?>)new OutageEntryBuilder((OutageEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigSpec": return (VisitableBuilder<T, ?>)new ConfigSpecBuilder((ConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerList": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerListBuilder((OpenShiftControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Etcd": return (VisitableBuilder<T, ?>)new EtcdBuilder((Etcd) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPFIXConfig": return (VisitableBuilder<T, ?>)new IPFIXConfigBuilder((IPFIXConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkStatus": return (VisitableBuilder<T, ?>)new NetworkStatusBuilder((NetworkStatus) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckCondition": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckConditionBuilder((PodNetworkConnectivityCheckCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodeStatus": return (VisitableBuilder<T, ?>)new NodeStatusBuilder((NodeStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"RouteAdmissionPolicy": return (VisitableBuilder<T, ?>)new RouteAdmissionPolicyBuilder((RouteAdmissionPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GenerationStatus": return (VisitableBuilder<T, ?>)new GenerationStatusBuilder((GenerationStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPHeaders": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPHeadersBuilder((IngressControllerCaptureHTTPHeaders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdList": return (VisitableBuilder<T, ?>)new EtcdListBuilder((EtcdList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"FeaturesMigration": return (VisitableBuilder<T, ?>)new FeaturesMigrationBuilder((FeaturesMigration) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DefaultNetworkDefinition": return (VisitableBuilder<T, ?>)new DefaultNetworkDefinitionBuilder((DefaultNetworkDefinition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPKMSKeyReference": return (VisitableBuilder<T, ?>)new GCPKMSKeyReferenceBuilder((GCPKMSKeyReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerSpec": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerSpecBuilder((OpenShiftAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerStatus": return (VisitableBuilder<T, ?>)new KubeSchedulerStatusBuilder((KubeSchedulerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SyslogLoggingDestinationParameters": return (VisitableBuilder<T, ?>)new SyslogLoggingDestinationParametersBuilder((SyslogLoggingDestinationParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSNetworkLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSNetworkLoadBalancerParametersBuilder((AWSNetworkLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCAList": return (VisitableBuilder<T, ?>)new ServiceCAListBuilder((ServiceCAList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdStatus": return (VisitableBuilder<T, ?>)new EtcdStatusBuilder((EtcdStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StatuspageProvider": return (VisitableBuilder<T, ?>)new StatuspageProviderBuilder((StatuspageProvider) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorStatus": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorStatusBuilder((KubeStorageVersionMigratorStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleProviders": return (VisitableBuilder<T, ?>)new ConsoleProvidersBuilder((ConsoleProviders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerLogging": return (VisitableBuilder<T, ?>)new IngressControllerLoggingBuilder((IngressControllerLogging) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageStatus": return (VisitableBuilder<T, ?>)new StorageStatusBuilder((StorageStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationSpec": return (VisitableBuilder<T, ?>)new AuthenticationSpecBuilder((AuthenticationSpec) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckSpec": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckSpecBuilder((PodNetworkConnectivityCheckSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotController": return (VisitableBuilder<T, ?>)new CSISnapshotControllerBuilder((CSISnapshotController) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogTypes": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogTypesBuilder((DeveloperConsoleCatalogTypes) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordSpec": return (VisitableBuilder<T, ?>)new DNSRecordSpecBuilder((DNSRecordSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCustomization": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCustomizationBuilder((DeveloperConsoleCatalogCustomization) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"LoggingDestination": return (VisitableBuilder<T, ?>)new LoggingDestinationBuilder((LoggingDestination) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerTuningOptions": return (VisitableBuilder<T, ?>)new IngressControllerTuningOptionsBuilder((IngressControllerTuningOptions) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMConfig": return (VisitableBuilder<T, ?>)new StaticIPAMConfigBuilder((StaticIPAMConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new AWSCSIDriverConfigSpecBuilder((AWSCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerSpec": return (VisitableBuilder<T, ?>)new KubeControllerManagerSpecBuilder((KubeControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMDNS": return (VisitableBuilder<T, ?>)new StaticIPAMDNSBuilder((StaticIPAMDNS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageSpec": return (VisitableBuilder<T, ?>)new StorageSpecBuilder((StorageSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodePlacement": return (VisitableBuilder<T, ?>)new NodePlacementBuilder((NodePlacement) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkSpec": return (VisitableBuilder<T, ?>)new NetworkSpecBuilder((NetworkSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleStatus": return (VisitableBuilder<T, ?>)new ConsoleStatusBuilder((ConsoleStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Server": return (VisitableBuilder<T, ?>)new ServerBuilder((Server) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialSpec": return (VisitableBuilder<T, ?>)new CloudCredentialSpecBuilder((CloudCredentialSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordStatus": return (VisitableBuilder<T, ?>)new DNSRecordStatusBuilder((DNSRecordStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterNetworkEntry": return (VisitableBuilder<T, ?>)new ClusterNetworkEntryBuilder((ClusterNetworkEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HTTPCompressionPolicy": return (VisitableBuilder<T, ?>)new HTTPCompressionPolicyBuilder((HTTPCompressionPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetFlowConfig": return (VisitableBuilder<T, ?>)new NetFlowConfigBuilder((NetFlowConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProjectAccess": return (VisitableBuilder<T, ?>)new ProjectAccessBuilder((ProjectAccess) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GatewayConfig": return (VisitableBuilder<T, ?>)new GatewayConfigBuilder((GatewayConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PolicyAuditConfig": return (VisitableBuilder<T, ?>)new PolicyAuditConfigBuilder((PolicyAuditConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PerspectiveVisibility": return (VisitableBuilder<T, ?>)new PerspectiveVisibilityBuilder((PerspectiveVisibility) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMAddresses": return (VisitableBuilder<T, ?>)new StaticIPAMAddressesBuilder((StaticIPAMAddresses) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecord": return (VisitableBuilder<T, ?>)new DNSRecordBuilder((DNSRecord) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServer": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerBuilder((OpenShiftAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleSpec": return (VisitableBuilder<T, ?>)new ConsoleSpecBuilder((ConsoleSpec) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ServiceCatalogAPIServerListObservedConfigNested<N> extends ServiceCatalogAPIServerListFluent<ServiceCatalogAPIServerListObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerListObservedConfigNested(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogAPIServerListObservedConfig() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckStatusObservedConfigNested<N> extends PodNetworkConnectivityCheckStatusFluent<PodNetworkConnectivityCheckStatusObservedConfigNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckStatusObservedConfigNested(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ImagePrunerObservedConfigNested<N> extends ImagePrunerFluent<ImagePrunerObservedConfigNested<N>> implements Nested<N>{
    ImagePrunerObservedConfigNested(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerObservedConfigNested<N> extends KubeControllerManagerFluent<KubeControllerManagerObservedConfigNested<N>> implements Nested<N>{
    KubeControllerManagerObservedConfigNested(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecObservedConfigNested<N> extends PodTemplateSpecFluent<PodTemplateSpecObservedConfigNested<N>> implements Nested<N>{
    PodTemplateSpecObservedConfigNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodTemplateSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerStatusObservedConfigNested<N> extends KubeControllerManagerStatusFluent<KubeControllerManagerStatusObservedConfigNested<N>> implements Nested<N>{
    KubeControllerManagerStatusObservedConfigNested(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeControllerManagerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerStatusObservedConfigNested<N> extends CSISnapshotControllerStatusFluent<CSISnapshotControllerStatusObservedConfigNested<N>> implements Nested<N>{
    CSISnapshotControllerStatusObservedConfigNested(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCSISnapshotControllerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class IPsecConfigObservedNested<N> extends IPsecConfigFluent<IPsecConfigObservedNested<N>> implements Nested<N>{
    IPsecConfigObservedNested(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIPsecConfigObserved() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicyObservedConfigNested<N> extends ImageContentSourcePolicyFluent<ImageContentSourcePolicyObservedConfigNested<N>> implements Nested<N>{
    ImageContentSourcePolicyObservedConfigNested(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsObservedConfigNested<N> extends ResourceRequirementsFluent<ResourceRequirementsObservedConfigNested<N>> implements Nested<N>{
    ResourceRequirementsObservedConfigNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endResourceRequirementsObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorSpecObservedConfigNested<N> extends KubeStorageVersionMigratorSpecFluent<KubeStorageVersionMigratorSpecObservedConfigNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorSpecObservedConfigNested(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeStorageVersionMigratorSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftSDNConfigObservedNested<N> extends OpenShiftSDNConfigFluent<OpenShiftSDNConfigObservedNested<N>> implements Nested<N>{
    OpenShiftSDNConfigObservedNested(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftSDNConfigObserved() {
      return and();
    }
    
  
  }
  public class IngressControllerHTTPHeadersObservedConfigNested<N> extends IngressControllerHTTPHeadersFluent<IngressControllerHTTPHeadersObservedConfigNested<N>> implements Nested<N>{
    IngressControllerHTTPHeadersObservedConfigNested(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerHTTPHeadersObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleListObservedConfigNested<N> extends ConsoleListFluent<ConsoleListObservedConfigNested<N>> implements Nested<N>{
    ConsoleListObservedConfigNested(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleListObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceAccountIssuerStatusObservedConfigNested<N> extends ServiceAccountIssuerStatusFluent<ServiceAccountIssuerStatusObservedConfigNested<N>> implements Nested<N>{
    ServiceAccountIssuerStatusObservedConfigNested(ServiceAccountIssuerStatus item) {
      this.builder = new ServiceAccountIssuerStatusBuilder(this, item);
    }
    ServiceAccountIssuerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceAccountIssuerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCategoryObservedConfigNested<N> extends DeveloperConsoleCatalogCategoryFluent<DeveloperConsoleCatalogCategoryObservedConfigNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryObservedConfigNested(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCategoryObservedConfig() {
      return and();
    }
    
  
  }
  public class ExportNetworkFlowsObservedConfigNested<N> extends ExportNetworkFlowsFluent<ExportNetworkFlowsObservedConfigNested<N>> implements Nested<N>{
    ExportNetworkFlowsObservedConfigNested(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endExportNetworkFlowsObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerSpecObservedConfigNested<N> extends OpenShiftControllerManagerSpecFluent<OpenShiftControllerManagerSpecObservedConfigNested<N>> implements Nested<N>{
    OpenShiftControllerManagerSpecObservedConfigNested(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftControllerManagerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverSpecObservedConfigNested<N> extends ClusterCSIDriverSpecFluent<ClusterCSIDriverSpecObservedConfigNested<N>> implements Nested<N>{
    ClusterCSIDriverSpecObservedConfigNested(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClusterCSIDriverSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class RepositoryDigestMirrorsObservedConfigNested<N> extends RepositoryDigestMirrorsFluent<RepositoryDigestMirrorsObservedConfigNested<N>> implements Nested<N>{
    RepositoryDigestMirrorsObservedConfigNested(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endRepositoryDigestMirrorsObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleCustomizationObservedConfigNested<N> extends ConsoleCustomizationFluent<ConsoleCustomizationObservedConfigNested<N>> implements Nested<N>{
    ConsoleCustomizationObservedConfigNested(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleCustomizationObservedConfig() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerSpecObservedConfigNested<N> extends CSISnapshotControllerSpecFluent<CSISnapshotControllerSpecObservedConfigNested<N>> implements Nested<N>{
    CSISnapshotControllerSpecObservedConfigNested(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCSISnapshotControllerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class UpstreamResolversObservedConfigNested<N> extends UpstreamResolversFluent<UpstreamResolversObservedConfigNested<N>> implements Nested<N>{
    UpstreamResolversObservedConfigNested(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endUpstreamResolversObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluent<IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<N>> implements Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig() {
      return and();
    }
    
  
  }
  public class MTUMigrationValuesObservedConfigNested<N> extends MTUMigrationValuesFluent<MTUMigrationValuesObservedConfigNested<N>> implements Nested<N>{
    MTUMigrationValuesObservedConfigNested(MTUMigrationValues item) {
      this.builder = new MTUMigrationValuesBuilder(this, item);
    }
    MTUMigrationValuesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endMTUMigrationValuesObservedConfig() {
      return and();
    }
    
  
  }
  public class ConfigStatusObservedConfigNested<N> extends ConfigStatusFluent<ConfigStatusObservedConfigNested<N>> implements Nested<N>{
    ConfigStatusObservedConfigNested(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConfigStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class VSphereCSIDriverConfigSpecObservedNested<N> extends VSphereCSIDriverConfigSpecFluent<VSphereCSIDriverConfigSpecObservedNested<N>> implements Nested<N>{
    VSphereCSIDriverConfigSpecObservedNested(VSphereCSIDriverConfigSpec item) {
      this.builder = new VSphereCSIDriverConfigSpecBuilder(this, item);
    }
    VSphereCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endVSphereCSIDriverConfigSpecObserved() {
      return and();
    }
    
  
  }
  public class ServiceCAObservedConfigNested<N> extends ServiceCAFluent<ServiceCAObservedConfigNested<N>> implements Nested<N>{
    ServiceCAObservedConfigNested(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCABuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerSpecObservedConfigNested<N> extends ServiceCatalogControllerManagerSpecFluent<ServiceCatalogControllerManagerSpecObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerSpecObservedConfigNested(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogControllerManagerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerListObservedConfigNested<N> extends IngressControllerListFluent<IngressControllerListObservedConfigNested<N>> implements Nested<N>{
    IngressControllerListObservedConfigNested(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerListObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSListObservedConfigNested<N> extends DNSListFluent<DNSListObservedConfigNested<N>> implements Nested<N>{
    DNSListObservedConfigNested(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSListObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeAPIServerStatusObservedConfigNested<N> extends KubeAPIServerStatusFluent<KubeAPIServerStatusObservedConfigNested<N>> implements Nested<N>{
    KubeAPIServerStatusObservedConfigNested(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeAPIServerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class AWSClassicLoadBalancerParametersObservedConfigNested<N> extends AWSClassicLoadBalancerParametersFluent<AWSClassicLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    AWSClassicLoadBalancerParametersObservedConfigNested(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAWSClassicLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeAPIServerObservedConfigNested<N> extends KubeAPIServerFluent<KubeAPIServerObservedConfigNested<N>> implements Nested<N>{
    KubeAPIServerObservedConfigNested(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleConfigRouteObservedNested<N> extends ConsoleConfigRouteFluent<ConsoleConfigRouteObservedNested<N>> implements Nested<N>{
    ConsoleConfigRouteObservedNested(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleConfigRouteObserved() {
      return and();
    }
    
  
  }
  public class IngressControllerObservedConfigNested<N> extends IngressControllerFluent<IngressControllerObservedConfigNested<N>> implements Nested<N>{
    IngressControllerObservedConfigNested(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  
  }
  public class CloudCredentialStatusObservedConfigNested<N> extends CloudCredentialStatusFluent<CloudCredentialStatusObservedConfigNested<N>> implements Nested<N>{
    CloudCredentialStatusObservedConfigNested(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCloudCredentialStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorObservedConfigNested<N> extends KubeStorageVersionMigratorFluent<KubeStorageVersionMigratorObservedConfigNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorObservedConfigNested(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerStatusObservedConfigNested<N> extends IngressControllerStatusFluent<IngressControllerStatusObservedConfigNested<N>> implements Nested<N>{
    IngressControllerStatusObservedConfigNested(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerStatusObservedConfigNested<N> extends ServiceCatalogControllerManagerStatusFluent<ServiceCatalogControllerManagerStatusObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerStatusObservedConfigNested(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogControllerManagerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ImagePrunerListObservedConfigNested<N> extends ImagePrunerListFluent<ImagePrunerListObservedConfigNested<N>> implements Nested<N>{
    ImagePrunerListObservedConfigNested(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImagePrunerListObservedConfig() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceObservedConfigNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceObservedConfigNested<N>> implements Nested<N>{
    LocalObjectReferenceObservedConfigNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endLocalObjectReferenceObservedConfig() {
      return and();
    }
    
  
  }
  public class ContainerLoggingDestinationParametersObservedConfigNested<N> extends ContainerLoggingDestinationParametersFluent<ContainerLoggingDestinationParametersObservedConfigNested<N>> implements Nested<N>{
    ContainerLoggingDestinationParametersObservedConfigNested(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endContainerLoggingDestinationParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeAPIServerSpecObservedConfigNested<N> extends KubeAPIServerSpecFluent<KubeAPIServerSpecObservedConfigNested<N>> implements Nested<N>{
    KubeAPIServerSpecObservedConfigNested(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeAPIServerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeSchedulerListObservedConfigNested<N> extends KubeSchedulerListFluent<KubeSchedulerListObservedConfigNested<N>> implements Nested<N>{
    KubeSchedulerListObservedConfigNested(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeSchedulerListObservedConfig() {
      return and();
    }
    
  
  }
  public class StaticIPAMRoutesObservedConfigNested<N> extends StaticIPAMRoutesFluent<StaticIPAMRoutesObservedConfigNested<N>> implements Nested<N>{
    StaticIPAMRoutesObservedConfigNested(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStaticIPAMRoutesObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerObservedConfigNested<N> extends OpenShiftControllerManagerFluent<OpenShiftControllerManagerObservedConfigNested<N>> implements Nested<N>{
    OpenShiftControllerManagerObservedConfigNested(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  
  }
  public class EndpointPublishingStrategyObservedConfigNested<N> extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyObservedConfigNested<N>> implements Nested<N>{
    EndpointPublishingStrategyObservedConfigNested(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEndpointPublishingStrategyObservedConfig() {
      return and();
    }
    
  
  }
  public class CloudCredentialObservedConfigNested<N> extends CloudCredentialFluent<CloudCredentialObservedConfigNested<N>> implements Nested<N>{
    CloudCredentialObservedConfigNested(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeSchedulerObservedConfigNested<N> extends KubeSchedulerFluent<KubeSchedulerObservedConfigNested<N>> implements Nested<N>{
    KubeSchedulerObservedConfigNested(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverStatusObservedConfigNested<N> extends ClusterCSIDriverStatusFluent<ClusterCSIDriverStatusObservedConfigNested<N>> implements Nested<N>{
    ClusterCSIDriverStatusObservedConfigNested(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClusterCSIDriverStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class SFlowConfigObservedNested<N> extends SFlowConfigFluent<SFlowConfigObservedNested<N>> implements Nested<N>{
    SFlowConfigObservedNested(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endSFlowConfigObserved() {
      return and();
    }
    
  
  }
  public class ForwardPluginObservedConfigNested<N> extends ForwardPluginFluent<ForwardPluginObservedConfigNested<N>> implements Nested<N>{
    ForwardPluginObservedConfigNested(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endForwardPluginObservedConfig() {
      return and();
    }
    
  
  }
  public class LogEntryObservedConfigNested<N> extends LogEntryFluent<LogEntryObservedConfigNested<N>> implements Nested<N>{
    LogEntryObservedConfigNested(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endLogEntryObservedConfig() {
      return and();
    }
    
  
  }
  public class AdditionalNetworkDefinitionObservedConfigNested<N> extends AdditionalNetworkDefinitionFluent<AdditionalNetworkDefinitionObservedConfigNested<N>> implements Nested<N>{
    AdditionalNetworkDefinitionObservedConfigNested(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAdditionalNetworkDefinitionObservedConfig() {
      return and();
    }
    
  
  }
  public class AuthenticationStatusObservedConfigNested<N> extends AuthenticationStatusFluent<AuthenticationStatusObservedConfigNested<N>> implements Nested<N>{
    AuthenticationStatusObservedConfigNested(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAuthenticationStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class NodePortStrategyObservedConfigNested<N> extends NodePortStrategyFluent<NodePortStrategyObservedConfigNested<N>> implements Nested<N>{
    NodePortStrategyObservedConfigNested(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNodePortStrategyObservedConfig() {
      return and();
    }
    
  
  }
  public class NetworkObservedConfigNested<N> extends NetworkFluent<NetworkObservedConfigNested<N>> implements Nested<N>{
    NetworkObservedConfigNested(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetworkObservedConfig() {
      return and();
    }
    
  
  }
  public class ClientTLSObservedConfigNested<N> extends ClientTLSFluent<ClientTLSObservedConfigNested<N>> implements Nested<N>{
    ClientTLSObservedConfigNested(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClientTLSObservedConfig() {
      return and();
    }
    
  
  }
  public class ImagePrunerStatusObservedConfigNested<N> extends ImagePrunerStatusFluent<ImagePrunerStatusObservedConfigNested<N>> implements Nested<N>{
    ImagePrunerStatusObservedConfigNested(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImagePrunerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class UpstreamObservedConfigNested<N> extends UpstreamFluent<UpstreamObservedConfigNested<N>> implements Nested<N>{
    UpstreamObservedConfigNested(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endUpstreamObservedConfig() {
      return and();
    }
    
  
  }
  public class AzureDiskEncryptionSetObservedConfigNested<N> extends AzureDiskEncryptionSetFluent<AzureDiskEncryptionSetObservedConfigNested<N>> implements Nested<N>{
    AzureDiskEncryptionSetObservedConfigNested(AzureDiskEncryptionSet item) {
      this.builder = new AzureDiskEncryptionSetBuilder(this, item);
    }
    AzureDiskEncryptionSetBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAzureDiskEncryptionSetObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerObservedConfigNested<N> extends ServiceCatalogAPIServerFluent<ServiceCatalogAPIServerObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerObservedConfigNested(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  
  }
  public class CSIDriverConfigSpecObservedNested<N> extends CSIDriverConfigSpecFluent<CSIDriverConfigSpecObservedNested<N>> implements Nested<N>{
    CSIDriverConfigSpecObservedNested(CSIDriverConfigSpec item) {
      this.builder = new CSIDriverConfigSpecBuilder(this, item);
    }
    CSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCSIDriverConfigSpecObserved() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPHeaderObservedConfigNested<N> extends IngressControllerCaptureHTTPHeaderFluent<IngressControllerCaptureHTTPHeaderObservedConfigNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeaderObservedConfigNested(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPHeaderObservedConfig() {
      return and();
    }
    
  
  }
  public class NetworkMigrationObservedConfigNested<N> extends NetworkMigrationFluent<NetworkMigrationObservedConfigNested<N>> implements Nested<N>{
    NetworkMigrationObservedConfigNested(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetworkMigrationObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSRecordListObservedConfigNested<N> extends DNSRecordListFluent<DNSRecordListObservedConfigNested<N>> implements Nested<N>{
    DNSRecordListObservedConfigNested(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSRecordListObservedConfig() {
      return and();
    }
    
  
  }
  public class RawExtensionObservedConfigNested<N> extends RawExtensionFluent<RawExtensionObservedConfigNested<N>> implements Nested<N>{
    RawExtensionObservedConfigNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endRawExtensionObservedConfig() {
      return and();
    }
    
  
  }
  public class EtcdSpecObservedConfigNested<N> extends EtcdSpecFluent<EtcdSpecObservedConfigNested<N>> implements Nested<N>{
    EtcdSpecObservedConfigNested(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEtcdSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckObservedConfigNested<N> extends PodNetworkConnectivityCheckFluent<PodNetworkConnectivityCheckObservedConfigNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNested(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  
  }
  public class LoadBalancerStrategyObservedConfigNested<N> extends LoadBalancerStrategyFluent<LoadBalancerStrategyObservedConfigNested<N>> implements Nested<N>{
    LoadBalancerStrategyObservedConfigNested(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endLoadBalancerStrategyObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerStatusObservedConfigNested<N> extends OpenShiftAPIServerStatusFluent<OpenShiftAPIServerStatusObservedConfigNested<N>> implements Nested<N>{
    OpenShiftAPIServerStatusObservedConfigNested(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftAPIServerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSOverTLSConfigObservedNested<N> extends DNSOverTLSConfigFluent<DNSOverTLSConfigObservedNested<N>> implements Nested<N>{
    DNSOverTLSConfigObservedNested(DNSOverTLSConfig item) {
      this.builder = new DNSOverTLSConfigBuilder(this, item);
    }
    DNSOverTLSConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSOverTLSConfigObserved() {
      return and();
    }
    
  
  }
  public class CloudCredentialListObservedConfigNested<N> extends CloudCredentialListFluent<CloudCredentialListObservedConfigNested<N>> implements Nested<N>{
    CloudCredentialListObservedConfigNested(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCloudCredentialListObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSCacheObservedConfigNested<N> extends DNSCacheFluent<DNSCacheObservedConfigNested<N>> implements Nested<N>{
    DNSCacheObservedConfigNested(DNSCache item) {
      this.builder = new DNSCacheBuilder(this, item);
    }
    DNSCacheBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSCacheObservedConfig() {
      return and();
    }
    
  
  }
  public class ImagePrunerSpecObservedConfigNested<N> extends ImagePrunerSpecFluent<ImagePrunerSpecObservedConfigNested<N>> implements Nested<N>{
    ImagePrunerSpecObservedConfigNested(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImagePrunerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ConfigListObservedConfigNested<N> extends ConfigListFluent<ConfigListObservedConfigNested<N>> implements Nested<N>{
    ConfigListObservedConfigNested(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConfigListObservedConfig() {
      return and();
    }
    
  
  }
  public class AuthenticationListObservedConfigNested<N> extends AuthenticationListFluent<AuthenticationListObservedConfigNested<N>> implements Nested<N>{
    AuthenticationListObservedConfigNested(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAuthenticationListObservedConfig() {
      return and();
    }
    
  
  }
  public class PinnedResourceReferenceObservedConfigNested<N> extends PinnedResourceReferenceFluent<PinnedResourceReferenceObservedConfigNested<N>> implements Nested<N>{
    PinnedResourceReferenceObservedConfigNested(PinnedResourceReference item) {
      this.builder = new PinnedResourceReferenceBuilder(this, item);
    }
    PinnedResourceReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPinnedResourceReferenceObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerListObservedConfigNested<N> extends KubeControllerManagerListFluent<KubeControllerManagerListObservedConfigNested<N>> implements Nested<N>{
    KubeControllerManagerListObservedConfigNested(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeControllerManagerListObservedConfig() {
      return and();
    }
    
  
  }
  public class IPAMConfigObservedNested<N> extends IPAMConfigFluent<IPAMConfigObservedNested<N>> implements Nested<N>{
    IPAMConfigObservedNested(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIPAMConfigObserved() {
      return and();
    }
    
  
  }
  public class ContainerObservedConfigNested<N> extends ContainerFluent<ContainerObservedConfigNested<N>> implements Nested<N>{
    ContainerObservedConfigNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endContainerObservedConfig() {
      return and();
    }
    
  
  }
  public class IBMLoadBalancerParametersObservedConfigNested<N> extends IBMLoadBalancerParametersFluent<IBMLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    IBMLoadBalancerParametersObservedConfigNested(IBMLoadBalancerParameters item) {
      this.builder = new IBMLoadBalancerParametersBuilder(this, item);
    }
    IBMLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIBMLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class AccessLoggingObservedConfigNested<N> extends AccessLoggingFluent<AccessLoggingObservedConfigNested<N>> implements Nested<N>{
    AccessLoggingObservedConfigNested(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAccessLoggingObservedConfig() {
      return and();
    }
    
  
  }
  public class HostNetworkStrategyObservedConfigNested<N> extends HostNetworkStrategyFluent<HostNetworkStrategyObservedConfigNested<N>> implements Nested<N>{
    HostNetworkStrategyObservedConfigNested(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endHostNetworkStrategyObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeSchedulerSpecObservedConfigNested<N> extends KubeSchedulerSpecFluent<KubeSchedulerSpecObservedConfigNested<N>> implements Nested<N>{
    KubeSchedulerSpecObservedConfigNested(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeSchedulerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicyListObservedConfigNested<N> extends ImageContentSourcePolicyListFluent<ImageContentSourcePolicyListObservedConfigNested<N>> implements Nested<N>{
    ImageContentSourcePolicyListObservedConfigNested(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImageContentSourcePolicyListObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerStatusObservedConfigNested<N> extends OpenShiftControllerManagerStatusFluent<OpenShiftControllerManagerStatusObservedConfigNested<N>> implements Nested<N>{
    OpenShiftControllerManagerStatusObservedConfigNested(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftControllerManagerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerStatusObservedConfigNested<N> extends ServiceCatalogAPIServerStatusFluent<ServiceCatalogAPIServerStatusObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerStatusObservedConfigNested(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogAPIServerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSNodePlacementObservedConfigNested<N> extends DNSNodePlacementFluent<DNSNodePlacementObservedConfigNested<N>> implements Nested<N>{
    DNSNodePlacementObservedConfigNested(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSNodePlacementObservedConfig() {
      return and();
    }
    
  
  }
  public class NetworkListObservedConfigNested<N> extends NetworkListFluent<NetworkListObservedConfigNested<N>> implements Nested<N>{
    NetworkListObservedConfigNested(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetworkListObservedConfig() {
      return and();
    }
    
  
  }
  public class ProviderLoadBalancerParametersObservedConfigNested<N> extends ProviderLoadBalancerParametersFluent<ProviderLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    ProviderLoadBalancerParametersObservedConfigNested(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endProviderLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class ResourceAttributesAccessReviewObservedConfigNested<N> extends ResourceAttributesAccessReviewFluent<ResourceAttributesAccessReviewObservedConfigNested<N>> implements Nested<N>{
    ResourceAttributesAccessReviewObservedConfigNested(ResourceAttributesAccessReview item) {
      this.builder = new ResourceAttributesAccessReviewBuilder(this, item);
    }
    ResourceAttributesAccessReviewBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endResourceAttributesAccessReviewObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCASpecObservedConfigNested<N> extends ServiceCASpecFluent<ServiceCASpecObservedConfigNested<N>> implements Nested<N>{
    ServiceCASpecObservedConfigNested(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCASpecObservedConfig() {
      return and();
    }
    
  
  }
  public class PrivateStrategyObservedConfigNested<N> extends PrivateStrategyFluent<PrivateStrategyObservedConfigNested<N>> implements Nested<N>{
    PrivateStrategyObservedConfigNested(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPrivateStrategyObservedConfig() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckListObservedConfigNested<N> extends PodNetworkConnectivityCheckListFluent<PodNetworkConnectivityCheckListObservedConfigNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckListObservedConfigNested(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckListObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerListObservedConfigNested<N> extends OpenShiftAPIServerListFluent<OpenShiftAPIServerListObservedConfigNested<N>> implements Nested<N>{
    OpenShiftAPIServerListObservedConfigNested(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftAPIServerListObservedConfig() {
      return and();
    }
    
  
  }
  public class OAuthAPIServerStatusObservedConfigNested<N> extends OAuthAPIServerStatusFluent<OAuthAPIServerStatusObservedConfigNested<N>> implements Nested<N>{
    OAuthAPIServerStatusObservedConfigNested(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOAuthAPIServerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class GCPCSIDriverConfigSpecObservedNested<N> extends GCPCSIDriverConfigSpecFluent<GCPCSIDriverConfigSpecObservedNested<N>> implements Nested<N>{
    GCPCSIDriverConfigSpecObservedNested(GCPCSIDriverConfigSpec item) {
      this.builder = new GCPCSIDriverConfigSpecBuilder(this, item);
    }
    GCPCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGCPCSIDriverConfigSpecObserved() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerObservedConfigNested<N> extends ServiceCatalogControllerManagerFluent<ServiceCatalogControllerManagerObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNested(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPCookieObservedConfigNested<N> extends IngressControllerCaptureHTTPCookieFluent<IngressControllerCaptureHTTPCookieObservedConfigNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPCookieObservedConfigNested(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPCookieObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSObservedConfigNested<N> extends DNSFluent<DNSObservedConfigNested<N>> implements Nested<N>{
    DNSObservedConfigNested(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSObservedConfig() {
      return and();
    }
    
  
  }
  public class AddPageObservedConfigNested<N> extends AddPageFluent<AddPageObservedConfigNested<N>> implements Nested<N>{
    AddPageObservedConfigNested(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAddPageObservedConfig() {
      return and();
    }
    
  
  }
  public class AzureCSIDriverConfigSpecObservedNested<N> extends AzureCSIDriverConfigSpecFluent<AzureCSIDriverConfigSpecObservedNested<N>> implements Nested<N>{
    AzureCSIDriverConfigSpecObservedNested(AzureCSIDriverConfigSpec item) {
      this.builder = new AzureCSIDriverConfigSpecBuilder(this, item);
    }
    AzureCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAzureCSIDriverConfigSpecObserved() {
      return and();
    }
    
  
  }
  public class StorageListObservedConfigNested<N> extends StorageListFluent<StorageListObservedConfigNested<N>> implements Nested<N>{
    StorageListObservedConfigNested(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStorageListObservedConfig() {
      return and();
    }
    
  
  }
  public class AuthenticationObservedConfigNested<N> extends AuthenticationFluent<AuthenticationObservedConfigNested<N>> implements Nested<N>{
    AuthenticationObservedConfigNested(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCAStatusObservedConfigNested<N> extends ServiceCAStatusFluent<ServiceCAStatusObservedConfigNested<N>> implements Nested<N>{
    ServiceCAStatusObservedConfigNested(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCAStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class MTUMigrationObservedConfigNested<N> extends MTUMigrationFluent<MTUMigrationObservedConfigNested<N>> implements Nested<N>{
    MTUMigrationObservedConfigNested(MTUMigration item) {
      this.builder = new MTUMigrationBuilder(this, item);
    }
    MTUMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endMTUMigrationObservedConfig() {
      return and();
    }
    
  
  }
  public class PerspectiveObservedConfigNested<N> extends PerspectiveFluent<PerspectiveObservedConfigNested<N>> implements Nested<N>{
    PerspectiveObservedConfigNested(Perspective item) {
      this.builder = new PerspectiveBuilder(this, item);
    }
    PerspectiveBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPerspectiveObservedConfig() {
      return and();
    }
    
  
  }
  public class LabelSelectorObservedConfigNested<N> extends LabelSelectorFluent<LabelSelectorObservedConfigNested<N>> implements Nested<N>{
    LabelSelectorObservedConfigNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endLabelSelectorObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorListObservedConfigNested<N> extends KubeStorageVersionMigratorListFluent<KubeStorageVersionMigratorListObservedConfigNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorListObservedConfigNested(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeStorageVersionMigratorListObservedConfig() {
      return and();
    }
    
  
  }
  public class StorageObservedConfigNested<N> extends StorageFluent<StorageObservedConfigNested<N>> implements Nested<N>{
    StorageObservedConfigNested(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStorageObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerListObservedConfigNested<N> extends ServiceCatalogControllerManagerListFluent<ServiceCatalogControllerManagerListObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerListObservedConfigNested(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogControllerManagerListObservedConfig() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCategoryMetaObservedConfigNested<N> extends DeveloperConsoleCatalogCategoryMetaFluent<DeveloperConsoleCatalogCategoryMetaObservedConfigNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryMetaObservedConfigNested(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCategoryMetaObservedConfig() {
      return and();
    }
    
  
  }
  public class OVNKubernetesConfigObservedNested<N> extends OVNKubernetesConfigFluent<OVNKubernetesConfigObservedNested<N>> implements Nested<N>{
    OVNKubernetesConfigObservedNested(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOVNKubernetesConfigObserved() {
      return and();
    }
    
  
  }
  public class DNSSpecObservedConfigNested<N> extends DNSSpecFluent<DNSSpecObservedConfigNested<N>> implements Nested<N>{
    DNSSpecObservedConfigNested(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerSpecObservedConfigNested<N> extends IngressControllerSpecFluent<IngressControllerSpecObservedConfigNested<N>> implements Nested<N>{
    IngressControllerSpecObservedConfigNested(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class OperatorConditionObservedConfigNested<N> extends OperatorConditionFluent<OperatorConditionObservedConfigNested<N>> implements Nested<N>{
    OperatorConditionObservedConfigNested(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOperatorConditionObservedConfig() {
      return and();
    }
    
  
  }
  public class ProxyConfigObservedNested<N> extends ProxyConfigFluent<ProxyConfigObservedNested<N>> implements Nested<N>{
    ProxyConfigObservedNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endProxyConfigObserved() {
      return and();
    }
    
  
  }
  public class KuryrConfigObservedNested<N> extends KuryrConfigFluent<KuryrConfigObservedNested<N>> implements Nested<N>{
    KuryrConfigObservedNested(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKuryrConfigObserved() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerSpecObservedConfigNested<N> extends ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerSpecObservedConfigNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerSpecObservedConfigNested(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCatalogAPIServerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicySpecObservedConfigNested<N> extends ImageContentSourcePolicySpecFluent<ImageContentSourcePolicySpecObservedConfigNested<N>> implements Nested<N>{
    ImageContentSourcePolicySpecObservedConfigNested(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endImageContentSourcePolicySpecObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSStatusObservedConfigNested<N> extends DNSStatusFluent<DNSStatusObservedConfigNested<N>> implements Nested<N>{
    DNSStatusObservedConfigNested(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSTransportConfigObservedNested<N> extends DNSTransportConfigFluent<DNSTransportConfigObservedNested<N>> implements Nested<N>{
    DNSTransportConfigObservedNested(DNSTransportConfig item) {
      this.builder = new DNSTransportConfigBuilder(this, item);
    }
    DNSTransportConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSTransportConfigObserved() {
      return and();
    }
    
  
  }
  public class GCPLoadBalancerParametersObservedConfigNested<N> extends GCPLoadBalancerParametersFluent<GCPLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    GCPLoadBalancerParametersObservedConfigNested(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGCPLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeAPIServerListObservedConfigNested<N> extends KubeAPIServerListFluent<KubeAPIServerListObservedConfigNested<N>> implements Nested<N>{
    KubeAPIServerListObservedConfigNested(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeAPIServerListObservedConfig() {
      return and();
    }
    
  
  }
  public class ConfigObservedConfigNested<N> extends ConfigFluent<ConfigObservedConfigNested<N>> implements Nested<N>{
    ConfigObservedConfigNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConfigObservedConfig() {
      return and();
    }
    
  
  }
  public class ObjectMetaObservedConfigNested<N> extends ObjectMetaFluent<ObjectMetaObservedConfigNested<N>> implements Nested<N>{
    ObjectMetaObservedConfigNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endObjectMetaObservedConfig() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverListObservedConfigNested<N> extends ClusterCSIDriverListFluent<ClusterCSIDriverListObservedConfigNested<N>> implements Nested<N>{
    ClusterCSIDriverListObservedConfigNested(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClusterCSIDriverListObservedConfig() {
      return and();
    }
    
  
  }
  public class SimpleMacvlanConfigObservedNested<N> extends SimpleMacvlanConfigFluent<SimpleMacvlanConfigObservedNested<N>> implements Nested<N>{
    SimpleMacvlanConfigObservedNested(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endSimpleMacvlanConfigObserved() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimObservedConfigNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimObservedConfigNested<N>> implements Nested<N>{
    PersistentVolumeClaimObservedConfigNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceObservedConfigNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceObservedConfigNested<N>> implements Nested<N>{
    GenericKubernetesResourceObservedConfigNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGenericKubernetesResourceObservedConfig() {
      return and();
    }
    
  
  }
  public class EgressIPConfigObservedNested<N> extends EgressIPConfigFluent<EgressIPConfigObservedNested<N>> implements Nested<N>{
    EgressIPConfigObservedNested(EgressIPConfig item) {
      this.builder = new EgressIPConfigBuilder(this, item);
    }
    EgressIPConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEgressIPConfigObserved() {
      return and();
    }
    
  
  }
  public class HybridOverlayConfigObservedNested<N> extends HybridOverlayConfigFluent<HybridOverlayConfigObservedNested<N>> implements Nested<N>{
    HybridOverlayConfigObservedNested(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endHybridOverlayConfigObserved() {
      return and();
    }
    
  
  }
  public class AWSLoadBalancerParametersObservedConfigNested<N> extends AWSLoadBalancerParametersFluent<AWSLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    AWSLoadBalancerParametersObservedConfigNested(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAWSLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerListObservedConfigNested<N> extends CSISnapshotControllerListFluent<CSISnapshotControllerListObservedConfigNested<N>> implements Nested<N>{
    CSISnapshotControllerListObservedConfigNested(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCSISnapshotControllerListObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleObservedConfigNested<N> extends ConsoleFluent<ConsoleObservedConfigNested<N>> implements Nested<N>{
    ConsoleObservedConfigNested(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSZoneConditionObservedConfigNested<N> extends DNSZoneConditionFluent<DNSZoneConditionObservedConfigNested<N>> implements Nested<N>{
    DNSZoneConditionObservedConfigNested(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSZoneConditionObservedConfig() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverObservedConfigNested<N> extends ClusterCSIDriverFluent<ClusterCSIDriverObservedConfigNested<N>> implements Nested<N>{
    ClusterCSIDriverObservedConfigNested(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  
  }
  public class QuickStartsObservedConfigNested<N> extends QuickStartsFluent<QuickStartsObservedConfigNested<N>> implements Nested<N>{
    QuickStartsObservedConfigNested(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endQuickStartsObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSZoneStatusObservedConfigNested<N> extends DNSZoneStatusFluent<DNSZoneStatusObservedConfigNested<N>> implements Nested<N>{
    DNSZoneStatusObservedConfigNested(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSZoneStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class OutageEntryObservedConfigNested<N> extends OutageEntryFluent<OutageEntryObservedConfigNested<N>> implements Nested<N>{
    OutageEntryObservedConfigNested(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOutageEntryObservedConfig() {
      return and();
    }
    
  
  }
  public class ConfigSpecObservedConfigNested<N> extends ConfigSpecFluent<ConfigSpecObservedConfigNested<N>> implements Nested<N>{
    ConfigSpecObservedConfigNested(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConfigSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerListObservedConfigNested<N> extends OpenShiftControllerManagerListFluent<OpenShiftControllerManagerListObservedConfigNested<N>> implements Nested<N>{
    OpenShiftControllerManagerListObservedConfigNested(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftControllerManagerListObservedConfig() {
      return and();
    }
    
  
  }
  public class EtcdObservedConfigNested<N> extends EtcdFluent<EtcdObservedConfigNested<N>> implements Nested<N>{
    EtcdObservedConfigNested(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEtcdObservedConfig() {
      return and();
    }
    
  
  }
  public class IPFIXConfigObservedNested<N> extends IPFIXConfigFluent<IPFIXConfigObservedNested<N>> implements Nested<N>{
    IPFIXConfigObservedNested(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIPFIXConfigObserved() {
      return and();
    }
    
  
  }
  public class NetworkStatusObservedConfigNested<N> extends NetworkStatusFluent<NetworkStatusObservedConfigNested<N>> implements Nested<N>{
    NetworkStatusObservedConfigNested(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetworkStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckConditionObservedConfigNested<N> extends PodNetworkConnectivityCheckConditionFluent<PodNetworkConnectivityCheckConditionObservedConfigNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckConditionObservedConfigNested(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckConditionObservedConfig() {
      return and();
    }
    
  
  }
  public class NodeStatusObservedConfigNested<N> extends NodeStatusFluent<NodeStatusObservedConfigNested<N>> implements Nested<N>{
    NodeStatusObservedConfigNested(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNodeStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class RouteAdmissionPolicyObservedConfigNested<N> extends RouteAdmissionPolicyFluent<RouteAdmissionPolicyObservedConfigNested<N>> implements Nested<N>{
    RouteAdmissionPolicyObservedConfigNested(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endRouteAdmissionPolicyObservedConfig() {
      return and();
    }
    
  
  }
  public class GenerationStatusObservedConfigNested<N> extends GenerationStatusFluent<GenerationStatusObservedConfigNested<N>> implements Nested<N>{
    GenerationStatusObservedConfigNested(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGenerationStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPHeadersObservedConfigNested<N> extends IngressControllerCaptureHTTPHeadersFluent<IngressControllerCaptureHTTPHeadersObservedConfigNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeadersObservedConfigNested(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPHeadersObservedConfig() {
      return and();
    }
    
  
  }
  public class EtcdListObservedConfigNested<N> extends EtcdListFluent<EtcdListObservedConfigNested<N>> implements Nested<N>{
    EtcdListObservedConfigNested(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEtcdListObservedConfig() {
      return and();
    }
    
  
  }
  public class FeaturesMigrationObservedConfigNested<N> extends FeaturesMigrationFluent<FeaturesMigrationObservedConfigNested<N>> implements Nested<N>{
    FeaturesMigrationObservedConfigNested(FeaturesMigration item) {
      this.builder = new FeaturesMigrationBuilder(this, item);
    }
    FeaturesMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endFeaturesMigrationObservedConfig() {
      return and();
    }
    
  
  }
  public class DefaultNetworkDefinitionObservedConfigNested<N> extends DefaultNetworkDefinitionFluent<DefaultNetworkDefinitionObservedConfigNested<N>> implements Nested<N>{
    DefaultNetworkDefinitionObservedConfigNested(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDefaultNetworkDefinitionObservedConfig() {
      return and();
    }
    
  
  }
  public class GCPKMSKeyReferenceObservedConfigNested<N> extends GCPKMSKeyReferenceFluent<GCPKMSKeyReferenceObservedConfigNested<N>> implements Nested<N>{
    GCPKMSKeyReferenceObservedConfigNested(GCPKMSKeyReference item) {
      this.builder = new GCPKMSKeyReferenceBuilder(this, item);
    }
    GCPKMSKeyReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGCPKMSKeyReferenceObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerSpecObservedConfigNested<N> extends OpenShiftAPIServerSpecFluent<OpenShiftAPIServerSpecObservedConfigNested<N>> implements Nested<N>{
    OpenShiftAPIServerSpecObservedConfigNested(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftAPIServerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeSchedulerStatusObservedConfigNested<N> extends KubeSchedulerStatusFluent<KubeSchedulerStatusObservedConfigNested<N>> implements Nested<N>{
    KubeSchedulerStatusObservedConfigNested(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeSchedulerStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class SyslogLoggingDestinationParametersObservedConfigNested<N> extends SyslogLoggingDestinationParametersFluent<SyslogLoggingDestinationParametersObservedConfigNested<N>> implements Nested<N>{
    SyslogLoggingDestinationParametersObservedConfigNested(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endSyslogLoggingDestinationParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class AWSNetworkLoadBalancerParametersObservedConfigNested<N> extends AWSNetworkLoadBalancerParametersFluent<AWSNetworkLoadBalancerParametersObservedConfigNested<N>> implements Nested<N>{
    AWSNetworkLoadBalancerParametersObservedConfigNested(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAWSNetworkLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCAListObservedConfigNested<N> extends ServiceCAListFluent<ServiceCAListObservedConfigNested<N>> implements Nested<N>{
    ServiceCAListObservedConfigNested(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServiceCAListObservedConfig() {
      return and();
    }
    
  
  }
  public class EtcdStatusObservedConfigNested<N> extends EtcdStatusFluent<EtcdStatusObservedConfigNested<N>> implements Nested<N>{
    EtcdStatusObservedConfigNested(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endEtcdStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class StatuspageProviderObservedConfigNested<N> extends StatuspageProviderFluent<StatuspageProviderObservedConfigNested<N>> implements Nested<N>{
    StatuspageProviderObservedConfigNested(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStatuspageProviderObservedConfig() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorStatusObservedConfigNested<N> extends KubeStorageVersionMigratorStatusFluent<KubeStorageVersionMigratorStatusObservedConfigNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorStatusObservedConfigNested(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeStorageVersionMigratorStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleProvidersObservedConfigNested<N> extends ConsoleProvidersFluent<ConsoleProvidersObservedConfigNested<N>> implements Nested<N>{
    ConsoleProvidersObservedConfigNested(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleProvidersObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerLoggingObservedConfigNested<N> extends IngressControllerLoggingFluent<IngressControllerLoggingObservedConfigNested<N>> implements Nested<N>{
    IngressControllerLoggingObservedConfigNested(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerLoggingObservedConfig() {
      return and();
    }
    
  
  }
  public class StorageStatusObservedConfigNested<N> extends StorageStatusFluent<StorageStatusObservedConfigNested<N>> implements Nested<N>{
    StorageStatusObservedConfigNested(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStorageStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class AuthenticationSpecObservedConfigNested<N> extends AuthenticationSpecFluent<AuthenticationSpecObservedConfigNested<N>> implements Nested<N>{
    AuthenticationSpecObservedConfigNested(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAuthenticationSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckSpecObservedConfigNested<N> extends PodNetworkConnectivityCheckSpecFluent<PodNetworkConnectivityCheckSpecObservedConfigNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckSpecObservedConfigNested(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerObservedConfigNested<N> extends CSISnapshotControllerFluent<CSISnapshotControllerObservedConfigNested<N>> implements Nested<N>{
    CSISnapshotControllerObservedConfigNested(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogTypesObservedConfigNested<N> extends DeveloperConsoleCatalogTypesFluent<DeveloperConsoleCatalogTypesObservedConfigNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogTypesObservedConfigNested(DeveloperConsoleCatalogTypes item) {
      this.builder = new DeveloperConsoleCatalogTypesBuilder(this, item);
    }
    DeveloperConsoleCatalogTypesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDeveloperConsoleCatalogTypesObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSRecordSpecObservedConfigNested<N> extends DNSRecordSpecFluent<DNSRecordSpecObservedConfigNested<N>> implements Nested<N>{
    DNSRecordSpecObservedConfigNested(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSRecordSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCustomizationObservedConfigNested<N> extends DeveloperConsoleCatalogCustomizationFluent<DeveloperConsoleCatalogCustomizationObservedConfigNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCustomizationObservedConfigNested(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCustomizationObservedConfig() {
      return and();
    }
    
  
  }
  public class LoggingDestinationObservedConfigNested<N> extends LoggingDestinationFluent<LoggingDestinationObservedConfigNested<N>> implements Nested<N>{
    LoggingDestinationObservedConfigNested(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endLoggingDestinationObservedConfig() {
      return and();
    }
    
  
  }
  public class IngressControllerTuningOptionsObservedConfigNested<N> extends IngressControllerTuningOptionsFluent<IngressControllerTuningOptionsObservedConfigNested<N>> implements Nested<N>{
    IngressControllerTuningOptionsObservedConfigNested(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endIngressControllerTuningOptionsObservedConfig() {
      return and();
    }
    
  
  }
  public class StaticIPAMConfigObservedNested<N> extends StaticIPAMConfigFluent<StaticIPAMConfigObservedNested<N>> implements Nested<N>{
    StaticIPAMConfigObservedNested(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStaticIPAMConfigObserved() {
      return and();
    }
    
  
  }
  public class AWSCSIDriverConfigSpecObservedNested<N> extends AWSCSIDriverConfigSpecFluent<AWSCSIDriverConfigSpecObservedNested<N>> implements Nested<N>{
    AWSCSIDriverConfigSpecObservedNested(AWSCSIDriverConfigSpec item) {
      this.builder = new AWSCSIDriverConfigSpecBuilder(this, item);
    }
    AWSCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endAWSCSIDriverConfigSpecObserved() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerSpecObservedConfigNested<N> extends KubeControllerManagerSpecFluent<KubeControllerManagerSpecObservedConfigNested<N>> implements Nested<N>{
    KubeControllerManagerSpecObservedConfigNested(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endKubeControllerManagerSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class StaticIPAMDNSObservedConfigNested<N> extends StaticIPAMDNSFluent<StaticIPAMDNSObservedConfigNested<N>> implements Nested<N>{
    StaticIPAMDNSObservedConfigNested(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStaticIPAMDNSObservedConfig() {
      return and();
    }
    
  
  }
  public class StorageSpecObservedConfigNested<N> extends StorageSpecFluent<StorageSpecObservedConfigNested<N>> implements Nested<N>{
    StorageSpecObservedConfigNested(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStorageSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class NodePlacementObservedConfigNested<N> extends NodePlacementFluent<NodePlacementObservedConfigNested<N>> implements Nested<N>{
    NodePlacementObservedConfigNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNodePlacementObservedConfig() {
      return and();
    }
    
  
  }
  public class NetworkSpecObservedConfigNested<N> extends NetworkSpecFluent<NetworkSpecObservedConfigNested<N>> implements Nested<N>{
    NetworkSpecObservedConfigNested(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetworkSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleStatusObservedConfigNested<N> extends ConsoleStatusFluent<ConsoleStatusObservedConfigNested<N>> implements Nested<N>{
    ConsoleStatusObservedConfigNested(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ObjectReferenceObservedConfigNested<N> extends ObjectReferenceFluent<ObjectReferenceObservedConfigNested<N>> implements Nested<N>{
    ObjectReferenceObservedConfigNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endObjectReferenceObservedConfig() {
      return and();
    }
    
  
  }
  public class ServerObservedConfigNested<N> extends ServerFluent<ServerObservedConfigNested<N>> implements Nested<N>{
    ServerObservedConfigNested(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endServerObservedConfig() {
      return and();
    }
    
  
  }
  public class CloudCredentialSpecObservedConfigNested<N> extends CloudCredentialSpecFluent<CloudCredentialSpecObservedConfigNested<N>> implements Nested<N>{
    CloudCredentialSpecObservedConfigNested(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endCloudCredentialSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSRecordStatusObservedConfigNested<N> extends DNSRecordStatusFluent<DNSRecordStatusObservedConfigNested<N>> implements Nested<N>{
    DNSRecordStatusObservedConfigNested(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSRecordStatusObservedConfig() {
      return and();
    }
    
  
  }
  public class ClusterNetworkEntryObservedConfigNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkEntryObservedConfigNested<N>> implements Nested<N>{
    ClusterNetworkEntryObservedConfigNested(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endClusterNetworkEntryObservedConfig() {
      return and();
    }
    
  
  }
  public class HTTPCompressionPolicyObservedConfigNested<N> extends HTTPCompressionPolicyFluent<HTTPCompressionPolicyObservedConfigNested<N>> implements Nested<N>{
    HTTPCompressionPolicyObservedConfigNested(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endHTTPCompressionPolicyObservedConfig() {
      return and();
    }
    
  
  }
  public class NetFlowConfigObservedNested<N> extends NetFlowConfigFluent<NetFlowConfigObservedNested<N>> implements Nested<N>{
    NetFlowConfigObservedNested(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endNetFlowConfigObserved() {
      return and();
    }
    
  
  }
  public class ProjectAccessObservedConfigNested<N> extends ProjectAccessFluent<ProjectAccessObservedConfigNested<N>> implements Nested<N>{
    ProjectAccessObservedConfigNested(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endProjectAccessObservedConfig() {
      return and();
    }
    
  
  }
  public class GatewayConfigObservedNested<N> extends GatewayConfigFluent<GatewayConfigObservedNested<N>> implements Nested<N>{
    GatewayConfigObservedNested(GatewayConfig item) {
      this.builder = new GatewayConfigBuilder(this, item);
    }
    GatewayConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endGatewayConfigObserved() {
      return and();
    }
    
  
  }
  public class PolicyAuditConfigObservedNested<N> extends PolicyAuditConfigFluent<PolicyAuditConfigObservedNested<N>> implements Nested<N>{
    PolicyAuditConfigObservedNested(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPolicyAuditConfigObserved() {
      return and();
    }
    
  
  }
  public class PerspectiveVisibilityObservedConfigNested<N> extends PerspectiveVisibilityFluent<PerspectiveVisibilityObservedConfigNested<N>> implements Nested<N>{
    PerspectiveVisibilityObservedConfigNested(PerspectiveVisibility item) {
      this.builder = new PerspectiveVisibilityBuilder(this, item);
    }
    PerspectiveVisibilityBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endPerspectiveVisibilityObservedConfig() {
      return and();
    }
    
  
  }
  public class StaticIPAMAddressesObservedConfigNested<N> extends StaticIPAMAddressesFluent<StaticIPAMAddressesObservedConfigNested<N>> implements Nested<N>{
    StaticIPAMAddressesObservedConfigNested(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endStaticIPAMAddressesObservedConfig() {
      return and();
    }
    
  
  }
  public class DNSRecordObservedConfigNested<N> extends DNSRecordFluent<DNSRecordObservedConfigNested<N>> implements Nested<N>{
    DNSRecordObservedConfigNested(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerObservedConfigNested<N> extends OpenShiftAPIServerFluent<OpenShiftAPIServerObservedConfigNested<N>> implements Nested<N>{
    OpenShiftAPIServerObservedConfigNested(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  
  }
  public class ConsoleSpecObservedConfigNested<N> extends ConsoleSpecFluent<ConsoleSpecObservedConfigNested<N>> implements Nested<N>{
    ConsoleSpecObservedConfigNested(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withObservedConfig(builder.build());
    }
    
    public N endConsoleSpecObservedConfig() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerListFluent<ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckStatusFluent<PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImagePrunerUnsupportedConfigOverridesNested<N> extends ImagePrunerFluent<ImagePrunerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNested(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerUnsupportedConfigOverridesNested<N> extends KubeControllerManagerFluent<KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNested(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecUnsupportedConfigOverridesNested<N> extends PodTemplateSpecFluent<PodTemplateSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodTemplateSpecUnsupportedConfigOverridesNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodTemplateSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerStatusUnsupportedConfigOverridesNested<N> extends KubeControllerManagerStatusFluent<KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerStatusUnsupportedConfigOverridesNested(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerStatusFluent<CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerStatusUnsupportedConfigOverridesNested(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCSISnapshotControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IPsecConfigUnsupportedOverridesNested<N> extends IPsecConfigFluent<IPsecConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPsecConfigUnsupportedOverridesNested(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIPsecConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicyFluent<ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNested(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsUnsupportedConfigOverridesNested<N> extends ResourceRequirementsFluent<ResourceRequirementsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ResourceRequirementsUnsupportedConfigOverridesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endResourceRequirementsUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorSpecFluent<KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftSDNConfigUnsupportedOverridesNested<N> extends OpenShiftSDNConfigFluent<OpenShiftSDNConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    OpenShiftSDNConfigUnsupportedOverridesNested(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftSDNConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N> extends IngressControllerHTTPHeadersFluent<IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleListUnsupportedConfigOverridesNested<N> extends ConsoleListFluent<ConsoleListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleListUnsupportedConfigOverridesNested(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<N> extends ServiceAccountIssuerStatusFluent<ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(ServiceAccountIssuerStatus item) {
      this.builder = new ServiceAccountIssuerStatusBuilder(this, item);
    }
    ServiceAccountIssuerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceAccountIssuerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCategoryFluent<DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ExportNetworkFlowsUnsupportedConfigOverridesNested<N> extends ExportNetworkFlowsFluent<ExportNetworkFlowsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ExportNetworkFlowsUnsupportedConfigOverridesNested(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endExportNetworkFlowsUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerSpecFluent<OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverSpecFluent<ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverSpecUnsupportedConfigOverridesNested(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClusterCSIDriverSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N> extends RepositoryDigestMirrorsFluent<RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RepositoryDigestMirrorsUnsupportedConfigOverridesNested(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endRepositoryDigestMirrorsUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleCustomizationUnsupportedConfigOverridesNested<N> extends ConsoleCustomizationFluent<ConsoleCustomizationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleCustomizationUnsupportedConfigOverridesNested(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerSpecFluent<CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerSpecUnsupportedConfigOverridesNested(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCSISnapshotControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class UpstreamResolversUnsupportedConfigOverridesNested<N> extends UpstreamResolversFluent<UpstreamResolversUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    UpstreamResolversUnsupportedConfigOverridesNested(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endUpstreamResolversUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluent<IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class MTUMigrationValuesUnsupportedConfigOverridesNested<N> extends MTUMigrationValuesFluent<MTUMigrationValuesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    MTUMigrationValuesUnsupportedConfigOverridesNested(MTUMigrationValues item) {
      this.builder = new MTUMigrationValuesBuilder(this, item);
    }
    MTUMigrationValuesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endMTUMigrationValuesUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConfigStatusUnsupportedConfigOverridesNested<N> extends ConfigStatusFluent<ConfigStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigStatusUnsupportedConfigOverridesNested(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConfigStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class VSphereCSIDriverConfigSpecUnsupportedOverridesNested<N> extends VSphereCSIDriverConfigSpecFluent<VSphereCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    VSphereCSIDriverConfigSpecUnsupportedOverridesNested(VSphereCSIDriverConfigSpec item) {
      this.builder = new VSphereCSIDriverConfigSpecBuilder(this, item);
    }
    VSphereCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endVSphereCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCAUnsupportedConfigOverridesNested<N> extends ServiceCAFluent<ServiceCAUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAUnsupportedConfigOverridesNested(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCABuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerSpecFluent<ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerListUnsupportedConfigOverridesNested<N> extends IngressControllerListFluent<IngressControllerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerListUnsupportedConfigOverridesNested(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSListUnsupportedConfigOverridesNested<N> extends DNSListFluent<DNSListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSListUnsupportedConfigOverridesNested(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeAPIServerStatusUnsupportedConfigOverridesNested<N> extends KubeAPIServerStatusFluent<KubeAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerStatusUnsupportedConfigOverridesNested(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSClassicLoadBalancerParametersFluent<AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeAPIServerUnsupportedConfigOverridesNested<N> extends KubeAPIServerFluent<KubeAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNested(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleConfigRouteUnsupportedOverridesNested<N> extends ConsoleConfigRouteFluent<ConsoleConfigRouteUnsupportedOverridesNested<N>> implements Nested<N>{
    ConsoleConfigRouteUnsupportedOverridesNested(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleConfigRouteUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerUnsupportedConfigOverridesNested<N> extends IngressControllerFluent<IngressControllerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerUnsupportedConfigOverridesNested(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CloudCredentialStatusUnsupportedConfigOverridesNested<N> extends CloudCredentialStatusFluent<CloudCredentialStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialStatusUnsupportedConfigOverridesNested(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCloudCredentialStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorFluent<KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNested(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerStatusUnsupportedConfigOverridesNested<N> extends IngressControllerStatusFluent<IngressControllerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerStatusUnsupportedConfigOverridesNested(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerStatusFluent<ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImagePrunerListUnsupportedConfigOverridesNested<N> extends ImagePrunerListFluent<ImagePrunerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerListUnsupportedConfigOverridesNested(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImagePrunerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceUnsupportedConfigOverridesNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LocalObjectReferenceUnsupportedConfigOverridesNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endLocalObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N> extends ContainerLoggingDestinationParametersFluent<ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeAPIServerSpecUnsupportedConfigOverridesNested<N> extends KubeAPIServerSpecFluent<KubeAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerSpecUnsupportedConfigOverridesNested(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeSchedulerListUnsupportedConfigOverridesNested<N> extends KubeSchedulerListFluent<KubeSchedulerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerListUnsupportedConfigOverridesNested(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeSchedulerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StaticIPAMRoutesUnsupportedConfigOverridesNested<N> extends StaticIPAMRoutesFluent<StaticIPAMRoutesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMRoutesUnsupportedConfigOverridesNested(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStaticIPAMRoutesUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerFluent<OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNested(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EndpointPublishingStrategyUnsupportedConfigOverridesNested<N> extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EndpointPublishingStrategyUnsupportedConfigOverridesNested(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEndpointPublishingStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CloudCredentialUnsupportedConfigOverridesNested<N> extends CloudCredentialFluent<CloudCredentialUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNested(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeSchedulerUnsupportedConfigOverridesNested<N> extends KubeSchedulerFluent<KubeSchedulerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNested(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverStatusFluent<ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverStatusUnsupportedConfigOverridesNested(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClusterCSIDriverStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class SFlowConfigUnsupportedOverridesNested<N> extends SFlowConfigFluent<SFlowConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    SFlowConfigUnsupportedOverridesNested(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endSFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ForwardPluginUnsupportedConfigOverridesNested<N> extends ForwardPluginFluent<ForwardPluginUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ForwardPluginUnsupportedConfigOverridesNested(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endForwardPluginUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class LogEntryUnsupportedConfigOverridesNested<N> extends LogEntryFluent<LogEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LogEntryUnsupportedConfigOverridesNested(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endLogEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N> extends AdditionalNetworkDefinitionFluent<AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AuthenticationStatusUnsupportedConfigOverridesNested<N> extends AuthenticationStatusFluent<AuthenticationStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationStatusUnsupportedConfigOverridesNested(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAuthenticationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NodePortStrategyUnsupportedConfigOverridesNested<N> extends NodePortStrategyFluent<NodePortStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodePortStrategyUnsupportedConfigOverridesNested(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNodePortStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NetworkUnsupportedConfigOverridesNested<N> extends NetworkFluent<NetworkUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkUnsupportedConfigOverridesNested(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClientTLSUnsupportedConfigOverridesNested<N> extends ClientTLSFluent<ClientTLSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClientTLSUnsupportedConfigOverridesNested(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClientTLSUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImagePrunerStatusUnsupportedConfigOverridesNested<N> extends ImagePrunerStatusFluent<ImagePrunerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerStatusUnsupportedConfigOverridesNested(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImagePrunerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class UpstreamUnsupportedConfigOverridesNested<N> extends UpstreamFluent<UpstreamUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    UpstreamUnsupportedConfigOverridesNested(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endUpstreamUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AzureDiskEncryptionSetUnsupportedConfigOverridesNested<N> extends AzureDiskEncryptionSetFluent<AzureDiskEncryptionSetUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AzureDiskEncryptionSetUnsupportedConfigOverridesNested(AzureDiskEncryptionSet item) {
      this.builder = new AzureDiskEncryptionSetBuilder(this, item);
    }
    AzureDiskEncryptionSetBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAzureDiskEncryptionSetUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerFluent<ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNested(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CSIDriverConfigSpecUnsupportedOverridesNested<N> extends CSIDriverConfigSpecFluent<CSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    CSIDriverConfigSpecUnsupportedOverridesNested(CSIDriverConfigSpec item) {
      this.builder = new CSIDriverConfigSpecBuilder(this, item);
    }
    CSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPHeaderFluent<IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NetworkMigrationUnsupportedConfigOverridesNested<N> extends NetworkMigrationFluent<NetworkMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkMigrationUnsupportedConfigOverridesNested(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetworkMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSRecordListUnsupportedConfigOverridesNested<N> extends DNSRecordListFluent<DNSRecordListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordListUnsupportedConfigOverridesNested(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSRecordListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class RawExtensionUnsupportedConfigOverridesNested<N> extends RawExtensionFluent<RawExtensionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RawExtensionUnsupportedConfigOverridesNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endRawExtensionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EtcdSpecUnsupportedConfigOverridesNested<N> extends EtcdSpecFluent<EtcdSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdSpecUnsupportedConfigOverridesNested(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEtcdSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckFluent<PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class LoadBalancerStrategyUnsupportedConfigOverridesNested<N> extends LoadBalancerStrategyFluent<LoadBalancerStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LoadBalancerStrategyUnsupportedConfigOverridesNested(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endLoadBalancerStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerStatusFluent<OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSOverTLSConfigUnsupportedOverridesNested<N> extends DNSOverTLSConfigFluent<DNSOverTLSConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    DNSOverTLSConfigUnsupportedOverridesNested(DNSOverTLSConfig item) {
      this.builder = new DNSOverTLSConfigBuilder(this, item);
    }
    DNSOverTLSConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSOverTLSConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class CloudCredentialListUnsupportedConfigOverridesNested<N> extends CloudCredentialListFluent<CloudCredentialListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialListUnsupportedConfigOverridesNested(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCloudCredentialListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSCacheUnsupportedConfigOverridesNested<N> extends DNSCacheFluent<DNSCacheUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSCacheUnsupportedConfigOverridesNested(DNSCache item) {
      this.builder = new DNSCacheBuilder(this, item);
    }
    DNSCacheBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSCacheUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImagePrunerSpecUnsupportedConfigOverridesNested<N> extends ImagePrunerSpecFluent<ImagePrunerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerSpecUnsupportedConfigOverridesNested(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImagePrunerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConfigListUnsupportedConfigOverridesNested<N> extends ConfigListFluent<ConfigListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigListUnsupportedConfigOverridesNested(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConfigListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AuthenticationListUnsupportedConfigOverridesNested<N> extends AuthenticationListFluent<AuthenticationListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationListUnsupportedConfigOverridesNested(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAuthenticationListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PinnedResourceReferenceUnsupportedConfigOverridesNested<N> extends PinnedResourceReferenceFluent<PinnedResourceReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PinnedResourceReferenceUnsupportedConfigOverridesNested(PinnedResourceReference item) {
      this.builder = new PinnedResourceReferenceBuilder(this, item);
    }
    PinnedResourceReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPinnedResourceReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerListUnsupportedConfigOverridesNested<N> extends KubeControllerManagerListFluent<KubeControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerListUnsupportedConfigOverridesNested(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IPAMConfigUnsupportedOverridesNested<N> extends IPAMConfigFluent<IPAMConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPAMConfigUnsupportedOverridesNested(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ContainerUnsupportedConfigOverridesNested<N> extends ContainerFluent<ContainerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ContainerUnsupportedConfigOverridesNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endContainerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IBMLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends IBMLoadBalancerParametersFluent<IBMLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IBMLoadBalancerParametersUnsupportedConfigOverridesNested(IBMLoadBalancerParameters item) {
      this.builder = new IBMLoadBalancerParametersBuilder(this, item);
    }
    IBMLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIBMLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AccessLoggingUnsupportedConfigOverridesNested<N> extends AccessLoggingFluent<AccessLoggingUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AccessLoggingUnsupportedConfigOverridesNested(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAccessLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class HostNetworkStrategyUnsupportedConfigOverridesNested<N> extends HostNetworkStrategyFluent<HostNetworkStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    HostNetworkStrategyUnsupportedConfigOverridesNested(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endHostNetworkStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeSchedulerSpecUnsupportedConfigOverridesNested<N> extends KubeSchedulerSpecFluent<KubeSchedulerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerSpecUnsupportedConfigOverridesNested(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeSchedulerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicyListFluent<ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicyListUnsupportedConfigOverridesNested(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImageContentSourcePolicyListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerStatusFluent<OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerStatusFluent<ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSNodePlacementUnsupportedConfigOverridesNested<N> extends DNSNodePlacementFluent<DNSNodePlacementUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSNodePlacementUnsupportedConfigOverridesNested(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NetworkListUnsupportedConfigOverridesNested<N> extends NetworkListFluent<NetworkListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkListUnsupportedConfigOverridesNested(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetworkListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends ProviderLoadBalancerParametersFluent<ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endProviderLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<N> extends ResourceAttributesAccessReviewFluent<ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(ResourceAttributesAccessReview item) {
      this.builder = new ResourceAttributesAccessReviewBuilder(this, item);
    }
    ResourceAttributesAccessReviewBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endResourceAttributesAccessReviewUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCASpecUnsupportedConfigOverridesNested<N> extends ServiceCASpecFluent<ServiceCASpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCASpecUnsupportedConfigOverridesNested(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCASpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PrivateStrategyUnsupportedConfigOverridesNested<N> extends PrivateStrategyFluent<PrivateStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PrivateStrategyUnsupportedConfigOverridesNested(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPrivateStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckListFluent<PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerListUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerListFluent<OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerListUnsupportedConfigOverridesNested(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OAuthAPIServerStatusUnsupportedConfigOverridesNested<N> extends OAuthAPIServerStatusFluent<OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OAuthAPIServerStatusUnsupportedConfigOverridesNested(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOAuthAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class GCPCSIDriverConfigSpecUnsupportedOverridesNested<N> extends GCPCSIDriverConfigSpecFluent<GCPCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    GCPCSIDriverConfigSpecUnsupportedOverridesNested(GCPCSIDriverConfigSpec item) {
      this.builder = new GCPCSIDriverConfigSpecBuilder(this, item);
    }
    GCPCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGCPCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerFluent<ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPCookieFluent<IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSUnsupportedConfigOverridesNested<N> extends DNSFluent<DNSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSUnsupportedConfigOverridesNested(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AddPageUnsupportedConfigOverridesNested<N> extends AddPageFluent<AddPageUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AddPageUnsupportedConfigOverridesNested(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAddPageUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AzureCSIDriverConfigSpecUnsupportedOverridesNested<N> extends AzureCSIDriverConfigSpecFluent<AzureCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    AzureCSIDriverConfigSpecUnsupportedOverridesNested(AzureCSIDriverConfigSpec item) {
      this.builder = new AzureCSIDriverConfigSpecBuilder(this, item);
    }
    AzureCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAzureCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class StorageListUnsupportedConfigOverridesNested<N> extends StorageListFluent<StorageListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageListUnsupportedConfigOverridesNested(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStorageListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AuthenticationUnsupportedConfigOverridesNested<N> extends AuthenticationFluent<AuthenticationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationUnsupportedConfigOverridesNested(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCAStatusUnsupportedConfigOverridesNested<N> extends ServiceCAStatusFluent<ServiceCAStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAStatusUnsupportedConfigOverridesNested(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCAStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class MTUMigrationUnsupportedConfigOverridesNested<N> extends MTUMigrationFluent<MTUMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    MTUMigrationUnsupportedConfigOverridesNested(MTUMigration item) {
      this.builder = new MTUMigrationBuilder(this, item);
    }
    MTUMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endMTUMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PerspectiveUnsupportedConfigOverridesNested<N> extends PerspectiveFluent<PerspectiveUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PerspectiveUnsupportedConfigOverridesNested(Perspective item) {
      this.builder = new PerspectiveBuilder(this, item);
    }
    PerspectiveBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPerspectiveUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class LabelSelectorUnsupportedConfigOverridesNested<N> extends LabelSelectorFluent<LabelSelectorUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LabelSelectorUnsupportedConfigOverridesNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endLabelSelectorUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorListFluent<KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StorageUnsupportedConfigOverridesNested<N> extends StorageFluent<StorageUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageUnsupportedConfigOverridesNested(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerListFluent<ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCategoryMetaFluent<DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OVNKubernetesConfigUnsupportedOverridesNested<N> extends OVNKubernetesConfigFluent<OVNKubernetesConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    OVNKubernetesConfigUnsupportedOverridesNested(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOVNKubernetesConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class DNSSpecUnsupportedConfigOverridesNested<N> extends DNSSpecFluent<DNSSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSSpecUnsupportedConfigOverridesNested(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerSpecUnsupportedConfigOverridesNested<N> extends IngressControllerSpecFluent<IngressControllerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerSpecUnsupportedConfigOverridesNested(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OperatorConditionUnsupportedConfigOverridesNested<N> extends OperatorConditionFluent<OperatorConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OperatorConditionUnsupportedConfigOverridesNested(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOperatorConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ProxyConfigUnsupportedOverridesNested<N> extends ProxyConfigFluent<ProxyConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    ProxyConfigUnsupportedOverridesNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endProxyConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class KuryrConfigUnsupportedOverridesNested<N> extends KuryrConfigFluent<KuryrConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    KuryrConfigUnsupportedOverridesNested(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKuryrConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicySpecFluent<ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endImageContentSourcePolicySpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSStatusUnsupportedConfigOverridesNested<N> extends DNSStatusFluent<DNSStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSStatusUnsupportedConfigOverridesNested(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSTransportConfigUnsupportedOverridesNested<N> extends DNSTransportConfigFluent<DNSTransportConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    DNSTransportConfigUnsupportedOverridesNested(DNSTransportConfig item) {
      this.builder = new DNSTransportConfigBuilder(this, item);
    }
    DNSTransportConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSTransportConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends GCPLoadBalancerParametersFluent<GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GCPLoadBalancerParametersUnsupportedConfigOverridesNested(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGCPLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeAPIServerListUnsupportedConfigOverridesNested<N> extends KubeAPIServerListFluent<KubeAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerListUnsupportedConfigOverridesNested(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConfigUnsupportedConfigOverridesNested<N> extends ConfigFluent<ConfigUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigUnsupportedConfigOverridesNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ObjectMetaUnsupportedConfigOverridesNested<N> extends ObjectMetaFluent<ObjectMetaUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ObjectMetaUnsupportedConfigOverridesNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endObjectMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverListUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverListFluent<ClusterCSIDriverListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverListUnsupportedConfigOverridesNested(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClusterCSIDriverListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class SimpleMacvlanConfigUnsupportedOverridesNested<N> extends SimpleMacvlanConfigFluent<SimpleMacvlanConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    SimpleMacvlanConfigUnsupportedOverridesNested(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endSimpleMacvlanConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceUnsupportedConfigOverridesNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GenericKubernetesResourceUnsupportedConfigOverridesNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGenericKubernetesResourceUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EgressIPConfigUnsupportedOverridesNested<N> extends EgressIPConfigFluent<EgressIPConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    EgressIPConfigUnsupportedOverridesNested(EgressIPConfig item) {
      this.builder = new EgressIPConfigBuilder(this, item);
    }
    EgressIPConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEgressIPConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class HybridOverlayConfigUnsupportedOverridesNested<N> extends HybridOverlayConfigFluent<HybridOverlayConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    HybridOverlayConfigUnsupportedOverridesNested(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endHybridOverlayConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSLoadBalancerParametersFluent<AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSLoadBalancerParametersUnsupportedConfigOverridesNested(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAWSLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerListUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerListFluent<CSISnapshotControllerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerListUnsupportedConfigOverridesNested(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCSISnapshotControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleUnsupportedConfigOverridesNested<N> extends ConsoleFluent<ConsoleUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleUnsupportedConfigOverridesNested(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSZoneConditionUnsupportedConfigOverridesNested<N> extends DNSZoneConditionFluent<DNSZoneConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSZoneConditionUnsupportedConfigOverridesNested(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSZoneConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClusterCSIDriverUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverFluent<ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNested(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class QuickStartsUnsupportedConfigOverridesNested<N> extends QuickStartsFluent<QuickStartsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    QuickStartsUnsupportedConfigOverridesNested(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endQuickStartsUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSZoneStatusUnsupportedConfigOverridesNested<N> extends DNSZoneStatusFluent<DNSZoneStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSZoneStatusUnsupportedConfigOverridesNested(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSZoneStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OutageEntryUnsupportedConfigOverridesNested<N> extends OutageEntryFluent<OutageEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OutageEntryUnsupportedConfigOverridesNested(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOutageEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConfigSpecUnsupportedConfigOverridesNested<N> extends ConfigSpecFluent<ConfigSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigSpecUnsupportedConfigOverridesNested(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConfigSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerListFluent<OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerListUnsupportedConfigOverridesNested(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EtcdUnsupportedConfigOverridesNested<N> extends EtcdFluent<EtcdUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdUnsupportedConfigOverridesNested(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IPFIXConfigUnsupportedOverridesNested<N> extends IPFIXConfigFluent<IPFIXConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPFIXConfigUnsupportedOverridesNested(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIPFIXConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class NetworkStatusUnsupportedConfigOverridesNested<N> extends NetworkStatusFluent<NetworkStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkStatusUnsupportedConfigOverridesNested(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetworkStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckConditionFluent<PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NodeStatusUnsupportedConfigOverridesNested<N> extends NodeStatusFluent<NodeStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodeStatusUnsupportedConfigOverridesNested(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNodeStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class RouteAdmissionPolicyUnsupportedConfigOverridesNested<N> extends RouteAdmissionPolicyFluent<RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RouteAdmissionPolicyUnsupportedConfigOverridesNested(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endRouteAdmissionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class GenerationStatusUnsupportedConfigOverridesNested<N> extends GenerationStatusFluent<GenerationStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GenerationStatusUnsupportedConfigOverridesNested(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGenerationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPHeadersFluent<IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EtcdListUnsupportedConfigOverridesNested<N> extends EtcdListFluent<EtcdListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdListUnsupportedConfigOverridesNested(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEtcdListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class FeaturesMigrationUnsupportedConfigOverridesNested<N> extends FeaturesMigrationFluent<FeaturesMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    FeaturesMigrationUnsupportedConfigOverridesNested(FeaturesMigration item) {
      this.builder = new FeaturesMigrationBuilder(this, item);
    }
    FeaturesMigrationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endFeaturesMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N> extends DefaultNetworkDefinitionFluent<DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DefaultNetworkDefinitionUnsupportedConfigOverridesNested(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDefaultNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class GCPKMSKeyReferenceUnsupportedConfigOverridesNested<N> extends GCPKMSKeyReferenceFluent<GCPKMSKeyReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GCPKMSKeyReferenceUnsupportedConfigOverridesNested(GCPKMSKeyReference item) {
      this.builder = new GCPKMSKeyReferenceBuilder(this, item);
    }
    GCPKMSKeyReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGCPKMSKeyReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerSpecFluent<OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeSchedulerStatusUnsupportedConfigOverridesNested<N> extends KubeSchedulerStatusFluent<KubeSchedulerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerStatusUnsupportedConfigOverridesNested(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeSchedulerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N> extends SyslogLoggingDestinationParametersFluent<SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSNetworkLoadBalancerParametersFluent<AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServiceCAListUnsupportedConfigOverridesNested<N> extends ServiceCAListFluent<ServiceCAListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAListUnsupportedConfigOverridesNested(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServiceCAListUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class EtcdStatusUnsupportedConfigOverridesNested<N> extends EtcdStatusFluent<EtcdStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdStatusUnsupportedConfigOverridesNested(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endEtcdStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StatuspageProviderUnsupportedConfigOverridesNested<N> extends StatuspageProviderFluent<StatuspageProviderUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StatuspageProviderUnsupportedConfigOverridesNested(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStatuspageProviderUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorStatusFluent<KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleProvidersUnsupportedConfigOverridesNested<N> extends ConsoleProvidersFluent<ConsoleProvidersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleProvidersUnsupportedConfigOverridesNested(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleProvidersUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerLoggingUnsupportedConfigOverridesNested<N> extends IngressControllerLoggingFluent<IngressControllerLoggingUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerLoggingUnsupportedConfigOverridesNested(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StorageStatusUnsupportedConfigOverridesNested<N> extends StorageStatusFluent<StorageStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageStatusUnsupportedConfigOverridesNested(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStorageStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class AuthenticationSpecUnsupportedConfigOverridesNested<N> extends AuthenticationSpecFluent<AuthenticationSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationSpecUnsupportedConfigOverridesNested(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAuthenticationSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckSpecFluent<PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerFluent<CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNested(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogTypesFluent<DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(DeveloperConsoleCatalogTypes item) {
      this.builder = new DeveloperConsoleCatalogTypesBuilder(this, item);
    }
    DeveloperConsoleCatalogTypesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDeveloperConsoleCatalogTypesUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSRecordSpecUnsupportedConfigOverridesNested<N> extends DNSRecordSpecFluent<DNSRecordSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordSpecUnsupportedConfigOverridesNested(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSRecordSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCustomizationFluent<DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class LoggingDestinationUnsupportedConfigOverridesNested<N> extends LoggingDestinationFluent<LoggingDestinationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LoggingDestinationUnsupportedConfigOverridesNested(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endLoggingDestinationUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N> extends IngressControllerTuningOptionsFluent<IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerTuningOptionsUnsupportedConfigOverridesNested(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endIngressControllerTuningOptionsUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StaticIPAMConfigUnsupportedOverridesNested<N> extends StaticIPAMConfigFluent<StaticIPAMConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    StaticIPAMConfigUnsupportedOverridesNested(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStaticIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class AWSCSIDriverConfigSpecUnsupportedOverridesNested<N> extends AWSCSIDriverConfigSpecFluent<AWSCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    AWSCSIDriverConfigSpecUnsupportedOverridesNested(AWSCSIDriverConfigSpec item) {
      this.builder = new AWSCSIDriverConfigSpecBuilder(this, item);
    }
    AWSCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endAWSCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class KubeControllerManagerSpecUnsupportedConfigOverridesNested<N> extends KubeControllerManagerSpecFluent<KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerSpecUnsupportedConfigOverridesNested(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endKubeControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StaticIPAMDNSUnsupportedConfigOverridesNested<N> extends StaticIPAMDNSFluent<StaticIPAMDNSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMDNSUnsupportedConfigOverridesNested(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStaticIPAMDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StorageSpecUnsupportedConfigOverridesNested<N> extends StorageSpecFluent<StorageSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageSpecUnsupportedConfigOverridesNested(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStorageSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NodePlacementUnsupportedConfigOverridesNested<N> extends NodePlacementFluent<NodePlacementUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodePlacementUnsupportedConfigOverridesNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NetworkSpecUnsupportedConfigOverridesNested<N> extends NetworkSpecFluent<NetworkSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkSpecUnsupportedConfigOverridesNested(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetworkSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleStatusUnsupportedConfigOverridesNested<N> extends ConsoleStatusFluent<ConsoleStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleStatusUnsupportedConfigOverridesNested(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ObjectReferenceUnsupportedConfigOverridesNested<N> extends ObjectReferenceFluent<ObjectReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ObjectReferenceUnsupportedConfigOverridesNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ServerUnsupportedConfigOverridesNested<N> extends ServerFluent<ServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServerUnsupportedConfigOverridesNested(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endServerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class CloudCredentialSpecUnsupportedConfigOverridesNested<N> extends CloudCredentialSpecFluent<CloudCredentialSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialSpecUnsupportedConfigOverridesNested(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endCloudCredentialSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSRecordStatusUnsupportedConfigOverridesNested<N> extends DNSRecordStatusFluent<DNSRecordStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordStatusUnsupportedConfigOverridesNested(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSRecordStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ClusterNetworkEntryUnsupportedConfigOverridesNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterNetworkEntryUnsupportedConfigOverridesNested(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endClusterNetworkEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class HTTPCompressionPolicyUnsupportedConfigOverridesNested<N> extends HTTPCompressionPolicyFluent<HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    HTTPCompressionPolicyUnsupportedConfigOverridesNested(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endHTTPCompressionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class NetFlowConfigUnsupportedOverridesNested<N> extends NetFlowConfigFluent<NetFlowConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    NetFlowConfigUnsupportedOverridesNested(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endNetFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class ProjectAccessUnsupportedConfigOverridesNested<N> extends ProjectAccessFluent<ProjectAccessUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ProjectAccessUnsupportedConfigOverridesNested(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endProjectAccessUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class GatewayConfigUnsupportedOverridesNested<N> extends GatewayConfigFluent<GatewayConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    GatewayConfigUnsupportedOverridesNested(GatewayConfig item) {
      this.builder = new GatewayConfigBuilder(this, item);
    }
    GatewayConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endGatewayConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class PolicyAuditConfigUnsupportedOverridesNested<N> extends PolicyAuditConfigFluent<PolicyAuditConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    PolicyAuditConfigUnsupportedOverridesNested(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPolicyAuditConfigUnsupportedOverrides() {
      return and();
    }
    
  
  }
  public class PerspectiveVisibilityUnsupportedConfigOverridesNested<N> extends PerspectiveVisibilityFluent<PerspectiveVisibilityUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PerspectiveVisibilityUnsupportedConfigOverridesNested(PerspectiveVisibility item) {
      this.builder = new PerspectiveVisibilityBuilder(this, item);
    }
    PerspectiveVisibilityBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endPerspectiveVisibilityUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class StaticIPAMAddressesUnsupportedConfigOverridesNested<N> extends StaticIPAMAddressesFluent<StaticIPAMAddressesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMAddressesUnsupportedConfigOverridesNested(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endStaticIPAMAddressesUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class DNSRecordUnsupportedConfigOverridesNested<N> extends DNSRecordFluent<DNSRecordUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordUnsupportedConfigOverridesNested(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerFluent<OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNested(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }
  public class ConsoleSpecUnsupportedConfigOverridesNested<N> extends ConsoleSpecFluent<ConsoleSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleSpecUnsupportedConfigOverridesNested(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecBuilder builder;
    
    public N and() {
      return (N) StorageSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    
    public N endConsoleSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  
  }

}