package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageStatusBuilder extends StorageStatusFluent<StorageStatusBuilder> implements VisitableBuilder<StorageStatus,StorageStatusBuilder>{
  public StorageStatusBuilder() {
    this(new StorageStatus());
  }
  
  public StorageStatusBuilder(StorageStatusFluent<?> fluent) {
    this(fluent, new StorageStatus());
  }
  
  public StorageStatusBuilder(StorageStatusFluent<?> fluent,StorageStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageStatusBuilder(StorageStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageStatusFluent<?> fluent;
  
  public StorageStatus build() {
    StorageStatus buildable = new StorageStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}