package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceInstanceBuilder extends ResourceInstanceFluent<ResourceInstanceBuilder> implements VisitableBuilder<ResourceInstance,ResourceInstanceBuilder>{
  public ResourceInstanceBuilder() {
    this(new ResourceInstance());
  }
  
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent) {
    this(fluent, new ResourceInstance());
  }
  
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent,ResourceInstance instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceInstanceBuilder(ResourceInstance instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceInstanceFluent<?> fluent;
  
  public ResourceInstance build() {
    ResourceInstance buildable = new ResourceInstance(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}