package io.fabric8.openshift.api.model.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IPPoolSpecBuilder extends IPPoolSpecFluent<IPPoolSpecBuilder> implements VisitableBuilder<IPPoolSpec,IPPoolSpecBuilder>{
  public IPPoolSpecBuilder() {
    this(new IPPoolSpec());
  }
  
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent) {
    this(fluent, new IPPoolSpec());
  }
  
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent,IPPoolSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IPPoolSpecBuilder(IPPoolSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IPPoolSpecFluent<?> fluent;
  
  public IPPoolSpec build() {
    IPPoolSpec buildable = new IPPoolSpec(fluent.getAllocations(),fluent.getRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}