package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BinaryBuildSourceBuilder extends BinaryBuildSourceFluent<BinaryBuildSourceBuilder> implements VisitableBuilder<BinaryBuildSource,BinaryBuildSourceBuilder>{
  public BinaryBuildSourceBuilder() {
    this(new BinaryBuildSource());
  }
  
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent) {
    this(fluent, new BinaryBuildSource());
  }
  
  public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent,BinaryBuildSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BinaryBuildSourceBuilder(BinaryBuildSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BinaryBuildSourceFluent<?> fluent;
  
  public BinaryBuildSource build() {
    BinaryBuildSource buildable = new BinaryBuildSource(fluent.getAsFile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}