package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HostSubnetBuilder extends HostSubnetFluent<HostSubnetBuilder> implements VisitableBuilder<HostSubnet,HostSubnetBuilder>{
  public HostSubnetBuilder() {
    this(new HostSubnet());
  }
  
  public HostSubnetBuilder(HostSubnetFluent<?> fluent) {
    this(fluent, new HostSubnet());
  }
  
  public HostSubnetBuilder(HostSubnetFluent<?> fluent,HostSubnet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HostSubnetBuilder(HostSubnet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HostSubnetFluent<?> fluent;
  
  public HostSubnet build() {
    HostSubnet buildable = new HostSubnet(fluent.getApiVersion(),fluent.getEgressCIDRs(),fluent.getEgressIPs(),fluent.getHost(),fluent.getHostIP(),fluent.getKind(),fluent.buildMetadata(),fluent.getSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}