package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.Long;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PolicyRuleFluent<A extends PolicyRuleFluent<A>> extends BaseFluent<A>{
  public PolicyRuleFluent() {
  }
  
  public PolicyRuleFluent(PolicyRule instance) {
    this.copyInstance(instance);
  }
  private List<String> apiGroups = new ArrayList<String>();
  private VisitableBuilder<? extends KubernetesResource,?> attributeRestrictions;
  private List<String> nonResourceURLs = new ArrayList<String>();
  private List<String> resourceNames = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private List<String> verbs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PolicyRule instance) {
    instance = (instance != null ? instance : new PolicyRule());
    if (instance != null) {
          this.withApiGroups(instance.getApiGroups());
          this.withAttributeRestrictions(instance.getAttributeRestrictions());
          this.withNonResourceURLs(instance.getNonResourceURLs());
          this.withResourceNames(instance.getResourceNames());
          this.withResources(instance.getResources());
          this.withVerbs(instance.getVerbs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  
  public A setToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  
  public A removeFromApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) return (A)this;
    for (String item : items) { this.apiGroups.remove(item);} return (A)this;
  }
  
  public A removeAllFromApiGroups(Collection<String> items) {
    if (this.apiGroups == null) return (A)this;
    for (String item : items) { this.apiGroups.remove(item);} return (A)this;
  }
  
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  
  public String getApiGroup(int index) {
    return this.apiGroups.get(index);
  }
  
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  
  public String getMatchingApiGroup(Predicate<String> predicate) {
      for (String item : apiGroups) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingApiGroup(Predicate<String> predicate) {
      for (String item : apiGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {
        this.apiGroups = new ArrayList();
        for (String item : apiGroups) {
          this.addToApiGroups(item);
        }
    } else {
      this.apiGroups = null;
    }
    return (A) this;
  }
  
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {
        this.apiGroups.clear();
        _visitables.remove("apiGroups");
    }
    if (apiGroups != null) {
      for (String item : apiGroups) {
        this.addToApiGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasApiGroups() {
    return this.apiGroups != null && !this.apiGroups.isEmpty();
  }
  
  public KubernetesResource buildAttributeRestrictions() {
    return this.attributeRestrictions != null ? this.attributeRestrictions.build() : null;
  }
  
  public A withAttributeRestrictions(KubernetesResource attributeRestrictions) {
    if (attributeRestrictions == null) {
        this.attributeRestrictions = null;
        this._visitables.remove("attributeRestrictions");
        return (A) this;
    } else {
        VisitableBuilder<? extends KubernetesResource,?> builder = builder(attributeRestrictions);;
        this._visitables.clear();
        this._visitables.get("attributeRestrictions").add(builder);
        this.attributeRestrictions = builder;
        return (A) this;
    }
  }
  
  public boolean hasAttributeRestrictions() {
    return this.attributeRestrictions != null;
  }
  
  public GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictions() {
    return new GenericWebHookCauseAttributeRestrictionsNested(null);
  }
  
  public GenericWebHookCauseAttributeRestrictionsNested<A> withNewGenericWebHookCauseAttributeRestrictionsLike(GenericWebHookCause item) {
    return new GenericWebHookCauseAttributeRestrictionsNested(item);
  }
  
  public ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictions() {
    return new ServiceAccountRestrictionAttributeRestrictionsNested(null);
  }
  
  public ServiceAccountRestrictionAttributeRestrictionsNested<A> withNewServiceAccountRestrictionAttributeRestrictionsLike(ServiceAccountRestriction item) {
    return new ServiceAccountRestrictionAttributeRestrictionsNested(item);
  }
  
  public ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictions() {
    return new ScopeRestrictionAttributeRestrictionsNested(null);
  }
  
  public ScopeRestrictionAttributeRestrictionsNested<A> withNewScopeRestrictionAttributeRestrictionsLike(ScopeRestriction item) {
    return new ScopeRestrictionAttributeRestrictionsNested(item);
  }
  
  public SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictions() {
    return new SecretLocalReferenceAttributeRestrictionsNested(null);
  }
  
  public SecretLocalReferenceAttributeRestrictionsNested<A> withNewSecretLocalReferenceAttributeRestrictionsLike(SecretLocalReference item) {
    return new SecretLocalReferenceAttributeRestrictionsNested(item);
  }
  
  public A withNewSecretLocalReferenceAttributeRestrictions(String name) {
    return (A)withAttributeRestrictions(new SecretLocalReference(name));
  }
  
  public StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictions() {
    return new StepInfoAttributeRestrictionsNested(null);
  }
  
  public StepInfoAttributeRestrictionsNested<A> withNewStepInfoAttributeRestrictionsLike(StepInfo item) {
    return new StepInfoAttributeRestrictionsNested(item);
  }
  
  public A withNewStepInfoAttributeRestrictions(Long durationMilliseconds,String name,String startTime) {
    return (A)withAttributeRestrictions(new StepInfo(durationMilliseconds, name, startTime));
  }
  
  public UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictions() {
    return new UserRestrictionAttributeRestrictionsNested(null);
  }
  
  public UserRestrictionAttributeRestrictionsNested<A> withNewUserRestrictionAttributeRestrictionsLike(UserRestriction item) {
    return new UserRestrictionAttributeRestrictionsNested(item);
  }
  
  public PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictions() {
    return new PodTemplateSpecAttributeRestrictionsNested(null);
  }
  
  public PodTemplateSpecAttributeRestrictionsNested<A> withNewPodTemplateSpecAttributeRestrictionsLike(PodTemplateSpec item) {
    return new PodTemplateSpecAttributeRestrictionsNested(item);
  }
  
  public ProjectHelmChartRepositoryAttributeRestrictionsNested<A> withNewProjectHelmChartRepositoryAttributeRestrictions() {
    return new ProjectHelmChartRepositoryAttributeRestrictionsNested(null);
  }
  
  public ProjectHelmChartRepositoryAttributeRestrictionsNested<A> withNewProjectHelmChartRepositoryAttributeRestrictionsLike(ProjectHelmChartRepository item) {
    return new ProjectHelmChartRepositoryAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictions() {
    return new TemplateInstanceListAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceListAttributeRestrictionsNested<A> withNewTemplateInstanceListAttributeRestrictionsLike(TemplateInstanceList item) {
    return new TemplateInstanceListAttributeRestrictionsNested(item);
  }
  
  public ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions() {
    return new ImageStreamImportAttributeRestrictionsNested(null);
  }
  
  public ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item) {
    return new ImageStreamImportAttributeRestrictionsNested(item);
  }
  
  public ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictions() {
    return new ResourceRequirementsAttributeRestrictionsNested(null);
  }
  
  public ResourceRequirementsAttributeRestrictionsNested<A> withNewResourceRequirementsAttributeRestrictionsLike(ResourceRequirements item) {
    return new ResourceRequirementsAttributeRestrictionsNested(item);
  }
  
  public GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictions() {
    return new GitHubWebHookCauseAttributeRestrictionsNested(null);
  }
  
  public GitHubWebHookCauseAttributeRestrictionsNested<A> withNewGitHubWebHookCauseAttributeRestrictionsLike(GitHubWebHookCause item) {
    return new GitHubWebHookCauseAttributeRestrictionsNested(item);
  }
  
  public OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictions() {
    return new OAuthClientListAttributeRestrictionsNested(null);
  }
  
  public OAuthClientListAttributeRestrictionsNested<A> withNewOAuthClientListAttributeRestrictionsLike(OAuthClientList item) {
    return new OAuthClientListAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new PodSecurityPolicyReviewStatusAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewStatusAttributeRestrictionsLike(PodSecurityPolicyReviewStatus item) {
    return new PodSecurityPolicyReviewStatusAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictions() {
    return new TemplateInstanceStatusAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceStatusAttributeRestrictionsNested<A> withNewTemplateInstanceStatusAttributeRestrictionsLike(TemplateInstanceStatus item) {
    return new TemplateInstanceStatusAttributeRestrictionsNested(item);
  }
  
  public HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictions() {
    return new HelmChartRepositoryListAttributeRestrictionsNested(null);
  }
  
  public HelmChartRepositoryListAttributeRestrictionsNested<A> withNewHelmChartRepositoryListAttributeRestrictionsLike(HelmChartRepositoryList item) {
    return new HelmChartRepositoryListAttributeRestrictionsNested(item);
  }
  
  public PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictions() {
    return new PolicyRuleAttributeRestrictionsNested(null);
  }
  
  public PolicyRuleAttributeRestrictionsNested<A> withNewPolicyRuleAttributeRestrictionsLike(PolicyRule item) {
    return new PolicyRuleAttributeRestrictionsNested(item);
  }
  
  public DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictions() {
    return new DeploymentTriggerPolicyAttributeRestrictionsNested(null);
  }
  
  public DeploymentTriggerPolicyAttributeRestrictionsNested<A> withNewDeploymentTriggerPolicyAttributeRestrictionsLike(DeploymentTriggerPolicy item) {
    return new DeploymentTriggerPolicyAttributeRestrictionsNested(item);
  }
  
  public BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictions() {
    return new BuildStrategyAttributeRestrictionsNested(null);
  }
  
  public BuildStrategyAttributeRestrictionsNested<A> withNewBuildStrategyAttributeRestrictionsLike(BuildStrategy item) {
    return new BuildStrategyAttributeRestrictionsNested(item);
  }
  
  public RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictions() {
    return new RepositoryImportSpecAttributeRestrictionsNested(null);
  }
  
  public RepositoryImportSpecAttributeRestrictionsNested<A> withNewRepositoryImportSpecAttributeRestrictionsLike(RepositoryImportSpec item) {
    return new RepositoryImportSpecAttributeRestrictionsNested(item);
  }
  
  public BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictions() {
    return new BrokerTemplateInstanceListAttributeRestrictionsNested(null);
  }
  
  public BrokerTemplateInstanceListAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceListAttributeRestrictionsLike(BrokerTemplateInstanceList item) {
    return new BrokerTemplateInstanceListAttributeRestrictionsNested(item);
  }
  
  public ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictions() {
    return new ImageStreamImportStatusAttributeRestrictionsNested(null);
  }
  
  public ImageStreamImportStatusAttributeRestrictionsNested<A> withNewImageStreamImportStatusAttributeRestrictionsLike(ImageStreamImportStatus item) {
    return new ImageStreamImportStatusAttributeRestrictionsNested(item);
  }
  
  public CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictions() {
    return new CustomBuildStrategyAttributeRestrictionsNested(null);
  }
  
  public CustomBuildStrategyAttributeRestrictionsNested<A> withNewCustomBuildStrategyAttributeRestrictionsLike(CustomBuildStrategy item) {
    return new CustomBuildStrategyAttributeRestrictionsNested(item);
  }
  
  public ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictions() {
    return new ClusterResourceQuotaSelectorAttributeRestrictionsNested(null);
  }
  
  public ClusterResourceQuotaSelectorAttributeRestrictionsNested<A> withNewClusterResourceQuotaSelectorAttributeRestrictionsLike(ClusterResourceQuotaSelector item) {
    return new ClusterResourceQuotaSelectorAttributeRestrictionsNested(item);
  }
  
  public SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictions() {
    return new SubjectAccessReviewResponseAttributeRestrictionsNested(null);
  }
  
  public SubjectAccessReviewResponseAttributeRestrictionsNested<A> withNewSubjectAccessReviewResponseAttributeRestrictionsLike(SubjectAccessReviewResponse item) {
    return new SubjectAccessReviewResponseAttributeRestrictionsNested(item);
  }
  
  public DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictions() {
    return new DeploymentTriggerImageChangeParamsAttributeRestrictionsNested(null);
  }
  
  public DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<A> withNewDeploymentTriggerImageChangeParamsAttributeRestrictionsLike(DeploymentTriggerImageChangeParams item) {
    return new DeploymentTriggerImageChangeParamsAttributeRestrictionsNested(item);
  }
  
  public LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictions() {
    return new LocalObjectReferenceAttributeRestrictionsNested(null);
  }
  
  public LocalObjectReferenceAttributeRestrictionsNested<A> withNewLocalObjectReferenceAttributeRestrictionsLike(LocalObjectReference item) {
    return new LocalObjectReferenceAttributeRestrictionsNested(item);
  }
  
  public A withNewLocalObjectReferenceAttributeRestrictions(String name) {
    return (A)withAttributeRestrictions(new LocalObjectReference(name));
  }
  
  public TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictions() {
    return new TagImageHookAttributeRestrictionsNested(null);
  }
  
  public TagImageHookAttributeRestrictionsNested<A> withNewTagImageHookAttributeRestrictionsLike(TagImageHook item) {
    return new TagImageHookAttributeRestrictionsNested(item);
  }
  
  public RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictions() {
    return new RouteTargetReferenceAttributeRestrictionsNested(null);
  }
  
  public RouteTargetReferenceAttributeRestrictionsNested<A> withNewRouteTargetReferenceAttributeRestrictionsLike(RouteTargetReference item) {
    return new RouteTargetReferenceAttributeRestrictionsNested(item);
  }
  
  public A withNewRouteTargetReferenceAttributeRestrictions(String kind,String name,Integer weight) {
    return (A)withAttributeRestrictions(new RouteTargetReference(kind, name, weight));
  }
  
  public SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictions() {
    return new SubjectRulesReviewSpecAttributeRestrictionsNested(null);
  }
  
  public SubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSubjectRulesReviewSpecAttributeRestrictionsLike(SubjectRulesReviewSpec item) {
    return new SubjectRulesReviewSpecAttributeRestrictionsNested(item);
  }
  
  public OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewOpenshiftRawExtensionAttributeRestrictions() {
    return new OpenshiftRawExtensionAttributeRestrictionsNested(null);
  }
  
  public OpenshiftRawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(io.fabric8.openshift.api.model.runtime.RawExtension item) {
    return new OpenshiftRawExtensionAttributeRestrictionsNested(item);
  }
  
  public A withNewOpenshiftRawExtensionAttributeRestrictions(Object value) {
    return (A)withAttributeRestrictions(new io.fabric8.openshift.api.model.runtime.RawExtension(value));
  }
  
  public RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictions() {
    return new RoleListAttributeRestrictionsNested(null);
  }
  
  public RoleListAttributeRestrictionsNested<A> withNewRoleListAttributeRestrictionsLike(RoleList item) {
    return new RoleListAttributeRestrictionsNested(item);
  }
  
  public TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictions() {
    return new TagReferencePolicyAttributeRestrictionsNested(null);
  }
  
  public TagReferencePolicyAttributeRestrictionsNested<A> withNewTagReferencePolicyAttributeRestrictionsLike(TagReferencePolicy item) {
    return new TagReferencePolicyAttributeRestrictionsNested(item);
  }
  
  public A withNewTagReferencePolicyAttributeRestrictions(String type) {
    return (A)withAttributeRestrictions(new TagReferencePolicy(type));
  }
  
  public ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions() {
    return new ProjectAttributeRestrictionsNested(null);
  }
  
  public ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item) {
    return new ProjectAttributeRestrictionsNested(item);
  }
  
  public BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictions() {
    return new BuildVolumeSourceAttributeRestrictionsNested(null);
  }
  
  public BuildVolumeSourceAttributeRestrictionsNested<A> withNewBuildVolumeSourceAttributeRestrictionsLike(BuildVolumeSource item) {
    return new BuildVolumeSourceAttributeRestrictionsNested(item);
  }
  
  public AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictions() {
    return new AppliedClusterResourceQuotaListAttributeRestrictionsNested(null);
  }
  
  public AppliedClusterResourceQuotaListAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaListAttributeRestrictionsLike(AppliedClusterResourceQuotaList item) {
    return new AppliedClusterResourceQuotaListAttributeRestrictionsNested(item);
  }
  
  public BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictions() {
    return new BuildStatusOutputAttributeRestrictionsNested(null);
  }
  
  public BuildStatusOutputAttributeRestrictionsNested<A> withNewBuildStatusOutputAttributeRestrictionsLike(BuildStatusOutput item) {
    return new BuildStatusOutputAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictions() {
    return new DeploymentConfigListAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigListAttributeRestrictionsNested<A> withNewDeploymentConfigListAttributeRestrictionsLike(DeploymentConfigList item) {
    return new DeploymentConfigListAttributeRestrictionsNested(item);
  }
  
  public BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions() {
    return new BuildConfigAttributeRestrictionsNested(null);
  }
  
  public BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item) {
    return new BuildConfigAttributeRestrictionsNested(item);
  }
  
  public ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictions() {
    return new ImageImportStatusAttributeRestrictionsNested(null);
  }
  
  public ImageImportStatusAttributeRestrictionsNested<A> withNewImageImportStatusAttributeRestrictionsLike(ImageImportStatus item) {
    return new ImageImportStatusAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictions() {
    return new PodSecurityPolicySubjectReviewAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicySubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewAttributeRestrictionsLike(PodSecurityPolicySubjectReview item) {
    return new PodSecurityPolicySubjectReviewAttributeRestrictionsNested(item);
  }
  
  public GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictions() {
    return new GitLabWebHookCauseAttributeRestrictionsNested(null);
  }
  
  public GitLabWebHookCauseAttributeRestrictionsNested<A> withNewGitLabWebHookCauseAttributeRestrictionsLike(GitLabWebHookCause item) {
    return new GitLabWebHookCauseAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictions() {
    return new DeploymentConfigStatusAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigStatusAttributeRestrictionsNested<A> withNewDeploymentConfigStatusAttributeRestrictionsLike(DeploymentConfigStatus item) {
    return new DeploymentConfigStatusAttributeRestrictionsNested(item);
  }
  
  public SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictions() {
    return new SecretBuildSourceAttributeRestrictionsNested(null);
  }
  
  public SecretBuildSourceAttributeRestrictionsNested<A> withNewSecretBuildSourceAttributeRestrictionsLike(SecretBuildSource item) {
    return new SecretBuildSourceAttributeRestrictionsNested(item);
  }
  
  public EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictions() {
    return new EgressNetworkPolicySpecAttributeRestrictionsNested(null);
  }
  
  public EgressNetworkPolicySpecAttributeRestrictionsNested<A> withNewEgressNetworkPolicySpecAttributeRestrictionsLike(EgressNetworkPolicySpec item) {
    return new EgressNetworkPolicySpecAttributeRestrictionsNested(item);
  }
  
  public HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions() {
    return new HelmChartRepositoryAttributeRestrictionsNested(null);
  }
  
  public HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(HelmChartRepository item) {
    return new HelmChartRepositoryAttributeRestrictionsNested(item);
  }
  
  public TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictions() {
    return new TagEventAttributeRestrictionsNested(null);
  }
  
  public TagEventAttributeRestrictionsNested<A> withNewTagEventAttributeRestrictionsLike(TagEvent item) {
    return new TagEventAttributeRestrictionsNested(item);
  }
  
  public A withNewTagEventAttributeRestrictions(String created,String dockerImageReference,Long generation,String image) {
    return (A)withAttributeRestrictions(new TagEvent(created, dockerImageReference, generation, image));
  }
  
  public BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictions() {
    return new BitbucketWebHookCauseAttributeRestrictionsNested(null);
  }
  
  public BitbucketWebHookCauseAttributeRestrictionsNested<A> withNewBitbucketWebHookCauseAttributeRestrictionsLike(BitbucketWebHookCause item) {
    return new BitbucketWebHookCauseAttributeRestrictionsNested(item);
  }
  
  public ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictions() {
    return new ImageStreamTagListAttributeRestrictionsNested(null);
  }
  
  public ImageStreamTagListAttributeRestrictionsNested<A> withNewImageStreamTagListAttributeRestrictionsLike(ImageStreamTagList item) {
    return new ImageStreamTagListAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigRollbackSpecAttributeRestrictionsNested<A> withNewDeploymentConfigRollbackSpecAttributeRestrictions() {
    return new DeploymentConfigRollbackSpecAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigRollbackSpecAttributeRestrictionsNested<A> withNewDeploymentConfigRollbackSpecAttributeRestrictionsLike(DeploymentConfigRollbackSpec item) {
    return new DeploymentConfigRollbackSpecAttributeRestrictionsNested(item);
  }
  
  public ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictions() {
    return new ProjectListAttributeRestrictionsNested(null);
  }
  
  public ProjectListAttributeRestrictionsNested<A> withNewProjectListAttributeRestrictionsLike(ProjectList item) {
    return new ProjectListAttributeRestrictionsNested(item);
  }
  
  public ProjectHelmChartRepositorySpecAttributeRestrictionsNested<A> withNewProjectHelmChartRepositorySpecAttributeRestrictions() {
    return new ProjectHelmChartRepositorySpecAttributeRestrictionsNested(null);
  }
  
  public ProjectHelmChartRepositorySpecAttributeRestrictionsNested<A> withNewProjectHelmChartRepositorySpecAttributeRestrictionsLike(ProjectHelmChartRepositorySpec item) {
    return new ProjectHelmChartRepositorySpecAttributeRestrictionsNested(item);
  }
  
  public ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictions() {
    return new ClusterRoleScopeRestrictionAttributeRestrictionsNested(null);
  }
  
  public ClusterRoleScopeRestrictionAttributeRestrictionsNested<A> withNewClusterRoleScopeRestrictionAttributeRestrictionsLike(ClusterRoleScopeRestriction item) {
    return new ClusterRoleScopeRestrictionAttributeRestrictionsNested(item);
  }
  
  public RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions() {
    return new RangeAllocationAttributeRestrictionsNested(null);
  }
  
  public RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item) {
    return new RangeAllocationAttributeRestrictionsNested(item);
  }
  
  public RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions() {
    return new RouteAttributeRestrictionsNested(null);
  }
  
  public RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item) {
    return new RouteAttributeRestrictionsNested(item);
  }
  
  public SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictions() {
    return new SourceStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public SourceStrategyOptionsAttributeRestrictionsNested<A> withNewSourceStrategyOptionsAttributeRestrictionsLike(SourceStrategyOptions item) {
    return new SourceStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public A withNewSourceStrategyOptionsAttributeRestrictions(Boolean incremental) {
    return (A)withAttributeRestrictions(new SourceStrategyOptions(incremental));
  }
  
  public ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions() {
    return new ClusterNetworkAttributeRestrictionsNested(null);
  }
  
  public ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item) {
    return new ClusterNetworkAttributeRestrictionsNested(item);
  }
  
  public OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions() {
    return new OAuthAuthorizeTokenAttributeRestrictionsNested(null);
  }
  
  public OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenAttributeRestrictionsNested(item);
  }
  
  public DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictions() {
    return new DockerBuildStrategyAttributeRestrictionsNested(null);
  }
  
  public DockerBuildStrategyAttributeRestrictionsNested<A> withNewDockerBuildStrategyAttributeRestrictionsLike(DockerBuildStrategy item) {
    return new DockerBuildStrategyAttributeRestrictionsNested(item);
  }
  
  public SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictions() {
    return new SignatureConditionAttributeRestrictionsNested(null);
  }
  
  public SignatureConditionAttributeRestrictionsNested<A> withNewSignatureConditionAttributeRestrictionsLike(SignatureCondition item) {
    return new SignatureConditionAttributeRestrictionsNested(item);
  }
  
  public UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions() {
    return new UserOAuthAccessTokenAttributeRestrictionsNested(null);
  }
  
  public UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenAttributeRestrictionsNested(item);
  }
  
  public ConnectionConfigNamespaceScopedAttributeRestrictionsNested<A> withNewConnectionConfigNamespaceScopedAttributeRestrictions() {
    return new ConnectionConfigNamespaceScopedAttributeRestrictionsNested(null);
  }
  
  public ConnectionConfigNamespaceScopedAttributeRestrictionsNested<A> withNewConnectionConfigNamespaceScopedAttributeRestrictionsLike(ConnectionConfigNamespaceScoped item) {
    return new ConnectionConfigNamespaceScopedAttributeRestrictionsNested(item);
  }
  
  public RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictions() {
    return new RoleBindingRestrictionListAttributeRestrictionsNested(null);
  }
  
  public RoleBindingRestrictionListAttributeRestrictionsNested<A> withNewRoleBindingRestrictionListAttributeRestrictionsLike(RoleBindingRestrictionList item) {
    return new RoleBindingRestrictionListAttributeRestrictionsNested(item);
  }
  
  public RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictions() {
    return new RawExtensionAttributeRestrictionsNested(null);
  }
  
  public RawExtensionAttributeRestrictionsNested<A> withNewRawExtensionAttributeRestrictionsLike(RawExtension item) {
    return new RawExtensionAttributeRestrictionsNested(item);
  }
  
  public A withNewRawExtensionAttributeRestrictions(Object value) {
    return (A)withAttributeRestrictions(new RawExtension(value));
  }
  
  public ImageManifestAttributeRestrictionsNested<A> withNewImageManifestAttributeRestrictions() {
    return new ImageManifestAttributeRestrictionsNested(null);
  }
  
  public ImageManifestAttributeRestrictionsNested<A> withNewImageManifestAttributeRestrictionsLike(ImageManifest item) {
    return new ImageManifestAttributeRestrictionsNested(item);
  }
  
  public SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictions() {
    return new SecurityContextConstraintsListAttributeRestrictionsNested(null);
  }
  
  public SecurityContextConstraintsListAttributeRestrictionsNested<A> withNewSecurityContextConstraintsListAttributeRestrictionsLike(SecurityContextConstraintsList item) {
    return new SecurityContextConstraintsListAttributeRestrictionsNested(item);
  }
  
  public BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictions() {
    return new BuildConfigListAttributeRestrictionsNested(null);
  }
  
  public BuildConfigListAttributeRestrictionsNested<A> withNewBuildConfigListAttributeRestrictionsLike(BuildConfigList item) {
    return new BuildConfigListAttributeRestrictionsNested(item);
  }
  
  public IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictions() {
    return new IdentityListAttributeRestrictionsNested(null);
  }
  
  public IdentityListAttributeRestrictionsNested<A> withNewIdentityListAttributeRestrictionsLike(IdentityList item) {
    return new IdentityListAttributeRestrictionsNested(item);
  }
  
  public ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictions() {
    return new ClusterNetworkListAttributeRestrictionsNested(null);
  }
  
  public ClusterNetworkListAttributeRestrictionsNested<A> withNewClusterNetworkListAttributeRestrictionsLike(ClusterNetworkList item) {
    return new ClusterNetworkListAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictions() {
    return new TemplateInstanceConditionAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceConditionAttributeRestrictionsNested<A> withNewTemplateInstanceConditionAttributeRestrictionsLike(TemplateInstanceCondition item) {
    return new TemplateInstanceConditionAttributeRestrictionsNested(item);
  }
  
  public A withNewTemplateInstanceConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withAttributeRestrictions(new TemplateInstanceCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictions() {
    return new DeploymentCauseAttributeRestrictionsNested(null);
  }
  
  public DeploymentCauseAttributeRestrictionsNested<A> withNewDeploymentCauseAttributeRestrictionsLike(DeploymentCause item) {
    return new DeploymentCauseAttributeRestrictionsNested(item);
  }
  
  public RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictions() {
    return new RepositoryImportStatusAttributeRestrictionsNested(null);
  }
  
  public RepositoryImportStatusAttributeRestrictionsNested<A> withNewRepositoryImportStatusAttributeRestrictionsLike(RepositoryImportStatus item) {
    return new RepositoryImportStatusAttributeRestrictionsNested(item);
  }
  
  public GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictions() {
    return new GroupListAttributeRestrictionsNested(null);
  }
  
  public GroupListAttributeRestrictionsNested<A> withNewGroupListAttributeRestrictionsLike(GroupList item) {
    return new GroupListAttributeRestrictionsNested(item);
  }
  
  public RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictions() {
    return new RunAsUserStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public RunAsUserStrategyOptionsAttributeRestrictionsNested<A> withNewRunAsUserStrategyOptionsAttributeRestrictionsLike(RunAsUserStrategyOptions item) {
    return new RunAsUserStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public A withNewRunAsUserStrategyOptionsAttributeRestrictions(String type,Long uid,Long uidRangeMax,Long uidRangeMin) {
    return (A)withAttributeRestrictions(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
  }
  
  public LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictions() {
    return new LifecycleHookAttributeRestrictionsNested(null);
  }
  
  public LifecycleHookAttributeRestrictionsNested<A> withNewLifecycleHookAttributeRestrictionsLike(LifecycleHook item) {
    return new LifecycleHookAttributeRestrictionsNested(item);
  }
  
  public ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictions() {
    return new ImageStreamTagReferenceAttributeRestrictionsNested(null);
  }
  
  public ImageStreamTagReferenceAttributeRestrictionsNested<A> withNewImageStreamTagReferenceAttributeRestrictionsLike(ImageStreamTagReference item) {
    return new ImageStreamTagReferenceAttributeRestrictionsNested(item);
  }
  
  public A withNewImageStreamTagReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withAttributeRestrictions(new ImageStreamTagReference(name, namespace));
  }
  
  public SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictions() {
    return new SourceControlUserAttributeRestrictionsNested(null);
  }
  
  public SourceControlUserAttributeRestrictionsNested<A> withNewSourceControlUserAttributeRestrictionsLike(SourceControlUser item) {
    return new SourceControlUserAttributeRestrictionsNested(item);
  }
  
  public A withNewSourceControlUserAttributeRestrictions(String email,String name) {
    return (A)withAttributeRestrictions(new SourceControlUser(email, name));
  }
  
  public ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictions() {
    return new ContainerAttributeRestrictionsNested(null);
  }
  
  public ContainerAttributeRestrictionsNested<A> withNewContainerAttributeRestrictionsLike(Container item) {
    return new ContainerAttributeRestrictionsNested(item);
  }
  
  public ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictions() {
    return new ImageStreamListAttributeRestrictionsNested(null);
  }
  
  public ImageStreamListAttributeRestrictionsNested<A> withNewImageStreamListAttributeRestrictionsLike(ImageStreamList item) {
    return new ImageStreamListAttributeRestrictionsNested(item);
  }
  
  public ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions() {
    return new ClusterRoleBindingAttributeRestrictionsNested(null);
  }
  
  public ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item) {
    return new ClusterRoleBindingAttributeRestrictionsNested(item);
  }
  
  public ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictions() {
    return new ResourceAccessReviewAttributeRestrictionsNested(null);
  }
  
  public ResourceAccessReviewAttributeRestrictionsNested<A> withNewResourceAccessReviewAttributeRestrictionsLike(ResourceAccessReview item) {
    return new ResourceAccessReviewAttributeRestrictionsNested(item);
  }
  
  public SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictions() {
    return new SelfSubjectRulesReviewAttributeRestrictionsNested(null);
  }
  
  public SelfSubjectRulesReviewAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewAttributeRestrictionsLike(SelfSubjectRulesReview item) {
    return new SelfSubjectRulesReviewAttributeRestrictionsNested(item);
  }
  
  public UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictions() {
    return new UserOAuthAccessTokenListAttributeRestrictionsNested(null);
  }
  
  public UserOAuthAccessTokenListAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenListAttributeRestrictionsLike(UserOAuthAccessTokenList item) {
    return new UserOAuthAccessTokenListAttributeRestrictionsNested(item);
  }
  
  public ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictions() {
    return new ImageChangeTriggerStatusAttributeRestrictionsNested(null);
  }
  
  public ImageChangeTriggerStatusAttributeRestrictionsNested<A> withNewImageChangeTriggerStatusAttributeRestrictionsLike(ImageChangeTriggerStatus item) {
    return new ImageChangeTriggerStatusAttributeRestrictionsNested(item);
  }
  
  public RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictions() {
    return new RouteStatusAttributeRestrictionsNested(null);
  }
  
  public RouteStatusAttributeRestrictionsNested<A> withNewRouteStatusAttributeRestrictionsLike(RouteStatus item) {
    return new RouteStatusAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigRollbackAttributeRestrictionsNested<A> withNewDeploymentConfigRollbackAttributeRestrictions() {
    return new DeploymentConfigRollbackAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigRollbackAttributeRestrictionsNested<A> withNewDeploymentConfigRollbackAttributeRestrictionsLike(DeploymentConfigRollback item) {
    return new DeploymentConfigRollbackAttributeRestrictionsNested(item);
  }
  
  public ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions() {
    return new ClusterResourceQuotaAttributeRestrictionsNested(null);
  }
  
  public ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item) {
    return new ClusterResourceQuotaAttributeRestrictionsNested(item);
  }
  
  public NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictions() {
    return new NamedTagEventListAttributeRestrictionsNested(null);
  }
  
  public NamedTagEventListAttributeRestrictionsNested<A> withNewNamedTagEventListAttributeRestrictionsLike(NamedTagEventList item) {
    return new NamedTagEventListAttributeRestrictionsNested(item);
  }
  
  public ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictions() {
    return new ClusterResourceQuotaListAttributeRestrictionsNested(null);
  }
  
  public ClusterResourceQuotaListAttributeRestrictionsNested<A> withNewClusterResourceQuotaListAttributeRestrictionsLike(ClusterResourceQuotaList item) {
    return new ClusterResourceQuotaListAttributeRestrictionsNested(item);
  }
  
  public RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictions() {
    return new RouteSpecAttributeRestrictionsNested(null);
  }
  
  public RouteSpecAttributeRestrictionsNested<A> withNewRouteSpecAttributeRestrictionsLike(RouteSpec item) {
    return new RouteSpecAttributeRestrictionsNested(item);
  }
  
  public ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions() {
    return new ProjectRequestAttributeRestrictionsNested(null);
  }
  
  public ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item) {
    return new ProjectRequestAttributeRestrictionsNested(item);
  }
  
  public TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions() {
    return new TemplateAttributeRestrictionsNested(null);
  }
  
  public TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item) {
    return new TemplateAttributeRestrictionsNested(item);
  }
  
  public ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictions() {
    return new ImageLookupPolicyAttributeRestrictionsNested(null);
  }
  
  public ImageLookupPolicyAttributeRestrictionsNested<A> withNewImageLookupPolicyAttributeRestrictionsLike(ImageLookupPolicy item) {
    return new ImageLookupPolicyAttributeRestrictionsNested(item);
  }
  
  public A withNewImageLookupPolicyAttributeRestrictions(Boolean local) {
    return (A)withAttributeRestrictions(new ImageLookupPolicy(local));
  }
  
  public OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions() {
    return new OAuthClientAuthorizationAttributeRestrictionsNested(null);
  }
  
  public OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item) {
    return new OAuthClientAuthorizationAttributeRestrictionsNested(item);
  }
  
  public ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictions() {
    return new ImageChangeCauseAttributeRestrictionsNested(null);
  }
  
  public ImageChangeCauseAttributeRestrictionsNested<A> withNewImageChangeCauseAttributeRestrictionsLike(ImageChangeCause item) {
    return new ImageChangeCauseAttributeRestrictionsNested(item);
  }
  
  public AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictions() {
    return new AllowedFlexVolumeAttributeRestrictionsNested(null);
  }
  
  public AllowedFlexVolumeAttributeRestrictionsNested<A> withNewAllowedFlexVolumeAttributeRestrictionsLike(AllowedFlexVolume item) {
    return new AllowedFlexVolumeAttributeRestrictionsNested(item);
  }
  
  public A withNewAllowedFlexVolumeAttributeRestrictions(String driver) {
    return (A)withAttributeRestrictions(new AllowedFlexVolume(driver));
  }
  
  public SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictions() {
    return new SubjectAccessReviewAttributeRestrictionsNested(null);
  }
  
  public SubjectAccessReviewAttributeRestrictionsNested<A> withNewSubjectAccessReviewAttributeRestrictionsLike(SubjectAccessReview item) {
    return new SubjectAccessReviewAttributeRestrictionsNested(item);
  }
  
  public LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictions() {
    return new LocalResourceAccessReviewAttributeRestrictionsNested(null);
  }
  
  public LocalResourceAccessReviewAttributeRestrictionsNested<A> withNewLocalResourceAccessReviewAttributeRestrictionsLike(LocalResourceAccessReview item) {
    return new LocalResourceAccessReviewAttributeRestrictionsNested(item);
  }
  
  public ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions() {
    return new ClusterRoleAttributeRestrictionsNested(null);
  }
  
  public ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item) {
    return new ClusterRoleAttributeRestrictionsNested(item);
  }
  
  public ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictions() {
    return new ConnectionConfigAttributeRestrictionsNested(null);
  }
  
  public ConnectionConfigAttributeRestrictionsNested<A> withNewConnectionConfigAttributeRestrictionsLike(ConnectionConfig item) {
    return new ConnectionConfigAttributeRestrictionsNested(item);
  }
  
  public TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictions() {
    return new TagEventConditionAttributeRestrictionsNested(null);
  }
  
  public TagEventConditionAttributeRestrictionsNested<A> withNewTagEventConditionAttributeRestrictionsLike(TagEventCondition item) {
    return new TagEventConditionAttributeRestrictionsNested(item);
  }
  
  public LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictions() {
    return new LabelSelectorAttributeRestrictionsNested(null);
  }
  
  public LabelSelectorAttributeRestrictionsNested<A> withNewLabelSelectorAttributeRestrictionsLike(LabelSelector item) {
    return new LabelSelectorAttributeRestrictionsNested(item);
  }
  
  public NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictions() {
    return new NetNamespaceListAttributeRestrictionsNested(null);
  }
  
  public NetNamespaceListAttributeRestrictionsNested<A> withNewNetNamespaceListAttributeRestrictionsLike(NetNamespaceList item) {
    return new NetNamespaceListAttributeRestrictionsNested(item);
  }
  
  public BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictions() {
    return new BrokerTemplateInstanceSpecAttributeRestrictionsNested(null);
  }
  
  public BrokerTemplateInstanceSpecAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceSpecAttributeRestrictionsLike(BrokerTemplateInstanceSpec item) {
    return new BrokerTemplateInstanceSpecAttributeRestrictionsNested(item);
  }
  
  public BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictions() {
    return new BinaryBuildSourceAttributeRestrictionsNested(null);
  }
  
  public BinaryBuildSourceAttributeRestrictionsNested<A> withNewBinaryBuildSourceAttributeRestrictionsLike(BinaryBuildSource item) {
    return new BinaryBuildSourceAttributeRestrictionsNested(item);
  }
  
  public A withNewBinaryBuildSourceAttributeRestrictions(String asFile) {
    return (A)withAttributeRestrictions(new BinaryBuildSource(asFile));
  }
  
  public BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictions() {
    return new BuildSpecAttributeRestrictionsNested(null);
  }
  
  public BuildSpecAttributeRestrictionsNested<A> withNewBuildSpecAttributeRestrictionsLike(BuildSpec item) {
    return new BuildSpecAttributeRestrictionsNested(item);
  }
  
  public OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictions() {
    return new OAuthClientAuthorizationListAttributeRestrictionsNested(null);
  }
  
  public OAuthClientAuthorizationListAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationListAttributeRestrictionsLike(OAuthClientAuthorizationList item) {
    return new OAuthClientAuthorizationListAttributeRestrictionsNested(item);
  }
  
  public LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictions() {
    return new LocalSubjectAccessReviewAttributeRestrictionsNested(null);
  }
  
  public LocalSubjectAccessReviewAttributeRestrictionsNested<A> withNewLocalSubjectAccessReviewAttributeRestrictionsLike(LocalSubjectAccessReview item) {
    return new LocalSubjectAccessReviewAttributeRestrictionsNested(item);
  }
  
  public ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictions() {
    return new ProjectStatusAttributeRestrictionsNested(null);
  }
  
  public ProjectStatusAttributeRestrictionsNested<A> withNewProjectStatusAttributeRestrictionsLike(ProjectStatus item) {
    return new ProjectStatusAttributeRestrictionsNested(item);
  }
  
  public RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictions() {
    return new RollingDeploymentStrategyParamsAttributeRestrictionsNested(null);
  }
  
  public RollingDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRollingDeploymentStrategyParamsAttributeRestrictionsLike(RollingDeploymentStrategyParams item) {
    return new RollingDeploymentStrategyParamsAttributeRestrictionsNested(item);
  }
  
  public GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictions() {
    return new GitSourceRevisionAttributeRestrictionsNested(null);
  }
  
  public GitSourceRevisionAttributeRestrictionsNested<A> withNewGitSourceRevisionAttributeRestrictionsLike(GitSourceRevision item) {
    return new GitSourceRevisionAttributeRestrictionsNested(item);
  }
  
  public ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictions() {
    return new ImageLabelAttributeRestrictionsNested(null);
  }
  
  public ImageLabelAttributeRestrictionsNested<A> withNewImageLabelAttributeRestrictionsLike(ImageLabel item) {
    return new ImageLabelAttributeRestrictionsNested(item);
  }
  
  public A withNewImageLabelAttributeRestrictions(String name,String value) {
    return (A)withAttributeRestrictions(new ImageLabel(name, value));
  }
  
  public ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictions() {
    return new ImageChangeTriggerAttributeRestrictionsNested(null);
  }
  
  public ImageChangeTriggerAttributeRestrictionsNested<A> withNewImageChangeTriggerAttributeRestrictionsLike(ImageChangeTrigger item) {
    return new ImageChangeTriggerAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictions() {
    return new PodSecurityPolicyReviewSpecAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicyReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewSpecAttributeRestrictionsLike(PodSecurityPolicyReviewSpec item) {
    return new PodSecurityPolicyReviewSpecAttributeRestrictionsNested(item);
  }
  
  public ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictions() {
    return new ImageStreamImportSpecAttributeRestrictionsNested(null);
  }
  
  public ImageStreamImportSpecAttributeRestrictionsNested<A> withNewImageStreamImportSpecAttributeRestrictionsLike(ImageStreamImportSpec item) {
    return new ImageStreamImportSpecAttributeRestrictionsNested(item);
  }
  
  public ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions() {
    return new ImageTagAttributeRestrictionsNested(null);
  }
  
  public ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item) {
    return new ImageTagAttributeRestrictionsNested(item);
  }
  
  public FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictions() {
    return new FSGroupStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public FSGroupStrategyOptionsAttributeRestrictionsNested<A> withNewFSGroupStrategyOptionsAttributeRestrictionsLike(FSGroupStrategyOptions item) {
    return new FSGroupStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictions() {
    return new PodSecurityPolicyReviewAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicyReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicyReviewAttributeRestrictionsLike(PodSecurityPolicyReview item) {
    return new PodSecurityPolicyReviewAttributeRestrictionsNested(item);
  }
  
  public RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictions() {
    return new RecreateDeploymentStrategyParamsAttributeRestrictionsNested(null);
  }
  
  public RecreateDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewRecreateDeploymentStrategyParamsAttributeRestrictionsLike(RecreateDeploymentStrategyParams item) {
    return new RecreateDeploymentStrategyParamsAttributeRestrictionsNested(item);
  }
  
  public DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictions() {
    return new DockerStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public DockerStrategyOptionsAttributeRestrictionsNested<A> withNewDockerStrategyOptionsAttributeRestrictionsLike(DockerStrategyOptions item) {
    return new DockerStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictions() {
    return new ImageListAttributeRestrictionsNested(null);
  }
  
  public ImageListAttributeRestrictionsNested<A> withNewImageListAttributeRestrictionsLike(ImageList item) {
    return new ImageListAttributeRestrictionsNested(item);
  }
  
  public ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictions() {
    return new ConfigMapBuildSourceAttributeRestrictionsNested(null);
  }
  
  public ConfigMapBuildSourceAttributeRestrictionsNested<A> withNewConfigMapBuildSourceAttributeRestrictionsLike(ConfigMapBuildSource item) {
    return new ConfigMapBuildSourceAttributeRestrictionsNested(item);
  }
  
  public ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictions() {
    return new ImageTagListAttributeRestrictionsNested(null);
  }
  
  public ImageTagListAttributeRestrictionsNested<A> withNewImageTagListAttributeRestrictionsLike(ImageTagList item) {
    return new ImageTagListAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions() {
    return new DeploymentConfigAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item) {
    return new DeploymentConfigAttributeRestrictionsNested(item);
  }
  
  public OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions() {
    return new OAuthAccessTokenAttributeRestrictionsNested(null);
  }
  
  public OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item) {
    return new OAuthAccessTokenAttributeRestrictionsNested(item);
  }
  
  public RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions() {
    return new RoleBindingAttributeRestrictionsNested(null);
  }
  
  public RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item) {
    return new RoleBindingAttributeRestrictionsNested(item);
  }
  
  public ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions() {
    return new ImageAttributeRestrictionsNested(null);
  }
  
  public ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item) {
    return new ImageAttributeRestrictionsNested(item);
  }
  
  public TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictions() {
    return new TLSConfigAttributeRestrictionsNested(null);
  }
  
  public TLSConfigAttributeRestrictionsNested<A> withNewTLSConfigAttributeRestrictionsLike(TLSConfig item) {
    return new TLSConfigAttributeRestrictionsNested(item);
  }
  
  public BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictions() {
    return new BuildVolumeAttributeRestrictionsNested(null);
  }
  
  public BuildVolumeAttributeRestrictionsNested<A> withNewBuildVolumeAttributeRestrictionsLike(BuildVolume item) {
    return new BuildVolumeAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictions() {
    return new TemplateInstanceSpecAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceSpecAttributeRestrictionsNested<A> withNewTemplateInstanceSpecAttributeRestrictionsLike(TemplateInstanceSpec item) {
    return new TemplateInstanceSpecAttributeRestrictionsNested(item);
  }
  
  public BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictions() {
    return new BuildStatusAttributeRestrictionsNested(null);
  }
  
  public BuildStatusAttributeRestrictionsNested<A> withNewBuildStatusAttributeRestrictionsLike(BuildStatus item) {
    return new BuildStatusAttributeRestrictionsNested(item);
  }
  
  public ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictions() {
    return new ImageSourceAttributeRestrictionsNested(null);
  }
  
  public ImageSourceAttributeRestrictionsNested<A> withNewImageSourceAttributeRestrictionsLike(ImageSource item) {
    return new ImageSourceAttributeRestrictionsNested(item);
  }
  
  public ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictions() {
    return new ObjectMetaAttributeRestrictionsNested(null);
  }
  
  public ObjectMetaAttributeRestrictionsNested<A> withNewObjectMetaAttributeRestrictionsLike(ObjectMeta item) {
    return new ObjectMetaAttributeRestrictionsNested(item);
  }
  
  public PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions() {
    return new PersistentVolumeClaimAttributeRestrictionsNested(null);
  }
  
  public PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
    return new PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReview item) {
    return new PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested(item);
  }
  
  public TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictions() {
    return new TagReferenceAttributeRestrictionsNested(null);
  }
  
  public TagReferenceAttributeRestrictionsNested<A> withNewTagReferenceAttributeRestrictionsLike(TagReference item) {
    return new TagReferenceAttributeRestrictionsNested(item);
  }
  
  public EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictions() {
    return new EgressNetworkPolicyRuleAttributeRestrictionsNested(null);
  }
  
  public EgressNetworkPolicyRuleAttributeRestrictionsNested<A> withNewEgressNetworkPolicyRuleAttributeRestrictionsLike(EgressNetworkPolicyRule item) {
    return new EgressNetworkPolicyRuleAttributeRestrictionsNested(item);
  }
  
  public SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictions() {
    return new SubjectRulesReviewStatusAttributeRestrictionsNested(null);
  }
  
  public SubjectRulesReviewStatusAttributeRestrictionsNested<A> withNewSubjectRulesReviewStatusAttributeRestrictionsLike(SubjectRulesReviewStatus item) {
    return new SubjectRulesReviewStatusAttributeRestrictionsNested(item);
  }
  
  public BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictions() {
    return new BuildVolumeMountAttributeRestrictionsNested(null);
  }
  
  public BuildVolumeMountAttributeRestrictionsNested<A> withNewBuildVolumeMountAttributeRestrictionsLike(BuildVolumeMount item) {
    return new BuildVolumeMountAttributeRestrictionsNested(item);
  }
  
  public A withNewBuildVolumeMountAttributeRestrictions(String destinationPath) {
    return (A)withAttributeRestrictions(new BuildVolumeMount(destinationPath));
  }
  
  public ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictions() {
    return new ClusterNetworkEntryAttributeRestrictionsNested(null);
  }
  
  public ClusterNetworkEntryAttributeRestrictionsNested<A> withNewClusterNetworkEntryAttributeRestrictionsLike(ClusterNetworkEntry item) {
    return new ClusterNetworkEntryAttributeRestrictionsNested(item);
  }
  
  public A withNewClusterNetworkEntryAttributeRestrictions(String cidr,Integer hostSubnetLength) {
    return (A)withAttributeRestrictions(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  
  public GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictions() {
    return new GenericKubernetesResourceAttributeRestrictionsNested(null);
  }
  
  public GenericKubernetesResourceAttributeRestrictionsNested<A> withNewGenericKubernetesResourceAttributeRestrictionsLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictions() {
    return new TemplateInstanceObjectAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceObjectAttributeRestrictionsNested<A> withNewTemplateInstanceObjectAttributeRestrictionsLike(TemplateInstanceObject item) {
    return new TemplateInstanceObjectAttributeRestrictionsNested(item);
  }
  
  public BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictions() {
    return new BuildSourceAttributeRestrictionsNested(null);
  }
  
  public BuildSourceAttributeRestrictionsNested<A> withNewBuildSourceAttributeRestrictionsLike(BuildSource item) {
    return new BuildSourceAttributeRestrictionsNested(item);
  }
  
  public ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictions() {
    return new ClusterResourceQuotaStatusAttributeRestrictionsNested(null);
  }
  
  public ClusterResourceQuotaStatusAttributeRestrictionsNested<A> withNewClusterResourceQuotaStatusAttributeRestrictionsLike(ClusterResourceQuotaStatus item) {
    return new ClusterResourceQuotaStatusAttributeRestrictionsNested(item);
  }
  
  public DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictions() {
    return new DeploymentConditionAttributeRestrictionsNested(null);
  }
  
  public DeploymentConditionAttributeRestrictionsNested<A> withNewDeploymentConditionAttributeRestrictionsLike(DeploymentCondition item) {
    return new DeploymentConditionAttributeRestrictionsNested(item);
  }
  
  public HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictions() {
    return new HelmChartRepositorySpecAttributeRestrictionsNested(null);
  }
  
  public HelmChartRepositorySpecAttributeRestrictionsNested<A> withNewHelmChartRepositorySpecAttributeRestrictionsLike(HelmChartRepositorySpec item) {
    return new HelmChartRepositorySpecAttributeRestrictionsNested(item);
  }
  
  public DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictions() {
    return new DeploymentCauseImageTriggerAttributeRestrictionsNested(null);
  }
  
  public DeploymentCauseImageTriggerAttributeRestrictionsNested<A> withNewDeploymentCauseImageTriggerAttributeRestrictionsLike(DeploymentCauseImageTrigger item) {
    return new DeploymentCauseImageTriggerAttributeRestrictionsNested(item);
  }
  
  public ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions() {
    return new ImageStreamMappingAttributeRestrictionsNested(null);
  }
  
  public ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item) {
    return new ImageStreamMappingAttributeRestrictionsNested(item);
  }
  
  public SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictions() {
    return new SubjectRulesReviewAttributeRestrictionsNested(null);
  }
  
  public SubjectRulesReviewAttributeRestrictionsNested<A> withNewSubjectRulesReviewAttributeRestrictionsLike(SubjectRulesReview item) {
    return new SubjectRulesReviewAttributeRestrictionsNested(item);
  }
  
  public RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions() {
    return new RoleAttributeRestrictionsNested(null);
  }
  
  public RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item) {
    return new RoleAttributeRestrictionsNested(item);
  }
  
  public GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictions() {
    return new GitBuildSourceAttributeRestrictionsNested(null);
  }
  
  public GitBuildSourceAttributeRestrictionsNested<A> withNewGitBuildSourceAttributeRestrictionsLike(GitBuildSource item) {
    return new GitBuildSourceAttributeRestrictionsNested(item);
  }
  
  public A withNewGitBuildSourceAttributeRestrictions(String httpProxy,String httpsProxy,String noProxy,String ref,String uri) {
    return (A)withAttributeRestrictions(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
  }
  
  public EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictions() {
    return new EgressNetworkPolicyListAttributeRestrictionsNested(null);
  }
  
  public EgressNetworkPolicyListAttributeRestrictionsNested<A> withNewEgressNetworkPolicyListAttributeRestrictionsLike(EgressNetworkPolicyList item) {
    return new EgressNetworkPolicyListAttributeRestrictionsNested(item);
  }
  
  public SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictions() {
    return new SelfSubjectRulesReviewSpecAttributeRestrictionsNested(null);
  }
  
  public SelfSubjectRulesReviewSpecAttributeRestrictionsNested<A> withNewSelfSubjectRulesReviewSpecAttributeRestrictionsLike(SelfSubjectRulesReviewSpec item) {
    return new SelfSubjectRulesReviewSpecAttributeRestrictionsNested(item);
  }
  
  public ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictions() {
    return new ImageSourcePathAttributeRestrictionsNested(null);
  }
  
  public ImageSourcePathAttributeRestrictionsNested<A> withNewImageSourcePathAttributeRestrictionsLike(ImageSourcePath item) {
    return new ImageSourcePathAttributeRestrictionsNested(item);
  }
  
  public A withNewImageSourcePathAttributeRestrictions(String destinationDir,String sourcePath) {
    return (A)withAttributeRestrictions(new ImageSourcePath(destinationDir, sourcePath));
  }
  
  public BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictions() {
    return new BuildConfigStatusAttributeRestrictionsNested(null);
  }
  
  public BuildConfigStatusAttributeRestrictionsNested<A> withNewBuildConfigStatusAttributeRestrictionsLike(BuildConfigStatus item) {
    return new BuildConfigStatusAttributeRestrictionsNested(item);
  }
  
  public ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictions() {
    return new ResourceQuotaStatusByNamespaceAttributeRestrictionsNested(null);
  }
  
  public ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<A> withNewResourceQuotaStatusByNamespaceAttributeRestrictionsLike(ResourceQuotaStatusByNamespace item) {
    return new ResourceQuotaStatusByNamespaceAttributeRestrictionsNested(item);
  }
  
  public ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictions() {
    return new ParameterAttributeRestrictionsNested(null);
  }
  
  public ParameterAttributeRestrictionsNested<A> withNewParameterAttributeRestrictionsLike(Parameter item) {
    return new ParameterAttributeRestrictionsNested(item);
  }
  
  public RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictions() {
    return new RoleBindingListAttributeRestrictionsNested(null);
  }
  
  public RoleBindingListAttributeRestrictionsNested<A> withNewRoleBindingListAttributeRestrictionsLike(RoleBindingList item) {
    return new RoleBindingListAttributeRestrictionsNested(item);
  }
  
  public SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictions() {
    return new SourceBuildStrategyAttributeRestrictionsNested(null);
  }
  
  public SourceBuildStrategyAttributeRestrictionsNested<A> withNewSourceBuildStrategyAttributeRestrictionsLike(SourceBuildStrategy item) {
    return new SourceBuildStrategyAttributeRestrictionsNested(item);
  }
  
  public BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions() {
    return new BrokerTemplateInstanceAttributeRestrictionsNested(null);
  }
  
  public BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
    return new PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySelfSubjectReviewSpec item) {
    return new PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested(item);
  }
  
  public BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictions() {
    return new BuildPostCommitSpecAttributeRestrictionsNested(null);
  }
  
  public BuildPostCommitSpecAttributeRestrictionsNested<A> withNewBuildPostCommitSpecAttributeRestrictionsLike(BuildPostCommitSpec item) {
    return new BuildPostCommitSpecAttributeRestrictionsNested(item);
  }
  
  public DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictions() {
    return new DeploymentStrategyAttributeRestrictionsNested(null);
  }
  
  public DeploymentStrategyAttributeRestrictionsNested<A> withNewDeploymentStrategyAttributeRestrictionsLike(DeploymentStrategy item) {
    return new DeploymentStrategyAttributeRestrictionsNested(item);
  }
  
  public OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictions() {
    return new OAuthAuthorizeTokenListAttributeRestrictionsNested(null);
  }
  
  public OAuthAuthorizeTokenListAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenListAttributeRestrictionsLike(OAuthAuthorizeTokenList item) {
    return new OAuthAuthorizeTokenListAttributeRestrictionsNested(item);
  }
  
  public SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictions() {
    return new SignatureSubjectAttributeRestrictionsNested(null);
  }
  
  public SignatureSubjectAttributeRestrictionsNested<A> withNewSignatureSubjectAttributeRestrictionsLike(SignatureSubject item) {
    return new SignatureSubjectAttributeRestrictionsNested(item);
  }
  
  public A withNewSignatureSubjectAttributeRestrictions(String commonName,String organization,String publicKeyID) {
    return (A)withAttributeRestrictions(new SignatureSubject(commonName, organization, publicKeyID));
  }
  
  public HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictions() {
    return new HostSubnetListAttributeRestrictionsNested(null);
  }
  
  public HostSubnetListAttributeRestrictionsNested<A> withNewHostSubnetListAttributeRestrictionsLike(HostSubnetList item) {
    return new HostSubnetListAttributeRestrictionsNested(item);
  }
  
  public RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictions() {
    return new RouteIngressConditionAttributeRestrictionsNested(null);
  }
  
  public RouteIngressConditionAttributeRestrictionsNested<A> withNewRouteIngressConditionAttributeRestrictionsLike(RouteIngressCondition item) {
    return new RouteIngressConditionAttributeRestrictionsNested(item);
  }
  
  public A withNewRouteIngressConditionAttributeRestrictions(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withAttributeRestrictions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictions() {
    return new CustomDeploymentStrategyParamsAttributeRestrictionsNested(null);
  }
  
  public CustomDeploymentStrategyParamsAttributeRestrictionsNested<A> withNewCustomDeploymentStrategyParamsAttributeRestrictionsLike(CustomDeploymentStrategyParams item) {
    return new CustomDeploymentStrategyParamsAttributeRestrictionsNested(item);
  }
  
  public ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictions() {
    return new ImageImportSpecAttributeRestrictionsNested(null);
  }
  
  public ImageImportSpecAttributeRestrictionsNested<A> withNewImageImportSpecAttributeRestrictionsLike(ImageImportSpec item) {
    return new ImageImportSpecAttributeRestrictionsNested(item);
  }
  
  public StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictions() {
    return new StageInfoAttributeRestrictionsNested(null);
  }
  
  public StageInfoAttributeRestrictionsNested<A> withNewStageInfoAttributeRestrictionsLike(StageInfo item) {
    return new StageInfoAttributeRestrictionsNested(item);
  }
  
  public RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictions() {
    return new RoleBindingRestrictionSpecAttributeRestrictionsNested(null);
  }
  
  public RoleBindingRestrictionSpecAttributeRestrictionsNested<A> withNewRoleBindingRestrictionSpecAttributeRestrictionsLike(RoleBindingRestrictionSpec item) {
    return new RoleBindingRestrictionSpecAttributeRestrictionsNested(item);
  }
  
  public IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictions() {
    return new IDRangeAttributeRestrictionsNested(null);
  }
  
  public IDRangeAttributeRestrictionsNested<A> withNewIDRangeAttributeRestrictionsLike(IDRange item) {
    return new IDRangeAttributeRestrictionsNested(item);
  }
  
  public A withNewIDRangeAttributeRestrictions(Long max,Long min) {
    return (A)withAttributeRestrictions(new IDRange(max, min));
  }
  
  public UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictions() {
    return new UserListAttributeRestrictionsNested(null);
  }
  
  public UserListAttributeRestrictionsNested<A> withNewUserListAttributeRestrictionsLike(UserList item) {
    return new UserListAttributeRestrictionsNested(item);
  }
  
  public BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictions() {
    return new BuildConfigSpecAttributeRestrictionsNested(null);
  }
  
  public BuildConfigSpecAttributeRestrictionsNested<A> withNewBuildConfigSpecAttributeRestrictionsLike(BuildConfigSpec item) {
    return new BuildConfigSpecAttributeRestrictionsNested(item);
  }
  
  public UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions() {
    return new UserAttributeRestrictionsNested(null);
  }
  
  public UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item) {
    return new UserAttributeRestrictionsNested(item);
  }
  
  public ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions() {
    return new ImageStreamImageAttributeRestrictionsNested(null);
  }
  
  public ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item) {
    return new ImageStreamImageAttributeRestrictionsNested(item);
  }
  
  public BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictions() {
    return new BuildConditionAttributeRestrictionsNested(null);
  }
  
  public BuildConditionAttributeRestrictionsNested<A> withNewBuildConditionAttributeRestrictionsLike(BuildCondition item) {
    return new BuildConditionAttributeRestrictionsNested(item);
  }
  
  public BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictions() {
    return new BuildStatusOutputToAttributeRestrictionsNested(null);
  }
  
  public BuildStatusOutputToAttributeRestrictionsNested<A> withNewBuildStatusOutputToAttributeRestrictionsLike(BuildStatusOutputTo item) {
    return new BuildStatusOutputToAttributeRestrictionsNested(item);
  }
  
  public A withNewBuildStatusOutputToAttributeRestrictions(String imageDigest) {
    return (A)withAttributeRestrictions(new BuildStatusOutputTo(imageDigest));
  }
  
  public ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictions() {
    return new ResourceAccessReviewResponseAttributeRestrictionsNested(null);
  }
  
  public ResourceAccessReviewResponseAttributeRestrictionsNested<A> withNewResourceAccessReviewResponseAttributeRestrictionsLike(ResourceAccessReviewResponse item) {
    return new ResourceAccessReviewResponseAttributeRestrictionsNested(item);
  }
  
  public ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictions() {
    return new ExecNewPodHookAttributeRestrictionsNested(null);
  }
  
  public ExecNewPodHookAttributeRestrictionsNested<A> withNewExecNewPodHookAttributeRestrictionsLike(ExecNewPodHook item) {
    return new ExecNewPodHookAttributeRestrictionsNested(item);
  }
  
  public SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictions() {
    return new SecretSpecAttributeRestrictionsNested(null);
  }
  
  public SecretSpecAttributeRestrictionsNested<A> withNewSecretSpecAttributeRestrictionsLike(SecretSpec item) {
    return new SecretSpecAttributeRestrictionsNested(item);
  }
  
  public ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictions() {
    return new ClusterRoleBindingListAttributeRestrictionsNested(null);
  }
  
  public ClusterRoleBindingListAttributeRestrictionsNested<A> withNewClusterRoleBindingListAttributeRestrictionsLike(ClusterRoleBindingList item) {
    return new ClusterRoleBindingListAttributeRestrictionsNested(item);
  }
  
  public EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictions() {
    return new EgressNetworkPolicyPeerAttributeRestrictionsNested(null);
  }
  
  public EgressNetworkPolicyPeerAttributeRestrictionsNested<A> withNewEgressNetworkPolicyPeerAttributeRestrictionsLike(EgressNetworkPolicyPeer item) {
    return new EgressNetworkPolicyPeerAttributeRestrictionsNested(item);
  }
  
  public A withNewEgressNetworkPolicyPeerAttributeRestrictions(String cidrSelector,String dnsName) {
    return (A)withAttributeRestrictions(new EgressNetworkPolicyPeer(cidrSelector, dnsName));
  }
  
  public ProjectHelmChartRepositoryListAttributeRestrictionsNested<A> withNewProjectHelmChartRepositoryListAttributeRestrictions() {
    return new ProjectHelmChartRepositoryListAttributeRestrictionsNested(null);
  }
  
  public ProjectHelmChartRepositoryListAttributeRestrictionsNested<A> withNewProjectHelmChartRepositoryListAttributeRestrictionsLike(ProjectHelmChartRepositoryList item) {
    return new ProjectHelmChartRepositoryListAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions() {
    return new TemplateInstanceAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(TemplateInstance item) {
    return new TemplateInstanceAttributeRestrictionsNested(item);
  }
  
  public WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictions() {
    return new WebHookTriggerAttributeRestrictionsNested(null);
  }
  
  public WebHookTriggerAttributeRestrictionsNested<A> withNewWebHookTriggerAttributeRestrictionsLike(WebHookTrigger item) {
    return new WebHookTriggerAttributeRestrictionsNested(item);
  }
  
  public BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions() {
    return new BuildAttributeRestrictionsNested(null);
  }
  
  public BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item) {
    return new BuildAttributeRestrictionsNested(item);
  }
  
  public ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictions() {
    return new ServiceAccountReferenceAttributeRestrictionsNested(null);
  }
  
  public ServiceAccountReferenceAttributeRestrictionsNested<A> withNewServiceAccountReferenceAttributeRestrictionsLike(ServiceAccountReference item) {
    return new ServiceAccountReferenceAttributeRestrictionsNested(item);
  }
  
  public A withNewServiceAccountReferenceAttributeRestrictions(String name,String namespace) {
    return (A)withAttributeRestrictions(new ServiceAccountReference(name, namespace));
  }
  
  public RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions() {
    return new RoleBindingRestrictionAttributeRestrictionsNested(null);
  }
  
  public RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item) {
    return new RoleBindingRestrictionAttributeRestrictionsNested(item);
  }
  
  public TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictions() {
    return new TagImportPolicyAttributeRestrictionsNested(null);
  }
  
  public TagImportPolicyAttributeRestrictionsNested<A> withNewTagImportPolicyAttributeRestrictionsLike(TagImportPolicy item) {
    return new TagImportPolicyAttributeRestrictionsNested(item);
  }
  
  public A withNewTagImportPolicyAttributeRestrictions(String importMode,Boolean insecure,Boolean scheduled) {
    return (A)withAttributeRestrictions(new TagImportPolicy(importMode, insecure, scheduled));
  }
  
  public ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions() {
    return new ImageStreamTagAttributeRestrictionsNested(null);
  }
  
  public ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item) {
    return new ImageStreamTagAttributeRestrictionsNested(item);
  }
  
  public BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictions() {
    return new BuildTriggerPolicyAttributeRestrictionsNested(null);
  }
  
  public BuildTriggerPolicyAttributeRestrictionsNested<A> withNewBuildTriggerPolicyAttributeRestrictionsLike(BuildTriggerPolicy item) {
    return new BuildTriggerPolicyAttributeRestrictionsNested(item);
  }
  
  public RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictions() {
    return new RoutePortAttributeRestrictionsNested(null);
  }
  
  public RoutePortAttributeRestrictionsNested<A> withNewRoutePortAttributeRestrictionsLike(RoutePort item) {
    return new RoutePortAttributeRestrictionsNested(item);
  }
  
  public TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictions() {
    return new TemplateInstanceRequesterAttributeRestrictionsNested(null);
  }
  
  public TemplateInstanceRequesterAttributeRestrictionsNested<A> withNewTemplateInstanceRequesterAttributeRestrictionsLike(TemplateInstanceRequester item) {
    return new TemplateInstanceRequesterAttributeRestrictionsNested(item);
  }
  
  public GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions() {
    return new GroupAttributeRestrictionsNested(null);
  }
  
  public GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item) {
    return new GroupAttributeRestrictionsNested(item);
  }
  
  public BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictions() {
    return new BuildTriggerCauseAttributeRestrictionsNested(null);
  }
  
  public BuildTriggerCauseAttributeRestrictionsNested<A> withNewBuildTriggerCauseAttributeRestrictionsLike(BuildTriggerCause item) {
    return new BuildTriggerCauseAttributeRestrictionsNested(item);
  }
  
  public ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions() {
    return new ImageSignatureAttributeRestrictionsNested(null);
  }
  
  public ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item) {
    return new ImageSignatureAttributeRestrictionsNested(item);
  }
  
  public HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictions() {
    return new HelmChartRepositoryStatusAttributeRestrictionsNested(null);
  }
  
  public HelmChartRepositoryStatusAttributeRestrictionsNested<A> withNewHelmChartRepositoryStatusAttributeRestrictionsLike(HelmChartRepositoryStatus item) {
    return new HelmChartRepositoryStatusAttributeRestrictionsNested(item);
  }
  
  public DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictions() {
    return new DeploymentConfigSpecAttributeRestrictionsNested(null);
  }
  
  public DeploymentConfigSpecAttributeRestrictionsNested<A> withNewDeploymentConfigSpecAttributeRestrictionsLike(DeploymentConfigSpec item) {
    return new DeploymentConfigSpecAttributeRestrictionsNested(item);
  }
  
  public HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions() {
    return new HostSubnetAttributeRestrictionsNested(null);
  }
  
  public HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(HostSubnet item) {
    return new HostSubnetAttributeRestrictionsNested(item);
  }
  
  public AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions() {
    return new AppliedClusterResourceQuotaAttributeRestrictionsNested(null);
  }
  
  public AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item) {
    return new AppliedClusterResourceQuotaAttributeRestrictionsNested(item);
  }
  
  public GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictions() {
    return new GroupRestrictionAttributeRestrictionsNested(null);
  }
  
  public GroupRestrictionAttributeRestrictionsNested<A> withNewGroupRestrictionAttributeRestrictionsLike(GroupRestriction item) {
    return new GroupRestrictionAttributeRestrictionsNested(item);
  }
  
  public OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictions() {
    return new OAuthAccessTokenListAttributeRestrictionsNested(null);
  }
  
  public OAuthAccessTokenListAttributeRestrictionsNested<A> withNewOAuthAccessTokenListAttributeRestrictionsLike(OAuthAccessTokenList item) {
    return new OAuthAccessTokenListAttributeRestrictionsNested(item);
  }
  
  public JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictions() {
    return new JenkinsPipelineBuildStrategyAttributeRestrictionsNested(null);
  }
  
  public JenkinsPipelineBuildStrategyAttributeRestrictionsNested<A> withNewJenkinsPipelineBuildStrategyAttributeRestrictionsLike(JenkinsPipelineBuildStrategy item) {
    return new JenkinsPipelineBuildStrategyAttributeRestrictionsNested(item);
  }
  
  public SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions() {
    return new SecurityContextConstraintsAttributeRestrictionsNested(null);
  }
  
  public SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item) {
    return new SecurityContextConstraintsAttributeRestrictionsNested(item);
  }
  
  public SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictions() {
    return new SupplementalGroupsStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<A> withNewSupplementalGroupsStrategyOptionsAttributeRestrictionsLike(SupplementalGroupsStrategyOptions item) {
    return new SupplementalGroupsStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
    return new ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested(null);
  }
  
  public ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<A> withNewServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested(item);
  }
  
  public BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions() {
    return new BuildRequestAttributeRestrictionsNested(null);
  }
  
  public BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item) {
    return new BuildRequestAttributeRestrictionsNested(item);
  }
  
  public SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictions() {
    return new SELinuxContextStrategyOptionsAttributeRestrictionsNested(null);
  }
  
  public SELinuxContextStrategyOptionsAttributeRestrictionsNested<A> withNewSELinuxContextStrategyOptionsAttributeRestrictionsLike(SELinuxContextStrategyOptions item) {
    return new SELinuxContextStrategyOptionsAttributeRestrictionsNested(item);
  }
  
  public ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictions() {
    return new ClusterRoleListAttributeRestrictionsNested(null);
  }
  
  public ClusterRoleListAttributeRestrictionsNested<A> withNewClusterRoleListAttributeRestrictionsLike(ClusterRoleList item) {
    return new ClusterRoleListAttributeRestrictionsNested(item);
  }
  
  public RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictions() {
    return new RouteListAttributeRestrictionsNested(null);
  }
  
  public RouteListAttributeRestrictionsNested<A> withNewRouteListAttributeRestrictionsLike(RouteList item) {
    return new RouteListAttributeRestrictionsNested(item);
  }
  
  public ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictions() {
    return new ImageStreamStatusAttributeRestrictionsNested(null);
  }
  
  public ImageStreamStatusAttributeRestrictionsNested<A> withNewImageStreamStatusAttributeRestrictionsLike(ImageStreamStatus item) {
    return new ImageStreamStatusAttributeRestrictionsNested(item);
  }
  
  public EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions() {
    return new EgressNetworkPolicyAttributeRestrictionsNested(null);
  }
  
  public EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item) {
    return new EgressNetworkPolicyAttributeRestrictionsNested(item);
  }
  
  public NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions() {
    return new NetNamespaceAttributeRestrictionsNested(null);
  }
  
  public NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item) {
    return new NetNamespaceAttributeRestrictionsNested(item);
  }
  
  public DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictions() {
    return new DeploymentDetailsAttributeRestrictionsNested(null);
  }
  
  public DeploymentDetailsAttributeRestrictionsNested<A> withNewDeploymentDetailsAttributeRestrictionsLike(DeploymentDetails item) {
    return new DeploymentDetailsAttributeRestrictionsNested(item);
  }
  
  public UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions() {
    return new UserIdentityMappingAttributeRestrictionsNested(null);
  }
  
  public UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(UserIdentityMapping item) {
    return new UserIdentityMappingAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
    return new PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewStatusAttributeRestrictionsLike(PodSecurityPolicySubjectReviewStatus item) {
    return new PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested(item);
  }
  
  public PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
    return new PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested(null);
  }
  
  public PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<A> withNewPodSecurityPolicySubjectReviewSpecAttributeRestrictionsLike(PodSecurityPolicySubjectReviewSpec item) {
    return new PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested(item);
  }
  
  public ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions() {
    return new ImageStreamAttributeRestrictionsNested(null);
  }
  
  public ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item) {
    return new ImageStreamAttributeRestrictionsNested(item);
  }
  
  public BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictions() {
    return new BuildListAttributeRestrictionsNested(null);
  }
  
  public BuildListAttributeRestrictionsNested<A> withNewBuildListAttributeRestrictionsLike(BuildList item) {
    return new BuildListAttributeRestrictionsNested(item);
  }
  
  public BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictions() {
    return new BuildOutputAttributeRestrictionsNested(null);
  }
  
  public BuildOutputAttributeRestrictionsNested<A> withNewBuildOutputAttributeRestrictionsLike(BuildOutput item) {
    return new BuildOutputAttributeRestrictionsNested(item);
  }
  
  public TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictions() {
    return new TemplateListAttributeRestrictionsNested(null);
  }
  
  public TemplateListAttributeRestrictionsNested<A> withNewTemplateListAttributeRestrictionsLike(TemplateList item) {
    return new TemplateListAttributeRestrictionsNested(item);
  }
  
  public ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictions() {
    return new ProjectSpecAttributeRestrictionsNested(null);
  }
  
  public ProjectSpecAttributeRestrictionsNested<A> withNewProjectSpecAttributeRestrictionsLike(ProjectSpec item) {
    return new ProjectSpecAttributeRestrictionsNested(item);
  }
  
  public SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictions() {
    return new SourceRevisionAttributeRestrictionsNested(null);
  }
  
  public SourceRevisionAttributeRestrictionsNested<A> withNewSourceRevisionAttributeRestrictionsLike(SourceRevision item) {
    return new SourceRevisionAttributeRestrictionsNested(item);
  }
  
  public ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictions() {
    return new ObjectReferenceAttributeRestrictionsNested(null);
  }
  
  public ObjectReferenceAttributeRestrictionsNested<A> withNewObjectReferenceAttributeRestrictionsLike(ObjectReference item) {
    return new ObjectReferenceAttributeRestrictionsNested(item);
  }
  
  public SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictions() {
    return new SignatureIssuerAttributeRestrictionsNested(null);
  }
  
  public SignatureIssuerAttributeRestrictionsNested<A> withNewSignatureIssuerAttributeRestrictionsLike(SignatureIssuer item) {
    return new SignatureIssuerAttributeRestrictionsNested(item);
  }
  
  public A withNewSignatureIssuerAttributeRestrictions(String commonName,String organization) {
    return (A)withAttributeRestrictions(new SignatureIssuer(commonName, organization));
  }
  
  public ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictions() {
    return new ImageLayerAttributeRestrictionsNested(null);
  }
  
  public ImageLayerAttributeRestrictionsNested<A> withNewImageLayerAttributeRestrictionsLike(ImageLayer item) {
    return new ImageLayerAttributeRestrictionsNested(item);
  }
  
  public A withNewImageLayerAttributeRestrictions(String mediaType,String name,Long size) {
    return (A)withAttributeRestrictions(new ImageLayer(mediaType, name, size));
  }
  
  public ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictions() {
    return new ClusterResourceQuotaSpecAttributeRestrictionsNested(null);
  }
  
  public ClusterResourceQuotaSpecAttributeRestrictionsNested<A> withNewClusterResourceQuotaSpecAttributeRestrictionsLike(ClusterResourceQuotaSpec item) {
    return new ClusterResourceQuotaSpecAttributeRestrictionsNested(item);
  }
  
  public ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictions() {
    return new ImageStreamSpecAttributeRestrictionsNested(null);
  }
  
  public ImageStreamSpecAttributeRestrictionsNested<A> withNewImageStreamSpecAttributeRestrictionsLike(ImageStreamSpec item) {
    return new ImageStreamSpecAttributeRestrictionsNested(item);
  }
  
  public RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictions() {
    return new RouteIngressAttributeRestrictionsNested(null);
  }
  
  public RouteIngressAttributeRestrictionsNested<A> withNewRouteIngressAttributeRestrictionsLike(RouteIngress item) {
    return new RouteIngressAttributeRestrictionsNested(item);
  }
  
  public OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions() {
    return new OAuthClientAttributeRestrictionsNested(null);
  }
  
  public OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item) {
    return new OAuthClientAttributeRestrictionsNested(item);
  }
  
  public IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions() {
    return new IdentityAttributeRestrictionsNested(null);
  }
  
  public IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item) {
    return new IdentityAttributeRestrictionsNested(item);
  }
  
  public RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictions() {
    return new RangeAllocationListAttributeRestrictionsNested(null);
  }
  
  public RangeAllocationListAttributeRestrictionsNested<A> withNewRangeAllocationListAttributeRestrictionsLike(RangeAllocationList item) {
    return new RangeAllocationListAttributeRestrictionsNested(item);
  }
  
  public A addToNonResourceURLs(int index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.add(index, item);
    return (A)this;
  }
  
  public A setToNonResourceURLs(int index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.set(index, item); return (A)this;
  }
  
  public A addToNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  
  public A addAllToNonResourceURLs(Collection<String> items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  
  public A removeFromNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) return (A)this;
    for (String item : items) { this.nonResourceURLs.remove(item);} return (A)this;
  }
  
  public A removeAllFromNonResourceURLs(Collection<String> items) {
    if (this.nonResourceURLs == null) return (A)this;
    for (String item : items) { this.nonResourceURLs.remove(item);} return (A)this;
  }
  
  public List<String> getNonResourceURLs() {
    return this.nonResourceURLs;
  }
  
  public String getNonResourceURL(int index) {
    return this.nonResourceURLs.get(index);
  }
  
  public String getFirstNonResourceURL() {
    return this.nonResourceURLs.get(0);
  }
  
  public String getLastNonResourceURL() {
    return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
  }
  
  public String getMatchingNonResourceURL(Predicate<String> predicate) {
      for (String item : nonResourceURLs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
      for (String item : nonResourceURLs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNonResourceURLs(List<String> nonResourceURLs) {
    if (nonResourceURLs != null) {
        this.nonResourceURLs = new ArrayList();
        for (String item : nonResourceURLs) {
          this.addToNonResourceURLs(item);
        }
    } else {
      this.nonResourceURLs = null;
    }
    return (A) this;
  }
  
  public A withNonResourceURLs(java.lang.String... nonResourceURLs) {
    if (this.nonResourceURLs != null) {
        this.nonResourceURLs.clear();
        _visitables.remove("nonResourceURLs");
    }
    if (nonResourceURLs != null) {
      for (String item : nonResourceURLs) {
        this.addToNonResourceURLs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNonResourceURLs() {
    return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
  }
  
  public A addToResourceNames(int index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.add(index, item);
    return (A)this;
  }
  
  public A setToResourceNames(int index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.set(index, item); return (A)this;
  }
  
  public A addToResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  
  public A addAllToResourceNames(Collection<String> items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  
  public A removeFromResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) return (A)this;
    for (String item : items) { this.resourceNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromResourceNames(Collection<String> items) {
    if (this.resourceNames == null) return (A)this;
    for (String item : items) { this.resourceNames.remove(item);} return (A)this;
  }
  
  public List<String> getResourceNames() {
    return this.resourceNames;
  }
  
  public String getResourceName(int index) {
    return this.resourceNames.get(index);
  }
  
  public String getFirstResourceName() {
    return this.resourceNames.get(0);
  }
  
  public String getLastResourceName() {
    return this.resourceNames.get(resourceNames.size() - 1);
  }
  
  public String getMatchingResourceName(Predicate<String> predicate) {
      for (String item : resourceNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceName(Predicate<String> predicate) {
      for (String item : resourceNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceNames(List<String> resourceNames) {
    if (resourceNames != null) {
        this.resourceNames = new ArrayList();
        for (String item : resourceNames) {
          this.addToResourceNames(item);
        }
    } else {
      this.resourceNames = null;
    }
    return (A) this;
  }
  
  public A withResourceNames(java.lang.String... resourceNames) {
    if (this.resourceNames != null) {
        this.resourceNames.clear();
        _visitables.remove("resourceNames");
    }
    if (resourceNames != null) {
      for (String item : resourceNames) {
        this.addToResourceNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourceNames() {
    return this.resourceNames != null && !this.resourceNames.isEmpty();
  }
  
  public A addToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  
  public A setToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  
  public A removeFromResources(java.lang.String... items) {
    if (this.resources == null) return (A)this;
    for (String item : items) { this.resources.remove(item);} return (A)this;
  }
  
  public A removeAllFromResources(Collection<String> items) {
    if (this.resources == null) return (A)this;
    for (String item : items) { this.resources.remove(item);} return (A)this;
  }
  
  public List<String> getResources() {
    return this.resources;
  }
  
  public String getResource(int index) {
    return this.resources.get(index);
  }
  
  public String getFirstResource() {
    return this.resources.get(0);
  }
  
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  
  public String getMatchingResource(Predicate<String> predicate) {
      for (String item : resources) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingResource(Predicate<String> predicate) {
      for (String item : resources) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResources(List<String> resources) {
    if (resources != null) {
        this.resources = new ArrayList();
        for (String item : resources) {
          this.addToResources(item);
        }
    } else {
      this.resources = null;
    }
    return (A) this;
  }
  
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {
        this.resources.clear();
        _visitables.remove("resources");
    }
    if (resources != null) {
      for (String item : resources) {
        this.addToResources(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null && !this.resources.isEmpty();
  }
  
  public A addToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  
  public A setToVerbs(int index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.set(index, item); return (A)this;
  }
  
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  
  public A addAllToVerbs(Collection<String> items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  
  public A removeFromVerbs(java.lang.String... items) {
    if (this.verbs == null) return (A)this;
    for (String item : items) { this.verbs.remove(item);} return (A)this;
  }
  
  public A removeAllFromVerbs(Collection<String> items) {
    if (this.verbs == null) return (A)this;
    for (String item : items) { this.verbs.remove(item);} return (A)this;
  }
  
  public List<String> getVerbs() {
    return this.verbs;
  }
  
  public String getVerb(int index) {
    return this.verbs.get(index);
  }
  
  public String getFirstVerb() {
    return this.verbs.get(0);
  }
  
  public String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  
  public String getMatchingVerb(Predicate<String> predicate) {
      for (String item : verbs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVerb(Predicate<String> predicate) {
      for (String item : verbs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVerbs(List<String> verbs) {
    if (verbs != null) {
        this.verbs = new ArrayList();
        for (String item : verbs) {
          this.addToVerbs(item);
        }
    } else {
      this.verbs = null;
    }
    return (A) this;
  }
  
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {
        this.verbs.clear();
        _visitables.remove("verbs");
    }
    if (verbs != null) {
      for (String item : verbs) {
        this.addToVerbs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVerbs() {
    return this.verbs != null && !this.verbs.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PolicyRuleFluent that = (PolicyRuleFluent) o;
    if (!java.util.Objects.equals(apiGroups, that.apiGroups)) return false;
    if (!java.util.Objects.equals(attributeRestrictions, that.attributeRestrictions)) return false;
    if (!java.util.Objects.equals(nonResourceURLs, that.nonResourceURLs)) return false;
    if (!java.util.Objects.equals(resourceNames, that.resourceNames)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(verbs, that.verbs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  attributeRestrictions,  nonResourceURLs,  resourceNames,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (attributeRestrictions != null) { sb.append("attributeRestrictions:"); sb.append(attributeRestrictions + ","); }
    if (nonResourceURLs != null && !nonResourceURLs.isEmpty()) { sb.append("nonResourceURLs:"); sb.append(nonResourceURLs + ","); }
    if (resourceNames != null && !resourceNames.isEmpty()) { sb.append("resourceNames:"); sb.append(resourceNames + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.openshift.api.model."+"GenericWebHookCause": return (VisitableBuilder<T, ?>)new GenericWebHookCauseBuilder((GenericWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountRestriction": return (VisitableBuilder<T, ?>)new ServiceAccountRestrictionBuilder((ServiceAccountRestriction) item);
    case "io.fabric8.openshift.api.model."+"ScopeRestriction": return (VisitableBuilder<T, ?>)new ScopeRestrictionBuilder((ScopeRestriction) item);
    case "io.fabric8.openshift.api.model."+"SecretLocalReference": return (VisitableBuilder<T, ?>)new SecretLocalReferenceBuilder((SecretLocalReference) item);
    case "io.fabric8.openshift.api.model."+"StepInfo": return (VisitableBuilder<T, ?>)new StepInfoBuilder((StepInfo) item);
    case "io.fabric8.openshift.api.model."+"UserRestriction": return (VisitableBuilder<T, ?>)new UserRestrictionBuilder((UserRestriction) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepository": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositoryBuilder((ProjectHelmChartRepository) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceList": return (VisitableBuilder<T, ?>)new TemplateInstanceListBuilder((TemplateInstanceList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImport": return (VisitableBuilder<T, ?>)new ImageStreamImportBuilder((ImageStreamImport) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.openshift.api.model."+"GitHubWebHookCause": return (VisitableBuilder<T, ?>)new GitHubWebHookCauseBuilder((GitHubWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientList": return (VisitableBuilder<T, ?>)new OAuthClientListBuilder((OAuthClientList) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReviewStatus": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewStatusBuilder((PodSecurityPolicyReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceStatus": return (VisitableBuilder<T, ?>)new TemplateInstanceStatusBuilder((TemplateInstanceStatus) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositoryList": return (VisitableBuilder<T, ?>)new HelmChartRepositoryListBuilder((HelmChartRepositoryList) item);
    case "io.fabric8.openshift.api.model."+"PolicyRule": return (VisitableBuilder<T, ?>)new PolicyRuleBuilder((PolicyRule) item);
    case "io.fabric8.openshift.api.model."+"DeploymentTriggerPolicy": return (VisitableBuilder<T, ?>)new DeploymentTriggerPolicyBuilder((DeploymentTriggerPolicy) item);
    case "io.fabric8.openshift.api.model."+"BuildStrategy": return (VisitableBuilder<T, ?>)new BuildStrategyBuilder((BuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"RepositoryImportSpec": return (VisitableBuilder<T, ?>)new RepositoryImportSpecBuilder((RepositoryImportSpec) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstanceList": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceListBuilder((BrokerTemplateInstanceList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImportStatus": return (VisitableBuilder<T, ?>)new ImageStreamImportStatusBuilder((ImageStreamImportStatus) item);
    case "io.fabric8.openshift.api.model."+"CustomBuildStrategy": return (VisitableBuilder<T, ?>)new CustomBuildStrategyBuilder((CustomBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaSelector": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaSelectorBuilder((ClusterResourceQuotaSelector) item);
    case "io.fabric8.openshift.api.model."+"SubjectAccessReviewResponse": return (VisitableBuilder<T, ?>)new SubjectAccessReviewResponseBuilder((SubjectAccessReviewResponse) item);
    case "io.fabric8.openshift.api.model."+"DeploymentTriggerImageChangeParams": return (VisitableBuilder<T, ?>)new DeploymentTriggerImageChangeParamsBuilder((DeploymentTriggerImageChangeParams) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.openshift.api.model."+"TagImageHook": return (VisitableBuilder<T, ?>)new TagImageHookBuilder((TagImageHook) item);
    case "io.fabric8.openshift.api.model."+"RouteTargetReference": return (VisitableBuilder<T, ?>)new RouteTargetReferenceBuilder((RouteTargetReference) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReviewSpec": return (VisitableBuilder<T, ?>)new SubjectRulesReviewSpecBuilder((SubjectRulesReviewSpec) item);
    case "io.fabric8.openshift.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder((io.fabric8.openshift.api.model.runtime.RawExtension) item);
    case "io.fabric8.openshift.api.model."+"RoleList": return (VisitableBuilder<T, ?>)new RoleListBuilder((RoleList) item);
    case "io.fabric8.openshift.api.model."+"TagReferencePolicy": return (VisitableBuilder<T, ?>)new TagReferencePolicyBuilder((TagReferencePolicy) item);
    case "io.fabric8.openshift.api.model."+"Project": return (VisitableBuilder<T, ?>)new ProjectBuilder((Project) item);
    case "io.fabric8.openshift.api.model."+"BuildVolumeSource": return (VisitableBuilder<T, ?>)new BuildVolumeSourceBuilder((BuildVolumeSource) item);
    case "io.fabric8.openshift.api.model."+"AppliedClusterResourceQuotaList": return (VisitableBuilder<T, ?>)new AppliedClusterResourceQuotaListBuilder((AppliedClusterResourceQuotaList) item);
    case "io.fabric8.openshift.api.model."+"BuildStatusOutput": return (VisitableBuilder<T, ?>)new BuildStatusOutputBuilder((BuildStatusOutput) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigList": return (VisitableBuilder<T, ?>)new DeploymentConfigListBuilder((DeploymentConfigList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfig": return (VisitableBuilder<T, ?>)new BuildConfigBuilder((BuildConfig) item);
    case "io.fabric8.openshift.api.model."+"ImageImportStatus": return (VisitableBuilder<T, ?>)new ImageImportStatusBuilder((ImageImportStatus) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewBuilder((PodSecurityPolicySubjectReview) item);
    case "io.fabric8.openshift.api.model."+"GitLabWebHookCause": return (VisitableBuilder<T, ?>)new GitLabWebHookCauseBuilder((GitLabWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigStatus": return (VisitableBuilder<T, ?>)new DeploymentConfigStatusBuilder((DeploymentConfigStatus) item);
    case "io.fabric8.openshift.api.model."+"SecretBuildSource": return (VisitableBuilder<T, ?>)new SecretBuildSourceBuilder((SecretBuildSource) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicySpec": return (VisitableBuilder<T, ?>)new EgressNetworkPolicySpecBuilder((EgressNetworkPolicySpec) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepository": return (VisitableBuilder<T, ?>)new HelmChartRepositoryBuilder((HelmChartRepository) item);
    case "io.fabric8.openshift.api.model."+"TagEvent": return (VisitableBuilder<T, ?>)new TagEventBuilder((TagEvent) item);
    case "io.fabric8.openshift.api.model."+"BitbucketWebHookCause": return (VisitableBuilder<T, ?>)new BitbucketWebHookCauseBuilder((BitbucketWebHookCause) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTagList": return (VisitableBuilder<T, ?>)new ImageStreamTagListBuilder((ImageStreamTagList) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigRollbackSpec": return (VisitableBuilder<T, ?>)new DeploymentConfigRollbackSpecBuilder((DeploymentConfigRollbackSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectList": return (VisitableBuilder<T, ?>)new ProjectListBuilder((ProjectList) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepositorySpec": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositorySpecBuilder((ProjectHelmChartRepositorySpec) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleScopeRestriction": return (VisitableBuilder<T, ?>)new ClusterRoleScopeRestrictionBuilder((ClusterRoleScopeRestriction) item);
    case "io.fabric8.openshift.api.model."+"RangeAllocation": return (VisitableBuilder<T, ?>)new RangeAllocationBuilder((RangeAllocation) item);
    case "io.fabric8.openshift.api.model."+"Route": return (VisitableBuilder<T, ?>)new RouteBuilder((Route) item);
    case "io.fabric8.openshift.api.model."+"SourceStrategyOptions": return (VisitableBuilder<T, ?>)new SourceStrategyOptionsBuilder((SourceStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetwork": return (VisitableBuilder<T, ?>)new ClusterNetworkBuilder((ClusterNetwork) item);
    case "io.fabric8.openshift.api.model."+"OAuthAuthorizeToken": return (VisitableBuilder<T, ?>)new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken) item);
    case "io.fabric8.openshift.api.model."+"DockerBuildStrategy": return (VisitableBuilder<T, ?>)new DockerBuildStrategyBuilder((DockerBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"SignatureCondition": return (VisitableBuilder<T, ?>)new SignatureConditionBuilder((SignatureCondition) item);
    case "io.fabric8.openshift.api.model."+"UserOAuthAccessToken": return (VisitableBuilder<T, ?>)new UserOAuthAccessTokenBuilder((UserOAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"ConnectionConfigNamespaceScoped": return (VisitableBuilder<T, ?>)new ConnectionConfigNamespaceScopedBuilder((ConnectionConfigNamespaceScoped) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestrictionList": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionListBuilder((RoleBindingRestrictionList) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.openshift.api.model."+"ImageManifest": return (VisitableBuilder<T, ?>)new ImageManifestBuilder((ImageManifest) item);
    case "io.fabric8.openshift.api.model."+"SecurityContextConstraintsList": return (VisitableBuilder<T, ?>)new SecurityContextConstraintsListBuilder((SecurityContextConstraintsList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigList": return (VisitableBuilder<T, ?>)new BuildConfigListBuilder((BuildConfigList) item);
    case "io.fabric8.openshift.api.model."+"IdentityList": return (VisitableBuilder<T, ?>)new IdentityListBuilder((IdentityList) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetworkList": return (VisitableBuilder<T, ?>)new ClusterNetworkListBuilder((ClusterNetworkList) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceCondition": return (VisitableBuilder<T, ?>)new TemplateInstanceConditionBuilder((TemplateInstanceCondition) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCause": return (VisitableBuilder<T, ?>)new DeploymentCauseBuilder((DeploymentCause) item);
    case "io.fabric8.openshift.api.model."+"RepositoryImportStatus": return (VisitableBuilder<T, ?>)new RepositoryImportStatusBuilder((RepositoryImportStatus) item);
    case "io.fabric8.openshift.api.model."+"GroupList": return (VisitableBuilder<T, ?>)new GroupListBuilder((GroupList) item);
    case "io.fabric8.openshift.api.model."+"RunAsUserStrategyOptions": return (VisitableBuilder<T, ?>)new RunAsUserStrategyOptionsBuilder((RunAsUserStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"LifecycleHook": return (VisitableBuilder<T, ?>)new LifecycleHookBuilder((LifecycleHook) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTagReference": return (VisitableBuilder<T, ?>)new ImageStreamTagReferenceBuilder((ImageStreamTagReference) item);
    case "io.fabric8.openshift.api.model."+"SourceControlUser": return (VisitableBuilder<T, ?>)new SourceControlUserBuilder((SourceControlUser) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamList": return (VisitableBuilder<T, ?>)new ImageStreamListBuilder((ImageStreamList) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleBinding": return (VisitableBuilder<T, ?>)new ClusterRoleBindingBuilder((ClusterRoleBinding) item);
    case "io.fabric8.openshift.api.model."+"ResourceAccessReview": return (VisitableBuilder<T, ?>)new ResourceAccessReviewBuilder((ResourceAccessReview) item);
    case "io.fabric8.openshift.api.model."+"SelfSubjectRulesReview": return (VisitableBuilder<T, ?>)new SelfSubjectRulesReviewBuilder((SelfSubjectRulesReview) item);
    case "io.fabric8.openshift.api.model."+"UserOAuthAccessTokenList": return (VisitableBuilder<T, ?>)new UserOAuthAccessTokenListBuilder((UserOAuthAccessTokenList) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeTriggerStatus": return (VisitableBuilder<T, ?>)new ImageChangeTriggerStatusBuilder((ImageChangeTriggerStatus) item);
    case "io.fabric8.openshift.api.model."+"RouteStatus": return (VisitableBuilder<T, ?>)new RouteStatusBuilder((RouteStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigRollback": return (VisitableBuilder<T, ?>)new DeploymentConfigRollbackBuilder((DeploymentConfigRollback) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuota": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaBuilder((ClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"NamedTagEventList": return (VisitableBuilder<T, ?>)new NamedTagEventListBuilder((NamedTagEventList) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaList": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaListBuilder((ClusterResourceQuotaList) item);
    case "io.fabric8.openshift.api.model."+"RouteSpec": return (VisitableBuilder<T, ?>)new RouteSpecBuilder((RouteSpec) item);
    case "io.fabric8.openshift.api.model."+"ProjectRequest": return (VisitableBuilder<T, ?>)new ProjectRequestBuilder((ProjectRequest) item);
    case "io.fabric8.openshift.api.model."+"Template": return (VisitableBuilder<T, ?>)new TemplateBuilder((Template) item);
    case "io.fabric8.openshift.api.model."+"ImageLookupPolicy": return (VisitableBuilder<T, ?>)new ImageLookupPolicyBuilder((ImageLookupPolicy) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientAuthorization": return (VisitableBuilder<T, ?>)new OAuthClientAuthorizationBuilder((OAuthClientAuthorization) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeCause": return (VisitableBuilder<T, ?>)new ImageChangeCauseBuilder((ImageChangeCause) item);
    case "io.fabric8.openshift.api.model."+"AllowedFlexVolume": return (VisitableBuilder<T, ?>)new AllowedFlexVolumeBuilder((AllowedFlexVolume) item);
    case "io.fabric8.openshift.api.model."+"SubjectAccessReview": return (VisitableBuilder<T, ?>)new SubjectAccessReviewBuilder((SubjectAccessReview) item);
    case "io.fabric8.openshift.api.model."+"LocalResourceAccessReview": return (VisitableBuilder<T, ?>)new LocalResourceAccessReviewBuilder((LocalResourceAccessReview) item);
    case "io.fabric8.openshift.api.model."+"ClusterRole": return (VisitableBuilder<T, ?>)new ClusterRoleBuilder((ClusterRole) item);
    case "io.fabric8.openshift.api.model."+"ConnectionConfig": return (VisitableBuilder<T, ?>)new ConnectionConfigBuilder((ConnectionConfig) item);
    case "io.fabric8.openshift.api.model."+"TagEventCondition": return (VisitableBuilder<T, ?>)new TagEventConditionBuilder((TagEventCondition) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.openshift.api.model."+"NetNamespaceList": return (VisitableBuilder<T, ?>)new NetNamespaceListBuilder((NetNamespaceList) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstanceSpec": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceSpecBuilder((BrokerTemplateInstanceSpec) item);
    case "io.fabric8.openshift.api.model."+"BinaryBuildSource": return (VisitableBuilder<T, ?>)new BinaryBuildSourceBuilder((BinaryBuildSource) item);
    case "io.fabric8.openshift.api.model."+"BuildSpec": return (VisitableBuilder<T, ?>)new BuildSpecBuilder((BuildSpec) item);
    case "io.fabric8.openshift.api.model."+"OAuthClientAuthorizationList": return (VisitableBuilder<T, ?>)new OAuthClientAuthorizationListBuilder((OAuthClientAuthorizationList) item);
    case "io.fabric8.openshift.api.model."+"LocalSubjectAccessReview": return (VisitableBuilder<T, ?>)new LocalSubjectAccessReviewBuilder((LocalSubjectAccessReview) item);
    case "io.fabric8.openshift.api.model."+"ProjectStatus": return (VisitableBuilder<T, ?>)new ProjectStatusBuilder((ProjectStatus) item);
    case "io.fabric8.openshift.api.model."+"RollingDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new RollingDeploymentStrategyParamsBuilder((RollingDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"GitSourceRevision": return (VisitableBuilder<T, ?>)new GitSourceRevisionBuilder((GitSourceRevision) item);
    case "io.fabric8.openshift.api.model."+"ImageLabel": return (VisitableBuilder<T, ?>)new ImageLabelBuilder((ImageLabel) item);
    case "io.fabric8.openshift.api.model."+"ImageChangeTrigger": return (VisitableBuilder<T, ?>)new ImageChangeTriggerBuilder((ImageChangeTrigger) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewSpecBuilder((PodSecurityPolicyReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImportSpec": return (VisitableBuilder<T, ?>)new ImageStreamImportSpecBuilder((ImageStreamImportSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageTag": return (VisitableBuilder<T, ?>)new ImageTagBuilder((ImageTag) item);
    case "io.fabric8.openshift.api.model."+"FSGroupStrategyOptions": return (VisitableBuilder<T, ?>)new FSGroupStrategyOptionsBuilder((FSGroupStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicyReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicyReviewBuilder((PodSecurityPolicyReview) item);
    case "io.fabric8.openshift.api.model."+"RecreateDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new RecreateDeploymentStrategyParamsBuilder((RecreateDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"DockerStrategyOptions": return (VisitableBuilder<T, ?>)new DockerStrategyOptionsBuilder((DockerStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ImageList": return (VisitableBuilder<T, ?>)new ImageListBuilder((ImageList) item);
    case "io.fabric8.openshift.api.model."+"ConfigMapBuildSource": return (VisitableBuilder<T, ?>)new ConfigMapBuildSourceBuilder((ConfigMapBuildSource) item);
    case "io.fabric8.openshift.api.model."+"ImageTagList": return (VisitableBuilder<T, ?>)new ImageTagListBuilder((ImageTagList) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfig": return (VisitableBuilder<T, ?>)new DeploymentConfigBuilder((DeploymentConfig) item);
    case "io.fabric8.openshift.api.model."+"OAuthAccessToken": return (VisitableBuilder<T, ?>)new OAuthAccessTokenBuilder((OAuthAccessToken) item);
    case "io.fabric8.openshift.api.model."+"RoleBinding": return (VisitableBuilder<T, ?>)new RoleBindingBuilder((RoleBinding) item);
    case "io.fabric8.openshift.api.model."+"Image": return (VisitableBuilder<T, ?>)new ImageBuilder((Image) item);
    case "io.fabric8.openshift.api.model."+"TLSConfig": return (VisitableBuilder<T, ?>)new TLSConfigBuilder((TLSConfig) item);
    case "io.fabric8.openshift.api.model."+"BuildVolume": return (VisitableBuilder<T, ?>)new BuildVolumeBuilder((BuildVolume) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceSpec": return (VisitableBuilder<T, ?>)new TemplateInstanceSpecBuilder((TemplateInstanceSpec) item);
    case "io.fabric8.openshift.api.model."+"BuildStatus": return (VisitableBuilder<T, ?>)new BuildStatusBuilder((BuildStatus) item);
    case "io.fabric8.openshift.api.model."+"ImageSource": return (VisitableBuilder<T, ?>)new ImageSourceBuilder((ImageSource) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySelfSubjectReview": return (VisitableBuilder<T, ?>)new PodSecurityPolicySelfSubjectReviewBuilder((PodSecurityPolicySelfSubjectReview) item);
    case "io.fabric8.openshift.api.model."+"TagReference": return (VisitableBuilder<T, ?>)new TagReferenceBuilder((TagReference) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyRule": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyRuleBuilder((EgressNetworkPolicyRule) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReviewStatus": return (VisitableBuilder<T, ?>)new SubjectRulesReviewStatusBuilder((SubjectRulesReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"BuildVolumeMount": return (VisitableBuilder<T, ?>)new BuildVolumeMountBuilder((BuildVolumeMount) item);
    case "io.fabric8.openshift.api.model."+"ClusterNetworkEntry": return (VisitableBuilder<T, ?>)new ClusterNetworkEntryBuilder((ClusterNetworkEntry) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceObject": return (VisitableBuilder<T, ?>)new TemplateInstanceObjectBuilder((TemplateInstanceObject) item);
    case "io.fabric8.openshift.api.model."+"BuildSource": return (VisitableBuilder<T, ?>)new BuildSourceBuilder((BuildSource) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaStatus": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaStatusBuilder((ClusterResourceQuotaStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCondition": return (VisitableBuilder<T, ?>)new DeploymentConditionBuilder((DeploymentCondition) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositorySpec": return (VisitableBuilder<T, ?>)new HelmChartRepositorySpecBuilder((HelmChartRepositorySpec) item);
    case "io.fabric8.openshift.api.model."+"DeploymentCauseImageTrigger": return (VisitableBuilder<T, ?>)new DeploymentCauseImageTriggerBuilder((DeploymentCauseImageTrigger) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamMapping": return (VisitableBuilder<T, ?>)new ImageStreamMappingBuilder((ImageStreamMapping) item);
    case "io.fabric8.openshift.api.model."+"SubjectRulesReview": return (VisitableBuilder<T, ?>)new SubjectRulesReviewBuilder((SubjectRulesReview) item);
    case "io.fabric8.openshift.api.model."+"Role": return (VisitableBuilder<T, ?>)new RoleBuilder((Role) item);
    case "io.fabric8.openshift.api.model."+"GitBuildSource": return (VisitableBuilder<T, ?>)new GitBuildSourceBuilder((GitBuildSource) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyList": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyListBuilder((EgressNetworkPolicyList) item);
    case "io.fabric8.openshift.api.model."+"SelfSubjectRulesReviewSpec": return (VisitableBuilder<T, ?>)new SelfSubjectRulesReviewSpecBuilder((SelfSubjectRulesReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageSourcePath": return (VisitableBuilder<T, ?>)new ImageSourcePathBuilder((ImageSourcePath) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigStatus": return (VisitableBuilder<T, ?>)new BuildConfigStatusBuilder((BuildConfigStatus) item);
    case "io.fabric8.openshift.api.model."+"ResourceQuotaStatusByNamespace": return (VisitableBuilder<T, ?>)new ResourceQuotaStatusByNamespaceBuilder((ResourceQuotaStatusByNamespace) item);
    case "io.fabric8.openshift.api.model."+"Parameter": return (VisitableBuilder<T, ?>)new ParameterBuilder((Parameter) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingList": return (VisitableBuilder<T, ?>)new RoleBindingListBuilder((RoleBindingList) item);
    case "io.fabric8.openshift.api.model."+"SourceBuildStrategy": return (VisitableBuilder<T, ?>)new SourceBuildStrategyBuilder((SourceBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"BrokerTemplateInstance": return (VisitableBuilder<T, ?>)new BrokerTemplateInstanceBuilder((BrokerTemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySelfSubjectReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicySelfSubjectReviewSpecBuilder((PodSecurityPolicySelfSubjectReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"BuildPostCommitSpec": return (VisitableBuilder<T, ?>)new BuildPostCommitSpecBuilder((BuildPostCommitSpec) item);
    case "io.fabric8.openshift.api.model."+"DeploymentStrategy": return (VisitableBuilder<T, ?>)new DeploymentStrategyBuilder((DeploymentStrategy) item);
    case "io.fabric8.openshift.api.model."+"OAuthAuthorizeTokenList": return (VisitableBuilder<T, ?>)new OAuthAuthorizeTokenListBuilder((OAuthAuthorizeTokenList) item);
    case "io.fabric8.openshift.api.model."+"SignatureSubject": return (VisitableBuilder<T, ?>)new SignatureSubjectBuilder((SignatureSubject) item);
    case "io.fabric8.openshift.api.model."+"HostSubnetList": return (VisitableBuilder<T, ?>)new HostSubnetListBuilder((HostSubnetList) item);
    case "io.fabric8.openshift.api.model."+"RouteIngressCondition": return (VisitableBuilder<T, ?>)new RouteIngressConditionBuilder((RouteIngressCondition) item);
    case "io.fabric8.openshift.api.model."+"CustomDeploymentStrategyParams": return (VisitableBuilder<T, ?>)new CustomDeploymentStrategyParamsBuilder((CustomDeploymentStrategyParams) item);
    case "io.fabric8.openshift.api.model."+"ImageImportSpec": return (VisitableBuilder<T, ?>)new ImageImportSpecBuilder((ImageImportSpec) item);
    case "io.fabric8.openshift.api.model."+"StageInfo": return (VisitableBuilder<T, ?>)new StageInfoBuilder((StageInfo) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestrictionSpec": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionSpecBuilder((RoleBindingRestrictionSpec) item);
    case "io.fabric8.openshift.api.model."+"IDRange": return (VisitableBuilder<T, ?>)new IDRangeBuilder((IDRange) item);
    case "io.fabric8.openshift.api.model."+"UserList": return (VisitableBuilder<T, ?>)new UserListBuilder((UserList) item);
    case "io.fabric8.openshift.api.model."+"BuildConfigSpec": return (VisitableBuilder<T, ?>)new BuildConfigSpecBuilder((BuildConfigSpec) item);
    case "io.fabric8.openshift.api.model."+"User": return (VisitableBuilder<T, ?>)new UserBuilder((User) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamImage": return (VisitableBuilder<T, ?>)new ImageStreamImageBuilder((ImageStreamImage) item);
    case "io.fabric8.openshift.api.model."+"BuildCondition": return (VisitableBuilder<T, ?>)new BuildConditionBuilder((BuildCondition) item);
    case "io.fabric8.openshift.api.model."+"BuildStatusOutputTo": return (VisitableBuilder<T, ?>)new BuildStatusOutputToBuilder((BuildStatusOutputTo) item);
    case "io.fabric8.openshift.api.model."+"ResourceAccessReviewResponse": return (VisitableBuilder<T, ?>)new ResourceAccessReviewResponseBuilder((ResourceAccessReviewResponse) item);
    case "io.fabric8.openshift.api.model."+"ExecNewPodHook": return (VisitableBuilder<T, ?>)new ExecNewPodHookBuilder((ExecNewPodHook) item);
    case "io.fabric8.openshift.api.model."+"SecretSpec": return (VisitableBuilder<T, ?>)new SecretSpecBuilder((SecretSpec) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleBindingList": return (VisitableBuilder<T, ?>)new ClusterRoleBindingListBuilder((ClusterRoleBindingList) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicyPeer": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyPeerBuilder((EgressNetworkPolicyPeer) item);
    case "io.fabric8.openshift.api.model."+"ProjectHelmChartRepositoryList": return (VisitableBuilder<T, ?>)new ProjectHelmChartRepositoryListBuilder((ProjectHelmChartRepositoryList) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstance": return (VisitableBuilder<T, ?>)new TemplateInstanceBuilder((TemplateInstance) item);
    case "io.fabric8.openshift.api.model."+"WebHookTrigger": return (VisitableBuilder<T, ?>)new WebHookTriggerBuilder((WebHookTrigger) item);
    case "io.fabric8.openshift.api.model."+"Build": return (VisitableBuilder<T, ?>)new BuildBuilder((Build) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountReference": return (VisitableBuilder<T, ?>)new ServiceAccountReferenceBuilder((ServiceAccountReference) item);
    case "io.fabric8.openshift.api.model."+"RoleBindingRestriction": return (VisitableBuilder<T, ?>)new RoleBindingRestrictionBuilder((RoleBindingRestriction) item);
    case "io.fabric8.openshift.api.model."+"TagImportPolicy": return (VisitableBuilder<T, ?>)new TagImportPolicyBuilder((TagImportPolicy) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamTag": return (VisitableBuilder<T, ?>)new ImageStreamTagBuilder((ImageStreamTag) item);
    case "io.fabric8.openshift.api.model."+"BuildTriggerPolicy": return (VisitableBuilder<T, ?>)new BuildTriggerPolicyBuilder((BuildTriggerPolicy) item);
    case "io.fabric8.openshift.api.model."+"RoutePort": return (VisitableBuilder<T, ?>)new RoutePortBuilder((RoutePort) item);
    case "io.fabric8.openshift.api.model."+"TemplateInstanceRequester": return (VisitableBuilder<T, ?>)new TemplateInstanceRequesterBuilder((TemplateInstanceRequester) item);
    case "io.fabric8.openshift.api.model."+"Group": return (VisitableBuilder<T, ?>)new GroupBuilder((Group) item);
    case "io.fabric8.openshift.api.model."+"BuildTriggerCause": return (VisitableBuilder<T, ?>)new BuildTriggerCauseBuilder((BuildTriggerCause) item);
    case "io.fabric8.openshift.api.model."+"ImageSignature": return (VisitableBuilder<T, ?>)new ImageSignatureBuilder((ImageSignature) item);
    case "io.fabric8.openshift.api.model."+"HelmChartRepositoryStatus": return (VisitableBuilder<T, ?>)new HelmChartRepositoryStatusBuilder((HelmChartRepositoryStatus) item);
    case "io.fabric8.openshift.api.model."+"DeploymentConfigSpec": return (VisitableBuilder<T, ?>)new DeploymentConfigSpecBuilder((DeploymentConfigSpec) item);
    case "io.fabric8.openshift.api.model."+"HostSubnet": return (VisitableBuilder<T, ?>)new HostSubnetBuilder((HostSubnet) item);
    case "io.fabric8.openshift.api.model."+"AppliedClusterResourceQuota": return (VisitableBuilder<T, ?>)new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota) item);
    case "io.fabric8.openshift.api.model."+"GroupRestriction": return (VisitableBuilder<T, ?>)new GroupRestrictionBuilder((GroupRestriction) item);
    case "io.fabric8.openshift.api.model."+"OAuthAccessTokenList": return (VisitableBuilder<T, ?>)new OAuthAccessTokenListBuilder((OAuthAccessTokenList) item);
    case "io.fabric8.openshift.api.model."+"JenkinsPipelineBuildStrategy": return (VisitableBuilder<T, ?>)new JenkinsPipelineBuildStrategyBuilder((JenkinsPipelineBuildStrategy) item);
    case "io.fabric8.openshift.api.model."+"SecurityContextConstraints": return (VisitableBuilder<T, ?>)new SecurityContextConstraintsBuilder((SecurityContextConstraints) item);
    case "io.fabric8.openshift.api.model."+"SupplementalGroupsStrategyOptions": return (VisitableBuilder<T, ?>)new SupplementalGroupsStrategyOptionsBuilder((SupplementalGroupsStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ServiceAccountPodSecurityPolicyReviewStatus": return (VisitableBuilder<T, ?>)new ServiceAccountPodSecurityPolicyReviewStatusBuilder((ServiceAccountPodSecurityPolicyReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"BuildRequest": return (VisitableBuilder<T, ?>)new BuildRequestBuilder((BuildRequest) item);
    case "io.fabric8.openshift.api.model."+"SELinuxContextStrategyOptions": return (VisitableBuilder<T, ?>)new SELinuxContextStrategyOptionsBuilder((SELinuxContextStrategyOptions) item);
    case "io.fabric8.openshift.api.model."+"ClusterRoleList": return (VisitableBuilder<T, ?>)new ClusterRoleListBuilder((ClusterRoleList) item);
    case "io.fabric8.openshift.api.model."+"RouteList": return (VisitableBuilder<T, ?>)new RouteListBuilder((RouteList) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamStatus": return (VisitableBuilder<T, ?>)new ImageStreamStatusBuilder((ImageStreamStatus) item);
    case "io.fabric8.openshift.api.model."+"EgressNetworkPolicy": return (VisitableBuilder<T, ?>)new EgressNetworkPolicyBuilder((EgressNetworkPolicy) item);
    case "io.fabric8.openshift.api.model."+"NetNamespace": return (VisitableBuilder<T, ?>)new NetNamespaceBuilder((NetNamespace) item);
    case "io.fabric8.openshift.api.model."+"DeploymentDetails": return (VisitableBuilder<T, ?>)new DeploymentDetailsBuilder((DeploymentDetails) item);
    case "io.fabric8.openshift.api.model."+"UserIdentityMapping": return (VisitableBuilder<T, ?>)new UserIdentityMappingBuilder((UserIdentityMapping) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReviewStatus": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewStatusBuilder((PodSecurityPolicySubjectReviewStatus) item);
    case "io.fabric8.openshift.api.model."+"PodSecurityPolicySubjectReviewSpec": return (VisitableBuilder<T, ?>)new PodSecurityPolicySubjectReviewSpecBuilder((PodSecurityPolicySubjectReviewSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStream": return (VisitableBuilder<T, ?>)new ImageStreamBuilder((ImageStream) item);
    case "io.fabric8.openshift.api.model."+"BuildList": return (VisitableBuilder<T, ?>)new BuildListBuilder((BuildList) item);
    case "io.fabric8.openshift.api.model."+"BuildOutput": return (VisitableBuilder<T, ?>)new BuildOutputBuilder((BuildOutput) item);
    case "io.fabric8.openshift.api.model."+"TemplateList": return (VisitableBuilder<T, ?>)new TemplateListBuilder((TemplateList) item);
    case "io.fabric8.openshift.api.model."+"ProjectSpec": return (VisitableBuilder<T, ?>)new ProjectSpecBuilder((ProjectSpec) item);
    case "io.fabric8.openshift.api.model."+"SourceRevision": return (VisitableBuilder<T, ?>)new SourceRevisionBuilder((SourceRevision) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.openshift.api.model."+"SignatureIssuer": return (VisitableBuilder<T, ?>)new SignatureIssuerBuilder((SignatureIssuer) item);
    case "io.fabric8.openshift.api.model."+"ImageLayer": return (VisitableBuilder<T, ?>)new ImageLayerBuilder((ImageLayer) item);
    case "io.fabric8.openshift.api.model."+"ClusterResourceQuotaSpec": return (VisitableBuilder<T, ?>)new ClusterResourceQuotaSpecBuilder((ClusterResourceQuotaSpec) item);
    case "io.fabric8.openshift.api.model."+"ImageStreamSpec": return (VisitableBuilder<T, ?>)new ImageStreamSpecBuilder((ImageStreamSpec) item);
    case "io.fabric8.openshift.api.model."+"RouteIngress": return (VisitableBuilder<T, ?>)new RouteIngressBuilder((RouteIngress) item);
    case "io.fabric8.openshift.api.model."+"OAuthClient": return (VisitableBuilder<T, ?>)new OAuthClientBuilder((OAuthClient) item);
    case "io.fabric8.openshift.api.model."+"Identity": return (VisitableBuilder<T, ?>)new IdentityBuilder((Identity) item);
    case "io.fabric8.openshift.api.model."+"RangeAllocationList": return (VisitableBuilder<T, ?>)new RangeAllocationListBuilder((RangeAllocationList) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class GenericWebHookCauseAttributeRestrictionsNested<N> extends GenericWebHookCauseFluent<GenericWebHookCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    GenericWebHookCauseAttributeRestrictionsNested(GenericWebHookCause item) {
      this.builder = new GenericWebHookCauseBuilder(this, item);
    }
    GenericWebHookCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGenericWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ServiceAccountRestrictionAttributeRestrictionsNested<N> extends ServiceAccountRestrictionFluent<ServiceAccountRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    ServiceAccountRestrictionAttributeRestrictionsNested(ServiceAccountRestriction item) {
      this.builder = new ServiceAccountRestrictionBuilder(this, item);
    }
    ServiceAccountRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endServiceAccountRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ScopeRestrictionAttributeRestrictionsNested<N> extends ScopeRestrictionFluent<ScopeRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    ScopeRestrictionAttributeRestrictionsNested(ScopeRestriction item) {
      this.builder = new ScopeRestrictionBuilder(this, item);
    }
    ScopeRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SecretLocalReferenceAttributeRestrictionsNested<N> extends SecretLocalReferenceFluent<SecretLocalReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    SecretLocalReferenceAttributeRestrictionsNested(SecretLocalReference item) {
      this.builder = new SecretLocalReferenceBuilder(this, item);
    }
    SecretLocalReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSecretLocalReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class StepInfoAttributeRestrictionsNested<N> extends StepInfoFluent<StepInfoAttributeRestrictionsNested<N>> implements Nested<N>{
    StepInfoAttributeRestrictionsNested(StepInfo item) {
      this.builder = new StepInfoBuilder(this, item);
    }
    StepInfoBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endStepInfoAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserRestrictionAttributeRestrictionsNested<N> extends UserRestrictionFluent<UserRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    UserRestrictionAttributeRestrictionsNested(UserRestriction item) {
      this.builder = new UserRestrictionBuilder(this, item);
    }
    UserRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecAttributeRestrictionsNested<N> extends PodTemplateSpecFluent<PodTemplateSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    PodTemplateSpecAttributeRestrictionsNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodTemplateSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositoryAttributeRestrictionsNested<N> extends ProjectHelmChartRepositoryFluent<ProjectHelmChartRepositoryAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectHelmChartRepositoryAttributeRestrictionsNested(ProjectHelmChartRepository item) {
      this.builder = new ProjectHelmChartRepositoryBuilder(this, item);
    }
    ProjectHelmChartRepositoryBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceListAttributeRestrictionsNested<N> extends TemplateInstanceListFluent<TemplateInstanceListAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceListAttributeRestrictionsNested(TemplateInstanceList item) {
      this.builder = new TemplateInstanceListBuilder(this, item);
    }
    TemplateInstanceListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamImportAttributeRestrictionsNested<N> extends ImageStreamImportFluent<ImageStreamImportAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamImportAttributeRestrictionsNested(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamImportAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsAttributeRestrictionsNested<N> extends ResourceRequirementsFluent<ResourceRequirementsAttributeRestrictionsNested<N>> implements Nested<N>{
    ResourceRequirementsAttributeRestrictionsNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endResourceRequirementsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GitHubWebHookCauseAttributeRestrictionsNested<N> extends GitHubWebHookCauseFluent<GitHubWebHookCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    GitHubWebHookCauseAttributeRestrictionsNested(GitHubWebHookCause item) {
      this.builder = new GitHubWebHookCauseBuilder(this, item);
    }
    GitHubWebHookCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGitHubWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthClientListAttributeRestrictionsNested<N> extends OAuthClientListFluent<OAuthClientListAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthClientListAttributeRestrictionsNested(OAuthClientList item) {
      this.builder = new OAuthClientListBuilder(this, item);
    }
    OAuthClientListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthClientListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N> extends PodSecurityPolicyReviewStatusFluent<PodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewStatusAttributeRestrictionsNested(PodSecurityPolicyReviewStatus item) {
      this.builder = new PodSecurityPolicyReviewStatusBuilder(this, item);
    }
    PodSecurityPolicyReviewStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceStatusAttributeRestrictionsNested<N> extends TemplateInstanceStatusFluent<TemplateInstanceStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceStatusAttributeRestrictionsNested(TemplateInstanceStatus item) {
      this.builder = new TemplateInstanceStatusBuilder(this, item);
    }
    TemplateInstanceStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryListAttributeRestrictionsNested<N> extends HelmChartRepositoryListFluent<HelmChartRepositoryListAttributeRestrictionsNested<N>> implements Nested<N>{
    HelmChartRepositoryListAttributeRestrictionsNested(HelmChartRepositoryList item) {
      this.builder = new HelmChartRepositoryListBuilder(this, item);
    }
    HelmChartRepositoryListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHelmChartRepositoryListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PolicyRuleAttributeRestrictionsNested<N> extends PolicyRuleFluent<PolicyRuleAttributeRestrictionsNested<N>> implements Nested<N>{
    PolicyRuleAttributeRestrictionsNested(PolicyRule item) {
      this.builder = new PolicyRuleBuilder(this, item);
    }
    PolicyRuleBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentTriggerPolicyAttributeRestrictionsNested<N> extends DeploymentTriggerPolicyFluent<DeploymentTriggerPolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentTriggerPolicyAttributeRestrictionsNested(DeploymentTriggerPolicy item) {
      this.builder = new DeploymentTriggerPolicyBuilder(this, item);
    }
    DeploymentTriggerPolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildStrategyAttributeRestrictionsNested<N> extends BuildStrategyFluent<BuildStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildStrategyAttributeRestrictionsNested(BuildStrategy item) {
      this.builder = new BuildStrategyBuilder(this, item);
    }
    BuildStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RepositoryImportSpecAttributeRestrictionsNested<N> extends RepositoryImportSpecFluent<RepositoryImportSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    RepositoryImportSpecAttributeRestrictionsNested(RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryImportSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRepositoryImportSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceListAttributeRestrictionsNested<N> extends BrokerTemplateInstanceListFluent<BrokerTemplateInstanceListAttributeRestrictionsNested<N>> implements Nested<N>{
    BrokerTemplateInstanceListAttributeRestrictionsNested(BrokerTemplateInstanceList item) {
      this.builder = new BrokerTemplateInstanceListBuilder(this, item);
    }
    BrokerTemplateInstanceListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBrokerTemplateInstanceListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamImportStatusAttributeRestrictionsNested<N> extends ImageStreamImportStatusFluent<ImageStreamImportStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamImportStatusAttributeRestrictionsNested(ImageStreamImportStatus item) {
      this.builder = new ImageStreamImportStatusBuilder(this, item);
    }
    ImageStreamImportStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamImportStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class CustomBuildStrategyAttributeRestrictionsNested<N> extends CustomBuildStrategyFluent<CustomBuildStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    CustomBuildStrategyAttributeRestrictionsNested(CustomBuildStrategy item) {
      this.builder = new CustomBuildStrategyBuilder(this, item);
    }
    CustomBuildStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endCustomBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaSelectorAttributeRestrictionsNested<N> extends ClusterResourceQuotaSelectorFluent<ClusterResourceQuotaSelectorAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterResourceQuotaSelectorAttributeRestrictionsNested(ClusterResourceQuotaSelector item) {
      this.builder = new ClusterResourceQuotaSelectorBuilder(this, item);
    }
    ClusterResourceQuotaSelectorBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterResourceQuotaSelectorAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SubjectAccessReviewResponseAttributeRestrictionsNested<N> extends SubjectAccessReviewResponseFluent<SubjectAccessReviewResponseAttributeRestrictionsNested<N>> implements Nested<N>{
    SubjectAccessReviewResponseAttributeRestrictionsNested(SubjectAccessReviewResponse item) {
      this.builder = new SubjectAccessReviewResponseBuilder(this, item);
    }
    SubjectAccessReviewResponseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSubjectAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N> extends DeploymentTriggerImageChangeParamsFluent<DeploymentTriggerImageChangeParamsAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentTriggerImageChangeParamsAttributeRestrictionsNested(DeploymentTriggerImageChangeParams item) {
      this.builder = new DeploymentTriggerImageChangeParamsBuilder(this, item);
    }
    DeploymentTriggerImageChangeParamsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentTriggerImageChangeParamsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceAttributeRestrictionsNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    LocalObjectReferenceAttributeRestrictionsNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endLocalObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagImageHookAttributeRestrictionsNested<N> extends TagImageHookFluent<TagImageHookAttributeRestrictionsNested<N>> implements Nested<N>{
    TagImageHookAttributeRestrictionsNested(TagImageHook item) {
      this.builder = new TagImageHookBuilder(this, item);
    }
    TagImageHookBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagImageHookAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteTargetReferenceAttributeRestrictionsNested<N> extends RouteTargetReferenceFluent<RouteTargetReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteTargetReferenceAttributeRestrictionsNested(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteTargetReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewSpecAttributeRestrictionsNested<N> extends SubjectRulesReviewSpecFluent<SubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    SubjectRulesReviewSpecAttributeRestrictionsNested(SubjectRulesReviewSpec item) {
      this.builder = new SubjectRulesReviewSpecBuilder(this, item);
    }
    SubjectRulesReviewSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OpenshiftRawExtensionAttributeRestrictionsNested<N> extends io.fabric8.openshift.api.model.runtime.RawExtensionFluent<OpenshiftRawExtensionAttributeRestrictionsNested<N>> implements Nested<N>{
    OpenshiftRawExtensionAttributeRestrictionsNested(io.fabric8.openshift.api.model.runtime.RawExtension item) {
      this.builder = new io.fabric8.openshift.api.model.runtime.RawExtensionBuilder(this, item);
    }
    io.fabric8.openshift.api.model.runtime.RawExtensionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOpenshiftRawExtensionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleListAttributeRestrictionsNested<N> extends RoleListFluent<RoleListAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleListAttributeRestrictionsNested(RoleList item) {
      this.builder = new RoleListBuilder(this, item);
    }
    RoleListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagReferencePolicyAttributeRestrictionsNested<N> extends TagReferencePolicyFluent<TagReferencePolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    TagReferencePolicyAttributeRestrictionsNested(TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    TagReferencePolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagReferencePolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectAttributeRestrictionsNested<N> extends ProjectFluent<ProjectAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectAttributeRestrictionsNested(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildVolumeSourceAttributeRestrictionsNested<N> extends BuildVolumeSourceFluent<BuildVolumeSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildVolumeSourceAttributeRestrictionsNested(BuildVolumeSource item) {
      this.builder = new BuildVolumeSourceBuilder(this, item);
    }
    BuildVolumeSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildVolumeSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class AppliedClusterResourceQuotaListAttributeRestrictionsNested<N> extends AppliedClusterResourceQuotaListFluent<AppliedClusterResourceQuotaListAttributeRestrictionsNested<N>> implements Nested<N>{
    AppliedClusterResourceQuotaListAttributeRestrictionsNested(AppliedClusterResourceQuotaList item) {
      this.builder = new AppliedClusterResourceQuotaListBuilder(this, item);
    }
    AppliedClusterResourceQuotaListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endAppliedClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildStatusOutputAttributeRestrictionsNested<N> extends BuildStatusOutputFluent<BuildStatusOutputAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildStatusOutputAttributeRestrictionsNested(BuildStatusOutput item) {
      this.builder = new BuildStatusOutputBuilder(this, item);
    }
    BuildStatusOutputBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildStatusOutputAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigListAttributeRestrictionsNested<N> extends DeploymentConfigListFluent<DeploymentConfigListAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigListAttributeRestrictionsNested(DeploymentConfigList item) {
      this.builder = new DeploymentConfigListBuilder(this, item);
    }
    DeploymentConfigListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildConfigAttributeRestrictionsNested<N> extends BuildConfigFluent<BuildConfigAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildConfigAttributeRestrictionsNested(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildConfigAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageImportStatusAttributeRestrictionsNested<N> extends ImageImportStatusFluent<ImageImportStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageImportStatusAttributeRestrictionsNested(ImageImportStatus item) {
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageImportStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N> extends PodSecurityPolicySubjectReviewFluent<PodSecurityPolicySubjectReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewAttributeRestrictionsNested(PodSecurityPolicySubjectReview item) {
      this.builder = new PodSecurityPolicySubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GitLabWebHookCauseAttributeRestrictionsNested<N> extends GitLabWebHookCauseFluent<GitLabWebHookCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    GitLabWebHookCauseAttributeRestrictionsNested(GitLabWebHookCause item) {
      this.builder = new GitLabWebHookCauseBuilder(this, item);
    }
    GitLabWebHookCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGitLabWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigStatusAttributeRestrictionsNested<N> extends DeploymentConfigStatusFluent<DeploymentConfigStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigStatusAttributeRestrictionsNested(DeploymentConfigStatus item) {
      this.builder = new DeploymentConfigStatusBuilder(this, item);
    }
    DeploymentConfigStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SecretBuildSourceAttributeRestrictionsNested<N> extends SecretBuildSourceFluent<SecretBuildSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    SecretBuildSourceAttributeRestrictionsNested(SecretBuildSource item) {
      this.builder = new SecretBuildSourceBuilder(this, item);
    }
    SecretBuildSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSecretBuildSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicySpecAttributeRestrictionsNested<N> extends EgressNetworkPolicySpecFluent<EgressNetworkPolicySpecAttributeRestrictionsNested<N>> implements Nested<N>{
    EgressNetworkPolicySpecAttributeRestrictionsNested(EgressNetworkPolicySpec item) {
      this.builder = new EgressNetworkPolicySpecBuilder(this, item);
    }
    EgressNetworkPolicySpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endEgressNetworkPolicySpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryAttributeRestrictionsNested<N> extends HelmChartRepositoryFluent<HelmChartRepositoryAttributeRestrictionsNested<N>> implements Nested<N>{
    HelmChartRepositoryAttributeRestrictionsNested(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagEventAttributeRestrictionsNested<N> extends TagEventFluent<TagEventAttributeRestrictionsNested<N>> implements Nested<N>{
    TagEventAttributeRestrictionsNested(TagEvent item) {
      this.builder = new TagEventBuilder(this, item);
    }
    TagEventBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagEventAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BitbucketWebHookCauseAttributeRestrictionsNested<N> extends BitbucketWebHookCauseFluent<BitbucketWebHookCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    BitbucketWebHookCauseAttributeRestrictionsNested(BitbucketWebHookCause item) {
      this.builder = new BitbucketWebHookCauseBuilder(this, item);
    }
    BitbucketWebHookCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBitbucketWebHookCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamTagListAttributeRestrictionsNested<N> extends ImageStreamTagListFluent<ImageStreamTagListAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamTagListAttributeRestrictionsNested(ImageStreamTagList item) {
      this.builder = new ImageStreamTagListBuilder(this, item);
    }
    ImageStreamTagListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamTagListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigRollbackSpecAttributeRestrictionsNested<N> extends DeploymentConfigRollbackSpecFluent<DeploymentConfigRollbackSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigRollbackSpecAttributeRestrictionsNested(DeploymentConfigRollbackSpec item) {
      this.builder = new DeploymentConfigRollbackSpecBuilder(this, item);
    }
    DeploymentConfigRollbackSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigRollbackSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectListAttributeRestrictionsNested<N> extends ProjectListFluent<ProjectListAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectListAttributeRestrictionsNested(ProjectList item) {
      this.builder = new ProjectListBuilder(this, item);
    }
    ProjectListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositorySpecAttributeRestrictionsNested<N> extends ProjectHelmChartRepositorySpecFluent<ProjectHelmChartRepositorySpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectHelmChartRepositorySpecAttributeRestrictionsNested(ProjectHelmChartRepositorySpec item) {
      this.builder = new ProjectHelmChartRepositorySpecBuilder(this, item);
    }
    ProjectHelmChartRepositorySpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectHelmChartRepositorySpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterRoleScopeRestrictionAttributeRestrictionsNested<N> extends ClusterRoleScopeRestrictionFluent<ClusterRoleScopeRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterRoleScopeRestrictionAttributeRestrictionsNested(ClusterRoleScopeRestriction item) {
      this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
    }
    ClusterRoleScopeRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterRoleScopeRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RangeAllocationAttributeRestrictionsNested<N> extends RangeAllocationFluent<RangeAllocationAttributeRestrictionsNested<N>> implements Nested<N>{
    RangeAllocationAttributeRestrictionsNested(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRangeAllocationAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteAttributeRestrictionsNested<N> extends RouteFluent<RouteAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteAttributeRestrictionsNested(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SourceStrategyOptionsAttributeRestrictionsNested<N> extends SourceStrategyOptionsFluent<SourceStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    SourceStrategyOptionsAttributeRestrictionsNested(SourceStrategyOptions item) {
      this.builder = new SourceStrategyOptionsBuilder(this, item);
    }
    SourceStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSourceStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterNetworkAttributeRestrictionsNested<N> extends ClusterNetworkFluent<ClusterNetworkAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterNetworkAttributeRestrictionsNested(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterNetworkAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthAuthorizeTokenAttributeRestrictionsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthAuthorizeTokenAttributeRestrictionsNested(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthAuthorizeTokenAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DockerBuildStrategyAttributeRestrictionsNested<N> extends DockerBuildStrategyFluent<DockerBuildStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    DockerBuildStrategyAttributeRestrictionsNested(DockerBuildStrategy item) {
      this.builder = new DockerBuildStrategyBuilder(this, item);
    }
    DockerBuildStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDockerBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SignatureConditionAttributeRestrictionsNested<N> extends SignatureConditionFluent<SignatureConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    SignatureConditionAttributeRestrictionsNested(SignatureCondition item) {
      this.builder = new SignatureConditionBuilder(this, item);
    }
    SignatureConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSignatureConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserOAuthAccessTokenAttributeRestrictionsNested<N> extends UserOAuthAccessTokenFluent<UserOAuthAccessTokenAttributeRestrictionsNested<N>> implements Nested<N>{
    UserOAuthAccessTokenAttributeRestrictionsNested(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ConnectionConfigNamespaceScopedAttributeRestrictionsNested<N> extends ConnectionConfigNamespaceScopedFluent<ConnectionConfigNamespaceScopedAttributeRestrictionsNested<N>> implements Nested<N>{
    ConnectionConfigNamespaceScopedAttributeRestrictionsNested(ConnectionConfigNamespaceScoped item) {
      this.builder = new ConnectionConfigNamespaceScopedBuilder(this, item);
    }
    ConnectionConfigNamespaceScopedBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endConnectionConfigNamespaceScopedAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionListAttributeRestrictionsNested<N> extends RoleBindingRestrictionListFluent<RoleBindingRestrictionListAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleBindingRestrictionListAttributeRestrictionsNested(RoleBindingRestrictionList item) {
      this.builder = new RoleBindingRestrictionListBuilder(this, item);
    }
    RoleBindingRestrictionListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleBindingRestrictionListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RawExtensionAttributeRestrictionsNested<N> extends RawExtensionFluent<RawExtensionAttributeRestrictionsNested<N>> implements Nested<N>{
    RawExtensionAttributeRestrictionsNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRawExtensionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageManifestAttributeRestrictionsNested<N> extends ImageManifestFluent<ImageManifestAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageManifestAttributeRestrictionsNested(ImageManifest item) {
      this.builder = new ImageManifestBuilder(this, item);
    }
    ImageManifestBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageManifestAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SecurityContextConstraintsListAttributeRestrictionsNested<N> extends SecurityContextConstraintsListFluent<SecurityContextConstraintsListAttributeRestrictionsNested<N>> implements Nested<N>{
    SecurityContextConstraintsListAttributeRestrictionsNested(SecurityContextConstraintsList item) {
      this.builder = new SecurityContextConstraintsListBuilder(this, item);
    }
    SecurityContextConstraintsListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSecurityContextConstraintsListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildConfigListAttributeRestrictionsNested<N> extends BuildConfigListFluent<BuildConfigListAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildConfigListAttributeRestrictionsNested(BuildConfigList item) {
      this.builder = new BuildConfigListBuilder(this, item);
    }
    BuildConfigListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildConfigListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class IdentityListAttributeRestrictionsNested<N> extends IdentityListFluent<IdentityListAttributeRestrictionsNested<N>> implements Nested<N>{
    IdentityListAttributeRestrictionsNested(IdentityList item) {
      this.builder = new IdentityListBuilder(this, item);
    }
    IdentityListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endIdentityListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterNetworkListAttributeRestrictionsNested<N> extends ClusterNetworkListFluent<ClusterNetworkListAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterNetworkListAttributeRestrictionsNested(ClusterNetworkList item) {
      this.builder = new ClusterNetworkListBuilder(this, item);
    }
    ClusterNetworkListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterNetworkListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceConditionAttributeRestrictionsNested<N> extends TemplateInstanceConditionFluent<TemplateInstanceConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceConditionAttributeRestrictionsNested(TemplateInstanceCondition item) {
      this.builder = new TemplateInstanceConditionBuilder(this, item);
    }
    TemplateInstanceConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentCauseAttributeRestrictionsNested<N> extends DeploymentCauseFluent<DeploymentCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentCauseAttributeRestrictionsNested(DeploymentCause item) {
      this.builder = new DeploymentCauseBuilder(this, item);
    }
    DeploymentCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RepositoryImportStatusAttributeRestrictionsNested<N> extends RepositoryImportStatusFluent<RepositoryImportStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    RepositoryImportStatusAttributeRestrictionsNested(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRepositoryImportStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GroupListAttributeRestrictionsNested<N> extends GroupListFluent<GroupListAttributeRestrictionsNested<N>> implements Nested<N>{
    GroupListAttributeRestrictionsNested(GroupList item) {
      this.builder = new GroupListBuilder(this, item);
    }
    GroupListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGroupListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RunAsUserStrategyOptionsAttributeRestrictionsNested<N> extends RunAsUserStrategyOptionsFluent<RunAsUserStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    RunAsUserStrategyOptionsAttributeRestrictionsNested(RunAsUserStrategyOptions item) {
      this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
    }
    RunAsUserStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRunAsUserStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class LifecycleHookAttributeRestrictionsNested<N> extends LifecycleHookFluent<LifecycleHookAttributeRestrictionsNested<N>> implements Nested<N>{
    LifecycleHookAttributeRestrictionsNested(LifecycleHook item) {
      this.builder = new LifecycleHookBuilder(this, item);
    }
    LifecycleHookBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endLifecycleHookAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamTagReferenceAttributeRestrictionsNested<N> extends ImageStreamTagReferenceFluent<ImageStreamTagReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamTagReferenceAttributeRestrictionsNested(ImageStreamTagReference item) {
      this.builder = new ImageStreamTagReferenceBuilder(this, item);
    }
    ImageStreamTagReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamTagReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SourceControlUserAttributeRestrictionsNested<N> extends SourceControlUserFluent<SourceControlUserAttributeRestrictionsNested<N>> implements Nested<N>{
    SourceControlUserAttributeRestrictionsNested(SourceControlUser item) {
      this.builder = new SourceControlUserBuilder(this, item);
    }
    SourceControlUserBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSourceControlUserAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ContainerAttributeRestrictionsNested<N> extends ContainerFluent<ContainerAttributeRestrictionsNested<N>> implements Nested<N>{
    ContainerAttributeRestrictionsNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endContainerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamListAttributeRestrictionsNested<N> extends ImageStreamListFluent<ImageStreamListAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamListAttributeRestrictionsNested(ImageStreamList item) {
      this.builder = new ImageStreamListBuilder(this, item);
    }
    ImageStreamListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterRoleBindingAttributeRestrictionsNested<N> extends ClusterRoleBindingFluent<ClusterRoleBindingAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterRoleBindingAttributeRestrictionsNested(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterRoleBindingAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ResourceAccessReviewAttributeRestrictionsNested<N> extends ResourceAccessReviewFluent<ResourceAccessReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    ResourceAccessReviewAttributeRestrictionsNested(ResourceAccessReview item) {
      this.builder = new ResourceAccessReviewBuilder(this, item);
    }
    ResourceAccessReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SelfSubjectRulesReviewAttributeRestrictionsNested<N> extends SelfSubjectRulesReviewFluent<SelfSubjectRulesReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    SelfSubjectRulesReviewAttributeRestrictionsNested(SelfSubjectRulesReview item) {
      this.builder = new SelfSubjectRulesReviewBuilder(this, item);
    }
    SelfSubjectRulesReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSelfSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserOAuthAccessTokenListAttributeRestrictionsNested<N> extends UserOAuthAccessTokenListFluent<UserOAuthAccessTokenListAttributeRestrictionsNested<N>> implements Nested<N>{
    UserOAuthAccessTokenListAttributeRestrictionsNested(UserOAuthAccessTokenList item) {
      this.builder = new UserOAuthAccessTokenListBuilder(this, item);
    }
    UserOAuthAccessTokenListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageChangeTriggerStatusAttributeRestrictionsNested<N> extends ImageChangeTriggerStatusFluent<ImageChangeTriggerStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageChangeTriggerStatusAttributeRestrictionsNested(ImageChangeTriggerStatus item) {
      this.builder = new ImageChangeTriggerStatusBuilder(this, item);
    }
    ImageChangeTriggerStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageChangeTriggerStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteStatusAttributeRestrictionsNested<N> extends RouteStatusFluent<RouteStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteStatusAttributeRestrictionsNested(RouteStatus item) {
      this.builder = new RouteStatusBuilder(this, item);
    }
    RouteStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigRollbackAttributeRestrictionsNested<N> extends DeploymentConfigRollbackFluent<DeploymentConfigRollbackAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigRollbackAttributeRestrictionsNested(DeploymentConfigRollback item) {
      this.builder = new DeploymentConfigRollbackBuilder(this, item);
    }
    DeploymentConfigRollbackBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigRollbackAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaAttributeRestrictionsNested<N> extends ClusterResourceQuotaFluent<ClusterResourceQuotaAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterResourceQuotaAttributeRestrictionsNested(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class NamedTagEventListAttributeRestrictionsNested<N> extends NamedTagEventListFluent<NamedTagEventListAttributeRestrictionsNested<N>> implements Nested<N>{
    NamedTagEventListAttributeRestrictionsNested(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endNamedTagEventListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaListAttributeRestrictionsNested<N> extends ClusterResourceQuotaListFluent<ClusterResourceQuotaListAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterResourceQuotaListAttributeRestrictionsNested(ClusterResourceQuotaList item) {
      this.builder = new ClusterResourceQuotaListBuilder(this, item);
    }
    ClusterResourceQuotaListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterResourceQuotaListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteSpecAttributeRestrictionsNested<N> extends RouteSpecFluent<RouteSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteSpecAttributeRestrictionsNested(RouteSpec item) {
      this.builder = new RouteSpecBuilder(this, item);
    }
    RouteSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectRequestAttributeRestrictionsNested<N> extends ProjectRequestFluent<ProjectRequestAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectRequestAttributeRestrictionsNested(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectRequestAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateAttributeRestrictionsNested<N> extends TemplateFluent<TemplateAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateAttributeRestrictionsNested(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageLookupPolicyAttributeRestrictionsNested<N> extends ImageLookupPolicyFluent<ImageLookupPolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageLookupPolicyAttributeRestrictionsNested(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageLookupPolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthClientAuthorizationAttributeRestrictionsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthClientAuthorizationAttributeRestrictionsNested(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthClientAuthorizationAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageChangeCauseAttributeRestrictionsNested<N> extends ImageChangeCauseFluent<ImageChangeCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageChangeCauseAttributeRestrictionsNested(ImageChangeCause item) {
      this.builder = new ImageChangeCauseBuilder(this, item);
    }
    ImageChangeCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageChangeCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class AllowedFlexVolumeAttributeRestrictionsNested<N> extends AllowedFlexVolumeFluent<AllowedFlexVolumeAttributeRestrictionsNested<N>> implements Nested<N>{
    AllowedFlexVolumeAttributeRestrictionsNested(AllowedFlexVolume item) {
      this.builder = new AllowedFlexVolumeBuilder(this, item);
    }
    AllowedFlexVolumeBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endAllowedFlexVolumeAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SubjectAccessReviewAttributeRestrictionsNested<N> extends SubjectAccessReviewFluent<SubjectAccessReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    SubjectAccessReviewAttributeRestrictionsNested(SubjectAccessReview item) {
      this.builder = new SubjectAccessReviewBuilder(this, item);
    }
    SubjectAccessReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class LocalResourceAccessReviewAttributeRestrictionsNested<N> extends LocalResourceAccessReviewFluent<LocalResourceAccessReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    LocalResourceAccessReviewAttributeRestrictionsNested(LocalResourceAccessReview item) {
      this.builder = new LocalResourceAccessReviewBuilder(this, item);
    }
    LocalResourceAccessReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endLocalResourceAccessReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterRoleAttributeRestrictionsNested<N> extends ClusterRoleFluent<ClusterRoleAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterRoleAttributeRestrictionsNested(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterRoleAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ConnectionConfigAttributeRestrictionsNested<N> extends ConnectionConfigFluent<ConnectionConfigAttributeRestrictionsNested<N>> implements Nested<N>{
    ConnectionConfigAttributeRestrictionsNested(ConnectionConfig item) {
      this.builder = new ConnectionConfigBuilder(this, item);
    }
    ConnectionConfigBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endConnectionConfigAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagEventConditionAttributeRestrictionsNested<N> extends TagEventConditionFluent<TagEventConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    TagEventConditionAttributeRestrictionsNested(TagEventCondition item) {
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagEventConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class LabelSelectorAttributeRestrictionsNested<N> extends LabelSelectorFluent<LabelSelectorAttributeRestrictionsNested<N>> implements Nested<N>{
    LabelSelectorAttributeRestrictionsNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endLabelSelectorAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class NetNamespaceListAttributeRestrictionsNested<N> extends NetNamespaceListFluent<NetNamespaceListAttributeRestrictionsNested<N>> implements Nested<N>{
    NetNamespaceListAttributeRestrictionsNested(NetNamespaceList item) {
      this.builder = new NetNamespaceListBuilder(this, item);
    }
    NetNamespaceListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endNetNamespaceListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceSpecAttributeRestrictionsNested<N> extends BrokerTemplateInstanceSpecFluent<BrokerTemplateInstanceSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    BrokerTemplateInstanceSpecAttributeRestrictionsNested(BrokerTemplateInstanceSpec item) {
      this.builder = new BrokerTemplateInstanceSpecBuilder(this, item);
    }
    BrokerTemplateInstanceSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBrokerTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BinaryBuildSourceAttributeRestrictionsNested<N> extends BinaryBuildSourceFluent<BinaryBuildSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    BinaryBuildSourceAttributeRestrictionsNested(BinaryBuildSource item) {
      this.builder = new BinaryBuildSourceBuilder(this, item);
    }
    BinaryBuildSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBinaryBuildSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildSpecAttributeRestrictionsNested<N> extends BuildSpecFluent<BuildSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildSpecAttributeRestrictionsNested(BuildSpec item) {
      this.builder = new BuildSpecBuilder(this, item);
    }
    BuildSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthClientAuthorizationListAttributeRestrictionsNested<N> extends OAuthClientAuthorizationListFluent<OAuthClientAuthorizationListAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthClientAuthorizationListAttributeRestrictionsNested(OAuthClientAuthorizationList item) {
      this.builder = new OAuthClientAuthorizationListBuilder(this, item);
    }
    OAuthClientAuthorizationListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthClientAuthorizationListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class LocalSubjectAccessReviewAttributeRestrictionsNested<N> extends LocalSubjectAccessReviewFluent<LocalSubjectAccessReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    LocalSubjectAccessReviewAttributeRestrictionsNested(LocalSubjectAccessReview item) {
      this.builder = new LocalSubjectAccessReviewBuilder(this, item);
    }
    LocalSubjectAccessReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endLocalSubjectAccessReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectStatusAttributeRestrictionsNested<N> extends ProjectStatusFluent<ProjectStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectStatusAttributeRestrictionsNested(ProjectStatus item) {
      this.builder = new ProjectStatusBuilder(this, item);
    }
    ProjectStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RollingDeploymentStrategyParamsAttributeRestrictionsNested<N> extends RollingDeploymentStrategyParamsFluent<RollingDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements Nested<N>{
    RollingDeploymentStrategyParamsAttributeRestrictionsNested(RollingDeploymentStrategyParams item) {
      this.builder = new RollingDeploymentStrategyParamsBuilder(this, item);
    }
    RollingDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRollingDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GitSourceRevisionAttributeRestrictionsNested<N> extends GitSourceRevisionFluent<GitSourceRevisionAttributeRestrictionsNested<N>> implements Nested<N>{
    GitSourceRevisionAttributeRestrictionsNested(GitSourceRevision item) {
      this.builder = new GitSourceRevisionBuilder(this, item);
    }
    GitSourceRevisionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGitSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageLabelAttributeRestrictionsNested<N> extends ImageLabelFluent<ImageLabelAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageLabelAttributeRestrictionsNested(ImageLabel item) {
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageLabelAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageChangeTriggerAttributeRestrictionsNested<N> extends ImageChangeTriggerFluent<ImageChangeTriggerAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageChangeTriggerAttributeRestrictionsNested(ImageChangeTrigger item) {
      this.builder = new ImageChangeTriggerBuilder(this, item);
    }
    ImageChangeTriggerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageChangeTriggerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N> extends PodSecurityPolicyReviewSpecFluent<PodSecurityPolicyReviewSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewSpecAttributeRestrictionsNested(PodSecurityPolicyReviewSpec item) {
      this.builder = new PodSecurityPolicyReviewSpecBuilder(this, item);
    }
    PodSecurityPolicyReviewSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicyReviewSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamImportSpecAttributeRestrictionsNested<N> extends ImageStreamImportSpecFluent<ImageStreamImportSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamImportSpecAttributeRestrictionsNested(ImageStreamImportSpec item) {
      this.builder = new ImageStreamImportSpecBuilder(this, item);
    }
    ImageStreamImportSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamImportSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageTagAttributeRestrictionsNested<N> extends ImageTagFluent<ImageTagAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageTagAttributeRestrictionsNested(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageTagAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class FSGroupStrategyOptionsAttributeRestrictionsNested<N> extends FSGroupStrategyOptionsFluent<FSGroupStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    FSGroupStrategyOptionsAttributeRestrictionsNested(FSGroupStrategyOptions item) {
      this.builder = new FSGroupStrategyOptionsBuilder(this, item);
    }
    FSGroupStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endFSGroupStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicyReviewAttributeRestrictionsNested<N> extends PodSecurityPolicyReviewFluent<PodSecurityPolicyReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicyReviewAttributeRestrictionsNested(PodSecurityPolicyReview item) {
      this.builder = new PodSecurityPolicyReviewBuilder(this, item);
    }
    PodSecurityPolicyReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicyReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N> extends RecreateDeploymentStrategyParamsFluent<RecreateDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements Nested<N>{
    RecreateDeploymentStrategyParamsAttributeRestrictionsNested(RecreateDeploymentStrategyParams item) {
      this.builder = new RecreateDeploymentStrategyParamsBuilder(this, item);
    }
    RecreateDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRecreateDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DockerStrategyOptionsAttributeRestrictionsNested<N> extends DockerStrategyOptionsFluent<DockerStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    DockerStrategyOptionsAttributeRestrictionsNested(DockerStrategyOptions item) {
      this.builder = new DockerStrategyOptionsBuilder(this, item);
    }
    DockerStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDockerStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageListAttributeRestrictionsNested<N> extends ImageListFluent<ImageListAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageListAttributeRestrictionsNested(ImageList item) {
      this.builder = new ImageListBuilder(this, item);
    }
    ImageListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ConfigMapBuildSourceAttributeRestrictionsNested<N> extends ConfigMapBuildSourceFluent<ConfigMapBuildSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    ConfigMapBuildSourceAttributeRestrictionsNested(ConfigMapBuildSource item) {
      this.builder = new ConfigMapBuildSourceBuilder(this, item);
    }
    ConfigMapBuildSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endConfigMapBuildSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageTagListAttributeRestrictionsNested<N> extends ImageTagListFluent<ImageTagListAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageTagListAttributeRestrictionsNested(ImageTagList item) {
      this.builder = new ImageTagListBuilder(this, item);
    }
    ImageTagListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageTagListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigAttributeRestrictionsNested<N> extends DeploymentConfigFluent<DeploymentConfigAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigAttributeRestrictionsNested(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthAccessTokenAttributeRestrictionsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthAccessTokenAttributeRestrictionsNested(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleBindingAttributeRestrictionsNested<N> extends RoleBindingFluent<RoleBindingAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleBindingAttributeRestrictionsNested(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleBindingAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageAttributeRestrictionsNested<N> extends ImageFluent<ImageAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageAttributeRestrictionsNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TLSConfigAttributeRestrictionsNested<N> extends TLSConfigFluent<TLSConfigAttributeRestrictionsNested<N>> implements Nested<N>{
    TLSConfigAttributeRestrictionsNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTLSConfigAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildVolumeAttributeRestrictionsNested<N> extends BuildVolumeFluent<BuildVolumeAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildVolumeAttributeRestrictionsNested(BuildVolume item) {
      this.builder = new BuildVolumeBuilder(this, item);
    }
    BuildVolumeBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildVolumeAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceSpecAttributeRestrictionsNested<N> extends TemplateInstanceSpecFluent<TemplateInstanceSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceSpecAttributeRestrictionsNested(TemplateInstanceSpec item) {
      this.builder = new TemplateInstanceSpecBuilder(this, item);
    }
    TemplateInstanceSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildStatusAttributeRestrictionsNested<N> extends BuildStatusFluent<BuildStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildStatusAttributeRestrictionsNested(BuildStatus item) {
      this.builder = new BuildStatusBuilder(this, item);
    }
    BuildStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageSourceAttributeRestrictionsNested<N> extends ImageSourceFluent<ImageSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageSourceAttributeRestrictionsNested(ImageSource item) {
      this.builder = new ImageSourceBuilder(this, item);
    }
    ImageSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ObjectMetaAttributeRestrictionsNested<N> extends ObjectMetaFluent<ObjectMetaAttributeRestrictionsNested<N>> implements Nested<N>{
    ObjectMetaAttributeRestrictionsNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endObjectMetaAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimAttributeRestrictionsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimAttributeRestrictionsNested<N>> implements Nested<N>{
    PersistentVolumeClaimAttributeRestrictionsNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPersistentVolumeClaimAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N> extends PodSecurityPolicySelfSubjectReviewFluent<PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicySelfSubjectReviewAttributeRestrictionsNested(PodSecurityPolicySelfSubjectReview item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicySelfSubjectReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagReferenceAttributeRestrictionsNested<N> extends TagReferenceFluent<TagReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    TagReferenceAttributeRestrictionsNested(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyRuleAttributeRestrictionsNested<N> extends EgressNetworkPolicyRuleFluent<EgressNetworkPolicyRuleAttributeRestrictionsNested<N>> implements Nested<N>{
    EgressNetworkPolicyRuleAttributeRestrictionsNested(EgressNetworkPolicyRule item) {
      this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
    }
    EgressNetworkPolicyRuleBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endEgressNetworkPolicyRuleAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewStatusAttributeRestrictionsNested<N> extends SubjectRulesReviewStatusFluent<SubjectRulesReviewStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    SubjectRulesReviewStatusAttributeRestrictionsNested(SubjectRulesReviewStatus item) {
      this.builder = new SubjectRulesReviewStatusBuilder(this, item);
    }
    SubjectRulesReviewStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSubjectRulesReviewStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildVolumeMountAttributeRestrictionsNested<N> extends BuildVolumeMountFluent<BuildVolumeMountAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildVolumeMountAttributeRestrictionsNested(BuildVolumeMount item) {
      this.builder = new BuildVolumeMountBuilder(this, item);
    }
    BuildVolumeMountBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildVolumeMountAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterNetworkEntryAttributeRestrictionsNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkEntryAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterNetworkEntryAttributeRestrictionsNested(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterNetworkEntryAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceAttributeRestrictionsNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceAttributeRestrictionsNested<N>> implements Nested<N>{
    GenericKubernetesResourceAttributeRestrictionsNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGenericKubernetesResourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceObjectAttributeRestrictionsNested<N> extends TemplateInstanceObjectFluent<TemplateInstanceObjectAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceObjectAttributeRestrictionsNested(TemplateInstanceObject item) {
      this.builder = new TemplateInstanceObjectBuilder(this, item);
    }
    TemplateInstanceObjectBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceObjectAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildSourceAttributeRestrictionsNested<N> extends BuildSourceFluent<BuildSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildSourceAttributeRestrictionsNested(BuildSource item) {
      this.builder = new BuildSourceBuilder(this, item);
    }
    BuildSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaStatusAttributeRestrictionsNested<N> extends ClusterResourceQuotaStatusFluent<ClusterResourceQuotaStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterResourceQuotaStatusAttributeRestrictionsNested(ClusterResourceQuotaStatus item) {
      this.builder = new ClusterResourceQuotaStatusBuilder(this, item);
    }
    ClusterResourceQuotaStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterResourceQuotaStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConditionAttributeRestrictionsNested<N> extends DeploymentConditionFluent<DeploymentConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConditionAttributeRestrictionsNested(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HelmChartRepositorySpecAttributeRestrictionsNested<N> extends HelmChartRepositorySpecFluent<HelmChartRepositorySpecAttributeRestrictionsNested<N>> implements Nested<N>{
    HelmChartRepositorySpecAttributeRestrictionsNested(HelmChartRepositorySpec item) {
      this.builder = new HelmChartRepositorySpecBuilder(this, item);
    }
    HelmChartRepositorySpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHelmChartRepositorySpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentCauseImageTriggerAttributeRestrictionsNested<N> extends DeploymentCauseImageTriggerFluent<DeploymentCauseImageTriggerAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentCauseImageTriggerAttributeRestrictionsNested(DeploymentCauseImageTrigger item) {
      this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
    }
    DeploymentCauseImageTriggerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentCauseImageTriggerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamMappingAttributeRestrictionsNested<N> extends ImageStreamMappingFluent<ImageStreamMappingAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamMappingAttributeRestrictionsNested(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamMappingAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SubjectRulesReviewAttributeRestrictionsNested<N> extends SubjectRulesReviewFluent<SubjectRulesReviewAttributeRestrictionsNested<N>> implements Nested<N>{
    SubjectRulesReviewAttributeRestrictionsNested(SubjectRulesReview item) {
      this.builder = new SubjectRulesReviewBuilder(this, item);
    }
    SubjectRulesReviewBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSubjectRulesReviewAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleAttributeRestrictionsNested<N> extends RoleFluent<RoleAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleAttributeRestrictionsNested(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GitBuildSourceAttributeRestrictionsNested<N> extends GitBuildSourceFluent<GitBuildSourceAttributeRestrictionsNested<N>> implements Nested<N>{
    GitBuildSourceAttributeRestrictionsNested(GitBuildSource item) {
      this.builder = new GitBuildSourceBuilder(this, item);
    }
    GitBuildSourceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGitBuildSourceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyListAttributeRestrictionsNested<N> extends EgressNetworkPolicyListFluent<EgressNetworkPolicyListAttributeRestrictionsNested<N>> implements Nested<N>{
    EgressNetworkPolicyListAttributeRestrictionsNested(EgressNetworkPolicyList item) {
      this.builder = new EgressNetworkPolicyListBuilder(this, item);
    }
    EgressNetworkPolicyListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endEgressNetworkPolicyListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N> extends SelfSubjectRulesReviewSpecFluent<SelfSubjectRulesReviewSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    SelfSubjectRulesReviewSpecAttributeRestrictionsNested(SelfSubjectRulesReviewSpec item) {
      this.builder = new SelfSubjectRulesReviewSpecBuilder(this, item);
    }
    SelfSubjectRulesReviewSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSelfSubjectRulesReviewSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageSourcePathAttributeRestrictionsNested<N> extends ImageSourcePathFluent<ImageSourcePathAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageSourcePathAttributeRestrictionsNested(ImageSourcePath item) {
      this.builder = new ImageSourcePathBuilder(this, item);
    }
    ImageSourcePathBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageSourcePathAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildConfigStatusAttributeRestrictionsNested<N> extends BuildConfigStatusFluent<BuildConfigStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildConfigStatusAttributeRestrictionsNested(BuildConfigStatus item) {
      this.builder = new BuildConfigStatusBuilder(this, item);
    }
    BuildConfigStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildConfigStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N> extends ResourceQuotaStatusByNamespaceFluent<ResourceQuotaStatusByNamespaceAttributeRestrictionsNested<N>> implements Nested<N>{
    ResourceQuotaStatusByNamespaceAttributeRestrictionsNested(ResourceQuotaStatusByNamespace item) {
      this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
    }
    ResourceQuotaStatusByNamespaceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endResourceQuotaStatusByNamespaceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ParameterAttributeRestrictionsNested<N> extends ParameterFluent<ParameterAttributeRestrictionsNested<N>> implements Nested<N>{
    ParameterAttributeRestrictionsNested(Parameter item) {
      this.builder = new ParameterBuilder(this, item);
    }
    ParameterBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endParameterAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleBindingListAttributeRestrictionsNested<N> extends RoleBindingListFluent<RoleBindingListAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleBindingListAttributeRestrictionsNested(RoleBindingList item) {
      this.builder = new RoleBindingListBuilder(this, item);
    }
    RoleBindingListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SourceBuildStrategyAttributeRestrictionsNested<N> extends SourceBuildStrategyFluent<SourceBuildStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    SourceBuildStrategyAttributeRestrictionsNested(SourceBuildStrategy item) {
      this.builder = new SourceBuildStrategyBuilder(this, item);
    }
    SourceBuildStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSourceBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BrokerTemplateInstanceAttributeRestrictionsNested<N> extends BrokerTemplateInstanceFluent<BrokerTemplateInstanceAttributeRestrictionsNested<N>> implements Nested<N>{
    BrokerTemplateInstanceAttributeRestrictionsNested(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBrokerTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N> extends PodSecurityPolicySelfSubjectReviewSpecFluent<PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicySelfSubjectReviewSpecAttributeRestrictionsNested(PodSecurityPolicySelfSubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySelfSubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySelfSubjectReviewSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicySelfSubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildPostCommitSpecAttributeRestrictionsNested<N> extends BuildPostCommitSpecFluent<BuildPostCommitSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildPostCommitSpecAttributeRestrictionsNested(BuildPostCommitSpec item) {
      this.builder = new BuildPostCommitSpecBuilder(this, item);
    }
    BuildPostCommitSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildPostCommitSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentStrategyAttributeRestrictionsNested<N> extends DeploymentStrategyFluent<DeploymentStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentStrategyAttributeRestrictionsNested(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthAuthorizeTokenListAttributeRestrictionsNested<N> extends OAuthAuthorizeTokenListFluent<OAuthAuthorizeTokenListAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthAuthorizeTokenListAttributeRestrictionsNested(OAuthAuthorizeTokenList item) {
      this.builder = new OAuthAuthorizeTokenListBuilder(this, item);
    }
    OAuthAuthorizeTokenListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthAuthorizeTokenListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SignatureSubjectAttributeRestrictionsNested<N> extends SignatureSubjectFluent<SignatureSubjectAttributeRestrictionsNested<N>> implements Nested<N>{
    SignatureSubjectAttributeRestrictionsNested(SignatureSubject item) {
      this.builder = new SignatureSubjectBuilder(this, item);
    }
    SignatureSubjectBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSignatureSubjectAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HostSubnetListAttributeRestrictionsNested<N> extends HostSubnetListFluent<HostSubnetListAttributeRestrictionsNested<N>> implements Nested<N>{
    HostSubnetListAttributeRestrictionsNested(HostSubnetList item) {
      this.builder = new HostSubnetListBuilder(this, item);
    }
    HostSubnetListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHostSubnetListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteIngressConditionAttributeRestrictionsNested<N> extends RouteIngressConditionFluent<RouteIngressConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteIngressConditionAttributeRestrictionsNested(RouteIngressCondition item) {
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    RouteIngressConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteIngressConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class CustomDeploymentStrategyParamsAttributeRestrictionsNested<N> extends CustomDeploymentStrategyParamsFluent<CustomDeploymentStrategyParamsAttributeRestrictionsNested<N>> implements Nested<N>{
    CustomDeploymentStrategyParamsAttributeRestrictionsNested(CustomDeploymentStrategyParams item) {
      this.builder = new CustomDeploymentStrategyParamsBuilder(this, item);
    }
    CustomDeploymentStrategyParamsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endCustomDeploymentStrategyParamsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageImportSpecAttributeRestrictionsNested<N> extends ImageImportSpecFluent<ImageImportSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageImportSpecAttributeRestrictionsNested(ImageImportSpec item) {
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImageImportSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageImportSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class StageInfoAttributeRestrictionsNested<N> extends StageInfoFluent<StageInfoAttributeRestrictionsNested<N>> implements Nested<N>{
    StageInfoAttributeRestrictionsNested(StageInfo item) {
      this.builder = new StageInfoBuilder(this, item);
    }
    StageInfoBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endStageInfoAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionSpecAttributeRestrictionsNested<N> extends RoleBindingRestrictionSpecFluent<RoleBindingRestrictionSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleBindingRestrictionSpecAttributeRestrictionsNested(RoleBindingRestrictionSpec item) {
      this.builder = new RoleBindingRestrictionSpecBuilder(this, item);
    }
    RoleBindingRestrictionSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleBindingRestrictionSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class IDRangeAttributeRestrictionsNested<N> extends IDRangeFluent<IDRangeAttributeRestrictionsNested<N>> implements Nested<N>{
    IDRangeAttributeRestrictionsNested(IDRange item) {
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endIDRangeAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserListAttributeRestrictionsNested<N> extends UserListFluent<UserListAttributeRestrictionsNested<N>> implements Nested<N>{
    UserListAttributeRestrictionsNested(UserList item) {
      this.builder = new UserListBuilder(this, item);
    }
    UserListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildConfigSpecAttributeRestrictionsNested<N> extends BuildConfigSpecFluent<BuildConfigSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildConfigSpecAttributeRestrictionsNested(BuildConfigSpec item) {
      this.builder = new BuildConfigSpecBuilder(this, item);
    }
    BuildConfigSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildConfigSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserAttributeRestrictionsNested<N> extends UserFluent<UserAttributeRestrictionsNested<N>> implements Nested<N>{
    UserAttributeRestrictionsNested(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamImageAttributeRestrictionsNested<N> extends ImageStreamImageFluent<ImageStreamImageAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamImageAttributeRestrictionsNested(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamImageAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildConditionAttributeRestrictionsNested<N> extends BuildConditionFluent<BuildConditionAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildConditionAttributeRestrictionsNested(BuildCondition item) {
      this.builder = new BuildConditionBuilder(this, item);
    }
    BuildConditionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildConditionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildStatusOutputToAttributeRestrictionsNested<N> extends BuildStatusOutputToFluent<BuildStatusOutputToAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildStatusOutputToAttributeRestrictionsNested(BuildStatusOutputTo item) {
      this.builder = new BuildStatusOutputToBuilder(this, item);
    }
    BuildStatusOutputToBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildStatusOutputToAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ResourceAccessReviewResponseAttributeRestrictionsNested<N> extends ResourceAccessReviewResponseFluent<ResourceAccessReviewResponseAttributeRestrictionsNested<N>> implements Nested<N>{
    ResourceAccessReviewResponseAttributeRestrictionsNested(ResourceAccessReviewResponse item) {
      this.builder = new ResourceAccessReviewResponseBuilder(this, item);
    }
    ResourceAccessReviewResponseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endResourceAccessReviewResponseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ExecNewPodHookAttributeRestrictionsNested<N> extends ExecNewPodHookFluent<ExecNewPodHookAttributeRestrictionsNested<N>> implements Nested<N>{
    ExecNewPodHookAttributeRestrictionsNested(ExecNewPodHook item) {
      this.builder = new ExecNewPodHookBuilder(this, item);
    }
    ExecNewPodHookBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endExecNewPodHookAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SecretSpecAttributeRestrictionsNested<N> extends SecretSpecFluent<SecretSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    SecretSpecAttributeRestrictionsNested(SecretSpec item) {
      this.builder = new SecretSpecBuilder(this, item);
    }
    SecretSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSecretSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterRoleBindingListAttributeRestrictionsNested<N> extends ClusterRoleBindingListFluent<ClusterRoleBindingListAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterRoleBindingListAttributeRestrictionsNested(ClusterRoleBindingList item) {
      this.builder = new ClusterRoleBindingListBuilder(this, item);
    }
    ClusterRoleBindingListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterRoleBindingListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyPeerAttributeRestrictionsNested<N> extends EgressNetworkPolicyPeerFluent<EgressNetworkPolicyPeerAttributeRestrictionsNested<N>> implements Nested<N>{
    EgressNetworkPolicyPeerAttributeRestrictionsNested(EgressNetworkPolicyPeer item) {
      this.builder = new EgressNetworkPolicyPeerBuilder(this, item);
    }
    EgressNetworkPolicyPeerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endEgressNetworkPolicyPeerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectHelmChartRepositoryListAttributeRestrictionsNested<N> extends ProjectHelmChartRepositoryListFluent<ProjectHelmChartRepositoryListAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectHelmChartRepositoryListAttributeRestrictionsNested(ProjectHelmChartRepositoryList item) {
      this.builder = new ProjectHelmChartRepositoryListBuilder(this, item);
    }
    ProjectHelmChartRepositoryListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectHelmChartRepositoryListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceAttributeRestrictionsNested<N> extends TemplateInstanceFluent<TemplateInstanceAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceAttributeRestrictionsNested(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class WebHookTriggerAttributeRestrictionsNested<N> extends WebHookTriggerFluent<WebHookTriggerAttributeRestrictionsNested<N>> implements Nested<N>{
    WebHookTriggerAttributeRestrictionsNested(WebHookTrigger item) {
      this.builder = new WebHookTriggerBuilder(this, item);
    }
    WebHookTriggerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endWebHookTriggerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildAttributeRestrictionsNested<N> extends BuildFluent<BuildAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildAttributeRestrictionsNested(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ServiceAccountReferenceAttributeRestrictionsNested<N> extends ServiceAccountReferenceFluent<ServiceAccountReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    ServiceAccountReferenceAttributeRestrictionsNested(ServiceAccountReference item) {
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceAccountReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endServiceAccountReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoleBindingRestrictionAttributeRestrictionsNested<N> extends RoleBindingRestrictionFluent<RoleBindingRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    RoleBindingRestrictionAttributeRestrictionsNested(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoleBindingRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TagImportPolicyAttributeRestrictionsNested<N> extends TagImportPolicyFluent<TagImportPolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    TagImportPolicyAttributeRestrictionsNested(TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    TagImportPolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTagImportPolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamTagAttributeRestrictionsNested<N> extends ImageStreamTagFluent<ImageStreamTagAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamTagAttributeRestrictionsNested(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamTagAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildTriggerPolicyAttributeRestrictionsNested<N> extends BuildTriggerPolicyFluent<BuildTriggerPolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildTriggerPolicyAttributeRestrictionsNested(BuildTriggerPolicy item) {
      this.builder = new BuildTriggerPolicyBuilder(this, item);
    }
    BuildTriggerPolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildTriggerPolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RoutePortAttributeRestrictionsNested<N> extends RoutePortFluent<RoutePortAttributeRestrictionsNested<N>> implements Nested<N>{
    RoutePortAttributeRestrictionsNested(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRoutePortAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateInstanceRequesterAttributeRestrictionsNested<N> extends TemplateInstanceRequesterFluent<TemplateInstanceRequesterAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateInstanceRequesterAttributeRestrictionsNested(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateInstanceRequesterAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GroupAttributeRestrictionsNested<N> extends GroupFluent<GroupAttributeRestrictionsNested<N>> implements Nested<N>{
    GroupAttributeRestrictionsNested(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGroupAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildTriggerCauseAttributeRestrictionsNested<N> extends BuildTriggerCauseFluent<BuildTriggerCauseAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildTriggerCauseAttributeRestrictionsNested(BuildTriggerCause item) {
      this.builder = new BuildTriggerCauseBuilder(this, item);
    }
    BuildTriggerCauseBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildTriggerCauseAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageSignatureAttributeRestrictionsNested<N> extends ImageSignatureFluent<ImageSignatureAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageSignatureAttributeRestrictionsNested(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageSignatureAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HelmChartRepositoryStatusAttributeRestrictionsNested<N> extends HelmChartRepositoryStatusFluent<HelmChartRepositoryStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    HelmChartRepositoryStatusAttributeRestrictionsNested(HelmChartRepositoryStatus item) {
      this.builder = new HelmChartRepositoryStatusBuilder(this, item);
    }
    HelmChartRepositoryStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHelmChartRepositoryStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentConfigSpecAttributeRestrictionsNested<N> extends DeploymentConfigSpecFluent<DeploymentConfigSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentConfigSpecAttributeRestrictionsNested(DeploymentConfigSpec item) {
      this.builder = new DeploymentConfigSpecBuilder(this, item);
    }
    DeploymentConfigSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentConfigSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class HostSubnetAttributeRestrictionsNested<N> extends HostSubnetFluent<HostSubnetAttributeRestrictionsNested<N>> implements Nested<N>{
    HostSubnetAttributeRestrictionsNested(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endHostSubnetAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class AppliedClusterResourceQuotaAttributeRestrictionsNested<N> extends AppliedClusterResourceQuotaFluent<AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> implements Nested<N>{
    AppliedClusterResourceQuotaAttributeRestrictionsNested(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endAppliedClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class GroupRestrictionAttributeRestrictionsNested<N> extends GroupRestrictionFluent<GroupRestrictionAttributeRestrictionsNested<N>> implements Nested<N>{
    GroupRestrictionAttributeRestrictionsNested(GroupRestriction item) {
      this.builder = new GroupRestrictionBuilder(this, item);
    }
    GroupRestrictionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endGroupRestrictionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthAccessTokenListAttributeRestrictionsNested<N> extends OAuthAccessTokenListFluent<OAuthAccessTokenListAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthAccessTokenListAttributeRestrictionsNested(OAuthAccessTokenList item) {
      this.builder = new OAuthAccessTokenListBuilder(this, item);
    }
    OAuthAccessTokenListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthAccessTokenListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N> extends JenkinsPipelineBuildStrategyFluent<JenkinsPipelineBuildStrategyAttributeRestrictionsNested<N>> implements Nested<N>{
    JenkinsPipelineBuildStrategyAttributeRestrictionsNested(JenkinsPipelineBuildStrategy item) {
      this.builder = new JenkinsPipelineBuildStrategyBuilder(this, item);
    }
    JenkinsPipelineBuildStrategyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endJenkinsPipelineBuildStrategyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SecurityContextConstraintsAttributeRestrictionsNested<N> extends SecurityContextConstraintsFluent<SecurityContextConstraintsAttributeRestrictionsNested<N>> implements Nested<N>{
    SecurityContextConstraintsAttributeRestrictionsNested(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSecurityContextConstraintsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N> extends SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    SupplementalGroupsStrategyOptionsAttributeRestrictionsNested(SupplementalGroupsStrategyOptions item) {
      this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
    }
    SupplementalGroupsStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSupplementalGroupsStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluent<ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictionsNested(ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endServiceAccountPodSecurityPolicyReviewStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildRequestAttributeRestrictionsNested<N> extends BuildRequestFluent<BuildRequestAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildRequestAttributeRestrictionsNested(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildRequestAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SELinuxContextStrategyOptionsAttributeRestrictionsNested<N> extends SELinuxContextStrategyOptionsFluent<SELinuxContextStrategyOptionsAttributeRestrictionsNested<N>> implements Nested<N>{
    SELinuxContextStrategyOptionsAttributeRestrictionsNested(SELinuxContextStrategyOptions item) {
      this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
    }
    SELinuxContextStrategyOptionsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSELinuxContextStrategyOptionsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterRoleListAttributeRestrictionsNested<N> extends ClusterRoleListFluent<ClusterRoleListAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterRoleListAttributeRestrictionsNested(ClusterRoleList item) {
      this.builder = new ClusterRoleListBuilder(this, item);
    }
    ClusterRoleListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterRoleListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteListAttributeRestrictionsNested<N> extends RouteListFluent<RouteListAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteListAttributeRestrictionsNested(RouteList item) {
      this.builder = new RouteListBuilder(this, item);
    }
    RouteListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamStatusAttributeRestrictionsNested<N> extends ImageStreamStatusFluent<ImageStreamStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamStatusAttributeRestrictionsNested(ImageStreamStatus item) {
      this.builder = new ImageStreamStatusBuilder(this, item);
    }
    ImageStreamStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class EgressNetworkPolicyAttributeRestrictionsNested<N> extends EgressNetworkPolicyFluent<EgressNetworkPolicyAttributeRestrictionsNested<N>> implements Nested<N>{
    EgressNetworkPolicyAttributeRestrictionsNested(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endEgressNetworkPolicyAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class NetNamespaceAttributeRestrictionsNested<N> extends NetNamespaceFluent<NetNamespaceAttributeRestrictionsNested<N>> implements Nested<N>{
    NetNamespaceAttributeRestrictionsNested(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endNetNamespaceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class DeploymentDetailsAttributeRestrictionsNested<N> extends DeploymentDetailsFluent<DeploymentDetailsAttributeRestrictionsNested<N>> implements Nested<N>{
    DeploymentDetailsAttributeRestrictionsNested(DeploymentDetails item) {
      this.builder = new DeploymentDetailsBuilder(this, item);
    }
    DeploymentDetailsBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endDeploymentDetailsAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class UserIdentityMappingAttributeRestrictionsNested<N> extends UserIdentityMappingFluent<UserIdentityMappingAttributeRestrictionsNested<N>> implements Nested<N>{
    UserIdentityMappingAttributeRestrictionsNested(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endUserIdentityMappingAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N> extends PodSecurityPolicySubjectReviewStatusFluent<PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewStatusAttributeRestrictionsNested(PodSecurityPolicySubjectReviewStatus item) {
      this.builder = new PodSecurityPolicySubjectReviewStatusBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewStatusBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewStatusAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N> extends PodSecurityPolicySubjectReviewSpecFluent<PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    PodSecurityPolicySubjectReviewSpecAttributeRestrictionsNested(PodSecurityPolicySubjectReviewSpec item) {
      this.builder = new PodSecurityPolicySubjectReviewSpecBuilder(this, item);
    }
    PodSecurityPolicySubjectReviewSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endPodSecurityPolicySubjectReviewSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamAttributeRestrictionsNested<N> extends ImageStreamFluent<ImageStreamAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamAttributeRestrictionsNested(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildListAttributeRestrictionsNested<N> extends BuildListFluent<BuildListAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildListAttributeRestrictionsNested(BuildList item) {
      this.builder = new BuildListBuilder(this, item);
    }
    BuildListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class BuildOutputAttributeRestrictionsNested<N> extends BuildOutputFluent<BuildOutputAttributeRestrictionsNested<N>> implements Nested<N>{
    BuildOutputAttributeRestrictionsNested(BuildOutput item) {
      this.builder = new BuildOutputBuilder(this, item);
    }
    BuildOutputBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endBuildOutputAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class TemplateListAttributeRestrictionsNested<N> extends TemplateListFluent<TemplateListAttributeRestrictionsNested<N>> implements Nested<N>{
    TemplateListAttributeRestrictionsNested(TemplateList item) {
      this.builder = new TemplateListBuilder(this, item);
    }
    TemplateListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endTemplateListAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ProjectSpecAttributeRestrictionsNested<N> extends ProjectSpecFluent<ProjectSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ProjectSpecAttributeRestrictionsNested(ProjectSpec item) {
      this.builder = new ProjectSpecBuilder(this, item);
    }
    ProjectSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endProjectSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SourceRevisionAttributeRestrictionsNested<N> extends SourceRevisionFluent<SourceRevisionAttributeRestrictionsNested<N>> implements Nested<N>{
    SourceRevisionAttributeRestrictionsNested(SourceRevision item) {
      this.builder = new SourceRevisionBuilder(this, item);
    }
    SourceRevisionBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSourceRevisionAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ObjectReferenceAttributeRestrictionsNested<N> extends ObjectReferenceFluent<ObjectReferenceAttributeRestrictionsNested<N>> implements Nested<N>{
    ObjectReferenceAttributeRestrictionsNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endObjectReferenceAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class SignatureIssuerAttributeRestrictionsNested<N> extends SignatureIssuerFluent<SignatureIssuerAttributeRestrictionsNested<N>> implements Nested<N>{
    SignatureIssuerAttributeRestrictionsNested(SignatureIssuer item) {
      this.builder = new SignatureIssuerBuilder(this, item);
    }
    SignatureIssuerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endSignatureIssuerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageLayerAttributeRestrictionsNested<N> extends ImageLayerFluent<ImageLayerAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageLayerAttributeRestrictionsNested(ImageLayer item) {
      this.builder = new ImageLayerBuilder(this, item);
    }
    ImageLayerBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageLayerAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ClusterResourceQuotaSpecAttributeRestrictionsNested<N> extends ClusterResourceQuotaSpecFluent<ClusterResourceQuotaSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ClusterResourceQuotaSpecAttributeRestrictionsNested(ClusterResourceQuotaSpec item) {
      this.builder = new ClusterResourceQuotaSpecBuilder(this, item);
    }
    ClusterResourceQuotaSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endClusterResourceQuotaSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class ImageStreamSpecAttributeRestrictionsNested<N> extends ImageStreamSpecFluent<ImageStreamSpecAttributeRestrictionsNested<N>> implements Nested<N>{
    ImageStreamSpecAttributeRestrictionsNested(ImageStreamSpec item) {
      this.builder = new ImageStreamSpecBuilder(this, item);
    }
    ImageStreamSpecBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endImageStreamSpecAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RouteIngressAttributeRestrictionsNested<N> extends RouteIngressFluent<RouteIngressAttributeRestrictionsNested<N>> implements Nested<N>{
    RouteIngressAttributeRestrictionsNested(RouteIngress item) {
      this.builder = new RouteIngressBuilder(this, item);
    }
    RouteIngressBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRouteIngressAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class OAuthClientAttributeRestrictionsNested<N> extends OAuthClientFluent<OAuthClientAttributeRestrictionsNested<N>> implements Nested<N>{
    OAuthClientAttributeRestrictionsNested(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endOAuthClientAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class IdentityAttributeRestrictionsNested<N> extends IdentityFluent<IdentityAttributeRestrictionsNested<N>> implements Nested<N>{
    IdentityAttributeRestrictionsNested(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endIdentityAttributeRestrictions() {
      return and();
    }
    
  
  }
  public class RangeAllocationListAttributeRestrictionsNested<N> extends RangeAllocationListFluent<RangeAllocationListAttributeRestrictionsNested<N>> implements Nested<N>{
    RangeAllocationListAttributeRestrictionsNested(RangeAllocationList item) {
      this.builder = new RangeAllocationListBuilder(this, item);
    }
    RangeAllocationListBuilder builder;
    
    public N and() {
      return (N) PolicyRuleFluent.this.withAttributeRestrictions(builder.build());
    }
    
    public N endRangeAllocationListAttributeRestrictions() {
      return and();
    }
    
  
  }

}