/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateInstanceRequester;
import io.fabric8.openshift.api.model.TemplateInstanceRequesterBuilder;
import io.fabric8.openshift.api.model.TemplateInstanceRequesterFluent;
import io.fabric8.openshift.api.model.TemplateInstanceSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TemplateInstanceSpecFluent<A extends TemplateInstanceSpecFluent<A>>
extends BaseFluent<A> {
    private TemplateInstanceRequesterBuilder requester;
    private LocalObjectReferenceBuilder secret;
    private TemplateBuilder template;
    private Map<String, Object> additionalProperties;

    public TemplateInstanceSpecFluent() {
    }

    public TemplateInstanceSpecFluent(TemplateInstanceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TemplateInstanceSpec instance) {
        TemplateInstanceSpec templateInstanceSpec = instance = instance != null ? instance : new TemplateInstanceSpec();
        if (instance != null) {
            this.withRequester(instance.getRequester());
            this.withSecret(instance.getSecret());
            this.withTemplate(instance.getTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TemplateInstanceRequester buildRequester() {
        return this.requester != null ? this.requester.build() : null;
    }

    public A withRequester(TemplateInstanceRequester requester) {
        this._visitables.remove((Object)"requester");
        if (requester != null) {
            this.requester = new TemplateInstanceRequesterBuilder(requester);
            this._visitables.get((Object)"requester").add(this.requester);
        } else {
            this.requester = null;
            this._visitables.get((Object)"requester").remove((Object)this.requester);
        }
        return (A)((Object)this);
    }

    public boolean hasRequester() {
        return this.requester != null;
    }

    public RequesterNested<A> withNewRequester() {
        return new RequesterNested(null);
    }

    public RequesterNested<A> withNewRequesterLike(TemplateInstanceRequester item) {
        return new RequesterNested(item);
    }

    public RequesterNested<A> editRequester() {
        return this.withNewRequesterLike(Optional.ofNullable(this.buildRequester()).orElse(null));
    }

    public RequesterNested<A> editOrNewRequester() {
        return this.withNewRequesterLike(Optional.ofNullable(this.buildRequester()).orElse(new TemplateInstanceRequesterBuilder().build()));
    }

    public RequesterNested<A> editOrNewRequesterLike(TemplateInstanceRequester item) {
        return this.withNewRequesterLike(Optional.ofNullable(this.buildRequester()).orElse(item));
    }

    public LocalObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    public A withSecret(LocalObjectReference secret) {
        this._visitables.remove((Object)"secret");
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove(this.secret);
        }
        return (A)((Object)this);
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNested(item);
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public Template buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(Template template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new TemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(Template item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new TemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(Template item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateInstanceSpecFluent that = (TemplateInstanceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.requester, (Object)that.requester)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requester, this.secret, this.template, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requester != null) {
            sb.append("requester:");
            sb.append(this.requester + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends TemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        TemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)TemplateInstanceSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SecretNested<N>
    extends LocalObjectReferenceFluent<SecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)TemplateInstanceSpecFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class RequesterNested<N>
    extends TemplateInstanceRequesterFluent<RequesterNested<N>>
    implements Nested<N> {
        TemplateInstanceRequesterBuilder builder;

        RequesterNested(TemplateInstanceRequester item) {
            this.builder = new TemplateInstanceRequesterBuilder(this, item);
        }

        public N and() {
            return (N)TemplateInstanceSpecFluent.this.withRequester(this.builder.build());
        }

        public N endRequester() {
            return this.and();
        }
    }
}

